/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.jdom;

import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.jdom.IDOMMethod;
import org.eclipse.wst.jsdt.core.jdom.IDOMNode;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMMember;
import org.eclipse.wst.jsdt.internal.core.jdom.DOMNode;
import org.eclipse.wst.jsdt.internal.core.util.CharArrayBuffer;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class DOMMethod
extends DOMMember
implements IDOMMethod {
    protected String fReturnType;
    protected int[] fReturnTypeRange;
    protected char[] fParameterList;
    protected int[] fParameterRange;
    protected char[] fExceptionList;
    protected int[] fExceptionRange;
    protected String fBody;
    protected int[] fBodyRange;
    protected String[] fParameterNames;
    protected String[] fParameterTypes;
    protected String[] fExceptions;
    protected String[] fTypeParameters = CharOperation.NO_STRINGS;
    protected String fDefaultValue = null;

    DOMMethod() {
    }

    DOMMethod(char[] cArray, int[] nArray, String string, int[] nArray2, int[] nArray3, int n, int[] nArray4, boolean bl, String string2, int[] nArray5, String[] stringArray, String[] stringArray2, int[] nArray6, String[] stringArray3, int[] nArray7, int[] nArray8) {
        super(cArray, nArray, string, nArray2, nArray3, n, nArray4);
        this.setMask(64, bl);
        this.fReturnType = string2;
        this.fReturnTypeRange = nArray5;
        this.fParameterTypes = stringArray;
        this.fParameterNames = stringArray2;
        this.fParameterRange = nArray6;
        this.fExceptionRange = nArray7;
        this.fExceptions = stringArray3;
        this.setHasBody(true);
        this.fBodyRange = nArray8;
        this.setMask(2048, true);
    }

    DOMMethod(char[] cArray, int[] nArray, String string, int[] nArray2, int n, boolean bl, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this(cArray, nArray, string, nArray2, new int[]{-1, -1}, n, new int[]{-1, -1}, bl, string2, new int[]{-1, -1}, stringArray, stringArray2, new int[]{-1, -1}, stringArray3, new int[]{-1, -1}, new int[]{-1, -1});
        this.setMask(2048, false);
    }

    public void addException(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.dom_nullExceptionType);
        }
        if (this.fExceptions == null) {
            this.fExceptions = new String[1];
            this.fExceptions[0] = string;
        } else {
            this.fExceptions = this.appendString(this.fExceptions, string);
        }
        this.setExceptions(this.fExceptions);
    }

    public void addParameter(String string, String string2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.dom_nullTypeParameter);
        }
        if (string2 == null) {
            throw new IllegalArgumentException(Messages.dom_nullNameParameter);
        }
        if (this.fParameterNames == null) {
            this.fParameterNames = new String[1];
            this.fParameterNames[0] = string2;
        } else {
            this.fParameterNames = this.appendString(this.fParameterNames, string2);
        }
        if (this.fParameterTypes == null) {
            this.fParameterTypes = new String[1];
            this.fParameterTypes[0] = string;
        } else {
            this.fParameterTypes = this.appendString(this.fParameterTypes, string);
        }
        this.setParameters(this.fParameterTypes, this.fParameterNames);
    }

    protected void appendMemberBodyContents(CharArrayBuffer charArrayBuffer) {
        if (this.fBody != null) {
            charArrayBuffer.append(this.fBody);
        } else {
            charArrayBuffer.append(this.fDocument, this.fBodyRange[0], this.fBodyRange[1] + 1 - this.fBodyRange[0]);
        }
    }

    protected void appendMemberDeclarationContents(CharArrayBuffer charArrayBuffer) {
        if (this.isConstructor()) {
            charArrayBuffer.append(this.getConstructorName()).append(this.fDocument, this.fNameRange[1] + 1, this.fParameterRange[0] - this.fNameRange[1] - 1);
        } else {
            charArrayBuffer.append(this.getReturnTypeContents());
            if (this.fReturnTypeRange[0] >= 0) {
                charArrayBuffer.append(this.fDocument, this.fReturnTypeRange[1] + 1, this.fNameRange[0] - this.fReturnTypeRange[1] - 1);
            } else {
                charArrayBuffer.append(' ');
            }
            charArrayBuffer.append(this.getNameContents()).append(this.fDocument, this.fNameRange[1] + 1, this.fParameterRange[0] - this.fNameRange[1] - 1);
        }
        if (this.fParameterList != null) {
            charArrayBuffer.append(this.fParameterList);
        } else {
            charArrayBuffer.append(this.fDocument, this.fParameterRange[0], this.fParameterRange[1] + 1 - this.fParameterRange[0]);
        }
        int n = this.hasTrailingArrayQualifier() && this.isReturnTypeAltered() ? this.fReturnTypeRange[3] + 1 : this.fParameterRange[1] + 1;
        if (this.fExceptions != null) {
            if (this.fExceptionRange[0] >= 0) {
                charArrayBuffer.append(this.fDocument, n, this.fExceptionRange[0] - n);
            } else {
                charArrayBuffer.append(" throws ");
            }
            if (this.fExceptionList != null) {
                charArrayBuffer.append(this.fExceptionList);
                if (this.fExceptionRange[0] >= 0) {
                    charArrayBuffer.append(this.fDocument, this.fExceptionRange[1] + 1, this.fBodyRange[0] - this.fExceptionRange[1] - 1);
                } else {
                    charArrayBuffer.append(this.fDocument, this.fParameterRange[1] + 1, this.fBodyRange[0] - this.fParameterRange[1] - 1);
                }
            } else {
                charArrayBuffer.append(this.fDocument, this.fExceptionRange[0], this.fBodyRange[0] - this.fExceptionRange[0]);
            }
        } else if (this.fExceptionRange[0] >= 0) {
            charArrayBuffer.append(this.fDocument, this.fExceptionRange[1] + 1, this.fBodyRange[0] - this.fExceptionRange[1] - 1);
        } else {
            charArrayBuffer.append(this.fDocument, n, this.fBodyRange[0] - n);
        }
    }

    protected void appendSimpleContents(CharArrayBuffer charArrayBuffer) {
        charArrayBuffer.append(this.fDocument, this.fSourceRange[0], this.fNameRange[0] - this.fSourceRange[0]);
        if (this.isConstructor()) {
            charArrayBuffer.append(this.getConstructorName());
        } else {
            charArrayBuffer.append(this.fName);
        }
        charArrayBuffer.append(this.fDocument, this.fNameRange[1] + 1, this.fSourceRange[1] - this.fNameRange[1]);
    }

    public String getBody() {
        this.becomeDetailed();
        if (this.hasBody()) {
            if (this.fBody != null) {
                return this.fBody;
            }
            return new String(this.fDocument, this.fBodyRange[0], this.fBodyRange[1] + 1 - this.fBodyRange[0]);
        }
        return null;
    }

    protected String getConstructorName() {
        if (this.isConstructor()) {
            if (this.getParent() != null) {
                return this.getParent().getName();
            }
            return new String(this.getNameContents());
        }
        return null;
    }

    protected DOMNode getDetailedNode() {
        return (DOMNode)((Object)this.getFactory().createMethod(this.getContents()));
    }

    public String[] getExceptions() {
        return this.fExceptions;
    }

    protected char[] generateFlags() {
        char[] cArray = Flags.toString(this.getFlags() & 0xFFFFFF7F).toCharArray();
        if (cArray.length == 0) {
            return cArray;
        }
        return CharOperation.concat(cArray, new char[]{' '});
    }

    public IJavaElement getJavaElement(IJavaElement iJavaElement) throws IllegalArgumentException {
        if (iJavaElement.getElementType() == 7) {
            String[] stringArray = null;
            if (this.fParameterTypes != null) {
                stringArray = new String[this.fParameterTypes.length];
                int n = 0;
                while (n < this.fParameterTypes.length) {
                    stringArray[n] = Signature.createTypeSignature(this.fParameterTypes[n].toCharArray(), false);
                    ++n;
                }
            }
            String string = null;
            string = this.isConstructor() ? this.getConstructorName() : this.getName();
            return ((IType)iJavaElement).getMethod(string, stringArray);
        }
        throw new IllegalArgumentException(Messages.element_illegalParent);
    }

    protected int getMemberDeclarationStartPosition() {
        if (this.fReturnTypeRange[0] >= 0) {
            return this.fReturnTypeRange[0];
        }
        return this.fNameRange[0];
    }

    public String getName() {
        if (this.isConstructor()) {
            return null;
        }
        return super.getName();
    }

    public int getNodeType() {
        return 6;
    }

    public String[] getParameterNames() {
        return this.fParameterNames;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String getReturnType() {
        if (this.isConstructor()) {
            return null;
        }
        return this.fReturnType;
    }

    protected char[] getReturnTypeContents() {
        if (this.isConstructor()) {
            return null;
        }
        if (this.isReturnTypeAltered()) {
            return this.fReturnType.toCharArray();
        }
        return CharOperation.subarray(this.fDocument, this.fReturnTypeRange[0], this.fReturnTypeRange[1] + 1);
    }

    protected boolean hasTrailingArrayQualifier() {
        return this.fReturnTypeRange.length > 2;
    }

    public boolean isConstructor() {
        return this.getMask(64);
    }

    protected boolean isReturnTypeAltered() {
        return this.getMask(1024);
    }

    public boolean isSignatureEqual(IDOMNode iDOMNode) {
        boolean bl;
        boolean bl2 = bl = iDOMNode.getNodeType() == this.getNodeType();
        if (bl) {
            IDOMMethod iDOMMethod = (IDOMMethod)iDOMNode;
            boolean bl3 = bl = this.isConstructor() && iDOMMethod.isConstructor() || !this.isConstructor() && !iDOMMethod.isConstructor();
            if (bl && !this.isConstructor()) {
                bl = this.getName().equals(iDOMMethod.getName());
            }
            if (!bl) {
                return false;
            }
            String[] stringArray = iDOMMethod.getParameterTypes();
            if (this.fParameterTypes == null || this.fParameterTypes.length == 0) {
                if (stringArray == null || stringArray.length == 0) {
                    return true;
                }
            } else {
                if (stringArray == null || stringArray.length == 0) {
                    return false;
                }
                if (this.fParameterTypes.length != stringArray.length) {
                    return false;
                }
                int n = 0;
                while (n < stringArray.length) {
                    if (!this.fParameterTypes[n].equals(stringArray[n])) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
        }
        return false;
    }

    protected DOMNode newDOMNode() {
        return new DOMMethod();
    }

    protected void offset(int n) {
        super.offset(n);
        this.offsetRange(this.fBodyRange, n);
        this.offsetRange(this.fExceptionRange, n);
        this.offsetRange(this.fParameterRange, n);
        this.offsetRange(this.fReturnTypeRange, n);
    }

    public void setBody(String string) {
        this.becomeDetailed();
        this.fragment();
        this.fBody = string;
        this.setHasBody(string != null);
        if (!this.hasBody()) {
            this.fBody = ";" + Util.getLineSeparator(string, null);
        }
    }

    void setBodyRangeEnd(int n) {
        this.fBodyRange[1] = n;
    }

    public void setConstructor(boolean bl) {
        this.becomeDetailed();
        this.setMask(64, bl);
        this.fragment();
    }

    public void setExceptions(String[] stringArray) {
        this.becomeDetailed();
        if (stringArray == null || stringArray.length == 0) {
            this.fExceptions = null;
        } else {
            this.fExceptions = stringArray;
            CharArrayBuffer charArrayBuffer = new CharArrayBuffer();
            char[] cArray = new char[]{',', ' '};
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                if (n > 0) {
                    charArrayBuffer.append(cArray);
                }
                charArrayBuffer.append(stringArray[n]);
                ++n;
            }
            this.fExceptionList = charArrayBuffer.getContents();
        }
        this.fragment();
    }

    public void setName(String string) {
        if (string == null) {
            throw new IllegalArgumentException(Messages.element_nullName);
        }
        super.setName(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setParameters(String[] stringArray, String[] stringArray2) throws IllegalArgumentException {
        this.becomeDetailed();
        if (stringArray == null || stringArray2 == null) {
            if (stringArray != null || stringArray2 != null) throw new IllegalArgumentException(Messages.dom_mismatchArgNamesAndTypes);
            this.fParameterTypes = null;
            this.fParameterNames = null;
            this.fParameterList = new char[]{'(', ')'};
        } else {
            if (stringArray2.length != stringArray.length) {
                throw new IllegalArgumentException(Messages.dom_mismatchArgNamesAndTypes);
            }
            if (stringArray2.length == 0) {
                this.setParameters(null, null);
            } else {
                this.fParameterNames = stringArray2;
                this.fParameterTypes = stringArray;
                CharArrayBuffer charArrayBuffer = new CharArrayBuffer();
                charArrayBuffer.append("(");
                char[] cArray = new char[]{',', ' '};
                int n = 0;
                while (n < stringArray2.length) {
                    if (n > 0) {
                        charArrayBuffer.append(cArray);
                    }
                    charArrayBuffer.append(stringArray[n]).append(' ').append(stringArray2[n]);
                    ++n;
                }
                charArrayBuffer.append(')');
                this.fParameterList = charArrayBuffer.getContents();
            }
        }
        this.fragment();
    }

    public void setReturnType(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException(Messages.dom_nullReturnType);
        }
        this.becomeDetailed();
        this.fragment();
        this.setReturnTypeAltered(true);
        this.fReturnType = string;
    }

    protected void setReturnTypeAltered(boolean bl) {
        this.setMask(1024, bl);
    }

    protected void setSourceRangeEnd(int n) {
        super.setSourceRangeEnd(n);
        this.fBodyRange[1] = n;
    }

    protected void shareContents(DOMNode dOMNode) {
        super.shareContents(dOMNode);
        DOMMethod dOMMethod = (DOMMethod)dOMNode;
        this.fBody = dOMMethod.fBody;
        this.fBodyRange = this.rangeCopy(dOMMethod.fBodyRange);
        this.fExceptionList = dOMMethod.fExceptionList;
        this.fExceptionRange = this.rangeCopy(dOMMethod.fExceptionRange);
        this.fExceptions = dOMMethod.fExceptions;
        this.fParameterList = dOMMethod.fParameterList;
        this.fParameterNames = dOMMethod.fParameterNames;
        this.fParameterRange = this.rangeCopy(dOMMethod.fParameterRange);
        this.fParameterTypes = dOMMethod.fParameterTypes;
        this.fReturnType = dOMMethod.fReturnType;
        this.fReturnTypeRange = this.rangeCopy(dOMMethod.fReturnTypeRange);
    }

    public String toString() {
        if (this.isConstructor()) {
            return "CONSTRUCTOR";
        }
        return "METHOD: " + this.getName();
    }

    public void setDefault(String string) {
        this.fDefaultValue = string;
    }

    public String getDefault() {
        return this.fDefaultValue;
    }

    public String[] getTypeParameters() {
        return this.fTypeParameters;
    }

    public void setTypeParameters(String[] stringArray) {
        this.fTypeParameters = stringArray;
    }
}

