/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;

public abstract class AbstractIndexer
implements IIndexConstants {
    SearchDocument document;

    public AbstractIndexer(SearchDocument searchDocument) {
        this.document = searchDocument;
    }

    public void addAnnotationTypeDeclaration(int n, char[] cArray, char[] cArray2, char[][] cArray3, boolean bl) {
        this.addTypeDeclaration(n, cArray, cArray2, cArray3, bl);
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(n, cArray, cArray2, cArray3, null, 'A', CharOperation.concatWith(TypeConstants.JAVA_LANG_ANNOTATION_ANNOTATION, '.'), 'A'));
    }

    public void addClassDeclaration(int n, char[] cArray, char[] cArray2, char[][] cArray3, char[] cArray4, char[][] cArray5, char[][] cArray6, boolean bl) {
        this.addTypeDeclaration(n, cArray, cArray2, cArray3, bl);
        if (cArray4 != null) {
            cArray4 = this.erasure(cArray4);
            this.addTypeReference(cArray4);
        }
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(n, cArray, cArray2, cArray3, cArray6, 'C', cArray4, 'C'));
        if (cArray5 != null) {
            int n2 = 0;
            int n3 = cArray5.length;
            while (n2 < n3) {
                char[] cArray7 = this.erasure(cArray5[n2]);
                this.addTypeReference(cArray7);
                this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(n, cArray, cArray2, cArray3, cArray6, 'C', cArray7, 'I'));
                ++n2;
            }
        }
    }

    private char[] erasure(char[] cArray) {
        int n = CharOperation.indexOf('<', cArray);
        if (n > -1) {
            cArray = CharOperation.subarray(cArray, 0, n);
        }
        return cArray;
    }

    public void addConstructorDeclaration(char[] cArray, char[][] cArray2, char[][] cArray3) {
        int n;
        int n2 = cArray2 == null ? 0 : cArray2.length;
        this.addIndexEntry(CONSTRUCTOR_DECL, ConstructorPattern.createIndexKey(CharOperation.lastSegment(cArray, '.'), n2));
        if (cArray2 != null) {
            n = 0;
            while (n < n2) {
                this.addTypeReference(cArray2[n]);
                ++n;
            }
        }
        if (cArray3 != null) {
            n = 0;
            int n3 = cArray3.length;
            while (n < n3) {
                this.addTypeReference(cArray3[n]);
                ++n;
            }
        }
    }

    public void addConstructorReference(char[] cArray, int n) {
        char[] cArray2 = CharOperation.lastSegment(cArray, '.');
        this.addTypeReference(cArray2);
        this.addIndexEntry(CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(cArray2, n));
        char[] cArray3 = CharOperation.lastSegment(cArray2, '$');
        if (cArray3 != cArray2) {
            this.addIndexEntry(CONSTRUCTOR_REF, ConstructorPattern.createIndexKey(cArray3, n));
        }
    }

    public void addEnumDeclaration(int n, char[] cArray, char[] cArray2, char[][] cArray3, char[] cArray4, char[][] cArray5, boolean bl) {
        this.addTypeDeclaration(n, cArray, cArray2, cArray3, bl);
        this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(n, cArray, cArray2, cArray3, null, 'E', cArray4, 'C'));
        if (cArray5 != null) {
            int n2 = 0;
            int n3 = cArray5.length;
            while (n2 < n3) {
                char[] cArray6 = this.erasure(cArray5[n2]);
                this.addTypeReference(cArray6);
                this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(n, cArray, cArray2, cArray3, null, 'E', cArray6, 'I'));
                ++n2;
            }
        }
    }

    public void addFieldDeclaration(char[] cArray, char[] cArray2, boolean bl) {
        char[] cArray3 = bl ? VAR_DECL : FIELD_DECL;
        this.addIndexEntry(cArray3, FieldPattern.createIndexKey(cArray2));
        if (cArray != null) {
            this.addTypeReference(cArray);
        }
    }

    public void addFieldReference(char[] cArray) {
        this.addNameReference(cArray);
    }

    protected void addIndexEntry(char[] cArray, char[] cArray2) {
        this.document.addIndexEntry(cArray, cArray2);
    }

    public void addInterfaceDeclaration(int n, char[] cArray, char[] cArray2, char[][] cArray3, char[][] cArray4, char[][] cArray5, boolean bl) {
        this.addTypeDeclaration(n, cArray, cArray2, cArray3, bl);
        if (cArray4 != null) {
            int n2 = 0;
            int n3 = cArray4.length;
            while (n2 < n3) {
                char[] cArray6 = this.erasure(cArray4[n2]);
                this.addTypeReference(cArray6);
                this.addIndexEntry(SUPER_REF, SuperTypeReferencePattern.createIndexKey(n, cArray, cArray2, cArray3, cArray5, 'I', cArray6, 'I'));
                ++n2;
            }
        }
    }

    public void addMethodDeclaration(char[] cArray, char[][] cArray2, char[] cArray3, char[][] cArray4, boolean bl) {
        int n;
        int n2 = cArray2 == null ? 0 : cArray2.length;
        this.addIndexEntry(bl ? FUNCTION_DECL : METHOD_DECL, MethodPattern.createIndexKey(cArray, n2));
        if (cArray2 != null) {
            n = 0;
            while (n < n2) {
                this.addTypeReference(cArray2[n]);
                ++n;
            }
        }
        if (cArray4 != null) {
            n = 0;
            int n3 = cArray4.length;
            while (n < n3) {
                this.addTypeReference(cArray4[n]);
                ++n;
            }
        }
        if (cArray3 != null) {
            this.addTypeReference(cArray3);
        }
    }

    public void addMethodReference(char[] cArray, int n) {
        this.addIndexEntry(METHOD_REF, MethodPattern.createIndexKey(cArray, n));
    }

    public void addNameReference(char[] cArray) {
        this.addIndexEntry(REF, cArray);
    }

    protected void addTypeDeclaration(int n, char[] cArray, char[] cArray2, char[][] cArray3, boolean bl) {
        char[] cArray4 = TypeDeclarationPattern.createIndexKey(n, cArray2, cArray, cArray3, bl);
        if (bl) {
            JavaModelManager.getJavaModelManager().secondaryTypeAdding(this.document.getPath(), cArray2 == null ? CharOperation.NO_CHAR : cArray2, cArray == null ? CharOperation.NO_CHAR : cArray);
        }
        this.addIndexEntry(TYPE_DECL, cArray4);
    }

    public void addTypeReference(char[] cArray) {
        if (cArray != null) {
            this.addNameReference(CharOperation.lastSegment(cArray, '.'));
        }
    }

    public abstract void indexDocument();
}

