/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.indexing;

import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.wst.jsdt.internal.compiler.env.ClassSignature;
import org.eclipse.wst.jsdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.SuffixConstants;
import org.eclipse.wst.jsdt.internal.core.search.indexing.AbstractIndexer;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BinaryIndexer
extends AbstractIndexer
implements SuffixConstants {
    private static final char[] BYTE = "byte".toCharArray();
    private static final char[] CHAR = "char".toCharArray();
    private static final char[] DOUBLE = "double".toCharArray();
    private static final char[] FLOAT = "float".toCharArray();
    private static final char[] INT = "int".toCharArray();
    private static final char[] LONG = "long".toCharArray();
    private static final char[] SHORT = "short".toCharArray();
    private static final char[] BOOLEAN = "boolean".toCharArray();
    private static final char[] VOID = "void".toCharArray();
    private static final char[] INIT = "<init>".toCharArray();

    public BinaryIndexer(SearchDocument searchDocument) {
        super(searchDocument);
    }

    private void addBinaryStandardAnnotations(long l) {
        char[][] cArray;
        if ((l & 0xFF800000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_ANNOTATION_TARGET;
            this.addTypeReference(cArray[cArray.length - 1]);
            this.addBinaryTargetAnnotation(l);
        }
        if ((l & 0x300000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_ANNOTATION_RETENTION;
            this.addTypeReference(cArray[cArray.length - 1]);
            this.addBinaryRetentionAnnotation(l);
        }
        if ((l & 0x400000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_DEPRECATED;
            this.addTypeReference(cArray[cArray.length - 1]);
        }
        if ((l & 0x800000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_ANNOTATION_DOCUMENTED;
            this.addTypeReference(cArray[cArray.length - 1]);
        }
        if ((l & 0x1000000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_ANNOTATION_INHERITED;
            this.addTypeReference(cArray[cArray.length - 1]);
        }
        if ((l & 0x2000000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_OVERRIDE;
            this.addTypeReference(cArray[cArray.length - 1]);
        }
        if ((l & 0x4000000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_SUPPRESSWARNINGS;
            this.addTypeReference(cArray[cArray.length - 1]);
        }
    }

    private void addBinaryTargetAnnotation(long l) {
        char[][] cArray = null;
        if ((l & 0x40000000000L) != 0L) {
            cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
            this.addTypeReference(cArray[cArray.length - 1]);
            this.addFieldReference(TypeConstants.UPPER_ANNOTATION_TYPE);
        }
        if ((l & 0x10000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.UPPER_CONSTRUCTOR);
        }
        if ((l & 0x2000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.UPPER_FIELD);
        }
        if ((l & 0x20000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.UPPER_LOCAL_VARIABLE);
        }
        if ((l & 0x4000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.UPPER_METHOD);
        }
        if ((l & 0x80000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.UPPER_PACKAGE);
        }
        if ((l & 0x8000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.UPPER_PARAMETER);
        }
        if ((l & 0x1000000000L) != 0L) {
            if (cArray == null) {
                cArray = TypeConstants.JAVA_LANG_ANNOTATION_ELEMENTTYPE;
                this.addTypeReference(cArray[cArray.length - 1]);
            }
            this.addFieldReference(TypeConstants.TYPE);
        }
    }

    private void addBinaryRetentionAnnotation(long l) {
        char[][] cArray = TypeConstants.JAVA_LANG_ANNOTATION_RETENTIONPOLICY;
        this.addTypeReference(cArray[cArray.length - 1]);
        if ((l & 0x300000000000L) != 0L) {
            this.addFieldReference(TypeConstants.UPPER_RUNTIME);
        } else if ((l & 0x200000000000L) != 0L) {
            this.addFieldReference(TypeConstants.UPPER_CLASS);
        } else if ((l & 0x100000000000L) != 0L) {
            this.addFieldReference(TypeConstants.UPPER_SOURCE);
        }
    }

    private void addBinaryAnnotation(IBinaryAnnotation iBinaryAnnotation) {
        this.addTypeReference(this.replace('/', '.', Signature.toCharArray(iBinaryAnnotation.getTypeName())));
        IBinaryElementValuePair[] iBinaryElementValuePairArray = iBinaryAnnotation.getElementValuePairs();
        if (iBinaryElementValuePairArray != null) {
            int n = 0;
            int n2 = iBinaryElementValuePairArray.length;
            while (n < n2) {
                IBinaryElementValuePair iBinaryElementValuePair = iBinaryElementValuePairArray[n];
                this.addMethodReference(iBinaryElementValuePair.getName(), 0);
                Object object = iBinaryElementValuePair.getValue();
                this.addPairValue(object);
                ++n;
            }
        }
    }

    private void addPairValue(Object object) {
        if (object instanceof EnumConstantSignature) {
            EnumConstantSignature enumConstantSignature = (EnumConstantSignature)object;
            this.addTypeReference(this.replace('/', '.', Signature.toCharArray(enumConstantSignature.getTypeName())));
            this.addNameReference(enumConstantSignature.getEnumConstantName());
        } else if (object instanceof ClassSignature) {
            ClassSignature classSignature = (ClassSignature)object;
            this.addTypeReference(this.replace('/', '.', Signature.toCharArray(classSignature.getTypeName())));
        } else if (object instanceof IBinaryAnnotation) {
            this.addBinaryAnnotation((IBinaryAnnotation)object);
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                this.addPairValue(objectArray[n]);
                ++n;
            }
        }
    }

    public void addTypeReference(char[] cArray) {
        int n = cArray.length;
        if (n > 2 && cArray[n - 2] == '$') {
            switch (cArray[n - 1]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return;
                }
            }
        }
        cArray = CharOperation.replaceOnCopy(cArray, '$', '.');
        super.addTypeReference(cArray);
    }

    private void convertToArrayType(char[][] cArray, int n, int n2) {
        int n3 = cArray[n].length;
        char[] cArray2 = new char[n3 + n2 * 2];
        System.arraycopy(cArray[n], 0, cArray2, 0, n3);
        int n4 = 0;
        while (n4 < n2) {
            cArray2[n3 + n4 * 2] = 91;
            cArray2[n3 + n4 * 2 + 1] = 93;
            ++n4;
        }
        cArray[n] = cArray2;
    }

    private char[] convertToArrayType(char[] cArray, int n) {
        int n2 = cArray.length;
        char[] cArray2 = new char[n2 + n * 2];
        System.arraycopy(cArray, 0, cArray2, 0, n2);
        int n3 = 0;
        while (n3 < n) {
            cArray2[n2 + n3 * 2] = 91;
            cArray2[n2 + n3 * 2 + 1] = 93;
            ++n3;
        }
        return cArray2;
    }

    private char[] decodeFieldType(char[] cArray) throws ClassFormatException {
        if (cArray == null) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = cArray.length;
        while (n2 < n3) {
            switch (cArray[n2]) {
                case 'B': {
                    if (n > 0) {
                        return this.convertToArrayType(BYTE, n);
                    }
                    return BYTE;
                }
                case 'C': {
                    if (n > 0) {
                        return this.convertToArrayType(CHAR, n);
                    }
                    return CHAR;
                }
                case 'D': {
                    if (n > 0) {
                        return this.convertToArrayType(DOUBLE, n);
                    }
                    return DOUBLE;
                }
                case 'F': {
                    if (n > 0) {
                        return this.convertToArrayType(FLOAT, n);
                    }
                    return FLOAT;
                }
                case 'I': {
                    if (n > 0) {
                        return this.convertToArrayType(INT, n);
                    }
                    return INT;
                }
                case 'J': {
                    if (n > 0) {
                        return this.convertToArrayType(LONG, n);
                    }
                    return LONG;
                }
                case 'L': {
                    int n4 = CharOperation.indexOf(';', cArray, n2 + 1);
                    if (n4 == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (n > 0) {
                        return this.convertToArrayType(this.replace('/', '.', CharOperation.subarray(cArray, n2 + 1, n4)), n);
                    }
                    return this.replace('/', '.', CharOperation.subarray(cArray, n2 + 1, n4));
                }
                case 'S': {
                    if (n > 0) {
                        return this.convertToArrayType(SHORT, n);
                    }
                    return SHORT;
                }
                case 'Z': {
                    if (n > 0) {
                        return this.convertToArrayType(BOOLEAN, n);
                    }
                    return BOOLEAN;
                }
                case 'V': {
                    return VOID;
                }
                case '[': {
                    ++n;
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++n2;
        }
        return null;
    }

    private char[][] decodeParameterTypes(char[] cArray, boolean bl) throws ClassFormatException {
        if (cArray == null) {
            return null;
        }
        int n = CharOperation.lastIndexOf(')', cArray);
        if (n == 1) {
            return null;
        }
        if (n == -1) {
            throw new ClassFormatException(28);
        }
        char[][] cArrayArray = new char[3][];
        int n2 = 0;
        int n3 = 0;
        int n4 = 1;
        while (n4 < n) {
            if (n2 == cArrayArray.length) {
                char[][] cArrayArray2 = cArrayArray;
                cArrayArray = new char[n2 * 2][];
                System.arraycopy(cArrayArray2, 0, cArrayArray, 0, n2);
            }
            switch (cArray[n4]) {
                case 'B': {
                    cArrayArray[n2++] = BYTE;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'C': {
                    cArrayArray[n2++] = CHAR;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'D': {
                    cArrayArray[n2++] = DOUBLE;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'F': {
                    cArrayArray[n2++] = FLOAT;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'I': {
                    cArrayArray[n2++] = INT;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'J': {
                    cArrayArray[n2++] = LONG;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'L': {
                    int n5 = CharOperation.indexOf(';', cArray, n4 + 1);
                    if (n5 == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (bl && n2 == 0) {
                        bl = false;
                    } else {
                        cArrayArray[n2++] = this.replace('/', '.', CharOperation.subarray(cArray, n4 + 1, n5));
                        if (n3 > 0) {
                            this.convertToArrayType(cArrayArray, n2 - 1, n3);
                        }
                    }
                    n4 = n5;
                    n3 = 0;
                    break;
                }
                case 'S': {
                    cArrayArray[n2++] = SHORT;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case 'Z': {
                    cArrayArray[n2++] = BOOLEAN;
                    if (n3 > 0) {
                        this.convertToArrayType(cArrayArray, n2 - 1, n3);
                    }
                    n3 = 0;
                    break;
                }
                case '[': {
                    ++n3;
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++n4;
        }
        if (cArrayArray.length != n2) {
            char[][] cArrayArray3 = cArrayArray;
            cArrayArray = new char[n2][];
            System.arraycopy(cArrayArray3, 0, cArrayArray, 0, n2);
        }
        return cArrayArray;
    }

    private char[] decodeReturnType(char[] cArray) throws ClassFormatException {
        if (cArray == null) {
            return null;
        }
        int n = CharOperation.lastIndexOf(')', cArray);
        if (n == -1) {
            throw new ClassFormatException(28);
        }
        int n2 = 0;
        int n3 = n + 1;
        int n4 = cArray.length;
        while (n3 < n4) {
            switch (cArray[n3]) {
                case 'B': {
                    if (n2 > 0) {
                        return this.convertToArrayType(BYTE, n2);
                    }
                    return BYTE;
                }
                case 'C': {
                    if (n2 > 0) {
                        return this.convertToArrayType(CHAR, n2);
                    }
                    return CHAR;
                }
                case 'D': {
                    if (n2 > 0) {
                        return this.convertToArrayType(DOUBLE, n2);
                    }
                    return DOUBLE;
                }
                case 'F': {
                    if (n2 > 0) {
                        return this.convertToArrayType(FLOAT, n2);
                    }
                    return FLOAT;
                }
                case 'I': {
                    if (n2 > 0) {
                        return this.convertToArrayType(INT, n2);
                    }
                    return INT;
                }
                case 'J': {
                    if (n2 > 0) {
                        return this.convertToArrayType(LONG, n2);
                    }
                    return LONG;
                }
                case 'L': {
                    int n5 = CharOperation.indexOf(';', cArray, n3 + 1);
                    if (n5 == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (n2 > 0) {
                        return this.convertToArrayType(this.replace('/', '.', CharOperation.subarray(cArray, n3 + 1, n5)), n2);
                    }
                    return this.replace('/', '.', CharOperation.subarray(cArray, n3 + 1, n5));
                }
                case 'S': {
                    if (n2 > 0) {
                        return this.convertToArrayType(SHORT, n2);
                    }
                    return SHORT;
                }
                case 'Z': {
                    if (n2 > 0) {
                        return this.convertToArrayType(BOOLEAN, n2);
                    }
                    return BOOLEAN;
                }
                case 'V': {
                    return VOID;
                }
                case '[': {
                    ++n2;
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++n3;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private int extractArgCount(char[] var1_1, char[] var2_2) throws ClassFormatException {
        var3_3 = CharOperation.lastIndexOf(')', var1_1);
        if (var3_3 == 1) {
            return 0;
        }
        if (var3_3 == -1) {
            throw new ClassFormatException(28);
        }
        var4_4 = 0;
        var5_5 = 1;
        while (var5_5 < var3_3) {
            switch (var1_1[var5_5]) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    ++var4_4;
                    break;
                }
                case 'L': {
                    var6_6 = CharOperation.indexOf(';', var1_1, var5_5 + 1);
                    if (var6_6 == -1) {
                        throw new ClassFormatException(28);
                    }
                    if (var2_2 == null || var4_4 != 0) ** GOTO lbl33
                    var7_7 = Signature.createCharArrayTypeSignature(var2_2, true);
                    if (var7_7.length <= (var8_8 = var6_6 - var5_5 + 1) + 1) ** GOTO lbl30
                    var9_9 = var5_5;
                    var10_10 = 0;
                    while (var9_9 < var6_6) {
                        if (var1_1[var9_9] == var7_7[var10_10] || var1_1[var9_9] == '/' && var7_7[var10_10] == '.') ** GOTO lbl26
                        ++var4_4;
                        ** GOTO lbl31
lbl26:
                        // 1 sources

                        ++var9_9;
                        ++var10_10;
                    }
                    ** GOTO lbl31
lbl30:
                    // 1 sources

                    ++var4_4;
lbl31:
                    // 3 sources

                    var2_2 = null;
                    ** GOTO lbl34
lbl33:
                    // 1 sources

                    ++var4_4;
lbl34:
                    // 2 sources

                    var5_5 = var6_6;
                    break;
                }
                case '[': {
                    break;
                }
                default: {
                    throw new ClassFormatException(28);
                }
            }
            ++var5_5;
        }
        return var4_4;
    }

    private char[] extractClassName(int[] nArray, ClassFileReader classFileReader, int n) {
        int n2 = classFileReader.u2At(nArray[n] + 1);
        int n3 = nArray[classFileReader.u2At(nArray[n2] + 1)];
        return classFileReader.utf8At(n3 + 3, classFileReader.u2At(n3 + 1));
    }

    private char[] extractName(int[] nArray, ClassFileReader classFileReader, int n) {
        int n2 = classFileReader.u2At(nArray[n] + 3);
        int n3 = nArray[classFileReader.u2At(nArray[n2] + 1)];
        return classFileReader.utf8At(n3 + 3, classFileReader.u2At(n3 + 1));
    }

    private char[] extractClassReference(int[] nArray, ClassFileReader classFileReader, int n) {
        int n2 = nArray[classFileReader.u2At(nArray[n] + 1)];
        return classFileReader.utf8At(n2 + 3, classFileReader.u2At(n2 + 1));
    }

    private void extractReferenceFromConstantPool(byte[] byArray, ClassFileReader classFileReader) throws ClassFormatException {
        int[] nArray = classFileReader.getConstantPoolOffsets();
        int n = nArray.length;
        int n2 = 1;
        while (n2 < n) {
            int n3 = classFileReader.u1At(nArray[n2]);
            char[] cArray = null;
            char[] cArray2 = null;
            switch (n3) {
                case 9: {
                    cArray = this.extractName(nArray, classFileReader, n2);
                    this.addFieldReference(cArray);
                    break;
                }
                case 10: 
                case 11: {
                    int n4;
                    int n5;
                    Object object;
                    cArray = this.extractName(nArray, classFileReader, n2);
                    cArray2 = this.extractType(nArray, classFileReader, n2);
                    if (CharOperation.equals(INIT, cArray)) {
                        object = this.extractClassName(nArray, classFileReader, n2);
                        n5 = 0;
                        if (object != null) {
                            n4 = 0;
                            int n6 = ((char[])object).length;
                            while (n4 < n6) {
                                switch (object[n4]) {
                                    case '/': {
                                        object[n4] = 46;
                                        break;
                                    }
                                    case '$': {
                                        n5 = 1;
                                    }
                                }
                                ++n4;
                            }
                        }
                        this.addConstructorReference((char[])object, this.extractArgCount(cArray2, (char[])(n5 != 0 ? object : null)));
                        break;
                    }
                    this.addMethodReference(cArray, this.extractArgCount(cArray2, null));
                    break;
                }
                case 7: {
                    cArray = this.extractClassReference(nArray, classFileReader, n2);
                    if (cArray.length > 0 && cArray[0] == '[') break;
                    cArray = this.replace('/', '.', cArray);
                    this.addTypeReference(cArray);
                    Object object = CharOperation.splitOn('.', cArray);
                    int n5 = 0;
                    int n4 = ((char[])object).length;
                    while (n5 < n4) {
                        this.addNameReference((char[])object[n5]);
                        ++n5;
                    }
                    break;
                }
            }
            ++n2;
        }
    }

    private char[] extractType(int[] nArray, ClassFileReader classFileReader, int n) {
        int n2 = classFileReader.u2At(nArray[n] + 3);
        int n3 = nArray[classFileReader.u2At(nArray[n2] + 3)];
        return classFileReader.utf8At(n3 + 3, classFileReader.u2At(n3 + 1));
    }

    public void indexDocument() {
        try {
            FieldInfo[] fieldInfoArray;
            Object object;
            char[] cArray;
            int n;
            long l;
            Object[] objectArray;
            char[][] cArrayArray;
            Object object2;
            byte[] byArray = this.document.getByteContents();
            if (byArray == null) {
                return;
            }
            String string = this.document.getPath();
            ClassFileReader classFileReader = new ClassFileReader(byArray, string == null ? null : string.toCharArray());
            char[] cArray2 = this.replace('/', '.', classFileReader.getName());
            int n2 = CharOperation.lastIndexOf('.', cArray2);
            char[] cArray3 = null;
            char[] cArray4 = null;
            if (n2 >= 0) {
                cArray3 = CharOperation.subarray(cArray2, 0, n2);
                cArray4 = CharOperation.subarray(cArray2, n2 + 1, cArray2.length);
            } else {
                cArray3 = CharOperation.NO_CHAR;
                cArray4 = cArray2;
            }
            char[] cArray5 = null;
            boolean bl = classFileReader.isNestedType();
            if (bl) {
                cArray4 = classFileReader.isAnonymous() ? CharOperation.NO_CHAR : classFileReader.getInnerSourceName();
                if (classFileReader.isLocal() || classFileReader.isAnonymous()) {
                    cArray5 = ONE_ZERO;
                } else {
                    object2 = classFileReader.getEnclosingTypeName();
                    int n3 = ((char[][])object2).length - n2 - 1;
                    if (n3 <= 0) {
                        return;
                    }
                    cArray5 = new char[n3];
                    System.arraycopy(object2, n2 + 1, cArray5, 0, n3);
                }
            }
            object2 = null;
            char[] cArray6 = classFileReader.getGenericSignature();
            if (cArray6 != null) {
                CharOperation.replace(cArray6, '/', '.');
                object2 = Signature.getTypeParameters(cArray6);
            }
            if (cArray4 == null) {
                return;
            }
            char[][] cArray7 = this.replace('/', '.', classFileReader.getInterfaceNames());
            if (cArray5 == null) {
                cArrayArray = null;
            } else {
                char[][] cArrayArray2 = new char[1][];
                cArrayArray = cArrayArray2;
                cArrayArray2[0] = cArray5;
            }
            char[][] cArrayArray3 = cArrayArray;
            int n4 = classFileReader.getModifiers();
            switch (TypeDeclaration.kind(n4)) {
                case 1: {
                    objectArray = this.replace('/', '.', classFileReader.getSuperclassName());
                    this.addClassDeclaration(n4, cArray3, cArray4, cArrayArray3, (char[])objectArray, cArray7, (char[][])object2, false);
                    break;
                }
                case 2: {
                    this.addInterfaceDeclaration(n4, cArray3, cArray4, cArrayArray3, cArray7, (char[][])object2, false);
                    break;
                }
                case 3: {
                    objectArray = this.replace('/', '.', classFileReader.getSuperclassName());
                    this.addEnumDeclaration(n4, cArray3, cArray4, cArrayArray3, (char[])objectArray, cArray7, false);
                    break;
                }
                case 4: {
                    this.addAnnotationTypeDeclaration(n4, cArray3, cArray4, cArrayArray3, false);
                }
            }
            objectArray = classFileReader.getAnnotations();
            if (objectArray != null) {
                int n5 = 0;
                int n6 = objectArray.length;
                while (n5 < n6) {
                    IBinaryAnnotation iBinaryAnnotation = objectArray[n5];
                    this.addBinaryAnnotation(iBinaryAnnotation);
                    ++n5;
                }
            }
            if ((l = classFileReader.getTagBits() & 0x7FFF800000000L) != 0L) {
                this.addBinaryStandardAnnotations(l);
            }
            boolean bl2 = true;
            MethodInfo[] methodInfoArray = (MethodInfo[])classFileReader.getMethods();
            if (methodInfoArray != null) {
                int n7 = 0;
                n = methodInfoArray.length;
                while (n7 < n) {
                    MethodInfo methodInfo = methodInfoArray[n7];
                    boolean bl3 = methodInfo.isConstructor();
                    cArray = methodInfo.getMethodDescriptor();
                    object = this.decodeParameterTypes(cArray, bl3 && bl);
                    char[] cArray8 = this.decodeReturnType(cArray);
                    char[][] cArray9 = this.replace('/', '.', methodInfo.getExceptionTypeNames());
                    if (bl3) {
                        this.addConstructorDeclaration(cArray2, (char[][])object, cArray9);
                    } else if (!methodInfo.isClinit()) {
                        this.addMethodDeclaration(methodInfo.getSelector(), (char[][])object, cArray8, cArray9, bl2);
                    }
                    objectArray = methodInfo.getAnnotations();
                    if (objectArray != null) {
                        int n8 = 0;
                        int n9 = objectArray.length;
                        while (n8 < n9) {
                            IBinaryAnnotation iBinaryAnnotation = objectArray[n8];
                            this.addBinaryAnnotation(iBinaryAnnotation);
                            ++n8;
                        }
                    }
                    ++n7;
                }
            }
            if ((fieldInfoArray = (FieldInfo[])classFileReader.getFields()) != null) {
                n = 0;
                int n10 = fieldInfoArray.length;
                while (n < n10) {
                    FieldInfo fieldInfo = fieldInfoArray[n];
                    cArray = fieldInfo.getName();
                    object = this.decodeFieldType(this.replace('/', '.', fieldInfo.getTypeName()));
                    this.addFieldDeclaration((char[])object, cArray, false);
                    objectArray = fieldInfo.getAnnotations();
                    if (objectArray != null) {
                        int n11 = 0;
                        int n12 = objectArray.length;
                        while (n11 < n12) {
                            IBinaryAnnotation iBinaryAnnotation = objectArray[n11];
                            this.addBinaryAnnotation(iBinaryAnnotation);
                            ++n11;
                        }
                    }
                    ++n;
                }
            }
            this.extractReferenceFromConstantPool(byArray, classFileReader);
        }
        catch (ClassFormatException classFormatException) {
            this.document.removeAllIndexEntries();
            Util.log(classFormatException, "ClassFormatException in " + this.document.getPath() + ". Please report this issue to JDT/Core including the problematic document");
        }
        catch (RuntimeException runtimeException) {
            this.document.removeAllIndexEntries();
            Util.log(runtimeException, "Indexer crashed on document " + this.document.getPath() + ". Please report this issue to JDT/Core including the problematic document");
        }
    }

    private char[][] replace(char c, char c2, char[][] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            this.replace(c, c2, cArray[n]);
            ++n;
        }
        return cArray;
    }

    private char[] replace(char c, char c2, char[] cArray) {
        if (cArray == null) {
            return null;
        }
        int n = 0;
        int n2 = cArray.length;
        while (n < n2) {
            if (cArray[n] == c) {
                cArray[n] = c2;
            }
            ++n;
        }
        return cArray;
    }
}

