/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfLong;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.wst.jsdt.internal.compiler.util.SimpleSet;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class MatchingNodeSet {
    SimpleLookupTable matchingNodes = new SimpleLookupTable(3);
    private HashtableOfLong matchingNodesKeys = new HashtableOfLong(3);
    static Integer EXACT_MATCH = new Integer(0);
    static Integer POTENTIAL_MATCH = new Integer(1);
    static Integer ERASURE_MATCH = new Integer(16);
    public boolean mustResolve;
    SimpleSet possibleMatchingNodesSet = new SimpleSet(7);
    private HashtableOfLong possibleMatchingNodesKeys = new HashtableOfLong(7);

    public MatchingNodeSet(boolean bl) {
        this.mustResolve = bl;
    }

    public int addMatch(ASTNode aSTNode, int n) {
        int n2 = n & 0xF;
        switch (n2) {
            case 1: {
                if (n != n2) {
                    this.addTrustedMatch(aSTNode, new Integer(1 + (n & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(aSTNode, POTENTIAL_MATCH);
                break;
            }
            case 2: {
                this.addPossibleMatch(aSTNode);
                break;
            }
            case 4: {
                if (n != n2) {
                    this.addTrustedMatch(aSTNode, new Integer(16 + (n & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(aSTNode, ERASURE_MATCH);
                break;
            }
            case 3: {
                if (n != n2) {
                    this.addTrustedMatch(aSTNode, new Integer(0 + (n & 0xFFFFFFF0)));
                    break;
                }
                this.addTrustedMatch(aSTNode, EXACT_MATCH);
            }
        }
        return n;
    }

    public void addPossibleMatch(ASTNode aSTNode) {
        long l = ((long)aSTNode.sourceStart << 32) + (long)aSTNode.sourceEnd;
        ASTNode aSTNode2 = (ASTNode)this.possibleMatchingNodesKeys.get(l);
        if (aSTNode2 != null && aSTNode2.getClass().equals(aSTNode.getClass())) {
            this.possibleMatchingNodesSet.remove(aSTNode2);
        }
        this.possibleMatchingNodesSet.add(aSTNode);
        this.possibleMatchingNodesKeys.put(l, aSTNode);
    }

    public void addTrustedMatch(ASTNode aSTNode, boolean bl) {
        this.addTrustedMatch(aSTNode, bl ? EXACT_MATCH : POTENTIAL_MATCH);
    }

    void addTrustedMatch(ASTNode aSTNode, Integer n) {
        long l = ((long)aSTNode.sourceStart << 32) + (long)aSTNode.sourceEnd;
        ASTNode aSTNode2 = (ASTNode)this.matchingNodesKeys.get(l);
        if (aSTNode2 != null && aSTNode2.getClass().equals(aSTNode.getClass())) {
            this.matchingNodes.removeKey(aSTNode2);
        }
        this.matchingNodes.put(aSTNode, n);
        this.matchingNodesKeys.put(l, aSTNode);
    }

    protected boolean hasPossibleNodes(int n, int n2) {
        ASTNode aSTNode;
        Object[] objectArray = this.possibleMatchingNodesSet.values;
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            aSTNode = (ASTNode)objectArray[n3];
            if (aSTNode != null && !aSTNode.isInferred() && n <= aSTNode.sourceStart && aSTNode.sourceEnd <= n2) {
                return true;
            }
            ++n3;
        }
        objectArray = this.matchingNodes.keyTable;
        n3 = 0;
        n4 = objectArray.length;
        while (n3 < n4) {
            aSTNode = (ASTNode)objectArray[n3];
            if (aSTNode != null && n <= aSTNode.sourceStart && aSTNode.sourceEnd <= n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    protected ASTNode[] matchingNodes(int n, int n2) {
        ArrayList<ASTNode> arrayList = null;
        Object[] objectArray = this.matchingNodes.keyTable;
        int n3 = 0;
        int n4 = objectArray.length;
        while (n3 < n4) {
            ASTNode aSTNode = (ASTNode)objectArray[n3];
            if (aSTNode != null && n <= aSTNode.sourceStart && aSTNode.sourceEnd <= n2 && !aSTNode.isInferred()) {
                if (arrayList == null) {
                    arrayList = new ArrayList<ASTNode>();
                }
                arrayList.add(aSTNode);
            }
            ++n3;
        }
        if (arrayList == null) {
            return null;
        }
        Object[] objectArray2 = new ASTNode[arrayList.size()];
        arrayList.toArray(objectArray2);
        Util.Comparer comparer = new Util.Comparer(){

            public int compare(Object object, Object object2) {
                return ((ASTNode)object).sourceStart - ((ASTNode)object2).sourceStart;
            }
        };
        Util.sort(objectArray2, comparer);
        return objectArray2;
    }

    public Object removePossibleMatch(ASTNode aSTNode) {
        long l = ((long)aSTNode.sourceStart << 32) + (long)aSTNode.sourceEnd;
        ASTNode aSTNode2 = (ASTNode)this.possibleMatchingNodesKeys.get(l);
        if (aSTNode2 == null) {
            return null;
        }
        this.possibleMatchingNodesKeys.put(l, null);
        return this.possibleMatchingNodesSet.remove(aSTNode);
    }

    public Object removeTrustedMatch(ASTNode aSTNode) {
        long l = ((long)aSTNode.sourceStart << 32) + (long)aSTNode.sourceEnd;
        ASTNode aSTNode2 = (ASTNode)this.matchingNodesKeys.get(l);
        if (aSTNode2 == null) {
            return null;
        }
        this.matchingNodesKeys.put(l, null);
        return this.matchingNodes.removeKey(aSTNode);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Exact matches:");
        Object[] objectArray = this.matchingNodes.keyTable;
        Object[] objectArray2 = this.matchingNodes.valueTable;
        int n = 0;
        int n2 = objectArray.length;
        while (n < n2) {
            ASTNode aSTNode = (ASTNode)objectArray[n];
            if (aSTNode != null) {
                stringBuffer.append("\n\t");
                switch ((Integer)objectArray2[n]) {
                    case 0: {
                        stringBuffer.append("ACCURATE_MATCH: ");
                        break;
                    }
                    case 1: {
                        stringBuffer.append("INACCURATE_MATCH: ");
                        break;
                    }
                    case 16: {
                        stringBuffer.append("ERASURE_MATCH: ");
                    }
                }
                aSTNode.print(0, stringBuffer);
            }
            ++n;
        }
        stringBuffer.append("\nPossible matches:");
        Object[] objectArray3 = this.possibleMatchingNodesSet.values;
        n2 = 0;
        int n3 = objectArray3.length;
        while (n2 < n3) {
            ASTNode aSTNode = (ASTNode)objectArray3[n2];
            if (aSTNode != null) {
                stringBuffer.append("\nPOSSIBLE_MATCH: ");
                aSTNode.print(0, stringBuffer);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }
}

