/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class PossibleMatch
implements ICompilationUnit {
    public static final String NO_SOURCE_FILE_NAME = "NO SOURCE FILE NAME";
    public IResource resource;
    public Openable openable;
    public MatchingNodeSet nodeSet;
    public char[][] compoundName;
    CompilationUnitDeclaration parsedUnit;
    public SearchDocument document;
    private String sourceFileName;
    private char[] source;

    public PossibleMatch(MatchLocator matchLocator, IResource iResource, Openable openable, SearchDocument searchDocument, boolean bl) {
        this.resource = iResource;
        this.openable = openable;
        this.document = searchDocument;
        this.nodeSet = new MatchingNodeSet(bl);
        char[] cArray = this.getQualifiedName();
        if (cArray != null) {
            this.compoundName = CharOperation.splitOn('.', cArray);
        }
    }

    public void cleanUp() {
        this.source = null;
        if (this.parsedUnit != null) {
            this.parsedUnit.cleanUp();
            this.parsedUnit = null;
        }
        this.nodeSet = null;
    }

    public boolean equals(Object object) {
        if (this.compoundName == null) {
            return super.equals(object);
        }
        if (!(object instanceof PossibleMatch)) {
            return false;
        }
        return CharOperation.equals(this.compoundName, ((PossibleMatch)object).compoundName);
    }

    public char[] getContents() {
        if (this.source != null) {
            return this.source;
        }
        if (this.openable instanceof ClassFile) {
            this.source = ((ClassFile)this.openable).getContents();
            return this.source;
        }
        this.source = this.document.getCharContents();
        return this.source;
    }

    public char[] getFileName() {
        return this.openable.getElementName().toCharArray();
    }

    public char[] getMainTypeName() {
        return this.compoundName[this.compoundName.length - 1];
    }

    public char[][] getPackageName() {
        int n = this.compoundName.length;
        if (n <= 1) {
            return CharOperation.NO_CHAR_CHAR;
        }
        return CharOperation.subarray(this.compoundName, 0, n - 1);
    }

    private char[] getQualifiedName() {
        if (this.openable instanceof CompilationUnit) {
            String string = this.openable.getElementName();
            char[] cArray = Util.getNameWithoutJavaLikeExtension(string).toCharArray();
            CompilationUnit compilationUnit = (CompilationUnit)this.openable;
            return compilationUnit.getType(new String(cArray)).getFullyQualifiedName().toCharArray();
        }
        if (this.openable instanceof ClassFile) {
            String string = this.getSourceFileName();
            if (string == NO_SOURCE_FILE_NAME) {
                return ((ClassFile)this.openable).getType().getFullyQualifiedName('.').toCharArray();
            }
            int n = Util.indexOfJavaLikeExtension(string);
            String string2 = n == -1 ? string : string.substring(0, n);
            PackageFragment packageFragment = (PackageFragment)this.openable.getParent();
            return Util.concatWith(packageFragment.names, string2, '.').toCharArray();
        }
        return null;
    }

    private String getSourceFileName() {
        if (this.sourceFileName != null) {
            return this.sourceFileName;
        }
        this.sourceFileName = NO_SOURCE_FILE_NAME;
        return this.sourceFileName;
    }

    public int hashCode() {
        if (this.compoundName == null) {
            return super.hashCode();
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.compoundName.length;
        while (n2 < n3) {
            n += CharOperation.hashCode(this.compoundName[n2]);
            ++n2;
        }
        return n;
    }

    public String toString() {
        return this.openable == null ? "Fake PossibleMatch" : this.openable.toString();
    }

    public LibrarySuperType getCommonSuperType() {
        return this.openable.getCommonSuperType();
    }
}

