/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;

public class BindingKeyParser {
    int keyStart;
    static final char C_THROWN = '|';
    private boolean parsingPaused;
    private Scanner scanner;
    private boolean hasTypeName = true;

    public BindingKeyParser(BindingKeyParser bindingKeyParser) {
        this("");
        this.scanner = bindingKeyParser.scanner;
    }

    public BindingKeyParser(String string) {
        this.scanner = new Scanner(string.toCharArray());
    }

    public void consumeArrayDimension(char[] cArray) {
    }

    public void consumeBaseType(char[] cArray) {
    }

    public void consumeCapture(int n) {
    }

    public void consumeException() {
    }

    public void consumeField(char[] cArray) {
    }

    public void consumeParameterizedGenericMethod() {
    }

    public void consumeLocalType(char[] cArray) {
    }

    public void consumeLocalVar(char[] cArray) {
    }

    public void consumeMethod(char[] cArray, char[] cArray2) {
    }

    public void consumeModifiers(char[] cArray) {
    }

    public void consumeNonGenericType() {
    }

    public void consumeMemberType(char[] cArray) {
    }

    public void consumePackage(char[] cArray) {
    }

    public void consumeParameterizedType(char[] cArray, boolean bl) {
    }

    public void consumeParser(BindingKeyParser bindingKeyParser) {
    }

    public void consumeRawType() {
    }

    public void consumeScope(int n) {
    }

    public void consumeSecondaryType(char[] cArray) {
    }

    public void consumeFullyQualifiedName(char[] cArray) {
    }

    public void consumeKey() {
    }

    public void consumeTopLevelType() {
    }

    public void consumeType() {
    }

    public void consumeTypeParameter(char[] cArray) {
    }

    public void consumeTypeVariable(char[] cArray, char[] cArray2) {
    }

    public void consumeTypeWithCapture() {
    }

    public void consumeWildCard(int n) {
    }

    public String getKey() {
        return new String(this.scanner.source);
    }

    public boolean hasTypeName() {
        return this.hasTypeName;
    }

    public void malformedKey() {
    }

    public BindingKeyParser newParser() {
        return new BindingKeyParser(this);
    }

    public void parse() {
        this.parse(false);
    }

    public void parse(boolean bl) {
        try {
            block25: {
                block24: {
                    if (!this.parsingPaused) {
                        this.parseFullyQualifiedName();
                        this.parseSecondaryType();
                        if (bl) {
                            this.parsingPaused = true;
                            return;
                        }
                    }
                    if (!this.hasTypeName()) {
                        this.consumeKey();
                        return;
                    }
                    this.consumeTopLevelType();
                    this.parseInnerType();
                    if (this.scanner.isAtParametersStart()) {
                        this.scanner.skipParametersStart();
                        if (this.scanner.isAtTypeParameterStart()) {
                            this.parseGenericType();
                            this.scanner.skipParametersEnd();
                            this.parseInnerType();
                        } else if (this.scanner.isAtTypeArgumentStart()) {
                            this.parseParameterizedType(null, false);
                        } else if (this.scanner.isAtRawTypeEnd()) {
                            this.parseRawType();
                        }
                    } else {
                        this.consumeNonGenericType();
                    }
                    this.consumeType();
                    this.scanner.skipTypeEnd();
                    if (!this.scanner.isAtFieldOrMethodStart()) break block24;
                    switch (this.scanner.nextToken()) {
                        case 2: {
                            this.parseField();
                            return;
                        }
                        case 3: {
                            this.parseMethod();
                            if (this.scanner.isAtLocalVariableStart()) {
                                this.parseLocalVariable();
                            } else if (this.scanner.isAtTypeVariableStart()) {
                                this.parseTypeVariable();
                            }
                            break block25;
                        }
                        default: {
                            this.malformedKey();
                            return;
                        }
                    }
                }
                if (this.scanner.isAtTypeVariableStart()) {
                    this.parseTypeVariable();
                } else if (this.scanner.isAtWildcardStart()) {
                    this.parseWildcard();
                } else if (this.scanner.isAtTypeWithCaptureStart()) {
                    this.parseTypeWithCapture();
                }
            }
            this.consumeKey();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    private void parseFullyQualifiedName() {
        if (this.scanner.isAtCaptureStart()) {
            this.parseCapture();
            this.hasTypeName = false;
            return;
        }
        block0 : switch (this.scanner.nextToken()) {
            case 0: {
                this.keyStart = 0;
                this.consumePackage(this.scanner.getTokenSource());
                this.hasTypeName = false;
                return;
            }
            case 1: {
                this.keyStart = this.scanner.start - 1;
                this.consumeFullyQualifiedName(this.scanner.getTokenSource());
                break;
            }
            case 9: {
                this.keyStart = this.scanner.start - 1;
                this.consumeBaseType(this.scanner.getTokenSource());
                this.hasTypeName = false;
                break;
            }
            case 4: {
                this.keyStart = this.scanner.start;
                this.consumeArrayDimension(this.scanner.getTokenSource());
                switch (this.scanner.nextToken()) {
                    case 1: {
                        this.consumeFullyQualifiedName(this.scanner.getTokenSource());
                        break block0;
                    }
                    case 9: {
                        this.consumeBaseType(this.scanner.getTokenSource());
                        this.hasTypeName = false;
                        break block0;
                    }
                }
                this.malformedKey();
                return;
            }
            default: {
                this.malformedKey();
                return;
            }
        }
    }

    private void parseParameterizedMethod() {
        this.scanner.skipParametersStart();
        while (!this.scanner.isAtParametersEnd()) {
            this.parseTypeArgument();
        }
        this.consumeParameterizedGenericMethod();
    }

    private void parseGenericType() {
        while (!this.scanner.isAtParametersEnd()) {
            if (this.scanner.nextToken() != 1) {
                this.malformedKey();
                return;
            }
            this.consumeTypeParameter(this.scanner.getTokenSource());
            this.scanner.skipTypeEnd();
        }
    }

    private void parseInnerType() {
        if (!this.scanner.isAtMemberTypeStart() || this.scanner.nextToken() != 1) {
            return;
        }
        char[] cArray = this.scanner.getTokenSource();
        if (Character.isDigit(cArray[0])) {
            int n = 1;
            while (this.scanner.isAtMemberTypeStart()) {
                n = this.scanner.nextToken();
            }
            cArray = n == 10 ? this.scanner.source : CharOperation.subarray(this.scanner.source, this.keyStart, this.scanner.index + 1);
            this.consumeLocalType(cArray);
        } else {
            this.consumeMemberType(cArray);
            this.parseInnerType();
        }
    }

    private void parseLocalVariable() {
        if (this.scanner.nextToken() != 5) {
            this.malformedKey();
            return;
        }
        char[] cArray = this.scanner.getTokenSource();
        if (Character.isDigit(cArray[0])) {
            int n = Integer.parseInt(new String(cArray));
            this.consumeScope(n);
            if (!this.scanner.isAtLocalVariableStart()) {
                this.malformedKey();
                return;
            }
            this.parseLocalVariable();
        } else {
            this.consumeLocalVar(cArray);
        }
    }

    private void parseMethod() {
        char[] cArray = this.scanner.getTokenSource();
        this.scanner.skipMethodSignature();
        char[] cArray2 = this.scanner.getTokenSource();
        this.consumeMethod(cArray, cArray2);
        if (this.scanner.isAtThrownStart()) {
            this.parseThrownExceptions();
        }
        if (this.scanner.isAtParametersStart()) {
            this.parseParameterizedMethod();
        }
    }

    private void parseCapture() {
        if (this.scanner.nextToken() != 8) {
            return;
        }
        this.parseCaptureWildcard();
        if (this.scanner.nextToken() != 1) {
            this.malformedKey();
            return;
        }
        char[] cArray = this.scanner.getTokenSource();
        int n = Integer.parseInt(new String(cArray));
        this.consumeCapture(n);
        this.scanner.skipTypeEnd();
    }

    private void parseCaptureWildcard() {
        BindingKeyParser bindingKeyParser = this.newParser();
        bindingKeyParser.parse();
        this.consumeParser(bindingKeyParser);
    }

    private void parseField() {
        char[] cArray = this.scanner.getTokenSource();
        this.parseReturnType();
        this.consumeField(cArray);
    }

    private void parseThrownExceptions() {
        while (this.scanner.isAtThrownStart()) {
            this.scanner.skipThrownStart();
            BindingKeyParser bindingKeyParser = this.newParser();
            bindingKeyParser.parse();
            this.consumeParser(bindingKeyParser);
            this.consumeException();
        }
    }

    private void parseParameterizedType(char[] cArray, boolean bl) {
        if (!bl) {
            while (!this.scanner.isAtParametersEnd()) {
                this.parseTypeArgument();
            }
        }
        this.scanner.skipParametersEnd();
        this.consumeParameterizedType(cArray, bl);
        this.scanner.skipTypeEnd();
        if (this.scanner.isAtMemberTypeStart() && this.scanner.nextToken() == 1) {
            cArray = this.scanner.getTokenSource();
            if (this.scanner.isAtParametersStart()) {
                this.scanner.skipParametersStart();
                this.parseParameterizedType(cArray, this.scanner.isAtRawTypeEnd());
            } else {
                this.consumeParameterizedType(cArray, true);
            }
        }
    }

    private void parseRawType() {
        this.scanner.skipParametersEnd();
        this.consumeRawType();
        this.scanner.skipTypeEnd();
        if (this.scanner.isAtMemberTypeStart() && this.scanner.nextToken() == 1) {
            char[] cArray = this.scanner.getTokenSource();
            if (this.scanner.isAtParametersStart()) {
                this.scanner.skipParametersStart();
                this.parseParameterizedType(cArray, this.scanner.isAtRawTypeEnd());
            } else {
                this.consumeParameterizedType(cArray, true);
            }
        }
    }

    private void parseReturnType() {
        BindingKeyParser bindingKeyParser = this.newParser();
        bindingKeyParser.parse();
        this.consumeParser(bindingKeyParser);
    }

    private void parseSecondaryType() {
        if (!this.scanner.isAtSecondaryTypeStart() || this.scanner.nextToken() != 1) {
            return;
        }
        this.consumeSecondaryType(this.scanner.getTokenSource());
    }

    private void parseTypeArgument() {
        BindingKeyParser bindingKeyParser = this.newParser();
        bindingKeyParser.parse();
        this.consumeParser(bindingKeyParser);
    }

    private void parseTypeWithCapture() {
        if (this.scanner.nextToken() != 8) {
            return;
        }
        BindingKeyParser bindingKeyParser = this.newParser();
        bindingKeyParser.parse();
        this.consumeParser(bindingKeyParser);
        this.consumeTypeWithCapture();
    }

    private void parseTypeVariable() {
        char[] cArray;
        if (this.scanner.nextToken() != 1) {
            this.malformedKey();
            return;
        }
        char[] cArray2 = this.scanner.getTokenSource();
        int n = cArray2.length;
        if (n > 0 && Character.isDigit(cArray2[0])) {
            int n2 = CharOperation.indexOf('T', cArray2);
            cArray = CharOperation.subarray(cArray2, 0, n2);
            cArray2 = CharOperation.subarray(cArray2, n2 + 1, cArray2.length);
        } else {
            cArray = CharOperation.NO_CHAR;
        }
        this.consumeTypeVariable(cArray, cArray2);
        this.scanner.skipTypeEnd();
    }

    private void parseWildcard() {
        if (this.scanner.nextToken() != 7) {
            return;
        }
        char[] cArray = this.scanner.getTokenSource();
        if (cArray.length == 0) {
            this.malformedKey();
            return;
        }
        int n = -1;
        switch (cArray[0]) {
            case '*': {
                n = 0;
                break;
            }
            case '+': {
                n = 1;
                break;
            }
            case '-': {
                n = 2;
            }
        }
        if (n == -1) {
            this.malformedKey();
            return;
        }
        if (n != 0) {
            this.parseWildcardBound();
        }
        this.consumeWildCard(n);
    }

    private void parseWildcardBound() {
        BindingKeyParser bindingKeyParser = this.newParser();
        bindingKeyParser.parse();
        this.consumeParser(bindingKeyParser);
    }

    static class Scanner {
        static final int PACKAGE = 0;
        static final int TYPE = 1;
        static final int FIELD = 2;
        static final int METHOD = 3;
        static final int ARRAY = 4;
        static final int LOCAL_VAR = 5;
        static final int FLAGS = 6;
        static final int WILDCARD = 7;
        static final int CAPTURE = 8;
        static final int BASE_TYPE = 9;
        static final int END = 10;
        static final int START = -1;
        int index = 0;
        int start;
        char[] source;
        int token = -1;

        Scanner(char[] cArray) {
            this.source = cArray;
        }

        char[] getTokenSource() {
            int n = this.index - this.start;
            char[] cArray = new char[n];
            System.arraycopy(this.source, this.start, cArray, 0, n);
            return cArray;
        }

        boolean isAtCaptureStart() {
            return this.index < this.source.length && this.source[this.index] == '!';
        }

        boolean isAtFieldOrMethodStart() {
            return this.index < this.source.length && this.source[this.index] == '.';
        }

        boolean isAtLocalVariableStart() {
            return this.index < this.source.length && this.source[this.index] == '#';
        }

        boolean isAtMemberTypeStart() {
            return this.index < this.source.length && (this.source[this.index] == '$' || this.source[this.index] == '.' && this.source[this.index - 1] == '>');
        }

        boolean isAtParametersEnd() {
            return this.index < this.source.length && this.source[this.index] == '>';
        }

        boolean isAtParametersStart() {
            char c;
            return this.index > 0 && this.index < this.source.length && ((c = this.source[this.index]) == '<' || c == '%');
        }

        boolean isAtRawTypeEnd() {
            return this.index > 0 && this.index < this.source.length && this.source[this.index] == '>';
        }

        boolean isAtSecondaryTypeStart() {
            return this.index < this.source.length && this.source[this.index] == '~';
        }

        boolean isAtWildcardStart() {
            return this.index < this.source.length && "*+-".indexOf(this.source[this.index]) != -1;
        }

        boolean isAtTypeParameterStart() {
            return this.index < this.source.length && this.source[this.index] == 'T';
        }

        boolean isAtTypeArgumentStart() {
            return this.index < this.source.length && "LIZVCDBFJS[!".indexOf(this.source[this.index]) != -1;
        }

        boolean isAtThrownStart() {
            return this.index < this.source.length && this.source[this.index] == '|';
        }

        boolean isAtTypeVariableStart() {
            return this.index < this.source.length && this.source[this.index] == ':';
        }

        boolean isAtTypeWithCaptureStart() {
            return this.index < this.source.length && this.source[this.index] == '&';
        }

        int nextToken() {
            int n = this.index;
            this.start = this.index;
            int n2 = this.source.length;
            while (this.index <= n2) {
                int n3 = this.index == n2 ? 0 : this.source[this.index];
                switch (n3) {
                    case 65: 
                    case 66: 
                    case 67: 
                    case 68: 
                    case 70: 
                    case 73: 
                    case 74: 
                    case 78: 
                    case 83: 
                    case 86: 
                    case 90: {
                        if (this.index != n || this.index != 0 && this.source[this.index - 1] == '.') break;
                        ++this.index;
                        this.token = 9;
                        return this.token;
                    }
                    case 76: 
                    case 84: {
                        if (this.index != n) break;
                        this.start = this.index + 1;
                        break;
                    }
                    case 59: {
                        if (this.index == n) {
                            n = this.start = this.index + 1;
                            break;
                        }
                        this.token = 1;
                        return this.token;
                    }
                    case 36: 
                    case 126: {
                        if (this.index == n) {
                            this.start = this.index + 1;
                            break;
                        }
                        this.token = 1;
                        return this.token;
                    }
                    case 37: 
                    case 46: 
                    case 58: 
                    case 62: {
                        n = this.start = this.index + 1;
                        break;
                    }
                    case 91: {
                        while (this.index < n2 && this.source[this.index] == '[') {
                            ++this.index;
                        }
                        this.token = 4;
                        return this.token;
                    }
                    case 60: {
                        if (this.start <= 0) break;
                        switch (this.source[this.start - 1]) {
                            case '.': {
                                this.token = this.source[this.start - 2] == '>' ? 1 : 3;
                                return this.token;
                            }
                        }
                        if (this.index == n) {
                            n = this.start = this.index + 1;
                            break;
                        }
                        this.token = 1;
                        return this.token;
                    }
                    case 40: {
                        this.token = 3;
                        return this.token;
                    }
                    case 41: {
                        if (this.token == 1) {
                            this.token = 2;
                            return this.token;
                        }
                        n = this.start = this.index + 1;
                        break;
                    }
                    case 35: {
                        if (this.index == n) {
                            n = this.start = this.index + 1;
                            break;
                        }
                        this.token = 5;
                        return this.token;
                    }
                    case 0: {
                        switch (this.token) {
                            case -1: {
                                this.token = 0;
                                break;
                            }
                            case 3: 
                            case 5: {
                                this.token = 5;
                                break;
                            }
                            case 1: {
                                if (this.index > this.start && this.source[this.start - 1] == '.') {
                                    this.token = 2;
                                    break;
                                }
                                this.token = 10;
                                break;
                            }
                            case 7: {
                                this.token = 1;
                                break;
                            }
                            default: {
                                this.token = 10;
                            }
                        }
                        return this.token;
                    }
                    case 42: 
                    case 43: 
                    case 45: {
                        ++this.index;
                        this.token = 7;
                        return this.token;
                    }
                    case 33: 
                    case 38: {
                        ++this.index;
                        this.token = 8;
                        return this.token;
                    }
                }
                ++this.index;
            }
            this.token = 10;
            return this.token;
        }

        void skipMethodSignature() {
            this.start = this.index;
            int n = 0;
            while (this.index < this.source.length) {
                switch (this.source[this.index]) {
                    case '#': 
                    case '%': 
                    case '|': {
                        return;
                    }
                    case ':': {
                        if (n != 0) break;
                        return;
                    }
                    case '(': 
                    case '<': {
                        ++n;
                        break;
                    }
                    case ')': 
                    case '>': {
                        --n;
                    }
                }
                ++this.index;
            }
        }

        void skipThrownStart() {
            while (this.index < this.source.length && this.source[this.index] == '|') {
                ++this.index;
            }
        }

        void skipParametersStart() {
            while (this.index < this.source.length && (this.source[this.index] == '<' || this.source[this.index] == '%')) {
                ++this.index;
            }
        }

        void skipParametersEnd() {
            while (this.index < this.source.length && this.source[this.index] != '>') {
                ++this.index;
            }
            ++this.index;
        }

        void skipTypeEnd() {
            if (this.index < this.source.length && this.source[this.index] == ';') {
                ++this.index;
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.token) {
                case -1: {
                    stringBuffer.append("START: ");
                    break;
                }
                case 0: {
                    stringBuffer.append("PACKAGE: ");
                    break;
                }
                case 1: {
                    stringBuffer.append("TYPE: ");
                    break;
                }
                case 2: {
                    stringBuffer.append("FIELD: ");
                    break;
                }
                case 3: {
                    stringBuffer.append("METHOD: ");
                    break;
                }
                case 4: {
                    stringBuffer.append("ARRAY: ");
                    break;
                }
                case 5: {
                    stringBuffer.append("LOCAL VAR: ");
                    break;
                }
                case 6: {
                    stringBuffer.append("MODIFIERS: ");
                    break;
                }
                case 7: {
                    stringBuffer.append("WILDCARD: ");
                    break;
                }
                case 8: {
                    stringBuffer.append("CAPTURE: ");
                    break;
                }
                case 9: {
                    stringBuffer.append("BASE TYPE: ");
                    break;
                }
                case 10: {
                    stringBuffer.append("END: ");
                }
            }
            if (this.index < 0) {
                stringBuffer.append("**");
                stringBuffer.append(this.source);
            } else if (this.index <= this.source.length) {
                stringBuffer.append(this.source, 0, this.start);
                stringBuffer.append('*');
                if (this.start <= this.index) {
                    stringBuffer.append(this.source, this.start, this.index - this.start);
                    stringBuffer.append('*');
                    stringBuffer.append(this.source, this.index, this.source.length - this.index);
                } else {
                    stringBuffer.append('*');
                    stringBuffer.append(this.source, this.start, this.source.length - this.start);
                }
            } else {
                stringBuffer.append(this.source);
                stringBuffer.append("**");
            }
            return stringBuffer.toString();
        }
    }
}

