/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.eval;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;

public class EvaluationResult {
    static final CategorizedProblem[] NO_PROBLEMS = new CategorizedProblem[0];
    char[] evaluationID;
    int evaluationType;
    CategorizedProblem[] problems;
    char[] displayString;
    char[] typeName;
    public static final int T_VARIABLE = 1;
    public static final int T_CODE_SNIPPET = 2;
    public static final int T_IMPORT = 3;
    public static final int T_PACKAGE = 4;
    public static final int T_INTERNAL = 5;

    public EvaluationResult(char[] cArray, int n, char[] cArray2, char[] cArray3) {
        this.evaluationID = cArray;
        this.evaluationType = n;
        this.displayString = cArray2;
        this.typeName = cArray3;
        this.problems = NO_PROBLEMS;
    }

    public EvaluationResult(char[] cArray, int n, CategorizedProblem[] categorizedProblemArray) {
        this.evaluationID = cArray;
        this.evaluationType = n;
        this.problems = categorizedProblemArray;
    }

    void addProblem(CategorizedProblem categorizedProblem) {
        CategorizedProblem[] categorizedProblemArray = this.problems;
        int n = categorizedProblemArray.length;
        this.problems = new CategorizedProblem[n + 1];
        System.arraycopy(categorizedProblemArray, 0, this.problems, 0, n);
        this.problems[n] = categorizedProblem;
    }

    public char[] getEvaluationID() {
        return this.evaluationID;
    }

    public int getEvaluationType() {
        return this.evaluationType;
    }

    public CategorizedProblem[] getProblems() {
        return this.problems;
    }

    public Object getValue() {
        return null;
    }

    public char[] getValueDisplayString() {
        return this.displayString;
    }

    public char[] getValueTypeName() {
        return this.typeName;
    }

    public boolean hasErrors() {
        if (this.problems == null) {
            return false;
        }
        int n = 0;
        while (n < this.problems.length) {
            if (this.problems[n].isError()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasProblems() {
        return this.problems != null && this.problems.length != 0;
    }

    public boolean hasValue() {
        return this.displayString != null;
    }

    public boolean hasWarnings() {
        if (this.problems == null) {
            return false;
        }
        int n = 0;
        while (n < this.problems.length) {
            if (this.problems[n].isWarning()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.evaluationType) {
            case 2: {
                stringBuffer.append("Code snippet");
                break;
            }
            case 3: {
                stringBuffer.append("Import");
                break;
            }
            case 5: {
                stringBuffer.append("Internal problem");
                break;
            }
            case 4: {
                stringBuffer.append("Package");
                break;
            }
            case 1: {
                stringBuffer.append("Global variable");
            }
        }
        stringBuffer.append(": ");
        stringBuffer.append(this.evaluationID == null ? "<unknown>".toCharArray() : this.evaluationID);
        stringBuffer.append("\n");
        if (this.hasProblems()) {
            stringBuffer.append("Problems:\n");
            int n = 0;
            while (n < this.problems.length) {
                stringBuffer.append(this.problems[n].toString());
                ++n;
            }
        } else if (this.hasValue()) {
            stringBuffer.append("(");
            stringBuffer.append(this.typeName);
            stringBuffer.append(") ");
            stringBuffer.append(this.displayString);
        } else {
            stringBuffer.append("(No explicit return value)");
        }
        return stringBuffer.toString();
    }
}

