/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.ui.internal.java.search;

import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.ui.search.ISearchRequestor;
import org.eclipse.wst.jsdt.web.ui.internal.Logger;
import org.eclipse.wst.jsdt.web.ui.internal.java.search.BasicJsSearchRequestor;

public class JsSearchRequestor
extends BasicJsSearchRequestor {
    private ISearchRequestor fJavaRequestor = null;

    public JsSearchRequestor() {
    }

    public JsSearchRequestor(ISearchRequestor iSearchRequestor) {
        this.fJavaRequestor = iSearchRequestor;
    }

    protected void addSearchMatch(IDocument iDocument, IFile iFile, int n, int n2, String string) {
        if (!iFile.exists()) {
            return;
        }
        int n3 = -1;
        try {
            n3 = iDocument.getLineOfOffset(n);
        }
        catch (BadLocationException badLocationException) {
            Logger.logException("offset: " + Integer.toString(n), badLocationException);
        }
        this.createSearchMarker(iFile, n, n2, n3);
        if (this.fJavaRequestor != null) {
            Match match = new Match((Object)iFile, n, n2 - n);
            this.fJavaRequestor.reportMatch(match);
        }
    }

    private void createSearchMarker(IFile iFile, int n, int n2, int n3) {
        try {
            IMarker iMarker = iFile.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(4);
            hashMap.put("charStart", new Integer(n));
            hashMap.put("charEnd", new Integer(n2));
            hashMap.put("lineNumber", new Integer(n3));
            iMarker.setAttributes(hashMap);
        }
        catch (CoreException coreException) {
            Logger.logException(coreException);
        }
    }
}

