/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class MoveStaticMembersDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private IMember[] fMembers;
    private IType fType = null;

    public MoveStaticMembersDescriptor() {
        super("org.eclipse.wst.jsdt.ui.move.static");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("input", MoveStaticMembersDescriptor.elementToHandle(this.getProject(), (IJavaElement)this.fType));
        this.fArguments.put(ATTRIBUTE_DELEGATE, Boolean.valueOf(this.fDelegate).toString());
        this.fArguments.put(ATTRIBUTE_DEPRECATE, Boolean.valueOf(this.fDeprecate).toString());
        int n = 0;
        while (n < this.fMembers.length) {
            this.fArguments.put("element" + (n + 1), MoveStaticMembersDescriptor.elementToHandle(this.getProject(), (IJavaElement)this.fMembers[n]));
            ++n;
        }
    }

    public void setDeprecateDelegate(boolean bl) {
        this.fDeprecate = bl;
    }

    public void setDestinationType(IType iType) {
        Assert.isNotNull((Object)iType);
        this.fType = iType;
    }

    public void setKeepOriginal(boolean bl) {
        this.fDelegate = bl;
    }

    public void setMembers(IMember[] iMemberArray) {
        Assert.isNotNull((Object)iMemberArray);
        this.fMembers = iMemberArray;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (this.fType == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_no_type));
        }
        if (this.fMembers == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_no_members));
        } else {
            int n = 0;
            while (n < this.fMembers.length) {
                if (this.fMembers[n] == null) {
                    refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.MoveStaticMembersDescriptor_invalid_members));
                    break;
                }
                ++n;
            }
        }
        return refactoringStatus;
    }
}

