/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class RenameJavaElementDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private static final String ATTRIBUTE_MATCH_STRATEGY = "matchStrategy";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_SUFFIX = 3;
    private boolean fDelegate = false;
    private boolean fDeprecate = false;
    private boolean fHierarchical = false;
    private IJavaElement fJavaElement = null;
    private int fMatchStrategy = 1;
    private String fName = null;
    private String fPatterns = null;
    private boolean fQualified = false;
    private boolean fReferences = false;
    private boolean fRenameGetter = false;
    private boolean fRenameSetter = false;
    private boolean fSimilarDeclarations = false;
    private boolean fTextual = false;

    public RenameJavaElementDescriptor(String string) {
        super(string);
        Assert.isLegal((boolean)this.checkId(string), (String)"Refactoring id is not a rename refactoring id");
    }

    private boolean checkId(String string) {
        Assert.isNotNull((Object)string);
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.compilationunit")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.enum.constant")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.field")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.java.project")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.local.variable")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.method")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.package")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.resource")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.source.folder")) {
            return true;
        }
        if (string.equals("org.eclipse.wst.jsdt.ui.rename.type")) {
            return true;
        }
        return string.equals("org.eclipse.wst.jsdt.ui.rename.type.parameter");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put("name", this.fName);
        if (this.getID().equals("org.eclipse.wst.jsdt.ui.rename.type.parameter")) {
            ITypeParameter iTypeParameter = (ITypeParameter)this.fJavaElement;
            this.fArguments.put("input", RenameJavaElementDescriptor.elementToHandle(this.getProject(), (IJavaElement)iTypeParameter.getDeclaringMember()));
            this.fArguments.put(ATTRIBUTE_PARAMETER, iTypeParameter.getElementName());
        } else {
            this.fArguments.put("input", RenameJavaElementDescriptor.elementToHandle(this.getProject(), this.fJavaElement));
        }
        int n = this.fJavaElement.getElementType();
        if (n != 3) {
            this.fArguments.put("references", Boolean.toString(this.fReferences));
        }
        if (n == 8) {
            this.fArguments.put(ATTRIBUTE_RENAME_GETTER, Boolean.toString(this.fRenameGetter));
            this.fArguments.put(ATTRIBUTE_RENAME_SETTER, Boolean.toString(this.fRenameSetter));
        }
        switch (n) {
            case 4: 
            case 7: 
            case 8: {
                this.fArguments.put(ATTRIBUTE_TEXTUAL_MATCHES, Boolean.toString(this.fTextual));
            }
        }
        switch (n) {
            case 8: 
            case 9: {
                this.fArguments.put(ATTRIBUTE_DEPRECATE, Boolean.toString(this.fDeprecate));
                this.fArguments.put(ATTRIBUTE_DELEGATE, Boolean.toString(this.fDelegate));
            }
        }
        switch (n) {
            case 4: 
            case 7: {
                this.fArguments.put(ATTRIBUTE_QUALIFIED, Boolean.toString(this.fQualified));
                if (this.fPatterns == null || "".equals(this.fPatterns)) break;
                this.fArguments.put(ATTRIBUTE_PATTERNS, this.fPatterns);
            }
        }
        switch (n) {
            case 7: {
                this.fArguments.put(ATTRIBUTE_SIMILAR_DECLARATIONS, Boolean.toString(this.fSimilarDeclarations));
                this.fArguments.put(ATTRIBUTE_MATCH_STRATEGY, Integer.toString(this.fMatchStrategy));
            }
        }
        switch (n) {
            case 4: {
                this.fArguments.put(ATTRIBUTE_HIERARCHICAL, Boolean.toString(this.fHierarchical));
            }
        }
    }

    public void setDeprecateDelegate(boolean bl) {
        this.fDeprecate = bl;
    }

    public void setFileNamePatterns(String string) {
        Assert.isNotNull((Object)string);
        Assert.isLegal((!"".equals(string) ? 1 : 0) != 0, (String)"Pattern must not be empty");
        this.fPatterns = string;
    }

    public void setJavaElement(IJavaElement iJavaElement) {
        Assert.isNotNull((Object)iJavaElement);
        this.fJavaElement = iJavaElement;
    }

    public void setKeepOriginal(boolean bl) {
        this.fDelegate = bl;
    }

    public void setMatchStrategy(int n) {
        Assert.isLegal((n == 1 || n == 2 || n == 3 ? 1 : 0) != 0, (String)"Wrong match strategy argument");
        this.fMatchStrategy = n;
    }

    public void setNewName(String string) {
        Assert.isNotNull((Object)string);
        Assert.isLegal((!"".equals(string) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = string;
    }

    public void setProject(String string) {
        super.setProject(string);
    }

    public void setRenameGetters(boolean bl) {
        this.fRenameGetter = bl;
    }

    public void setRenameSetters(boolean bl) {
        this.fRenameSetter = bl;
    }

    public void setUpdateHierarchy(boolean bl) {
        this.fHierarchical = bl;
    }

    public void setUpdateQualifiedNames(boolean bl) {
        this.fQualified = bl;
    }

    public void setUpdateReferences(boolean bl) {
        this.fReferences = bl;
    }

    public void setUpdateSimilarDeclarations(boolean bl) {
        this.fSimilarDeclarations = bl;
    }

    public void setUpdateTextualOccurrences(boolean bl) {
        this.fTextual = bl;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (this.fName == null || "".equals(this.fName)) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameResourceDescriptor_no_new_name));
        }
        if (this.fJavaElement == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_no_java_element));
        } else {
            int n = this.fJavaElement.getElementType();
            if (n == 2 && this.getProject() != null) {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_project_constraint));
            }
            if (n == 3 && this.fReferences) {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_reference_constraint));
            }
            if (this.fTextual) {
                switch (n) {
                    case 4: 
                    case 7: 
                    case 8: {
                        break;
                    }
                    default: {
                        refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_textual_constraint));
                    }
                }
            }
            if (this.fDeprecate) {
                switch (n) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_deprecation_constraint));
                    }
                }
            }
            if (this.fDelegate) {
                switch (n) {
                    case 8: 
                    case 9: {
                        break;
                    }
                    default: {
                        refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_delegate_constraint));
                    }
                }
            }
            if ((this.fRenameGetter || this.fRenameSetter) && n != 8) {
                refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_accessor_constraint));
            }
            if (this.fQualified) {
                switch (n) {
                    case 4: 
                    case 7: {
                        break;
                    }
                    default: {
                        refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_qualified_constraint));
                    }
                }
            }
            if (this.fSimilarDeclarations) {
                switch (n) {
                    case 7: {
                        break;
                    }
                    default: {
                        refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_similar_constraint));
                    }
                }
            }
            if (this.fHierarchical) {
                switch (n) {
                    case 4: {
                        break;
                    }
                    default: {
                        refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.RenameJavaElementDescriptor_hierarchical_constraint));
                    }
                }
            }
        }
        return refactoringStatus;
    }
}

