/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.core.refactoring.descriptors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.core.refactoring.descriptors.DescriptorMessages;

public final class UseSupertypeDescriptor
extends JavaRefactoringDescriptor {
    private static final String ATTRIBUTE_INSTANCEOF = "instanceof";
    private boolean fInstanceof = false;
    private IType fSubType = null;
    private IType fSupertype = null;

    public UseSupertypeDescriptor() {
        super("org.eclipse.wst.jsdt.ui.use.supertype");
    }

    protected void populateArgumentMap() {
        super.populateArgumentMap();
        this.fArguments.put(ATTRIBUTE_INSTANCEOF, Boolean.valueOf(this.fInstanceof).toString());
        this.fArguments.put("input", UseSupertypeDescriptor.elementToHandle(this.getProject(), (IJavaElement)this.fSubType));
        this.fArguments.put("element1", UseSupertypeDescriptor.elementToHandle(this.getProject(), (IJavaElement)this.fSupertype));
    }

    public void setReplaceInstanceof(boolean bl) {
        this.fInstanceof = bl;
    }

    public void setSubtype(IType iType) {
        Assert.isNotNull((Object)iType);
        this.fSubType = iType;
    }

    public void setSupertype(IType iType) {
        Assert.isNotNull((Object)iType);
        this.fSupertype = iType;
    }

    public RefactoringStatus validateDescriptor() {
        RefactoringStatus refactoringStatus = super.validateDescriptor();
        if (this.fSubType == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.UseSupertypeDescriptor_no_subtype));
        }
        if (this.fSupertype == null) {
            refactoringStatus.merge(RefactoringStatus.createFatalErrorStatus((String)DescriptorMessages.UseSupertypeDescriptor_no_supertype));
        }
        return refactoringStatus;
    }
}

