/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchy;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallSearchResultCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

class CalleeAnalyzerVisitor
extends ASTVisitor {
    private CallSearchResultCollector fSearchResults = new CallSearchResultCollector();
    private IMethod fMethod;
    private CompilationUnit fCompilationUnit;
    private IProgressMonitor fProgressMonitor;
    private int fMethodEndPosition;
    private int fMethodStartPosition;

    CalleeAnalyzerVisitor(IMethod iMethod, CompilationUnit compilationUnit, IProgressMonitor iProgressMonitor) {
        this.fMethod = iMethod;
        this.fCompilationUnit = compilationUnit;
        this.fProgressMonitor = iProgressMonitor;
        try {
            ISourceRange iSourceRange = iMethod.getSourceRange();
            this.fMethodStartPosition = iSourceRange.getOffset();
            this.fMethodEndPosition = this.fMethodStartPosition + iSourceRange.getLength();
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    public Map getCallees() {
        return this.fSearchResults.getCallers();
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)classInstanceCreation)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)classInstanceCreation)) {
            this.addMethodCall(classInstanceCreation.resolveConstructorBinding(), (ASTNode)classInstanceCreation);
        }
        return true;
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)constructorInvocation)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)constructorInvocation)) {
            this.addMethodCall(constructorInvocation.resolveConstructorBinding(), (ASTNode)constructorInvocation);
        }
        return true;
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        this.progressMonitorWorked(1);
        return this.isFurtherTraversalNecessary((ASTNode)methodDeclaration);
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)methodInvocation)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)methodInvocation)) {
            this.addMethodCall(methodInvocation.resolveMethodBinding(), (ASTNode)methodInvocation);
        }
        return true;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)superConstructorInvocation)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)superConstructorInvocation)) {
            this.addMethodCall(superConstructorInvocation.resolveConstructorBinding(), (ASTNode)superConstructorInvocation);
        }
        return true;
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        this.progressMonitorWorked(1);
        if (!this.isFurtherTraversalNecessary((ASTNode)superMethodInvocation)) {
            return false;
        }
        if (this.isNodeWithinMethod((ASTNode)superMethodInvocation)) {
            this.addMethodCall(superMethodInvocation.resolveMethodBinding(), (ASTNode)superMethodInvocation);
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
        return this.isNodeEnclosingMethod((ASTNode)anonymousClassDeclaration);
    }

    protected void addMethodCall(IMethodBinding iMethodBinding, ASTNode aSTNode) {
        try {
            if (iMethodBinding != null) {
                this.fProgressMonitor.worked(1);
                ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
                IType iType = null;
                iType = !iTypeBinding.isAnonymous() ? (IType)iTypeBinding.getJavaElement() : (!"java.lang.Object".equals(iTypeBinding.getSuperclass().getQualifiedName()) ? (IType)iTypeBinding.getSuperclass().getJavaElement() : (IType)iTypeBinding.getInterfaces()[0].getJavaElement());
                IMethod iMethod = CalleeAnalyzerVisitor.findIncludingSupertypes(iMethodBinding, iType, this.fProgressMonitor);
                IType iType2 = null;
                if (iMethod == null) {
                    if (iMethodBinding.isConstructor() && iMethodBinding.getParameterTypes().length == 0) {
                        iType2 = iType;
                    }
                } else {
                    if (iType.isInterface()) {
                        iMethod = this.findImplementingMethods(iMethod);
                    }
                    if (!this.isIgnoredBySearchScope(iMethod)) {
                        iType2 = iMethod;
                    }
                }
                int n = aSTNode.getStartPosition();
                int n2 = this.fCompilationUnit.getLineNumber(n);
                this.fSearchResults.addMember((IMember)this.fMethod, (IMember)iType2, n, n + aSTNode.getLength(), n2 < 1 ? 1 : n2);
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
    }

    private static IMethod findIncludingSupertypes(IMethodBinding iMethodBinding, IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMethod iMethod = Bindings.findMethod(iMethodBinding, iType);
        if (iMethod != null) {
            return iMethod;
        }
        IType[] iTypeArray = JavaModelUtil.getAllSuperTypes(iType, iProgressMonitor);
        int n = 0;
        while (n < iTypeArray.length) {
            IMethod iMethod2 = Bindings.findMethod(iMethodBinding, iTypeArray[n]);
            if (iMethod2 != null) {
                return iMethod2;
            }
            ++n;
        }
        return null;
    }

    private boolean isIgnoredBySearchScope(IMethod iMethod) {
        if (iMethod != null) {
            return !this.getSearchScope().encloses((IJavaElement)iMethod);
        }
        return false;
    }

    private IJavaSearchScope getSearchScope() {
        return CallHierarchy.getDefault().getSearchScope();
    }

    private boolean isNodeWithinMethod(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        int n2 = n + aSTNode.getLength();
        if (n < this.fMethodStartPosition) {
            return false;
        }
        return n2 <= this.fMethodEndPosition;
    }

    private boolean isNodeEnclosingMethod(ASTNode aSTNode) {
        int n = aSTNode.getStartPosition();
        int n2 = n + aSTNode.getLength();
        return n < this.fMethodStartPosition && n2 > this.fMethodEndPosition;
    }

    private boolean isFurtherTraversalNecessary(ASTNode aSTNode) {
        return this.isNodeWithinMethod(aSTNode) || this.isNodeEnclosingMethod(aSTNode);
    }

    private IMethod findImplementingMethods(IMethod iMethod) {
        Collection collection = CallHierarchy.getDefault().getImplementingMethods(iMethod);
        if (collection.size() == 0 || collection.size() > 1) {
            return iMethod;
        }
        return (IMethod)collection.iterator().next();
    }

    private void progressMonitorWorked(int n) {
        if (this.fProgressMonitor != null) {
            this.fProgressMonitor.worked(n);
            if (this.fProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
        }
    }
}

