/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.CallHierarchyVisitor;
import org.eclipse.wst.jsdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.MethodWrapperWorkbenchAdapter;

public abstract class MethodWrapper
extends PlatformObject {
    private Map fElements = null;
    private Map fMethodCache;
    private MethodCall fMethodCall;
    private MethodWrapper fParent;
    private int fLevel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MethodWrapper(MethodWrapper methodWrapper, MethodCall methodCall) {
        Assert.isNotNull((Object)methodCall);
        if (methodWrapper == null) {
            this.setMethodCache(new HashMap());
            this.fLevel = 1;
        } else {
            this.setMethodCache(methodWrapper.getMethodCache());
            this.fLevel = methodWrapper.getLevel() + 1;
        }
        this.fMethodCall = methodCall;
        this.fParent = methodWrapper;
    }

    public Object getAdapter(Class clazz) {
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.wst.jsdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            return this.getMember();
        }
        Class<?> clazz3 = class$1;
        if (clazz3 == null) {
            try {
                clazz3 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz3) {
            return new MethodWrapperWorkbenchAdapter(this);
        }
        return null;
    }

    public MethodWrapper[] getCalls(IProgressMonitor iProgressMonitor) {
        if (this.fElements == null) {
            this.doFindChildren(iProgressMonitor);
        }
        MethodWrapper[] methodWrapperArray = new MethodWrapper[this.fElements.size()];
        int n = 0;
        Iterator iterator = this.fElements.keySet().iterator();
        while (iterator.hasNext()) {
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iterator.next());
            methodWrapperArray[n++] = this.createMethodWrapper(methodCall);
        }
        return methodWrapperArray;
    }

    public int getLevel() {
        return this.fLevel;
    }

    public IMember getMember() {
        return this.getMethodCall().getMember();
    }

    public MethodCall getMethodCall() {
        return this.fMethodCall;
    }

    public String getName() {
        if (this.getMethodCall() != null) {
            return this.getMethodCall().getMember().getElementName();
        }
        return "";
    }

    public MethodWrapper getParent() {
        return this.fParent;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof MethodWrapperWorkbenchAdapter) {
            object = ((MethodWrapperWorkbenchAdapter)object).getMethodWrapper();
        }
        if (object.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MethodWrapper methodWrapper = (MethodWrapper)((Object)object);
        if (this.fParent == null ? methodWrapper.fParent != null : !this.fParent.equals((Object)methodWrapper.fParent)) {
            return false;
        }
        return !(this.getMethodCall() == null ? methodWrapper.getMethodCall() != null : !this.getMethodCall().equals(methodWrapper.getMethodCall()));
    }

    public int hashCode() {
        int n = 0;
        if (this.fParent != null) {
            n = 1000003 * n + this.fParent.hashCode();
        }
        if (this.getMethodCall() != null) {
            n = 1000003 * n + this.getMethodCall().getMember().hashCode();
        }
        return n;
    }

    private void setMethodCache(Map map) {
        this.fMethodCache = map;
    }

    protected abstract String getTaskName();

    private void addCallToCache(MethodCall methodCall) {
        Map map = this.lookupMethod(this.getMethodCall());
        map.put(methodCall.getKey(), methodCall);
    }

    protected abstract MethodWrapper createMethodWrapper(MethodCall var1);

    /*
     * Exception decompiling
     */
    private void doFindChildren(IProgressMonitor var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 86->90)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isRecursive() {
        MethodWrapper methodWrapper = this.getParent();
        while (methodWrapper != null) {
            if (this.getMember().getHandleIdentifier().equals(methodWrapper.getMember().getHandleIdentifier())) {
                return true;
            }
            methodWrapper = methodWrapper.getParent();
        }
        return false;
    }

    protected abstract Map findChildren(IProgressMonitor var1);

    private Map getMethodCache() {
        return this.fMethodCache;
    }

    private void initCalls() {
        this.fElements = new HashMap();
        this.initCacheForMethod();
    }

    private Map lookupMethod(MethodCall methodCall) {
        return (Map)this.getMethodCache().get(methodCall.getKey());
    }

    private void performSearch(IProgressMonitor iProgressMonitor) {
        this.fElements = this.findChildren(iProgressMonitor);
        Iterator iterator = this.fElements.keySet().iterator();
        while (iterator.hasNext()) {
            this.checkCanceled(iProgressMonitor);
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iterator.next());
            this.addCallToCache(methodCall);
        }
    }

    private MethodCall getMethodCallFromMap(Map map, Object object) {
        return (MethodCall)map.get(object);
    }

    private void initCacheForMethod() {
        HashMap hashMap = new HashMap();
        this.getMethodCache().put(this.getMethodCall().getKey(), hashMap);
    }

    protected void checkCanceled(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null && iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void accept(CallHierarchyVisitor callHierarchyVisitor, IProgressMonitor iProgressMonitor) {
        if (this.getParent() != null && this.getParent().isRecursive()) {
            return;
        }
        this.checkCanceled(iProgressMonitor);
        callHierarchyVisitor.preVisit(this);
        if (callHierarchyVisitor.visit(this)) {
            MethodWrapper[] methodWrapperArray = this.getCalls(iProgressMonitor);
            int n = 0;
            while (n < methodWrapperArray.length) {
                methodWrapperArray[n].accept(callHierarchyVisitor, iProgressMonitor);
                ++n;
            }
        }
        callHierarchyVisitor.postVisit(this);
        if (iProgressMonitor != null) {
            iProgressMonitor.worked(1);
        }
    }
}

