/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.codemanipulation;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.MarkerAnnotation;
import org.eclipse.wst.jsdt.core.dom.MemberRef;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.MethodRef;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NormalAnnotation;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleMemberAnnotation;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;

public class ImportReferencesCollector
extends GenericVisitor {
    private CompilationUnit fASTRoot;
    private Region fSubRange;
    private Collection fTypeImports;
    private Collection fStaticImports;

    public static void collect(ASTNode aSTNode, IJavaProject iJavaProject, Region region, Collection collection, Collection collection2) {
        CompilationUnit compilationUnit = (CompilationUnit)aSTNode.getRoot();
        aSTNode.accept((ASTVisitor)new ImportReferencesCollector(iJavaProject, compilationUnit, region, collection, collection2));
    }

    private ImportReferencesCollector(IJavaProject iJavaProject, CompilationUnit compilationUnit, Region region, Collection collection, Collection collection2) {
        super(true);
        this.fTypeImports = collection;
        this.fStaticImports = collection2;
        this.fSubRange = region;
        if (iJavaProject == null || !JavaModelUtil.is50OrHigher(iJavaProject)) {
            this.fStaticImports = null;
        }
        this.fASTRoot = compilationUnit;
    }

    public ImportReferencesCollector(IJavaProject iJavaProject, Region region, Collection collection, Collection collection2) {
        this(iJavaProject, null, region, collection, collection2);
    }

    public CompilationUnit getASTRoot(ASTNode aSTNode) {
        if (this.fASTRoot == null) {
            this.fASTRoot = (CompilationUnit)aSTNode.getRoot();
        }
        return this.fASTRoot;
    }

    private boolean isAffected(ASTNode aSTNode) {
        if (this.fSubRange == null) {
            return true;
        }
        int n = aSTNode.getStartPosition();
        int n2 = this.fSubRange.getOffset();
        return n + aSTNode.getLength() > n2 && n2 + this.fSubRange.getLength() > n;
    }

    private void addReference(SimpleName simpleName) {
        if (this.isAffected((ASTNode)simpleName)) {
            this.fTypeImports.add(simpleName);
        }
    }

    private void typeRefFound(Name name) {
        if (name != null) {
            while (name.isQualifiedName()) {
                name = ((QualifiedName)name).getQualifier();
            }
            this.addReference((SimpleName)name);
        }
    }

    private void possibleTypeRefFound(Name name) {
        while (name.isQualifiedName()) {
            name = ((QualifiedName)name).getQualifier();
        }
        IBinding iBinding = name.resolveBinding();
        if (iBinding == null || iBinding.getKind() == 2) {
            this.addReference((SimpleName)name);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void possibleStaticImportFound(Name var1_1) {
        if (this.fStaticImports != null) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            var1_1 = ((QualifiedName)var1_1).getQualifier();
lbl4:
            // 2 sources

            ** while (var1_1.isQualifiedName())
        }
lbl5:
        // 1 sources

        if (!this.isAffected((ASTNode)var1_1)) {
            return;
        }
        var2_2 = var1_1.resolveBinding();
        if (var2_2 == null || var2_2 instanceof ITypeBinding || !Modifier.isStatic((int)var2_2.getModifiers()) || ((SimpleName)var1_1).isDeclaration()) {
            return;
        }
        if (var2_2 instanceof IVariableBinding) {
            var3_3 = (IVariableBinding)var2_2;
            if (var3_3.isField() && (var4_5 = (var3_3 = var3_3.getVariableDeclaration()).getDeclaringClass()) != null && !var4_5.isLocal()) {
                if (new ScopeAnalyzer(this.getASTRoot((ASTNode)var1_1)).isDeclaredInScope((IBinding)var3_3, (SimpleName)var1_1, 18)) {
                    return;
                }
                this.fStaticImports.add(var1_1);
            }
        } else if (var2_2 instanceof IMethodBinding && (var4_6 = (var3_4 = ((IMethodBinding)var2_2).getMethodDeclaration()).getDeclaringClass()) != null && !var4_6.isLocal()) {
            if (new ScopeAnalyzer(this.getASTRoot((ASTNode)var1_1)).isDeclaredInScope((IBinding)var3_4, (SimpleName)var1_1, 17)) {
                return;
            }
            this.fStaticImports.add(var1_1);
        }
    }

    private void doVisitChildren(List list) {
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            ((ASTNode)list.get(n2)).accept((ASTVisitor)this);
            ++n2;
        }
    }

    private void doVisitNode(ASTNode aSTNode) {
        if (aSTNode != null) {
            aSTNode.accept((ASTVisitor)this);
        }
    }

    protected boolean visitNode(ASTNode aSTNode) {
        return this.isAffected(aSTNode);
    }

    public boolean visit(ArrayType arrayType) {
        this.doVisitNode((ASTNode)arrayType.getElementType());
        return false;
    }

    public boolean visit(SimpleType simpleType) {
        this.typeRefFound(simpleType.getName());
        return false;
    }

    public boolean visit(QualifiedType qualifiedType) {
        return true;
    }

    public boolean visit(QualifiedName qualifiedName) {
        this.possibleTypeRefFound((Name)qualifiedName);
        this.possibleStaticImportFound((Name)qualifiedName);
        return false;
    }

    public boolean visit(ImportDeclaration importDeclaration) {
        return false;
    }

    public boolean visit(PackageDeclaration packageDeclaration) {
        if (packageDeclaration.getAST().apiLevel() >= 3) {
            this.doVisitChildren(packageDeclaration.annotations());
        }
        return false;
    }

    public boolean visit(ThisExpression thisExpression) {
        this.typeRefFound(thisExpression.getQualifier());
        return false;
    }

    private void evalQualifyingExpression(Expression expression, Name name) {
        if (expression != null) {
            if (expression instanceof Name) {
                Name name2 = (Name)expression;
                this.possibleTypeRefFound(name2);
                this.possibleStaticImportFound(name2);
            } else {
                expression.accept((ASTVisitor)this);
            }
        } else if (name != null) {
            this.possibleStaticImportFound(name);
        }
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        this.doVisitChildren(classInstanceCreation.typeArguments());
        this.doVisitNode((ASTNode)classInstanceCreation.getType());
        this.evalQualifyingExpression(classInstanceCreation.getExpression(), null);
        if (classInstanceCreation.getAnonymousClassDeclaration() != null) {
            classInstanceCreation.getAnonymousClassDeclaration().accept((ASTVisitor)this);
        }
        this.doVisitChildren(classInstanceCreation.arguments());
        return false;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        this.evalQualifyingExpression(methodInvocation.getExpression(), (Name)methodInvocation.getName());
        this.doVisitChildren(methodInvocation.typeArguments());
        this.doVisitChildren(methodInvocation.arguments());
        return false;
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        if (!this.isAffected((ASTNode)superConstructorInvocation)) {
            return false;
        }
        this.evalQualifyingExpression(superConstructorInvocation.getExpression(), null);
        this.doVisitChildren(superConstructorInvocation.typeArguments());
        this.doVisitChildren(superConstructorInvocation.arguments());
        return false;
    }

    public boolean visit(FieldAccess fieldAccess) {
        this.evalQualifyingExpression(fieldAccess.getExpression(), (Name)fieldAccess.getName());
        return false;
    }

    public boolean visit(SimpleName simpleName) {
        this.possibleStaticImportFound((Name)simpleName);
        return false;
    }

    public boolean visit(MarkerAnnotation markerAnnotation) {
        this.typeRefFound(markerAnnotation.getTypeName());
        return false;
    }

    public boolean visit(NormalAnnotation normalAnnotation) {
        this.typeRefFound(normalAnnotation.getTypeName());
        this.doVisitChildren(normalAnnotation.values());
        return false;
    }

    public boolean visit(SingleMemberAnnotation singleMemberAnnotation) {
        this.typeRefFound(singleMemberAnnotation.getTypeName());
        this.doVisitNode((ASTNode)singleMemberAnnotation.getValue());
        return false;
    }

    public boolean visit(TypeDeclaration typeDeclaration) {
        return this.isAffected((ASTNode)typeDeclaration);
    }

    public boolean visit(MethodDeclaration methodDeclaration) {
        if (!this.isAffected((ASTNode)methodDeclaration)) {
            return false;
        }
        this.doVisitNode((ASTNode)methodDeclaration.getJavadoc());
        if (methodDeclaration.getAST().apiLevel() >= 3) {
            this.doVisitChildren(methodDeclaration.modifiers());
            this.doVisitChildren(methodDeclaration.typeParameters());
        }
        if (!methodDeclaration.isConstructor()) {
            this.doVisitNode((ASTNode)methodDeclaration.getReturnType2());
        }
        this.doVisitChildren(methodDeclaration.parameters());
        Iterator iterator = methodDeclaration.thrownExceptions().iterator();
        while (iterator.hasNext()) {
            this.typeRefFound((Name)iterator.next());
        }
        this.doVisitNode((ASTNode)methodDeclaration.getBody());
        return false;
    }

    public boolean visit(TagElement tagElement) {
        Object e;
        String string = tagElement.getTagName();
        List list = tagElement.fragments();
        int n = 0;
        if (string != null && !list.isEmpty() && (e = list.get(0)) instanceof Name) {
            if ("@throws".equals(string) || "@exception".equals(string)) {
                this.typeRefFound((Name)e);
            } else if ("@see".equals(string) || "@link".equals(string) || "@linkplain".equals(string)) {
                Name name = (Name)e;
                this.possibleTypeRefFound(name);
            }
            ++n;
        }
        int n2 = n;
        while (n2 < list.size()) {
            this.doVisitNode((ASTNode)list.get(n2));
            ++n2;
        }
        return false;
    }

    public boolean visit(MemberRef memberRef) {
        Name name = memberRef.getQualifier();
        if (name != null) {
            this.typeRefFound(name);
        }
        return false;
    }

    public boolean visit(MethodRef methodRef) {
        List list;
        Name name = methodRef.getQualifier();
        if (name != null) {
            this.typeRefFound(name);
        }
        if ((list = methodRef.parameters()) != null) {
            this.doVisitChildren(list);
        }
        return false;
    }
}

