/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;

public class LocalVariableIndex
extends ASTVisitor {
    private int fTopIndex;

    public static int perform(BodyDeclaration bodyDeclaration) {
        Assert.isTrue((bodyDeclaration != null ? 1 : 0) != 0);
        switch (bodyDeclaration.getNodeType()) {
            case 31: {
                return LocalVariableIndex.internalPerform((MethodDeclaration)bodyDeclaration);
            }
            case 28: {
                return LocalVariableIndex.internalPerform((Initializer)bodyDeclaration);
            }
        }
        Assert.isTrue((boolean)false);
        return -1;
    }

    private static int internalPerform(MethodDeclaration methodDeclaration) {
        MethodDeclaration methodDeclaration2 = methodDeclaration;
        while (ASTNodes.getParent((ASTNode)methodDeclaration2, 31) != null) {
            methodDeclaration2 = (MethodDeclaration)ASTNodes.getParent((ASTNode)methodDeclaration2, 31);
        }
        return LocalVariableIndex.doPerform((BodyDeclaration)methodDeclaration2);
    }

    private static int internalPerform(Initializer initializer) {
        return LocalVariableIndex.doPerform((BodyDeclaration)initializer);
    }

    private static int doPerform(BodyDeclaration bodyDeclaration) {
        LocalVariableIndex localVariableIndex = new LocalVariableIndex();
        bodyDeclaration.accept((ASTVisitor)localVariableIndex);
        return localVariableIndex.fTopIndex;
    }

    public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
        this.handleVariableBinding(singleVariableDeclaration.resolveBinding());
        return true;
    }

    public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
        this.handleVariableBinding(variableDeclarationFragment.resolveBinding());
        return true;
    }

    private void handleVariableBinding(IVariableBinding iVariableBinding) {
        if (iVariableBinding == null) {
            return;
        }
        this.fTopIndex = Math.max(this.fTopIndex, iVariableBinding.getVariableId());
    }
}

