/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.SwitchCase;
import org.eclipse.wst.jsdt.core.dom.SwitchStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public class ScopeAnalyzer {
    private static final IBinding[] NO_BINDING = new IBinding[0];
    public static final int METHODS = 1;
    public static final int VARIABLES = 2;
    public static final int TYPES = 4;
    public static final int CHECK_VISIBILITY = 16;
    private HashSet fTypesVisited = new HashSet();
    private CompilationUnit fRoot;

    public ScopeAnalyzer(CompilationUnit compilationUnit) {
        this.fRoot = compilationUnit;
    }

    private void clearLists() {
        this.fTypesVisited.clear();
    }

    private static String getSignature(IBinding iBinding) {
        if (iBinding != null) {
            switch (iBinding.getKind()) {
                case 4: {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append('M');
                    stringBuffer.append(iBinding.getName()).append('(');
                    ITypeBinding[] iTypeBindingArray = ((IMethodBinding)iBinding).getParameterTypes();
                    int n = 0;
                    while (n < iTypeBindingArray.length) {
                        if (n > 0) {
                            stringBuffer.append(',');
                        }
                        ITypeBinding iTypeBinding = iTypeBindingArray[n].getErasure();
                        stringBuffer.append(iTypeBinding.getQualifiedName());
                        ++n;
                    }
                    stringBuffer.append(')');
                    return stringBuffer.toString();
                }
                case 3: {
                    return String.valueOf('V') + iBinding.getName();
                }
                case 2: {
                    return String.valueOf('T') + iBinding.getName();
                }
            }
        }
        return null;
    }

    static final boolean hasFlag(int n, int n2) {
        return (n2 & n) != 0;
    }

    private boolean addInherited(ITypeBinding iTypeBinding, int n, IBindingRequestor iBindingRequestor) {
        ITypeBinding iTypeBinding2;
        int n2;
        ITypeBinding iTypeBinding3;
        if (!this.fTypesVisited.add(iTypeBinding)) {
            return false;
        }
        if (ScopeAnalyzer.hasFlag(2, n)) {
            iTypeBinding3 = iTypeBinding.getDeclaredFields();
            n2 = 0;
            while (n2 < ((IVariableBinding[])iTypeBinding3).length) {
                if (iBindingRequestor.acceptBinding((IBinding)iTypeBinding3[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        if (ScopeAnalyzer.hasFlag(1, n)) {
            iTypeBinding3 = iTypeBinding.getDeclaredMethods();
            n2 = 0;
            while (n2 < ((ITypeBinding)iTypeBinding3).length) {
                iTypeBinding2 = iTypeBinding3[n2];
                if (!iTypeBinding2.isSynthetic() && !iTypeBinding2.isConstructor() && iBindingRequestor.acceptBinding((IBinding)iTypeBinding2)) {
                    return true;
                }
                ++n2;
            }
        }
        if (ScopeAnalyzer.hasFlag(4, n)) {
            iTypeBinding3 = iTypeBinding.getDeclaredTypes();
            n2 = 0;
            while (n2 < ((ITypeBinding)iTypeBinding3).length) {
                iTypeBinding2 = iTypeBinding3[n2];
                if (iBindingRequestor.acceptBinding((IBinding)iTypeBinding2)) {
                    return true;
                }
                ++n2;
            }
        }
        if ((iTypeBinding3 = iTypeBinding.getSuperclass()) != null ? this.addInherited(iTypeBinding3, n, iBindingRequestor) : iTypeBinding.isArray() && this.addInherited(this.fRoot.getAST().resolveWellKnownType("java.lang.Object"), n, iBindingRequestor)) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
        int n3 = 0;
        while (n3 < iTypeBindingArray.length) {
            if (this.addInherited(iTypeBindingArray[n3], n, iBindingRequestor)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    private boolean addTypeDeclarations(ITypeBinding iTypeBinding, int n, IBindingRequestor iBindingRequestor) {
        ITypeBinding iTypeBinding2;
        if (ScopeAnalyzer.hasFlag(4, n) && !iTypeBinding.isAnonymous()) {
            if (iBindingRequestor.acceptBinding((IBinding)iTypeBinding)) {
                return true;
            }
            iTypeBinding2 = iTypeBinding.getTypeParameters();
            int n2 = 0;
            while (n2 < ((ITypeBinding)iTypeBinding2).length) {
                if (iBindingRequestor.acceptBinding((IBinding)iTypeBinding2[n2])) {
                    return true;
                }
                ++n2;
            }
        }
        this.addInherited(iTypeBinding, n, iBindingRequestor);
        if (iTypeBinding.isLocal()) {
            this.addOuterDeclarationsForLocalType(iTypeBinding, n, iBindingRequestor);
        } else {
            iTypeBinding2 = iTypeBinding.getDeclaringClass();
            if (iTypeBinding2 != null) {
                if (this.addTypeDeclarations(iTypeBinding2, n, iBindingRequestor)) {
                    return true;
                }
            } else if (ScopeAnalyzer.hasFlag(4, n) && this.fRoot.findDeclaringNode((IBinding)iTypeBinding) != null) {
                List list = this.fRoot.types();
                int n3 = 0;
                while (n3 < list.size()) {
                    if (iBindingRequestor.acceptBinding((IBinding)((AbstractTypeDeclaration)list.get(n3)).resolveBinding())) {
                        return true;
                    }
                    ++n3;
                }
            }
        }
        return false;
    }

    private boolean addOuterDeclarationsForLocalType(ITypeBinding iTypeBinding, int n, IBindingRequestor iBindingRequestor) {
        ASTNode aSTNode = this.fRoot.findDeclaringNode((IBinding)iTypeBinding);
        if (aSTNode == null) {
            return false;
        }
        if (aSTNode instanceof AbstractTypeDeclaration || aSTNode instanceof AnonymousClassDeclaration) {
            if (this.addLocalDeclarations(aSTNode.getParent(), n, iBindingRequestor)) {
                return true;
            }
            ITypeBinding iTypeBinding2 = Bindings.getBindingOfParentType(aSTNode.getParent());
            if (iTypeBinding2 != null && this.addTypeDeclarations(iTypeBinding2, n, iBindingRequestor)) {
                return true;
            }
        } else if (aSTNode instanceof CompilationUnit) {
            this.addLocalDeclarations(aSTNode, n, iBindingRequestor);
            ITypeBinding iTypeBinding3 = Bindings.getBindingOfParentType(aSTNode.getParent());
            if (iTypeBinding3 != null && this.addTypeDeclarations(iTypeBinding3, n, iBindingRequestor)) {
                return true;
            }
            IJavaElement iJavaElement = ((CompilationUnit)aSTNode).getJavaElement();
            try {
                SearchableEnvironment searchableEnvironment = iJavaElement.newSearchableNameEnvironment(new ICompilationUnit[0]);
            }
            catch (JavaModelException javaModelException) {
                javaModelException.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private static ITypeBinding getBinding(Expression expression) {
        if (expression != null) {
            return expression.resolveTypeBinding();
        }
        return null;
    }

    private static ITypeBinding getQualifier(SimpleName simpleName) {
        ASTNode aSTNode;
        ASTNode aSTNode2 = simpleName.getParent();
        switch (aSTNode2.getNodeType()) {
            case 32: {
                MethodInvocation methodInvocation = (MethodInvocation)aSTNode2;
                if (simpleName == methodInvocation.getName()) {
                    return ScopeAnalyzer.getBinding(methodInvocation.getExpression());
                }
                return null;
            }
            case 40: {
                QualifiedName qualifiedName = (QualifiedName)aSTNode2;
                if (simpleName == qualifiedName.getName()) {
                    return ScopeAnalyzer.getBinding((Expression)qualifiedName.getQualifier());
                }
                return null;
            }
            case 22: {
                FieldAccess fieldAccess = (FieldAccess)aSTNode2;
                if (simpleName == fieldAccess.getName()) {
                    return ScopeAnalyzer.getBinding(fieldAccess.getExpression());
                }
                return null;
            }
            case 47: {
                ITypeBinding iTypeBinding = Bindings.getBindingOfParentType(aSTNode2);
                return iTypeBinding.getSuperclass();
            }
            case 48: {
                SuperMethodInvocation superMethodInvocation = (SuperMethodInvocation)aSTNode2;
                if (simpleName == superMethodInvocation.getName()) {
                    ITypeBinding iTypeBinding = Bindings.getBindingOfParentType(aSTNode2);
                    return iTypeBinding.getSuperclass();
                }
                return null;
            }
        }
        if (aSTNode2 instanceof Type && (aSTNode = ASTNodes.getNormalizedNode(aSTNode2)).getLocationInParent() == ClassInstanceCreation.TYPE_PROPERTY) {
            ClassInstanceCreation classInstanceCreation = (ClassInstanceCreation)aSTNode.getParent();
            return ScopeAnalyzer.getBinding(classInstanceCreation.getExpression());
        }
        return null;
    }

    public IBinding[] getDeclarationsInScope(SimpleName simpleName, int n) {
        block7: {
            ITypeBinding iTypeBinding;
            block6: {
                try {
                    if (simpleName.getLocationInParent() != SwitchCase.EXPRESSION_PROPERTY || (iTypeBinding = ((SwitchStatement)simpleName.getParent().getParent()).getExpression().resolveTypeBinding()) == null || !iTypeBinding.isEnum()) break block6;
                    IVariableBinding[] iVariableBindingArray = this.getEnumContants(iTypeBinding);
                    Object var7_7 = null;
                    this.clearLists();
                    return iVariableBindingArray;
                }
                catch (Throwable throwable) {
                    Object var7_10 = null;
                    this.clearLists();
                    throw throwable;
                }
            }
            iTypeBinding = Bindings.getBindingOfParentType((ASTNode)simpleName);
            if (iTypeBinding == null) break block7;
            ITypeBinding iTypeBinding2 = ScopeAnalyzer.getQualifier(simpleName);
            DefaultBindingRequestor defaultBindingRequestor = new DefaultBindingRequestor(iTypeBinding, n);
            if (iTypeBinding2 == null) {
                this.addLocalDeclarations((ASTNode)simpleName, n, defaultBindingRequestor);
                this.addTypeDeclarations(iTypeBinding, n, defaultBindingRequestor);
            } else {
                this.addInherited(iTypeBinding2, n, defaultBindingRequestor);
            }
            List list = defaultBindingRequestor.getResult();
            IBinding[] iBindingArray = list.toArray(new IBinding[list.size()]);
            Object var7_8 = null;
            this.clearLists();
            return iBindingArray;
        }
        IBinding[] iBindingArray = NO_BINDING;
        Object var7_9 = null;
        this.clearLists();
        return iBindingArray;
    }

    public boolean isDeclaredInScope(IBinding iBinding, SimpleName simpleName, int n) {
        block8: {
            SearchRequestor searchRequestor;
            ITypeBinding iTypeBinding;
            block9: {
                ITypeBinding iTypeBinding2;
                block10: {
                    block7: {
                        try {
                            if (simpleName.getLocationInParent() != SwitchCase.EXPRESSION_PROPERTY || (iTypeBinding2 = ((SwitchStatement)simpleName.getParent().getParent()).getExpression().resolveTypeBinding()) == null || !iTypeBinding2.isEnum()) break block7;
                            boolean bl = this.hasEnumContants(iBinding, iTypeBinding2);
                            Object var7_9 = null;
                            this.clearLists();
                            return bl;
                        }
                        catch (Throwable throwable) {
                            Object var7_14 = null;
                            this.clearLists();
                            throw throwable;
                        }
                    }
                    iTypeBinding2 = Bindings.getBindingOfParentTypeContext((ASTNode)simpleName);
                    if (iTypeBinding2 == null) break block8;
                    iTypeBinding = ScopeAnalyzer.getQualifier(simpleName);
                    searchRequestor = new SearchRequestor(iBinding, iTypeBinding2, n);
                    if (iTypeBinding != null) break block9;
                    this.addLocalDeclarations((ASTNode)simpleName, n, searchRequestor);
                    if (!searchRequestor.found()) break block10;
                    boolean bl = searchRequestor.isVisible();
                    Object var7_10 = null;
                    this.clearLists();
                    return bl;
                }
                this.addTypeDeclarations(iTypeBinding2, n, searchRequestor);
                if (searchRequestor.found()) {
                    boolean bl = searchRequestor.isVisible();
                    Object var7_11 = null;
                    this.clearLists();
                    return bl;
                }
                break block8;
            }
            this.addInherited(iTypeBinding, n, searchRequestor);
            if (!searchRequestor.found()) break block8;
            boolean bl = searchRequestor.isVisible();
            Object var7_12 = null;
            this.clearLists();
            return bl;
        }
        Object var7_13 = null;
        this.clearLists();
        return false;
    }

    private IVariableBinding[] getEnumContants(ITypeBinding iTypeBinding) {
        IVariableBinding[] iVariableBindingArray = iTypeBinding.getDeclaredFields();
        ArrayList<IVariableBinding> arrayList = new ArrayList<IVariableBinding>(iVariableBindingArray.length);
        int n = 0;
        while (n < iVariableBindingArray.length) {
            IVariableBinding iVariableBinding = iVariableBindingArray[n];
            if (iVariableBinding.isEnumConstant()) {
                arrayList.add(iVariableBinding);
            }
            ++n;
        }
        return arrayList.toArray(new IVariableBinding[arrayList.size()]);
    }

    private boolean hasEnumContants(IBinding iBinding, ITypeBinding iTypeBinding) {
        IVariableBinding[] iVariableBindingArray = iTypeBinding.getDeclaredFields();
        int n = 0;
        while (n < iVariableBindingArray.length) {
            IVariableBinding iVariableBinding = iVariableBindingArray[n];
            if (iVariableBinding == iBinding) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public IBinding[] getDeclarationsInScope(int n, int n2) {
        NodeFinder nodeFinder = new NodeFinder(n, 0);
        this.fRoot.accept((ASTVisitor)nodeFinder);
        ASTNode aSTNode = nodeFinder.getCoveringNode();
        if (aSTNode == null) {
            return NO_BINDING;
        }
        if (aSTNode instanceof SimpleName) {
            return this.getDeclarationsInScope((SimpleName)aSTNode, n2);
        }
        try {
            ITypeBinding iTypeBinding = Bindings.getBindingOfParentType(aSTNode);
            DefaultBindingRequestor defaultBindingRequestor = new DefaultBindingRequestor(iTypeBinding, n2);
            this.addLocalDeclarations(aSTNode, n, n2, defaultBindingRequestor);
            if (iTypeBinding != null) {
                this.addTypeDeclarations(iTypeBinding, n2, defaultBindingRequestor);
            }
            List list = defaultBindingRequestor.getResult();
            IBinding[] iBindingArray = list.toArray(new IBinding[list.size()]);
            Object var8_9 = null;
            this.clearLists();
            return iBindingArray;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.clearLists();
            throw throwable;
        }
    }

    private static ITypeBinding getDeclaringType(IBinding iBinding) {
        switch (iBinding.getKind()) {
            case 3: {
                return ((IVariableBinding)iBinding).getDeclaringClass();
            }
            case 4: {
                return ((IMethodBinding)iBinding).getDeclaringClass();
            }
            case 2: {
                ITypeBinding iTypeBinding = (ITypeBinding)iBinding;
                if (iTypeBinding.getDeclaringClass() != null) {
                    return iTypeBinding;
                }
                return iTypeBinding;
            }
        }
        return null;
    }

    public static boolean isVisible(IBinding iBinding, ITypeBinding iTypeBinding) {
        if (iBinding.getKind() == 3 && !((IVariableBinding)iBinding).isField()) {
            return true;
        }
        ITypeBinding iTypeBinding2 = ScopeAnalyzer.getDeclaringType(iBinding);
        if (iTypeBinding2 == null) {
            return false;
        }
        int n = iBinding.getModifiers();
        if (Modifier.isPublic((int)n) || iTypeBinding2.isInterface()) {
            return true;
        }
        if (Modifier.isProtected((int)n) || !Modifier.isPrivate((int)n)) {
            if (iTypeBinding2.getPackage() == iTypeBinding.getPackage()) {
                return true;
            }
            return ScopeAnalyzer.isTypeInScope(iTypeBinding2, iTypeBinding, Modifier.isProtected((int)n));
        }
        return ScopeAnalyzer.isTypeInScope(iTypeBinding2, iTypeBinding, false);
    }

    private static boolean isTypeInScope(ITypeBinding iTypeBinding, ITypeBinding iTypeBinding2, boolean bl) {
        ITypeBinding iTypeBinding3 = iTypeBinding2;
        while (iTypeBinding3 != null && iTypeBinding3 != iTypeBinding) {
            if (bl && Bindings.isSuperType(iTypeBinding, iTypeBinding3)) {
                return true;
            }
            iTypeBinding3 = iTypeBinding3.getDeclaringClass();
        }
        return iTypeBinding3 == iTypeBinding;
    }

    public IBinding[] getDeclarationsAfter(int n, int n2) {
        block6: {
            ASTNode aSTNode;
            block5: {
                NodeFinder nodeFinder = new NodeFinder(n, 0);
                this.fRoot.accept((ASTVisitor)nodeFinder);
                aSTNode = nodeFinder.getCoveringNode();
                if (aSTNode != null) break block5;
                Object var9_5 = null;
                this.clearLists();
                return null;
            }
            try {
                Statement statement = ASTResolving.findParentStatement(aSTNode);
                while (statement instanceof Statement && statement.getNodeType() != 8) {
                    statement = statement.getParent();
                }
                if (!(statement instanceof Block)) break block6;
                DefaultBindingRequestor defaultBindingRequestor = new DefaultBindingRequestor();
                DeclarationsAfterVisitor declarationsAfterVisitor = new DeclarationsAfterVisitor(aSTNode.getStartPosition(), n2, defaultBindingRequestor);
                statement.accept((ASTVisitor)declarationsAfterVisitor);
                List list = defaultBindingRequestor.getResult();
                IBinding[] iBindingArray = list.toArray(new IBinding[list.size()]);
                Object var9_6 = null;
                this.clearLists();
                return iBindingArray;
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.clearLists();
                throw throwable;
            }
        }
        IBinding[] iBindingArray = NO_BINDING;
        Object var9_7 = null;
        this.clearLists();
        return iBindingArray;
    }

    private boolean addLocalDeclarations(ASTNode aSTNode, int n, IBindingRequestor iBindingRequestor) {
        return this.addLocalDeclarations(aSTNode, aSTNode.getStartPosition(), n, iBindingRequestor);
    }

    private boolean addLocalDeclarations(ASTNode aSTNode, int n, int n2, IBindingRequestor iBindingRequestor) {
        BodyDeclaration bodyDeclaration;
        if ((ScopeAnalyzer.hasFlag(2, n2) || ScopeAnalyzer.hasFlag(4, n2)) && ((bodyDeclaration = ASTResolving.findParentBodyDeclaration(aSTNode)) instanceof MethodDeclaration || bodyDeclaration instanceof Initializer)) {
            ScopeAnalyzerVisitor scopeAnalyzerVisitor = new ScopeAnalyzerVisitor(n, n2, iBindingRequestor);
            bodyDeclaration.accept((ASTVisitor)scopeAnalyzerVisitor);
            return scopeAnalyzerVisitor.fBreak;
        }
        return false;
    }

    public Collection getUsedVariableNames(int n, int n2) {
        HashSet<String> hashSet = new HashSet<String>();
        IBinding[] iBindingArray = this.getDeclarationsInScope(n, 2);
        int n3 = 0;
        while (n3 < iBindingArray.length) {
            hashSet.add(iBindingArray[n3].getName());
            ++n3;
        }
        IBinding[] iBindingArray2 = this.getDeclarationsAfter(n + n2, 2);
        int n4 = 0;
        while (n4 < iBindingArray2.length) {
            hashSet.add(iBindingArray2[n4].getName());
            ++n4;
        }
        List list = this.fRoot.imports();
        int n5 = 0;
        while (n5 < list.size()) {
            ImportDeclaration importDeclaration = (ImportDeclaration)list.get(n5);
            if (importDeclaration.isStatic() && !importDeclaration.isOnDemand()) {
                hashSet.add(ASTNodes.getSimpleNameIdentifier(importDeclaration.getName()));
            }
            ++n5;
        }
        return hashSet;
    }

    private class DeclarationsAfterVisitor
    extends HierarchicalASTVisitor {
        private final int fPosition;
        private final int fFlags;
        private final IBindingRequestor fRequestor;
        private boolean fBreak;

        public DeclarationsAfterVisitor(int n, int n2, IBindingRequestor iBindingRequestor) {
            this.fPosition = n;
            this.fFlags = n2;
            this.fRequestor = iBindingRequestor;
            this.fBreak = false;
        }

        public boolean visit(ASTNode aSTNode) {
            return !this.fBreak;
        }

        public boolean visit(VariableDeclaration variableDeclaration) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && this.fPosition < variableDeclaration.getStartPosition()) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)variableDeclaration.resolveBinding());
            }
            return false;
        }

        public boolean visit(AnonymousClassDeclaration anonymousClassDeclaration) {
            return false;
        }

        public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && this.fPosition < typeDeclarationStatement.getStartPosition()) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)typeDeclarationStatement.resolveBinding());
            }
            return false;
        }
    }

    private static class DefaultBindingRequestor
    implements IBindingRequestor {
        private final List fResult;
        private final HashSet fNamesAdded;
        private final int fFlags;
        private final ITypeBinding fParentTypeBinding;

        public DefaultBindingRequestor(ITypeBinding iTypeBinding, int n) {
            this.fParentTypeBinding = iTypeBinding;
            this.fFlags = n;
            this.fResult = new ArrayList();
            this.fNamesAdded = new HashSet();
        }

        public DefaultBindingRequestor() {
            this(null, 0);
        }

        public boolean acceptBinding(IBinding iBinding) {
            if (iBinding == null) {
                return false;
            }
            String string = ScopeAnalyzer.getSignature(iBinding);
            if (string != null && this.fNamesAdded.add(string)) {
                this.fResult.add(iBinding);
            }
            return false;
        }

        public List getResult() {
            if (ScopeAnalyzer.hasFlag(16, this.fFlags)) {
                int n = this.fResult.size() - 1;
                while (n >= 0) {
                    IBinding iBinding = (IBinding)this.fResult.get(n);
                    if (!ScopeAnalyzer.isVisible(iBinding, this.fParentTypeBinding)) {
                        this.fResult.remove(n);
                    }
                    --n;
                }
            }
            return this.fResult;
        }
    }

    private static interface IBindingRequestor {
        public boolean acceptBinding(IBinding var1);
    }

    private class ScopeAnalyzerVisitor
    extends HierarchicalASTVisitor {
        private int fPosition;
        private int fFlags;
        private final IBindingRequestor fRequestor;
        private boolean fBreak;

        public ScopeAnalyzerVisitor(int n, int n2, IBindingRequestor iBindingRequestor) {
            this.fPosition = n;
            this.fFlags = n2;
            this.fRequestor = iBindingRequestor;
            this.fBreak = false;
        }

        private boolean isInside(ASTNode aSTNode) {
            int n = aSTNode.getStartPosition();
            int n2 = n + aSTNode.getLength();
            return n <= this.fPosition && this.fPosition < n2;
        }

        public boolean visit(MethodDeclaration methodDeclaration) {
            if (this.isInside((ASTNode)methodDeclaration)) {
                Block block = methodDeclaration.getBody();
                if (block != null) {
                    block.accept((ASTVisitor)this);
                }
                this.visitBackwards(methodDeclaration.parameters());
                if (methodDeclaration.getAST().apiLevel() >= 3) {
                    this.visitBackwards(methodDeclaration.typeParameters());
                }
            }
            return false;
        }

        public boolean visit(TypeParameter typeParameter) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && typeParameter.getStartPosition() < this.fPosition) {
                this.fBreak = this.fRequestor.acceptBinding(typeParameter.getName().resolveBinding());
            }
            return !this.fBreak;
        }

        public boolean visit(SwitchCase switchCase) {
            SwitchStatement switchStatement;
            ITypeBinding iTypeBinding;
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && !switchCase.isDefault() && this.isInside((ASTNode)switchCase.getExpression()) && (iTypeBinding = (switchStatement = (SwitchStatement)switchCase.getParent()).getExpression().resolveTypeBinding()) != null && iTypeBinding.isEnum()) {
                IVariableBinding[] iVariableBindingArray = iTypeBinding.getDeclaredFields();
                int n = 0;
                while (n < iVariableBindingArray.length) {
                    IVariableBinding iVariableBinding = iVariableBindingArray[n];
                    if (iVariableBinding.isEnumConstant()) {
                        this.fBreak = this.fRequestor.acceptBinding((IBinding)iVariableBinding);
                        if (this.fBreak) {
                            return false;
                        }
                    }
                    ++n;
                }
            }
            return false;
        }

        public boolean visit(Initializer initializer) {
            return !this.fBreak && this.isInside((ASTNode)initializer);
        }

        public boolean visit(Statement statement) {
            return !this.fBreak && this.isInside((ASTNode)statement);
        }

        public boolean visit(ASTNode aSTNode) {
            return false;
        }

        public boolean visit(Block block) {
            if (this.isInside((ASTNode)block)) {
                this.visitBackwards(block.statements());
            }
            return false;
        }

        public boolean visit(VariableDeclaration variableDeclaration) {
            if (ScopeAnalyzer.hasFlag(2, this.fFlags) && variableDeclaration.getStartPosition() < this.fPosition) {
                this.fBreak = this.fRequestor.acceptBinding((IBinding)variableDeclaration.resolveBinding());
            }
            return !this.fBreak;
        }

        public boolean visit(VariableDeclarationStatement variableDeclarationStatement) {
            this.visitBackwards(variableDeclarationStatement.fragments());
            return false;
        }

        public boolean visit(VariableDeclarationExpression variableDeclarationExpression) {
            this.visitBackwards(variableDeclarationExpression.fragments());
            return false;
        }

        public boolean visit(CatchClause catchClause) {
            if (this.isInside((ASTNode)catchClause)) {
                catchClause.getBody().accept((ASTVisitor)this);
                catchClause.getException().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(ForStatement forStatement) {
            if (this.isInside((ASTNode)forStatement)) {
                forStatement.getBody().accept((ASTVisitor)this);
                this.visitBackwards(forStatement.initializers());
            }
            return false;
        }

        public boolean visit(ForInStatement forInStatement) {
            if (this.isInside((ASTNode)forInStatement)) {
                forInStatement.getBody().accept((ASTVisitor)this);
                forInStatement.getIterationVariable().accept((ASTVisitor)this);
            }
            return false;
        }

        public boolean visit(TypeDeclarationStatement typeDeclarationStatement) {
            if (ScopeAnalyzer.hasFlag(4, this.fFlags) && typeDeclarationStatement.getStartPosition() + typeDeclarationStatement.getLength() < this.fPosition) {
                this.fBreak = typeDeclarationStatement.getAST().apiLevel() == 2 ? this.fRequestor.acceptBinding((IBinding)typeDeclarationStatement.getTypeDeclaration().resolveBinding()) : this.fRequestor.acceptBinding(typeDeclarationStatement.getDeclaration().getName().resolveBinding());
                return false;
            }
            return !this.fBreak && this.isInside((ASTNode)typeDeclarationStatement);
        }

        private void visitBackwards(List list) {
            if (this.fBreak) {
                return;
            }
            int n = list.size() - 1;
            while (n >= 0) {
                ASTNode aSTNode = (ASTNode)list.get(n);
                if (aSTNode.getStartPosition() < this.fPosition) {
                    aSTNode.accept((ASTVisitor)this);
                }
                --n;
            }
        }
    }

    private static class SearchRequestor
    implements IBindingRequestor {
        private final int fFlags;
        private final ITypeBinding fParentTypeBinding;
        private final IBinding fToSearch;
        private boolean fFound;
        private boolean fIsVisible;

        public SearchRequestor(IBinding iBinding, ITypeBinding iTypeBinding, int n) {
            this.fFlags = n;
            this.fToSearch = iBinding;
            this.fParentTypeBinding = iTypeBinding;
            this.fFound = false;
            this.fIsVisible = true;
        }

        public boolean acceptBinding(IBinding iBinding) {
            if (this.fFound) {
                return true;
            }
            if (iBinding == null) {
                return false;
            }
            if (this.fToSearch.getKind() != iBinding.getKind()) {
                return false;
            }
            boolean bl = ScopeAnalyzer.hasFlag(16, this.fFlags);
            if (iBinding == this.fToSearch) {
                this.fFound = true;
            } else {
                String string;
                IBinding iBinding2 = Bindings.getDeclaration(iBinding);
                if (iBinding2 == this.fToSearch) {
                    this.fFound = true;
                } else if (iBinding2.getName().equals(this.fToSearch.getName()) && (string = ScopeAnalyzer.getSignature(iBinding2)) != null && string.equals(ScopeAnalyzer.getSignature(this.fToSearch))) {
                    if (bl) {
                        this.fIsVisible = false;
                    }
                    return true;
                }
            }
            if (this.fFound && bl) {
                this.fIsVisible = ScopeAnalyzer.isVisible(iBinding, this.fParentTypeBinding);
            }
            return this.fFound;
        }

        public boolean found() {
            return this.fFound;
        }

        public boolean isVisible() {
            return this.fIsVisible;
        }
    }
}

