/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.dom;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;

public class SelectionAnalyzer
extends GenericVisitor {
    private Selection fSelection;
    private boolean fTraverseSelectedNode;
    private ASTNode fLastCoveringNode;
    private List fSelectedNodes;

    public SelectionAnalyzer(Selection selection, boolean bl) {
        super(true);
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
        this.fTraverseSelectedNode = bl;
    }

    public boolean hasSelectedNodes() {
        return this.fSelectedNodes != null && !this.fSelectedNodes.isEmpty();
    }

    public ASTNode[] getSelectedNodes() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return new ASTNode[0];
        }
        return this.fSelectedNodes.toArray(new ASTNode[this.fSelectedNodes.size()]);
    }

    public ASTNode getFirstSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return (ASTNode)this.fSelectedNodes.get(0);
    }

    public ASTNode getLastSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return (ASTNode)this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
    }

    public boolean isExpressionSelected() {
        if (!this.hasSelectedNodes()) {
            return false;
        }
        return this.fSelectedNodes.get(0) instanceof Expression;
    }

    public IRegion getSelectedNodeRange() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        ASTNode aSTNode = (ASTNode)this.fSelectedNodes.get(0);
        ASTNode aSTNode2 = (ASTNode)this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
        int n = aSTNode.getStartPosition();
        return new Region(n, aSTNode2.getStartPosition() + aSTNode2.getLength() - n);
    }

    public ASTNode getLastCoveringNode() {
        return this.fLastCoveringNode;
    }

    protected Selection getSelection() {
        return this.fSelection;
    }

    protected boolean visitNode(ASTNode aSTNode) {
        if (this.fSelection.liesOutside(aSTNode)) {
            return false;
        }
        if (this.fSelection.covers(aSTNode)) {
            if (this.isFirstNode()) {
                this.handleFirstSelectedNode(aSTNode);
            } else {
                this.handleNextSelectedNode(aSTNode);
            }
            return this.fTraverseSelectedNode;
        }
        if (this.fSelection.coveredBy(aSTNode)) {
            this.fLastCoveringNode = aSTNode;
            return true;
        }
        if (this.fSelection.endsIn(aSTNode)) {
            return this.handleSelectionEndsIn(aSTNode);
        }
        return true;
    }

    protected void reset() {
        this.fSelectedNodes = null;
    }

    protected void handleFirstSelectedNode(ASTNode aSTNode) {
        this.fSelectedNodes = new ArrayList(5);
        this.fSelectedNodes.add(aSTNode);
    }

    protected void handleNextSelectedNode(ASTNode aSTNode) {
        if (this.getFirstSelectedNode().getParent() == aSTNode.getParent()) {
            this.fSelectedNodes.add(aSTNode);
        }
    }

    protected boolean handleSelectionEndsIn(ASTNode aSTNode) {
        return false;
    }

    protected List internalGetSelectedNodes() {
        return this.fSelectedNodes;
    }

    private boolean isFirstNode() {
        return this.fSelectedNodes == null;
    }
}

