/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public abstract class AbstractFix
implements IFix {
    private final String fName;
    private final ICompilationUnit fCompilationUnit;
    private final IFixRewriteOperation[] fFixRewrites;
    private final CompilationUnit fUnit;
    private IStatus fStatus;

    protected AbstractFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        this.fName = string;
        this.fCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        this.fFixRewrites = iFixRewriteOperationArray;
        this.fUnit = compilationUnit;
        this.fStatus = StatusInfo.OK_STATUS;
    }

    public String getDescription() {
        return this.fName;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    public TextChange createChange() throws CoreException {
        if (this.fFixRewrites == null || this.fFixRewrites.length == 0) {
            return null;
        }
        CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(this.getCompilationUnit(), this.fUnit);
        ArrayList arrayList = new ArrayList();
        int n = 0;
        while (n < this.fFixRewrites.length) {
            this.fFixRewrites[n].rewriteAST(compilationUnitRewrite, arrayList);
            ++n;
        }
        CompilationUnitChange compilationUnitChange = compilationUnitRewrite.createChange(this.getDescription(), true, null);
        if (compilationUnitChange == null) {
            return null;
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            TextEditGroup textEditGroup = (TextEditGroup)iterator.next();
            compilationUnitChange.addTextEditGroup(textEditGroup);
        }
        return compilationUnitChange;
    }

    public String getAdditionalInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.fFixRewrites.length) {
            AbstractFixRewriteOperation abstractFixRewriteOperation;
            String string;
            IFixRewriteOperation iFixRewriteOperation = this.fFixRewrites[n];
            if (iFixRewriteOperation instanceof AbstractFixRewriteOperation && (string = (abstractFixRewriteOperation = (AbstractFixRewriteOperation)iFixRewriteOperation).getAdditionalInfo()) != null) {
                stringBuffer.append(string);
            }
            ++n;
        }
        if (stringBuffer.length() > 0) {
            return stringBuffer.toString();
        }
        return null;
    }

    public IStatus getStatus() {
        return this.fStatus;
    }

    public void setStatus(IStatus iStatus) {
        this.fStatus = iStatus;
    }

    public static abstract class AbstractFixRewriteOperation
    implements IFixRewriteOperation {
        protected Type importType(ITypeBinding iTypeBinding, ASTNode aSTNode, ImportRewrite importRewrite, CompilationUnit compilationUnit) {
            ContextSensitiveImportRewriteContext contextSensitiveImportRewriteContext = new ContextSensitiveImportRewriteContext(compilationUnit, aSTNode.getStartPosition(), importRewrite);
            return importRewrite.addImport(iTypeBinding, compilationUnit.getAST(), (ImportRewrite.ImportRewriteContext)contextSensitiveImportRewriteContext);
        }

        protected TextEditGroup createTextEditGroup(String string) {
            if (string.length() > 0) {
                return new CategorizedTextEditGroup(string, new GroupCategorySet(new GroupCategory(string, string, string)));
            }
            return new TextEditGroup(string);
        }

        public String getAdditionalInfo() {
            return null;
        }
    }
}

