/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.ui.CodeGeneration;

public abstract class AbstractSerialVersionOperation
extends LinkedFix.AbstractLinkedFixRewriteOperation {
    protected static final String LONG_SUFFIX = "L";
    public static final long SERIAL_VALUE = 1L;
    protected static final String DEFAULT_EXPRESSION = "1L";
    protected static final String NAME_FIELD = "serialVersionUID";
    private final ASTNode[] fNodes;
    private final ICompilationUnit fUnit;

    protected AbstractSerialVersionOperation(ICompilationUnit iCompilationUnit, ASTNode[] aSTNodeArray) {
        this.fUnit = iCompilationUnit;
        this.fNodes = aSTNodeArray;
    }

    protected abstract boolean addInitializer(VariableDeclarationFragment var1, ASTNode var2) throws CoreException;

    protected abstract void addLinkedPositions(ASTRewrite var1, VariableDeclarationFragment var2, LinkedProposalModel var3);

    public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list, LinkedProposalModel linkedProposalModel) throws CoreException {
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        VariableDeclarationFragment variableDeclarationFragment = null;
        int n = 0;
        while (n < this.fNodes.length) {
            ASTNode aSTNode = this.fNodes[n];
            AST aST = aSTNode.getAST();
            variableDeclarationFragment = aST.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(aST.newSimpleName(NAME_FIELD));
            FieldDeclaration fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
            fieldDeclaration.setType((Type)aST.newPrimitiveType(PrimitiveType.LONG));
            fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, 26));
            if (this.addInitializer(variableDeclarationFragment, aSTNode)) {
                ParameterizedType parameterizedType;
                Object object;
                if (variableDeclarationFragment.getInitializer() != null) {
                    object = this.createTextEditGroup(FixMessages.SerialVersion_group_description);
                    list.add(object);
                    if (aSTNode instanceof AbstractTypeDeclaration) {
                        aSTRewrite.getListRewrite(aSTNode, ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty()).insertAt((ASTNode)fieldDeclaration, 0, (TextEditGroup)object);
                    } else if (aSTNode instanceof AnonymousClassDeclaration) {
                        aSTRewrite.getListRewrite(aSTNode, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)fieldDeclaration, 0, (TextEditGroup)object);
                    } else if (aSTNode instanceof ParameterizedType) {
                        ClassInstanceCreation classInstanceCreation;
                        AnonymousClassDeclaration anonymousClassDeclaration;
                        parameterizedType = (ParameterizedType)aSTNode;
                        ASTNode aSTNode2 = parameterizedType.getParent();
                        if (aSTNode2 instanceof ClassInstanceCreation && (anonymousClassDeclaration = (classInstanceCreation = (ClassInstanceCreation)aSTNode2).getAnonymousClassDeclaration()) != null) {
                            aSTRewrite.getListRewrite((ASTNode)anonymousClassDeclaration, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY).insertAt((ASTNode)fieldDeclaration, 0, (TextEditGroup)object);
                        }
                    } else {
                        Assert.isTrue((boolean)false);
                    }
                    this.addLinkedPositions(aSTRewrite, variableDeclarationFragment, linkedProposalModel);
                }
                if ((object = CodeGeneration.getFieldComment(this.fUnit, fieldDeclaration.getType().toString(), NAME_FIELD, StubUtility.getLineDelimiterUsed((IJavaElement)this.fUnit))) != null && ((String)object).length() > 0) {
                    parameterizedType = (Javadoc)aSTRewrite.createStringPlaceholder((String)object, 29);
                    fieldDeclaration.setJavadoc((Javadoc)parameterizedType);
                }
            }
            ++n;
        }
        if (variableDeclarationFragment == null) {
            return;
        }
        linkedProposalModel.setEndPosition(aSTRewrite.track(variableDeclarationFragment));
    }
}

