/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnhancedForStatement;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.NullLiteral;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.UndefinedLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.ConvertLoopOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRemover;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TightSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;

public final class ConvertIterableLoopOperation
extends ConvertLoopOperation {
    private boolean fAssigned = false;
    private IBinding fElement = null;
    private Expression fExpression = null;
    private IBinding fIterable = null;
    private boolean fThis = false;
    private IVariableBinding fIterator = null;
    private final List fOccurrences = new ArrayList(2);
    private EnhancedForStatement fEnhancedForLoop;
    private final boolean fMakeFinal;
    static /* synthetic */ Class class$0;

    private static ITypeBinding getSuperType(ITypeBinding iTypeBinding, String string) {
        ITypeBinding iTypeBinding2;
        if (iTypeBinding.isArray() || iTypeBinding.isPrimitive()) {
            return null;
        }
        if (iTypeBinding.getQualifiedName().startsWith(string)) {
            return iTypeBinding;
        }
        ITypeBinding iTypeBinding3 = iTypeBinding.getSuperclass();
        if (iTypeBinding3 != null && (iTypeBinding2 = ConvertIterableLoopOperation.getSuperType(iTypeBinding3, string)) != null) {
            return iTypeBinding2;
        }
        iTypeBinding2 = iTypeBinding.getInterfaces();
        int n = 0;
        while (n < ((ITypeBinding)iTypeBinding2).length) {
            ITypeBinding iTypeBinding4 = ConvertIterableLoopOperation.getSuperType(iTypeBinding2[n], string);
            if (iTypeBinding4 != null) {
                return iTypeBinding4;
            }
            ++n;
        }
        return null;
    }

    public ConvertIterableLoopOperation(ForStatement forStatement) {
        this(forStatement, new String[0], false);
    }

    public ConvertIterableLoopOperation(ForStatement forStatement, String[] stringArray, boolean bl) {
        super(forStatement, stringArray);
        this.fMakeFinal = bl;
    }

    public String getIntroducedVariableName() {
        if (this.fElement != null) {
            return this.fElement.getName();
        }
        return this.getVariableNameProposals()[0];
    }

    private String[] getVariableNameProposals() {
        String[] stringArray = this.getUsedVariableNames();
        String[] stringArray2 = StubUtility.getLocalNameSuggestions(this.getJavaProject(), "element", 0, stringArray);
        ITypeBinding iTypeBinding = this.fIterator.getType();
        if (iTypeBinding != null && iTypeBinding.isParameterizedType()) {
            String string = iTypeBinding.getTypeArguments()[0].getName();
            String[] stringArray3 = StubUtility.getLocalNameSuggestions(this.getJavaProject(), string, 0, stringArray);
            String[] stringArray4 = new String[stringArray2.length + stringArray3.length];
            System.arraycopy(stringArray3, 0, stringArray4, 0, stringArray3.length);
            System.arraycopy(stringArray2, 0, stringArray4, stringArray3.length, stringArray2.length);
            return stringArray4;
        }
        return stringArray2;
    }

    private IJavaProject getJavaProject() {
        return this.getRoot().getJavaElement().getJavaProject();
    }

    private CompilationUnit getRoot() {
        return (CompilationUnit)this.getForStatement().getRoot();
    }

    private Expression getExpression(ASTRewrite aSTRewrite) {
        if (this.fThis) {
            return aSTRewrite.getAST().newThisExpression();
        }
        if (this.fExpression instanceof MethodInvocation) {
            return (MethodInvocation)aSTRewrite.createMoveTarget((ASTNode)this.fExpression);
        }
        return (Expression)ASTNode.copySubtree((AST)aSTRewrite.getAST(), (ASTNode)this.fExpression);
    }

    private ITypeBinding getIterableType(ITypeBinding iTypeBinding) {
        ITypeBinding[] iTypeBindingArray;
        if (iTypeBinding != null && (iTypeBindingArray = iTypeBinding.getTypeArguments()).length > 0) {
            ITypeBinding iTypeBinding2 = iTypeBindingArray[0];
            if (iTypeBinding2.isWildcardType()) {
                iTypeBinding2 = ASTResolving.normalizeWildcardType(iTypeBinding2, true, this.getRoot().getAST());
            }
            return iTypeBinding2;
        }
        return this.getRoot().getAST().resolveWellKnownType("java.lang.Object");
    }

    public void rewriteAST(CompilationUnitRewrite compilationUnitRewrite, List list, LinkedProposalModel linkedProposalModel) throws CoreException {
        TextEditGroup textEditGroup = this.createTextEditGroup(FixMessages.Java50Fix_ConvertToEnhancedForLoop_description);
        list.add(textEditGroup);
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        TightSourceRangeComputer tightSourceRangeComputer = aSTRewrite.getExtendedSourceRangeComputer() instanceof TightSourceRangeComputer ? (TightSourceRangeComputer)aSTRewrite.getExtendedSourceRangeComputer() : new TightSourceRangeComputer();
        tightSourceRangeComputer.addTightSourceNode((ASTNode)this.getForStatement());
        aSTRewrite.setTargetSourceRangeComputer((TargetSourceRangeComputer)tightSourceRangeComputer);
        Statement statement = this.convert(compilationUnitRewrite, textEditGroup, linkedProposalModel);
        aSTRewrite.replace((ASTNode)this.getForStatement(), (ASTNode)statement, textEditGroup);
    }

    protected Statement convert(CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup, LinkedProposalModel linkedProposalModel) throws CoreException {
        ASTNode aSTNode;
        ITypeBinding iTypeBinding;
        Object object;
        SingleVariableDeclaration singleVariableDeclaration;
        final AST aST = compilationUnitRewrite.getAST();
        ASTRewrite aSTRewrite = compilationUnitRewrite.getASTRewrite();
        ImportRewrite importRewrite = compilationUnitRewrite.getImportRewrite();
        ImportRemover importRemover = compilationUnitRewrite.getImportRemover();
        this.fEnhancedForLoop = aST.newEnhancedForStatement();
        String[] stringArray = this.getVariableNameProposals();
        String string = this.fElement != null ? this.fElement.getName() : stringArray[0];
        LinkedProposalPositionGroup linkedProposalPositionGroup = linkedProposalModel.getPositionGroup(string, true);
        if (this.fElement != null) {
            linkedProposalPositionGroup.addProposal(string, null, 10);
        }
        int n = 0;
        while (n < stringArray.length) {
            linkedProposalPositionGroup.addProposal(stringArray[n], null, 10);
            ++n;
        }
        Statement statement = this.getForStatement().getBody();
        if (statement != null) {
            if (statement instanceof Block) {
                singleVariableDeclaration = aSTRewrite.getListRewrite((ASTNode)statement, Block.STATEMENTS_PROPERTY);
                object = this.fOccurrences.iterator();
                while (object.hasNext()) {
                    ASTNode aSTNode2 = (ASTNode)object.next();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.Statement");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((iTypeBinding = (Statement)ASTNodes.getParent(aSTNode2, clazz)) == null || !singleVariableDeclaration.getRewrittenList().contains(iTypeBinding)) continue;
                    singleVariableDeclaration.remove((ASTNode)iTypeBinding, null);
                    importRemover.registerRemovedNode((ASTNode)iTypeBinding);
                }
            } else {
                singleVariableDeclaration = null;
            }
            object = string;
            statement.accept(new ASTVisitor((String)object, aSTRewrite, textEditGroup, importRemover, linkedProposalPositionGroup, (ListRewrite)singleVariableDeclaration){
                private final /* synthetic */ String val$text;
                private final /* synthetic */ ASTRewrite val$astRewrite;
                private final /* synthetic */ TextEditGroup val$group;
                private final /* synthetic */ ImportRemover val$remover;
                private final /* synthetic */ LinkedProposalPositionGroup val$pg;
                private final /* synthetic */ ListRewrite val$list;
                {
                    this.val$text = string;
                    this.val$astRewrite = aSTRewrite;
                    this.val$group = textEditGroup;
                    this.val$remover = importRemover;
                    this.val$pg = linkedProposalPositionGroup;
                    this.val$list = listRewrite;
                }

                private boolean replace(Expression expression) {
                    SimpleName simpleName = aST.newSimpleName(this.val$text);
                    this.val$astRewrite.replace((ASTNode)expression, (ASTNode)simpleName, this.val$group);
                    this.val$remover.registerRemovedNode((ASTNode)expression);
                    this.val$pg.addPosition(this.val$astRewrite.track((ASTNode)simpleName), false);
                    return false;
                }

                public final boolean visit(MethodInvocation methodInvocation) {
                    IVariableBinding iVariableBinding;
                    IBinding iBinding;
                    Expression expression;
                    IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
                    if (iMethodBinding != null && (iMethodBinding.getName().equals("next") || iMethodBinding.getName().equals("nextElement")) && ((expression = methodInvocation.getExpression()) instanceof Name ? (iBinding = ((Name)expression).resolveBinding()) != null && iBinding.equals((Object)ConvertIterableLoopOperation.this.fIterator) : expression instanceof FieldAccess && (iVariableBinding = ((FieldAccess)expression).resolveFieldBinding()) != null && iVariableBinding.equals((Object)ConvertIterableLoopOperation.this.fIterator))) {
                        return this.replace((Expression)methodInvocation);
                    }
                    return super.visit(methodInvocation);
                }

                public final boolean visit(SimpleName simpleName) {
                    IBinding iBinding;
                    if (ConvertIterableLoopOperation.this.fElement != null && (iBinding = simpleName.resolveBinding()) != null && iBinding.equals((Object)ConvertIterableLoopOperation.this.fElement)) {
                        Statement statement;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.Statement");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((statement = (Statement)ASTNodes.getParent((ASTNode)simpleName, clazz)) != null && (this.val$list == null || this.val$list.getRewrittenList().contains(statement))) {
                            this.val$pg.addPosition(this.val$astRewrite.track((ASTNode)simpleName), false);
                        }
                    }
                    return false;
                }
            });
            this.fEnhancedForLoop.setBody(this.getBody(compilationUnitRewrite, textEditGroup, linkedProposalModel));
        }
        singleVariableDeclaration = aST.newSingleVariableDeclaration();
        object = aST.newSimpleName(string);
        linkedProposalPositionGroup.addPosition(aSTRewrite.track((ASTNode)object), true);
        singleVariableDeclaration.setName((SimpleName)object);
        iTypeBinding = this.getIterableType(this.fIterator.getType());
        singleVariableDeclaration.setType(this.importType(iTypeBinding, (ASTNode)this.getForStatement(), importRewrite, this.getRoot()));
        if (this.fMakeFinal) {
            ModifierRewrite.create(aSTRewrite, (ASTNode)singleVariableDeclaration).setModifiers(16, 0, textEditGroup);
        }
        importRemover.registerAddedImport(iTypeBinding.getQualifiedName());
        this.fEnhancedForLoop.setParameter(singleVariableDeclaration);
        this.fEnhancedForLoop.setExpression(this.getExpression(aSTRewrite));
        importRemover.registerRemovedNode((ASTNode)this.getForStatement().getExpression());
        Iterator iterator = this.getForStatement().initializers().iterator();
        while (iterator.hasNext()) {
            aSTNode = (ASTNode)iterator.next();
            importRemover.registerRemovedNode(aSTNode);
        }
        iterator = this.getForStatement().updaters().iterator();
        while (iterator.hasNext()) {
            aSTNode = (ASTNode)iterator.next();
            importRemover.registerRemovedNode(aSTNode);
        }
        return this.fEnhancedForLoop;
    }

    public final IStatus satisfiesPreconditions() {
        IStatus iStatus = StatusInfo.OK_STATUS;
        if (JavaModelUtil.is50OrHigher(this.getJavaProject())) {
            List list;
            Object object;
            Object object2;
            iStatus = this.checkExpressionCondition();
            if (iStatus.getSeverity() == 4) {
                return iStatus;
            }
            List list2 = (List)this.getForStatement().getStructuralProperty((StructuralPropertyDescriptor)ForStatement.UPDATERS_PROPERTY);
            if (list2.size() == 1) {
                iStatus = new StatusInfo(2, Messages.format(FixMessages.ConvertIterableLoopOperation_RemoveUpdateExpression_Warning, ((Expression)list2.get(0)).toString()));
            } else if (list2.size() > 1) {
                iStatus = new StatusInfo(2, FixMessages.ConvertIterableLoopOperation_RemoveUpdateExpressions_Warning);
            }
            Statement statement = this.getForStatement().initializers().iterator();
            while (statement.hasNext()) {
                object2 = (Expression)statement.next();
                if (!(object2 instanceof VariableDeclarationExpression)) continue;
                object = (VariableDeclarationExpression)object2;
                list = object.fragments();
                if (list.size() != 1) {
                    return new StatusInfo(4, "");
                }
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)list.get(0);
                variableDeclarationFragment.accept(new ASTVisitor(){

                    public final boolean visit(MethodInvocation methodInvocation) {
                        String string;
                        ITypeBinding iTypeBinding;
                        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
                        if (iMethodBinding != null && (iTypeBinding = iMethodBinding.getReturnType()) != null && ((string = iTypeBinding.getQualifiedName()).startsWith("java.util.Enumeration<") || string.startsWith("java.util.Iterator<"))) {
                            Expression expression = methodInvocation.getExpression();
                            if (expression != null) {
                                ITypeBinding iTypeBinding2;
                                ITypeBinding iTypeBinding3 = expression.resolveTypeBinding();
                                if (iTypeBinding3 != null && (iTypeBinding2 = ConvertIterableLoopOperation.getSuperType(iTypeBinding3, "java.lang.Iterable")) != null) {
                                    ConvertIterableLoopOperation.this.fExpression = expression;
                                    if (expression instanceof Name) {
                                        Name name = (Name)expression;
                                        ConvertIterableLoopOperation.this.fIterable = name.resolveBinding();
                                    } else if (expression instanceof MethodInvocation) {
                                        MethodInvocation methodInvocation2 = (MethodInvocation)expression;
                                        ConvertIterableLoopOperation.this.fIterable = (IBinding)methodInvocation2.resolveMethodBinding();
                                    } else if (expression instanceof FieldAccess) {
                                        FieldAccess fieldAccess = (FieldAccess)expression;
                                        ConvertIterableLoopOperation.this.fIterable = (IBinding)fieldAccess.resolveFieldBinding();
                                    } else if (expression instanceof ThisExpression) {
                                        ConvertIterableLoopOperation.this.fIterable = (IBinding)iTypeBinding3;
                                    }
                                }
                            } else {
                                ITypeBinding iTypeBinding4;
                                ITypeBinding iTypeBinding5 = iMethodBinding.getDeclaringClass();
                                if (iTypeBinding5 != null && (iTypeBinding4 = ConvertIterableLoopOperation.getSuperType(iTypeBinding5, "java.lang.Iterable")) != null) {
                                    ConvertIterableLoopOperation.this.fIterable = (IBinding)iTypeBinding4;
                                    ConvertIterableLoopOperation.this.fThis = true;
                                }
                            }
                        }
                        return true;
                    }

                    public final boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                        ITypeBinding iTypeBinding;
                        IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
                        if (iVariableBinding != null && (iTypeBinding = iVariableBinding.getType()) != null) {
                            ITypeBinding iTypeBinding2 = ConvertIterableLoopOperation.getSuperType(iTypeBinding, "java.util.Iterator");
                            if (iTypeBinding2 != null) {
                                ConvertIterableLoopOperation.this.fIterator = iVariableBinding;
                            } else {
                                iTypeBinding2 = ConvertIterableLoopOperation.getSuperType(iTypeBinding, "java.util.Enumeration");
                                if (iTypeBinding2 != null) {
                                    ConvertIterableLoopOperation.this.fIterator = iVariableBinding;
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            statement = this.getForStatement().getBody();
            object2 = new boolean[1];
            object = new int[1];
            if (statement != null && this.fIterator != null) {
                list = this.getIterableType(this.fIterator.getType());
                statement.accept(new ASTVisitor((ITypeBinding)list){
                    private final /* synthetic */ ITypeBinding val$iterable;
                    {
                        this.val$iterable = iTypeBinding;
                    }

                    public final boolean visit(Assignment assignment) {
                        return this.visit(assignment.getLeftHandSide(), assignment.getRightHandSide());
                    }

                    private boolean visit(Expression expression) {
                        ITypeBinding iTypeBinding;
                        if (expression != null && (iTypeBinding = expression.resolveTypeBinding()) != null && this.val$iterable.equals((Object)iTypeBinding)) {
                            FieldAccess fieldAccess;
                            IVariableBinding iVariableBinding;
                            if (expression instanceof Name) {
                                Name name = (Name)expression;
                                IBinding iBinding = name.resolveBinding();
                                if (iBinding != null) {
                                    ConvertIterableLoopOperation.this.fOccurrences.add(expression);
                                    ConvertIterableLoopOperation.this.fElement = iBinding;
                                    return false;
                                }
                            } else if (expression instanceof FieldAccess && (iVariableBinding = (fieldAccess = (FieldAccess)expression).resolveFieldBinding()) != null) {
                                ConvertIterableLoopOperation.this.fOccurrences.add(expression);
                                ConvertIterableLoopOperation.this.fElement = (IBinding)iVariableBinding;
                                return false;
                            }
                        }
                        return true;
                    }

                    private boolean visit(Expression expression, Expression expression2) {
                        if (expression2 instanceof MethodInvocation) {
                            MethodInvocation methodInvocation = (MethodInvocation)expression2;
                            methodInvocation.resolveMethodBinding();
                        } else if (expression2 instanceof NullLiteral || expression2 instanceof UndefinedLiteral) {
                            return this.visit(expression);
                        }
                        return true;
                    }

                    public boolean visit(MethodInvocation methodInvocation) {
                        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
                        if (iMethodBinding != null) {
                            FieldAccess fieldAccess;
                            IVariableBinding iVariableBinding;
                            Expression expression = methodInvocation.getExpression();
                            if (expression instanceof Name) {
                                Name name = (Name)expression;
                                IBinding iBinding = name.resolveBinding();
                                if (iBinding != null) {
                                    iBinding.equals((Object)ConvertIterableLoopOperation.this.fIterator);
                                }
                            } else if (expression instanceof FieldAccess && (iVariableBinding = (fieldAccess = (FieldAccess)expression).resolveFieldBinding()) != null) {
                                iVariableBinding.equals((Object)ConvertIterableLoopOperation.this.fIterator);
                            }
                        }
                        return false;
                    }

                    public final boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                        return this.visit((Expression)variableDeclarationFragment.getName(), variableDeclarationFragment.getInitializer());
                    }
                });
                if (object2[0] != false) {
                    return new StatusInfo(4, "");
                }
                if (object[0] > 1) {
                    return new StatusInfo(4, "");
                }
            }
            if ((list = this.getForStatement().getRoot()) != null) {
                list.accept(new ASTVisitor(){

                    public final boolean visit(ForStatement forStatement) {
                        return false;
                    }

                    public final boolean visit(SimpleName simpleName) {
                        IBinding iBinding = simpleName.resolveBinding();
                        if (iBinding != null && iBinding.equals((Object)ConvertIterableLoopOperation.this.fElement)) {
                            ConvertIterableLoopOperation.this.fAssigned = true;
                        }
                        return false;
                    }
                });
            }
        }
        if ((this.fExpression != null || this.fThis) && this.fIterable != null && this.fIterator != null && !this.fAssigned) {
            return iStatus;
        }
        return new StatusInfo(4, "");
    }

    private IStatus checkExpressionCondition() {
        String string = FixMessages.ConvertIterableLoopOperation_semanticChangeWarning;
        Expression expression = this.getForStatement().getExpression();
        if (!(expression instanceof MethodInvocation)) {
            return new StatusInfo(2, string);
        }
        MethodInvocation methodInvocation = (MethodInvocation)expression;
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        if (iMethodBinding == null) {
            return new StatusInfo(4, "");
        }
        ITypeBinding iTypeBinding = iMethodBinding.getDeclaringClass();
        if (iTypeBinding == null) {
            return new StatusInfo(4, "");
        }
        iTypeBinding.getQualifiedName();
        return StatusInfo.OK_STATUS;
    }
}

