/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedFix;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public abstract class ConvertLoopOperation
extends LinkedFix.AbstractLinkedFixRewriteOperation {
    protected static final String FOR_LOOP_ELEMENT_IDENTIFIER = "element";
    protected static final IStatus ERROR_STATUS = new Status(4, JavaPlugin.getPluginId(), "");
    private final ForStatement fStatement;
    private ConvertLoopOperation fOperation;
    private final String[] fUsedNames;

    public ConvertLoopOperation(ForStatement forStatement, String[] stringArray) {
        this.fStatement = forStatement;
        this.fUsedNames = stringArray;
    }

    public void setBodyConverter(ConvertLoopOperation convertLoopOperation) {
        this.fOperation = convertLoopOperation;
    }

    public abstract String getIntroducedVariableName();

    public abstract IStatus satisfiesPreconditions();

    protected abstract Statement convert(CompilationUnitRewrite var1, TextEditGroup var2, LinkedProposalModel var3) throws CoreException;

    protected ForStatement getForStatement() {
        return this.fStatement;
    }

    protected Statement getBody(CompilationUnitRewrite compilationUnitRewrite, TextEditGroup textEditGroup, LinkedProposalModel linkedProposalModel) throws CoreException {
        if (this.fOperation != null) {
            return this.fOperation.convert(compilationUnitRewrite, textEditGroup, linkedProposalModel);
        }
        return (Statement)compilationUnitRewrite.getASTRewrite().createMoveTarget((ASTNode)this.getForStatement().getBody());
    }

    protected String[] getUsedVariableNames() {
        final ArrayList<String> arrayList = new ArrayList<String>();
        ForStatement forStatement = this.getForStatement();
        CompilationUnit compilationUnit = (CompilationUnit)forStatement.getRoot();
        Collection collection = new ScopeAnalyzer(compilationUnit).getUsedVariableNames(forStatement.getStartPosition(), forStatement.getLength());
        arrayList.addAll(collection);
        forStatement.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(SingleVariableDeclaration singleVariableDeclaration) {
                arrayList.add(singleVariableDeclaration.getName().getIdentifier());
                return super.visit(singleVariableDeclaration);
            }

            public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                arrayList.add(variableDeclarationFragment.getName().getIdentifier());
                return super.visit(variableDeclarationFragment);
            }
        });
        arrayList.addAll(Arrays.asList(this.fUsedNames));
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

