/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractFix;
import org.eclipse.wst.jsdt.internal.corext.fix.FixMessages;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;

public class ImportsFix
extends AbstractFix {
    public static IFix createCleanUp(final CompilationUnit compilationUnit, CodeGenerationSettings codeGenerationSettings, boolean bl, RefactoringStatus refactoringStatus) throws CoreException {
        TextEdit textEdit;
        if (!bl) {
            return null;
        }
        OrganizeImportsOperation.IChooseImportQuery iChooseImportQuery = new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] typeNameMatchArray, ISourceRange[] iSourceRangeArray) {
                throw new AmbiguousImportException();
            }
        };
        OrganizeImportsOperation organizeImportsOperation = new OrganizeImportsOperation((ICompilationUnit)compilationUnit.getJavaElement(), compilationUnit, codeGenerationSettings.importIgnoreLowercase, false, false, iChooseImportQuery);
        try {
            textEdit = organizeImportsOperation.createTextEdit(null);
        }
        catch (AmbiguousImportException ambiguousImportException) {
            refactoringStatus.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unresolvable, ImportsFix.getLocationString(compilationUnit)));
            return null;
        }
        if (organizeImportsOperation.getParseError() != null) {
            refactoringStatus.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_parse, ImportsFix.getLocationString(compilationUnit)));
            return null;
        }
        if (textEdit == null) {
            return null;
        }
        if (organizeImportsOperation.getNumberOfImportsAdded() == 0 && organizeImportsOperation.getNumberOfImportsRemoved() == 0) {
            return null;
        }
        return new IFix(){

            public TextChange createChange() throws CoreException {
                CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.getDescription(), this.getCompilationUnit());
                compilationUnitChange.setEdit(textEdit);
                String string = this.getDescription();
                compilationUnitChange.addTextEditGroup((TextEditGroup)new CategorizedTextEditGroup(string, new GroupCategorySet(new GroupCategory(string, string, string))));
                return compilationUnitChange;
            }

            public ICompilationUnit getCompilationUnit() {
                return (ICompilationUnit)compilationUnit.getJavaElement();
            }

            public String getDescription() {
                return FixMessages.ImportsFix_OrganizeImports_Description;
            }

            public IStatus getStatus() {
                return StatusInfo.OK_STATUS;
            }
        };
    }

    private static String getLocationString(CompilationUnit compilationUnit) {
        return compilationUnit.getJavaElement().getPath().makeRelative().toString();
    }

    protected ImportsFix(String string, CompilationUnit compilationUnit, IFixRewriteOperation[] iFixRewriteOperationArray) {
        super(string, compilationUnit, iFixRewriteOperationArray);
    }

    private static final class AmbiguousImportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AmbiguousImportException() {
        }
    }
}

