/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;

public class ExceptionInfo {
    private final IType fType;
    private final ITypeBinding fTypeBinding;
    private int fKind;
    public static final int OLD = 0;
    public static final int ADDED = 1;
    public static final int DELETED = 2;

    public ExceptionInfo(IType iType, int n, ITypeBinding iTypeBinding) {
        Assert.isNotNull((Object)iType);
        this.fType = iType;
        this.fKind = n;
        this.fTypeBinding = iTypeBinding;
    }

    public static ExceptionInfo createInfoForOldException(IType iType, ITypeBinding iTypeBinding) {
        return new ExceptionInfo(iType, 0, iTypeBinding);
    }

    public static ExceptionInfo createInfoForAddedException(IType iType) {
        return new ExceptionInfo(iType, 1, null);
    }

    public void markAsDeleted() {
        Assert.isTrue((!this.isAdded() ? 1 : 0) != 0);
        this.fKind = 2;
    }

    public void markAsOld() {
        Assert.isTrue((boolean)this.isDeleted());
        this.fKind = 0;
    }

    public boolean isAdded() {
        return this.fKind == 1;
    }

    public boolean isDeleted() {
        return this.fKind == 2;
    }

    public boolean isOld() {
        return this.fKind == 0;
    }

    public IType getType() {
        return this.fType;
    }

    public int getKind() {
        return this.fKind;
    }

    public ITypeBinding getTypeBinding() {
        return this.fTypeBinding;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        switch (this.fKind) {
            case 0: {
                stringBuffer.append("OLD: ");
                break;
            }
            case 1: {
                stringBuffer.append("ADDED: ");
                break;
            }
            case 2: {
                stringBuffer.append("DELETED: ");
            }
        }
        if (this.fType == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.fType.toString());
        }
        return stringBuffer.toString();
    }
}

