/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

public class RefactoringScopeFactory {
    private static void addReferencingProjects(IJavaProject iJavaProject, Set set) throws JavaModelException {
        IProject[] iProjectArray = iJavaProject.getProject().getReferencingProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IClasspathEntry iClasspathEntry;
            IJavaProject iJavaProject2 = JavaCore.create((IProject)iProjectArray[n]);
            if (iJavaProject2 != null && !set.contains(iJavaProject2) && iJavaProject2.exists() && (iClasspathEntry = RefactoringScopeFactory.getReferencingClassPathEntry(iJavaProject2, iJavaProject)) != null) {
                set.add(iJavaProject2);
                if (iClasspathEntry.isExported()) {
                    RefactoringScopeFactory.addReferencingProjects(iJavaProject2, set);
                }
            }
            ++n;
        }
    }

    private static void addRelatedReferencing(IJavaProject iJavaProject, Set set) throws CoreException {
        IProject[] iProjectArray = iJavaProject.getProject().getReferencingProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IClasspathEntry iClasspathEntry;
            IJavaProject iJavaProject2 = JavaCore.create((IProject)iProjectArray[n]);
            if (iJavaProject2 != null && !set.contains(iJavaProject2) && iJavaProject2.exists() && (iClasspathEntry = RefactoringScopeFactory.getReferencingClassPathEntry(iJavaProject2, iJavaProject)) != null) {
                set.add(iJavaProject2);
                if (iClasspathEntry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferencing(iJavaProject2, set);
                    RefactoringScopeFactory.addRelatedReferenced(iJavaProject2, set);
                }
            }
            ++n;
        }
    }

    private static void addRelatedReferenced(IJavaProject iJavaProject, Set set) throws CoreException {
        IProject[] iProjectArray = iJavaProject.getProject().getReferencedProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            IClasspathEntry iClasspathEntry;
            IJavaProject iJavaProject2 = JavaCore.create((IProject)iProjectArray[n]);
            if (iJavaProject2 != null && !set.contains(iJavaProject2) && iJavaProject2.exists() && (iClasspathEntry = RefactoringScopeFactory.getReferencingClassPathEntry(iJavaProject, iJavaProject2)) != null) {
                set.add(iJavaProject2);
                if (iClasspathEntry.isExported()) {
                    RefactoringScopeFactory.addRelatedReferenced(iJavaProject2, set);
                    RefactoringScopeFactory.addRelatedReferencing(iJavaProject2, set);
                }
            }
            ++n;
        }
    }

    public static IJavaSearchScope create(IJavaElement iJavaElement) throws JavaModelException {
        return RefactoringScopeFactory.create(iJavaElement, true);
    }

    public static IJavaSearchScope create(IJavaElement iJavaElement, boolean bl) throws JavaModelException {
        IMember iMember;
        if (bl & iJavaElement instanceof IMember && JdtFlags.isPrivate(iMember = (IMember)iJavaElement)) {
            if (iMember.getCompilationUnit() != null) {
                return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iMember.getCompilationUnit()});
            }
            return SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{iMember});
        }
        return RefactoringScopeFactory.create(iJavaElement.getJavaProject());
    }

    private static IJavaSearchScope create(IJavaProject iJavaProject) throws JavaModelException {
        return SearchEngine.createJavaSearchScope((IJavaElement[])RefactoringScopeFactory.getAllScopeElements(iJavaProject), (boolean)false);
    }

    public static IJavaSearchScope create(IMember[] iMemberArray) throws JavaModelException {
        Assert.isTrue((iMemberArray != null && iMemberArray.length > 0 ? 1 : 0) != 0);
        IMember iMember = iMemberArray[0];
        int n = RefactoringScopeFactory.getVisibility(iMember);
        int n2 = 1;
        while (n2 < iMemberArray.length) {
            int n3 = RefactoringScopeFactory.getVisibility(iMemberArray[n2]);
            if (n3 > n) {
                n = n3;
                iMember = iMemberArray[n2];
            }
            ++n2;
        }
        return RefactoringScopeFactory.create((IJavaElement)iMember);
    }

    public static IJavaSearchScope createReferencedScope(IJavaElement[] iJavaElementArray) {
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
        int n = 0;
        while (n < iJavaElementArray.length) {
            hashSet.add(iJavaElementArray[n].getJavaProject());
            ++n;
        }
        IJavaProject[] iJavaProjectArray = hashSet.toArray(new IJavaProject[hashSet.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaProjectArray, (boolean)true);
    }

    public static IJavaSearchScope createReferencedScope(IJavaElement[] iJavaElementArray, int n) {
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
        int n2 = 0;
        while (n2 < iJavaElementArray.length) {
            hashSet.add(iJavaElementArray[n2].getJavaProject());
            ++n2;
        }
        IJavaProject[] iJavaProjectArray = hashSet.toArray(new IJavaProject[hashSet.size()]);
        return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaProjectArray, (int)n);
    }

    public static IJavaSearchScope createRelatedProjectsScope(IJavaProject iJavaProject, int n) throws CoreException {
        IJavaProject[] iJavaProjectArray = RefactoringScopeFactory.getRelatedProjects(iJavaProject);
        return SearchEngine.createJavaSearchScope((IJavaElement[])iJavaProjectArray, (int)n);
    }

    private static IJavaElement[] getAllScopeElements(IJavaProject iJavaProject) throws JavaModelException {
        Collection collection = RefactoringScopeFactory.getAllSourceRootsInProjects(RefactoringScopeFactory.getReferencingProjects(iJavaProject));
        return collection.toArray(new IPackageFragmentRoot[collection.size()]);
    }

    private static Collection getAllSourceRootsInProjects(Collection collection) throws JavaModelException {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(RefactoringScopeFactory.getSourceRoots((IJavaProject)iterator.next()));
        }
        return arrayList;
    }

    private static IClasspathEntry getReferencingClassPathEntry(IJavaProject iJavaProject, IJavaProject iJavaProject2) throws JavaModelException {
        IClasspathEntry iClasspathEntry = null;
        IPath iPath = iJavaProject2.getProject().getFullPath();
        IClasspathEntry[] iClasspathEntryArray = iJavaProject.getResolvedClasspath(true);
        int n = 0;
        while (n < iClasspathEntryArray.length) {
            IClasspathEntry iClasspathEntry2 = iClasspathEntryArray[n];
            if (iClasspathEntry2.getEntryKind() == 2 && iPath.equals((Object)iClasspathEntry2.getPath())) {
                if (iClasspathEntry2.isExported()) {
                    return iClasspathEntry2;
                }
                iClasspathEntry = iClasspathEntry2;
            }
            ++n;
        }
        return iClasspathEntry;
    }

    private static IJavaProject[] getRelatedProjects(IJavaProject iJavaProject) throws CoreException {
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addRelatedReferencing(iJavaProject, hashSet);
        RefactoringScopeFactory.addRelatedReferenced(iJavaProject, hashSet);
        hashSet.add(iJavaProject);
        return hashSet.toArray(new IJavaProject[hashSet.size()]);
    }

    private static Collection getReferencingProjects(IJavaProject iJavaProject) throws JavaModelException {
        HashSet<IJavaProject> hashSet = new HashSet<IJavaProject>();
        RefactoringScopeFactory.addReferencingProjects(iJavaProject, hashSet);
        hashSet.add(iJavaProject);
        return hashSet;
    }

    private static List getSourceRoots(IJavaProject iJavaProject) throws JavaModelException {
        ArrayList<IPackageFragmentRoot> arrayList = new ArrayList<IPackageFragmentRoot>();
        IPackageFragmentRoot[] iPackageFragmentRootArray = iJavaProject.getPackageFragmentRoots();
        int n = 0;
        while (n < iPackageFragmentRootArray.length) {
            IPackageFragmentRoot iPackageFragmentRoot = iPackageFragmentRootArray[n];
            if (!iPackageFragmentRoot.isArchive()) {
                arrayList.add(iPackageFragmentRoot);
            }
            ++n;
        }
        return arrayList;
    }

    private static int getVisibility(IMember iMember) throws JavaModelException {
        if (JdtFlags.isPrivate(iMember)) {
            return 0;
        }
        if (JdtFlags.isPackageVisible(iMember)) {
            return 1;
        }
        if (JdtFlags.isProtected(iMember)) {
            return 2;
        }
        return 4;
    }

    private RefactoringScopeFactory() {
    }
}

