/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;

public class TypedSource {
    private final String fSource;
    private final int fType;

    private TypedSource(String string, int n) {
        Assert.isNotNull((Object)string);
        Assert.isTrue((boolean)TypedSource.canCreateForType(n));
        this.fSource = string;
        this.fType = n;
    }

    public static TypedSource create(String string, int n) {
        if (string == null || !TypedSource.canCreateForType(n)) {
            return null;
        }
        return new TypedSource(string, n);
    }

    public String getSource() {
        return this.fSource;
    }

    public int getType() {
        return this.fType;
    }

    public boolean equals(Object object) {
        if (!(object instanceof TypedSource)) {
            return false;
        }
        TypedSource typedSource = (TypedSource)object;
        return typedSource.getSource().equals(this.getSource()) && typedSource.getType() == this.getType();
    }

    public int hashCode() {
        return this.getSource().hashCode() ^ 97 * this.getType();
    }

    private static boolean canCreateForType(int n) {
        return n == 8 || n == 7 || n == 12 || n == 13 || n == 10 || n == 9 || n == 11;
    }

    public static void sortByType(TypedSource[] typedSourceArray) {
        Arrays.sort(typedSourceArray, TypedSource.createTypeComparator());
    }

    public static Comparator createTypeComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return ((TypedSource)object).getType() - ((TypedSource)object2).getType();
            }
        };
    }

    public static TypedSource[] createTypedSources(IJavaElement[] iJavaElementArray) throws CoreException {
        Map map = ReorgUtils.groupByCompilationUnit(Arrays.asList(iJavaElementArray));
        ArrayList<TypedSource> arrayList = new ArrayList<TypedSource>(iJavaElementArray.length);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
            Iterator iterator2 = ((List)map.get(iCompilationUnit)).iterator();
            while (iterator2.hasNext()) {
                SourceTuple sourceTuple = new SourceTuple(iCompilationUnit);
                TypedSource[] typedSourceArray = TypedSource.createTypedSources((IJavaElement)iterator2.next(), sourceTuple);
                if (typedSourceArray == null) continue;
                arrayList.addAll(Arrays.asList(typedSourceArray));
            }
        }
        return arrayList.toArray(new TypedSource[arrayList.size()]);
    }

    private static TypedSource[] createTypedSources(IJavaElement iJavaElement, SourceTuple sourceTuple) throws CoreException {
        if (!ReorgUtils.isInsideCompilationUnit(iJavaElement)) {
            return null;
        }
        if (iJavaElement.getElementType() == 12) {
            return TypedSource.createTypedSourcesForImportContainer(sourceTuple, (IImportContainer)iJavaElement);
        }
        if (iJavaElement.getElementType() == 8) {
            return new TypedSource[]{TypedSource.create(TypedSource.getFieldSource((IField)iJavaElement, sourceTuple), iJavaElement.getElementType())};
        }
        return new TypedSource[]{TypedSource.create(TypedSource.getSourceOfDeclararationNode(iJavaElement, sourceTuple.unit), iJavaElement.getElementType())};
    }

    private static TypedSource[] createTypedSourcesForImportContainer(SourceTuple sourceTuple, IImportContainer iImportContainer) throws JavaModelException, CoreException {
        IJavaElement[] iJavaElementArray = iImportContainer.getChildren();
        ArrayList<TypedSource> arrayList = new ArrayList<TypedSource>(iJavaElementArray.length);
        int n = 0;
        while (n < iJavaElementArray.length) {
            arrayList.addAll(Arrays.asList(TypedSource.createTypedSources(iJavaElementArray[n], sourceTuple)));
            ++n;
        }
        return arrayList.toArray(new TypedSource[arrayList.size()]);
    }

    private static String getFieldSource(IField iField, SourceTuple sourceTuple) throws CoreException {
        if (Flags.isEnum((int)iField.getFlags())) {
            String string = iField.getSource();
            if (string != null) {
                return string;
            }
        } else {
            ASTParser aSTParser;
            if (sourceTuple.node == null) {
                aSTParser = ASTParser.newParser((int)3);
                aSTParser.setSource(sourceTuple.unit);
                sourceTuple.node = (CompilationUnit)aSTParser.createAST(null);
            }
            if ((aSTParser = ASTNodeSearchUtil.getFieldDeclarationNode(iField, sourceTuple.node)).fragments().size() == 1) {
                return TypedSource.getSourceOfDeclararationNode((IJavaElement)iField, sourceTuple.unit);
            }
            VariableDeclarationFragment variableDeclarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode(iField, sourceTuple.node);
            IBuffer iBuffer = sourceTuple.unit.getBuffer();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(iBuffer.getText(aSTParser.getStartPosition(), ((ASTNode)aSTParser.fragments().get(0)).getStartPosition() - aSTParser.getStartPosition()));
            stringBuffer.append(iBuffer.getText(variableDeclarationFragment.getStartPosition(), variableDeclarationFragment.getLength()));
            stringBuffer.append(";");
            return stringBuffer.toString();
        }
        return "";
    }

    private static String getSourceOfDeclararationNode(IJavaElement iJavaElement, ICompilationUnit iCompilationUnit) throws JavaModelException, CoreException {
        ISourceReference iSourceReference;
        String string;
        Assert.isTrue((iJavaElement.getElementType() != 12 ? 1 : 0) != 0);
        if (iJavaElement instanceof ISourceReference && (string = (iSourceReference = (ISourceReference)iJavaElement).getSource()) != null) {
            return Strings.trimIndentation(string, iCompilationUnit.getJavaProject(), false);
        }
        return "";
    }

    private static class SourceTuple {
        private ICompilationUnit unit;
        private CompilationUnit node;

        private SourceTuple(ICompilationUnit iCompilationUnit) {
            this.unit = iCompilationUnit;
        }
    }
}

