/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;

public class DeleteFolderChange
extends AbstractDeleteChange {
    private final IPath fPath;
    private final boolean fIsExecuteChange;

    public DeleteFolderChange(IFolder iFolder, boolean bl) {
        this(DeleteFolderChange.getFolderPath(iFolder), bl);
    }

    public DeleteFolderChange(IPath iPath, boolean bl) {
        this.fPath = iPath;
        this.fIsExecuteChange = bl;
    }

    public static IPath getFolderPath(IFolder iFolder) {
        return iFolder.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    public static IFolder getFolder(IPath iPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFolder(iPath);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteFolderChange_0, this.fPath.lastSegment());
    }

    public Object getModifiedElement() {
        return DeleteFolderChange.getFolder(this.fPath);
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(iProgressMonitor, 0);
        }
        return super.isValid(iProgressMonitor, 3);
    }

    protected Change doDelete(IProgressMonitor iProgressMonitor) throws CoreException {
        IFolder iFolder = DeleteFolderChange.getFolder(this.fPath);
        Assert.isTrue((boolean)iFolder.exists());
        iProgressMonitor.beginTask("", 3);
        iFolder.accept(new IResourceVisitor(){

            public boolean visit(IResource iResource) throws CoreException {
                if (iResource instanceof IFile) {
                    DeleteFolderChange.saveFileIfNeeded((IFile)iResource, (IProgressMonitor)new NullProgressMonitor());
                }
                return true;
            }
        }, 2, false);
        iProgressMonitor.worked(1);
        ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)iFolder);
        iFolder.delete(false, true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        resourceDescription.recordStateFromHistory((IResource)iFolder, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.done();
        return new UndoDeleteResourceChange(resourceDescription);
    }
}

