/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IPackageFragmentRootManipulationQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class DeletePackageFragmentRootChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;
    private final IPackageFragmentRootManipulationQuery fUpdateClasspathQuery;

    public DeletePackageFragmentRootChange(IPackageFragmentRoot iPackageFragmentRoot, boolean bl, IPackageFragmentRootManipulationQuery iPackageFragmentRootManipulationQuery) {
        Assert.isNotNull((Object)iPackageFragmentRoot);
        Assert.isTrue((!iPackageFragmentRoot.isExternal() ? 1 : 0) != 0);
        this.fHandle = iPackageFragmentRoot.getHandleIdentifier();
        this.fIsExecuteChange = bl;
        this.fUpdateClasspathQuery = iPackageFragmentRootManipulationQuery;
    }

    public String getName() {
        Object[] objectArray = new String[]{this.getRoot().getElementName()};
        return Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_delete, objectArray);
    }

    public Object getModifiedElement() {
        return this.getRoot();
    }

    private IPackageFragmentRoot getRoot() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fHandle);
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fIsExecuteChange) {
            return super.isValid(iProgressMonitor, 2);
        }
        return super.isValid(iProgressMonitor, 3);
    }

    protected Change doDelete(IProgressMonitor iProgressMonitor) throws CoreException {
        IFile iFile;
        Object object;
        if (!this.confirmDeleteIfReferenced()) {
            return new NullChange();
        }
        int n = 2;
        int n2 = 6;
        iProgressMonitor.beginTask("", 2);
        IPackageFragmentRoot iPackageFragmentRoot = this.getRoot();
        IResource iResource = iPackageFragmentRoot.getResource();
        CompositeChange compositeChange = new CompositeChange(this.getName());
        ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)iResource);
        IJavaProject[] iJavaProjectArray = JavaElementUtil.getReferencingProjects(iPackageFragmentRoot);
        HashMap<IFile, String> hashMap = new HashMap<IFile, String>();
        int n3 = 0;
        while (n3 < iJavaProjectArray.length) {
            object = iJavaProjectArray[n3];
            iFile = object.getProject().getFile(".jsdtscope");
            if (iFile.exists()) {
                hashMap.put(iFile, DeletePackageFragmentRootChange.getFileContents(iFile));
            }
            ++n3;
        }
        iPackageFragmentRoot.delete(n, n2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        resourceDescription.recordStateFromHistory(iResource, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            iFile = (IFile)object.getKey();
            String string = (String)object.getValue();
            TextFileChange textFileChange = new TextFileChange(Messages.format(RefactoringCoreMessages.DeletePackageFragmentRootChange_restore_file, iFile.getFullPath().toOSString()), iFile);
            textFileChange.setEdit((TextEdit)new ReplaceEdit(0, DeletePackageFragmentRootChange.getFileLength(iFile), string));
            compositeChange.add((Change)textFileChange);
        }
        compositeChange.add((Change)new UndoDeleteResourceChange(resourceDescription));
        iProgressMonitor.done();
        return compositeChange;
    }

    private static String getFileContents(IFile iFile) throws CoreException {
        String string;
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath iPath = iFile.getFullPath();
        iTextFileBufferManager.connect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        try {
            string = iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.IFILE).getDocument().get();
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
            throw throwable;
        }
        iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new NullProgressMonitor());
        return string;
    }

    private static int getFileLength(IFile iFile) throws CoreException {
        InputStreamReader inputStreamReader;
        InputStream inputStream = iFile.getContents();
        try {
            inputStreamReader = new InputStreamReader(inputStream, iFile.getCharset());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JavaPlugin.log(unsupportedEncodingException);
            inputStreamReader = new InputStreamReader(inputStream);
        }
        try {
            return (int)inputStreamReader.skip(Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw new CoreException((IStatus)new Status(4, Corext.getPluginId(), iOException.getMessage(), (Throwable)iOException));
        }
    }

    private boolean confirmDeleteIfReferenced() throws JavaModelException {
        if (!this.getRoot().isArchive()) {
            return true;
        }
        if (this.fUpdateClasspathQuery == null) {
            return true;
        }
        IJavaProject[] iJavaProjectArray = JavaElementUtil.getReferencingProjects(this.getRoot());
        if (iJavaProjectArray.length <= 1) {
            return true;
        }
        return this.fUpdateClasspathQuery.confirmManipulation(this.getRoot(), iJavaProjectArray);
    }
}

