/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.wst.jsdt.internal.corext.util.JavaElementResourceMapping;

abstract class PackageReorgChange
extends JDTChange {
    private String fPackageHandle;
    private String fDestinationHandle;
    private INewNameQuery fNameQuery;
    static /* synthetic */ Class class$0;

    PackageReorgChange(IPackageFragment iPackageFragment, IPackageFragmentRoot iPackageFragmentRoot, INewNameQuery iNewNameQuery) {
        this.fPackageHandle = iPackageFragment.getHandleIdentifier();
        this.fDestinationHandle = iPackageFragmentRoot.getHandleIdentifier();
        this.fNameQuery = iNewNameQuery;
    }

    abstract Change doPerformReorg(IProgressMonitor var1) throws JavaModelException, OperationCanceledException;

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return this.isValid(iProgressMonitor, 0);
    }

    public final Change perform(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        Change change;
        iProgressMonitor.beginTask(this.getName(), 1);
        try {
            IPackageFragment iPackageFragment = this.getPackage();
            ResourceMapping resourceMapping = JavaElementResourceMapping.create(iPackageFragment);
            Change change2 = this.doPerformReorg(iProgressMonitor);
            this.markAsExecuted(iPackageFragment, resourceMapping);
            change = change2;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return change;
    }

    public Object getModifiedElement() {
        return this.getPackage();
    }

    IPackageFragmentRoot getDestination() {
        return (IPackageFragmentRoot)JavaCore.create((String)this.fDestinationHandle);
    }

    IPackageFragment getPackage() {
        return (IPackageFragment)JavaCore.create((String)this.fPackageHandle);
    }

    String getNewName() throws OperationCanceledException {
        if (this.fNameQuery == null) {
            return null;
        }
        return this.fNameQuery.getNewName();
    }

    private void markAsExecuted(IPackageFragment iPackageFragment, ResourceMapping resourceMapping) {
        ReorgExecutionLog reorgExecutionLog;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((reorgExecutionLog = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            reorgExecutionLog.markAsProcessed((Object)iPackageFragment);
            reorgExecutionLog.markAsProcessed((Object)resourceMapping);
        }
    }
}

