/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.ASTCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class IntroduceFactoryRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_PROTECT = "protect";
    private ICompilationUnit fCUHandle;
    private CompilationUnit fCU;
    private ICompilationUnit fFactoryUnitHandle;
    private int fSelectionStart;
    private int fSelectionLength;
    private ASTNode fSelectedNode;
    private IMethodBinding fCtorBinding;
    private AbstractTypeDeclaration fCtorOwningClass;
    private String fNewMethodName = null;
    private SearchResultGroup[] fAllCallsTo;
    private AbstractTypeDeclaration fFactoryOwningClass;
    private MethodDeclaration fFactoryMethod = null;
    private String[] fFormalArgNames = null;
    private ITypeBinding[] fArgTypes;
    private boolean fCtorIsVarArgs;
    private boolean fProtectConstructor = true;
    private ImportRewrite fImportRewriter;
    private boolean fCallSitesInBinaryUnits;
    private CompilationUnit fFactoryCU;
    private String fFactoryClassName;
    private int fConstructorVisibility = 2;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IntroduceFactoryRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCUHandle = iCompilationUnit;
        if (iCompilationUnit != null) {
            this.initialize();
        }
    }

    private void initialize() {
        this.fCU = ASTCreator.createAST(this.fCUHandle, null);
    }

    private ASTNode getTargetNode(ICompilationUnit iCompilationUnit, int n, int n2) {
        ASTNode aSTNode = ASTNodes.getNormalizedNode(NodeFinder.perform((ASTNode)this.fCU, n, n2));
        if (aSTNode.getNodeType() == 14) {
            return aSTNode;
        }
        if (aSTNode.getNodeType() == 31 && ((MethodDeclaration)aSTNode).isConstructor()) {
            return aSTNode;
        }
        StructuralPropertyDescriptor structuralPropertyDescriptor = aSTNode.getLocationInParent();
        ASTNode aSTNode2 = aSTNode.getParent();
        if (structuralPropertyDescriptor == ClassInstanceCreation.TYPE_PROPERTY) {
            return aSTNode2;
        }
        if (structuralPropertyDescriptor == MethodDeclaration.NAME_PROPERTY && ((MethodDeclaration)aSTNode2).isConstructor()) {
            return aSTNode2;
        }
        return null;
    }

    private RefactoringStatus checkSelection(IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType iType;
        block18: {
            block17: {
                ClassInstanceCreation classInstanceCreation;
                block16: {
                    block15: {
                        block14: {
                            RefactoringStatus refactoringStatus;
                            try {
                                iProgressMonitor.beginTask(RefactoringCoreMessages.IntroduceFactory_examiningSelection, 2);
                                this.fSelectedNode = this.getTargetNode(this.fCUHandle, this.fSelectionStart, this.fSelectionLength);
                                if (this.fSelectedNode != null) break block14;
                                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_notAConstructorInvocation);
                                Object var5_8 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_14 = null;
                                iProgressMonitor.done();
                                throw throwable;
                            }
                            iProgressMonitor.done();
                            return refactoringStatus;
                        }
                        if (this.fSelectedNode instanceof ClassInstanceCreation) {
                            classInstanceCreation = (ClassInstanceCreation)this.fSelectedNode;
                            this.fCtorBinding = classInstanceCreation.resolveConstructorBinding();
                        } else if (this.fSelectedNode instanceof MethodDeclaration) {
                            classInstanceCreation = (MethodDeclaration)this.fSelectedNode;
                            this.fCtorBinding = classInstanceCreation.resolveBinding();
                        }
                        if (this.fCtorBinding != null) break block15;
                        RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_unableToResolveConstructorBinding);
                        Object var5_9 = null;
                        iProgressMonitor.done();
                        return refactoringStatus;
                    }
                    this.fCtorBinding = this.fCtorBinding.getMethodDeclaration();
                    if (this.fNewMethodName == null) {
                        this.fNewMethodName = "create" + this.fCtorBinding.getName();
                    }
                    iProgressMonitor.worked(1);
                    if (!this.fCtorBinding.getDeclaringClass().isNested()) break block16;
                    RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_unsupportedNestedTypes);
                    Object var5_10 = null;
                    iProgressMonitor.done();
                    return refactoringStatus;
                }
                classInstanceCreation = this.fCtorBinding.getDeclaringClass();
                iType = (IType)classInstanceCreation.getJavaElement();
                if (!iType.isBinary()) break block17;
                RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_constructorInBinaryClass);
                Object var5_11 = null;
                iProgressMonitor.done();
                return refactoringStatus;
            }
            if (!iType.isEnum()) break block18;
            RefactoringStatus refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_constructorInEnum);
            Object var5_12 = null;
            iProgressMonitor.done();
            return refactoringStatus;
        }
        this.fFactoryUnitHandle = iType.getCompilationUnit();
        this.fFactoryCU = this.getASTFor(this.fFactoryUnitHandle);
        Name name = (Name)NodeFinder.perform((ASTNode)this.fFactoryCU, iType.getNameRange());
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fFactoryOwningClass = this.fCtorOwningClass = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)name, clazz);
        iProgressMonitor.worked(1);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Object var5_13 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        block3: {
            RefactoringStatus refactoringStatus;
            try {
                iProgressMonitor.beginTask(RefactoringCoreMessages.IntroduceFactory_checkingActivation, 1);
                if (this.fCUHandle.isStructureKnown()) break block3;
                refactoringStatus = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_syntaxError);
                Object var2_4 = null;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus;
        }
        RefactoringStatus refactoringStatus = this.checkSelection((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        Object var2_5 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private ICompilationUnit[] collectAffectedUnits(SearchResultGroup[] searchResultGroupArray) {
        ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>();
        boolean bl = false;
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            arrayList.add(iCompilationUnit);
            if (iCompilationUnit.equals(this.fFactoryUnitHandle)) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            arrayList.add(this.fFactoryUnitHandle);
        }
        return arrayList.toArray(new ICompilationUnit[arrayList.size()]);
    }

    private SearchPattern createSearchPattern(IMethod iMethod, IMethodBinding iMethodBinding) {
        Assert.isNotNull((Object)iMethodBinding, (String)RefactoringCoreMessages.IntroduceFactory_noBindingForSelectedConstructor);
        if (iMethod != null) {
            return SearchPattern.createPattern((IJavaElement)iMethod, (int)2, (int)24);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(iMethodBinding.getDeclaringClass().getQualifiedName()).append("(");
        int n = 0;
        while (n < this.fArgTypes.length) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.fArgTypes[n].getQualifiedName());
            ++n;
        }
        stringBuffer.append(")");
        return SearchPattern.createPattern((String)stringBuffer.toString(), (int)3, (int)2, (int)24);
    }

    private IJavaSearchScope createSearchScope(IMethod iMethod, IMethodBinding iMethodBinding) throws JavaModelException {
        if (iMethod != null) {
            return RefactoringScopeFactory.create((IJavaElement)iMethod);
        }
        ITypeBinding iTypeBinding = Bindings.getTopLevelType(iMethodBinding.getDeclaringClass());
        return RefactoringScopeFactory.create(iTypeBinding.getJavaElement());
    }

    private SearchResultGroup[] excludeBinaryUnits(SearchResultGroup[] searchResultGroupArray) {
        ArrayList<SearchResultGroup> arrayList = new ArrayList<SearchResultGroup>();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                arrayList.add(searchResultGroup);
            } else {
                this.fCallSitesInBinaryUnits = true;
            }
            ++n;
        }
        return arrayList.toArray(new SearchResultGroup[arrayList.size()]);
    }

    private SearchResultGroup[] searchForCallsTo(IMethodBinding iMethodBinding, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        IMethod iMethod = (IMethod)iMethodBinding.getJavaElement();
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(this.createSearchPattern(iMethod, iMethodBinding));
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(this.createSearchScope(iMethod, iMethodBinding));
        refactoringSearchEngine2.setStatus(refactoringStatus);
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return (SearchResultGroup[])refactoringSearchEngine2.getResults();
    }

    private SearchResultGroup[] findAllCallsTo(IMethodBinding iMethodBinding, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        SearchResultGroup[] searchResultGroupArray = this.excludeBinaryUnits(this.searchForCallsTo(iMethodBinding, iProgressMonitor, refactoringStatus));
        return searchResultGroupArray;
    }

    private IType findNonPrimaryType(String string, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        SearchPattern searchPattern = SearchPattern.createPattern((String)string, (int)0, (int)0, (int)24);
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(searchPattern);
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(RefactoringScopeFactory.create((IJavaElement)this.fCtorBinding.getJavaElement().getJavaProject()));
        refactoringSearchEngine2.setStatus(refactoringStatus);
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        SearchResultGroup[] searchResultGroupArray = (SearchResultGroup[])refactoringSearchEngine2.getResults();
        if (searchResultGroupArray.length != 0) {
            int n = 0;
            while (n < searchResultGroupArray.length) {
                SearchMatch[] searchMatchArray = searchResultGroupArray[n].getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    if (searchMatchArray[n2].getAccuracy() == 0) {
                        return (IType)searchMatchArray[n2].getElement();
                    }
                    ++n2;
                }
                ++n;
            }
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block5: {
            RefactoringStatus refactoringStatus2;
            try {
                iProgressMonitor.beginTask(RefactoringCoreMessages.IntroduceFactory_checking_preconditions, 1);
                refactoringStatus = new RefactoringStatus();
                if (this.fFactoryClassName != null) {
                    refactoringStatus.merge(this.setFactoryClass(this.fFactoryClassName));
                }
                if (!refactoringStatus.hasFatalError()) break block5;
                refactoringStatus2 = refactoringStatus;
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        this.fArgTypes = this.fCtorBinding.getParameterTypes();
        this.fCtorIsVarArgs = this.fCtorBinding.isVarargs();
        this.fAllCallsTo = this.findAllCallsTo(this.fCtorBinding, iProgressMonitor, refactoringStatus);
        this.fFormalArgNames = this.findCtorArgNames();
        ICompilationUnit[] iCompilationUnitArray = this.collectAffectedUnits(this.fAllCallsTo);
        refactoringStatus.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(iCompilationUnitArray), this.getValidationContext()));
        if (this.fCallSitesInBinaryUnits) {
            refactoringStatus.merge(RefactoringStatus.createWarningStatus((String)RefactoringCoreMessages.IntroduceFactory_callSitesInBinaryClass));
        }
        RefactoringStatus refactoringStatus3 = refactoringStatus;
        Object var4_6 = null;
        iProgressMonitor.done();
        return refactoringStatus3;
    }

    private String[] findCtorArgNames() {
        CompilationUnit compilationUnit;
        MethodDeclaration methodDeclaration;
        int n = this.fCtorBinding.getParameterTypes().length;
        String[] stringArray = new String[n];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((methodDeclaration = (MethodDeclaration)(compilationUnit = (CompilationUnit)ASTNodes.getParent((ASTNode)this.fCtorOwningClass, clazz)).findDeclaringNode(this.fCtorBinding.getKey())) != null) {
            List list = methodDeclaration.parameters();
            int n2 = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                SingleVariableDeclaration singleVariableDeclaration = (SingleVariableDeclaration)iterator.next();
                stringArray[n2] = singleVariableDeclaration.getName().getIdentifier();
                ++n2;
            }
            return stringArray;
        }
        int n3 = 0;
        while (n3 < n) {
            stringArray[n3] = "arg" + (n3 + 1);
            ++n3;
        }
        return stringArray;
    }

    private MethodDeclaration createFactoryMethod(AST aST, IMethodBinding iMethodBinding, ASTRewrite aSTRewrite) {
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        SimpleName simpleName = aST.newSimpleName(this.fNewMethodName);
        ClassInstanceCreation classInstanceCreation = aST.newClassInstanceCreation();
        ReturnStatement returnStatement = aST.newReturnStatement();
        Block block = aST.newBlock();
        List list = block.statements();
        String string = iMethodBinding.getName();
        this.createFactoryMethodSignature(aST, methodDeclaration);
        methodDeclaration.setName(simpleName);
        methodDeclaration.setBody(block);
        ITypeBinding[] iTypeBindingArray = this.fCtorBinding.getDeclaringClass().getTypeParameters();
        this.setMethodReturnType(methodDeclaration, string, iTypeBindingArray, aST);
        methodDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, 9));
        this.setCtorTypeArguments(classInstanceCreation, string, iTypeBindingArray, aST);
        this.createFactoryMethodConstructorArgs(aST, classInstanceCreation);
        returnStatement.setExpression((Expression)classInstanceCreation);
        list.add(returnStatement);
        return methodDeclaration;
    }

    private void setCtorTypeArguments(ClassInstanceCreation classInstanceCreation, String string, ITypeBinding[] iTypeBindingArray, AST aST) {
        if (iTypeBindingArray.length == 0) {
            classInstanceCreation.setType(ASTNodeFactory.newType(aST, string));
        } else {
            SimpleType simpleType = aST.newSimpleType((Name)aST.newSimpleName(string));
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)simpleType);
            List list = parameterizedType.typeArguments();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                Type type = ASTNodeFactory.newType(aST, iTypeBindingArray[n].getName());
                list.add(type);
                ++n;
            }
            classInstanceCreation.setType((Type)parameterizedType);
        }
    }

    private void setMethodReturnType(MethodDeclaration methodDeclaration, String string, ITypeBinding[] iTypeBindingArray, AST aST) {
        if (iTypeBindingArray.length == 0) {
            methodDeclaration.setReturnType2((Type)aST.newSimpleType((Name)aST.newSimpleName(string)));
        } else {
            SimpleType simpleType = aST.newSimpleType((Name)aST.newSimpleName(string));
            ParameterizedType parameterizedType = aST.newParameterizedType((Type)simpleType);
            List list = parameterizedType.typeArguments();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                Type type = ASTNodeFactory.newType(aST, iTypeBindingArray[n].getName());
                list.add(type);
                ++n;
            }
            methodDeclaration.setReturnType2((Type)parameterizedType);
        }
    }

    private void createFactoryMethodSignature(AST aST, MethodDeclaration methodDeclaration) {
        Object object;
        List list = methodDeclaration.parameters();
        int n = 0;
        while (n < this.fArgTypes.length) {
            Type type;
            object = aST.newSingleVariableDeclaration();
            if (n == this.fArgTypes.length - 1 && this.fCtorIsVarArgs) {
                type = this.typeNodeForTypeBinding(this.fArgTypes[n].getElementType(), this.fArgTypes[n].getDimensions() - 1, aST);
                object.setVarargs(true);
            } else {
                type = this.typeNodeForTypeBinding(this.fArgTypes[n], 0, aST);
            }
            object.setName(aST.newSimpleName(this.fFormalArgNames[n]));
            object.setType(type);
            list.add(object);
            ++n;
        }
        ITypeBinding[] iTypeBindingArray = this.fCtorBinding.getExceptionTypes();
        object = methodDeclaration.thrownExceptions();
        int n2 = 0;
        while (n2 < iTypeBindingArray.length) {
            String string = this.fImportRewriter.addImport(iTypeBindingArray[n2]);
            object.add(ASTNodeFactory.newName(aST, string));
            ++n2;
        }
        this.copyTypeParameters(aST, methodDeclaration);
    }

    private void copyTypeParameters(AST aST, MethodDeclaration methodDeclaration) {
        ITypeBinding[] iTypeBindingArray = this.fCtorBinding.getDeclaringClass().getTypeParameters();
        List list = methodDeclaration.typeParameters();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            TypeParameter typeParameter = aST.newTypeParameter();
            ITypeBinding[] iTypeBindingArray2 = iTypeBindingArray[n].getTypeBounds();
            List list2 = typeParameter.typeBounds();
            typeParameter.setName(aST.newSimpleName(iTypeBindingArray[n].getName()));
            int n2 = 0;
            while (n2 < iTypeBindingArray2.length) {
                if (!iTypeBindingArray2[n2].isClass() || iTypeBindingArray2[n2].getSuperclass() != null) {
                    Type type = this.fImportRewriter.addImport(iTypeBindingArray2[n2], aST);
                    list2.add(type);
                }
                ++n2;
            }
            list.add(typeParameter);
            ++n;
        }
    }

    private Type typeNodeForTypeBinding(ITypeBinding iTypeBinding, int n, AST aST) {
        if (n > 0) {
            return aST.newArrayType(this.typeNodeForTypeBinding(iTypeBinding, 0, aST), n);
        }
        if (iTypeBinding.isArray()) {
            Type type = this.typeNodeForTypeBinding(iTypeBinding.getElementType(), n, aST);
            return aST.newArrayType(type, iTypeBinding.getDimensions());
        }
        return this.fImportRewriter.addImport(iTypeBinding, aST);
    }

    private void createFactoryMethodConstructorArgs(AST aST, ClassInstanceCreation classInstanceCreation) {
        List list = classInstanceCreation.arguments();
        int n = 0;
        while (n < this.fArgTypes.length) {
            SimpleName simpleName = aST.newSimpleName(this.fFormalArgNames[n]);
            list.add(simpleName);
            ++n;
        }
    }

    private MethodInvocation createFactoryMethodCall(AST aST, ClassInstanceCreation classInstanceCreation, ASTRewrite aSTRewrite, TextEditGroup textEditGroup) {
        AbstractTypeDeclaration abstractTypeDeclaration;
        ITypeBinding iTypeBinding;
        MethodInvocation methodInvocation = aST.newMethodInvocation();
        List list = methodInvocation.arguments();
        List list2 = classInstanceCreation.arguments();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((iTypeBinding = (abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)classInstanceCreation, clazz)).resolveBinding()) == null || !Bindings.equals((IBinding)abstractTypeDeclaration.resolveBinding(), (IBinding)this.fFactoryOwningClass.resolveBinding())) {
            String string = this.fImportRewriter.addImport(this.fFactoryOwningClass.resolveBinding());
            methodInvocation.setExpression((Expression)ASTNodeFactory.newName(aST, string));
        }
        methodInvocation.setName(aST.newSimpleName(this.fNewMethodName));
        int n = 0;
        while (n < list2.size()) {
            Expression expression = (Expression)list2.get(n);
            ASTNode aSTNode = aSTRewrite.createMoveTarget((ASTNode)expression);
            list.add(aSTNode);
            ++n;
        }
        aSTRewrite.replace((ASTNode)classInstanceCreation, (ASTNode)methodInvocation, textEditGroup);
        return methodInvocation;
    }

    private boolean isConstructorUnit(ICompilationUnit iCompilationUnit) {
        return iCompilationUnit.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
    }

    private boolean shouldProtectConstructor() {
        return this.fProtectConstructor && this.fCtorOwningClass != null;
    }

    private boolean protectConstructor(CompilationUnit compilationUnit, ASTRewrite aSTRewrite, TextEditGroup textEditGroup) {
        MethodDeclaration methodDeclaration = (MethodDeclaration)compilationUnit.findDeclaringNode(this.fCtorBinding.getKey());
        if (methodDeclaration == null || JdtFlags.getVisibilityCode((BodyDeclaration)methodDeclaration) == this.fConstructorVisibility) {
            return false;
        }
        ModifierRewrite.create(aSTRewrite, (ASTNode)methodDeclaration).setVisibility(this.fConstructorVisibility, textEditGroup);
        return true;
    }

    private boolean addAllChangesFor(SearchResultGroup searchResultGroup, ICompilationUnit iCompilationUnit, CompilationUnitChange compilationUnitChange) throws CoreException {
        TextEditGroup textEditGroup;
        Assert.isTrue((searchResultGroup == null || searchResultGroup.getCompilationUnit() == iCompilationUnit ? 1 : 0) != 0);
        CompilationUnit compilationUnit = this.getASTFor(iCompilationUnit);
        ASTRewrite aSTRewrite = ASTRewrite.create((AST)compilationUnit.getAST());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        boolean bl = false;
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        this.fImportRewriter = StubUtility.createImportRewrite(compilationUnit, true);
        if (iCompilationUnit.equals(this.fFactoryUnitHandle)) {
            textEditGroup = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_addFactoryMethod);
            this.createFactoryChange(aSTRewrite, compilationUnit, textEditGroup);
            compilationUnitChange.addTextEditGroup(textEditGroup);
            bl = true;
        }
        if (searchResultGroup != null && this.replaceConstructorCalls(searchResultGroup, compilationUnit, aSTRewrite, compilationUnitChange)) {
            bl = true;
        }
        if (this.shouldProtectConstructor() && this.isConstructorUnit(iCompilationUnit) && this.protectConstructor(compilationUnit, aSTRewrite, textEditGroup = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_protectConstructor))) {
            compilationUnitChange.addTextEditGroup(textEditGroup);
            bl = true;
        }
        if (bl) {
            multiTextEdit.addChild(aSTRewrite.rewriteAST());
            multiTextEdit.addChild(this.fImportRewriter.rewriteImports(null));
        }
        return bl;
    }

    private CompilationUnit getASTFor(ICompilationUnit iCompilationUnit) {
        if (iCompilationUnit.equals(this.fCUHandle)) {
            if (this.fCU == null) {
                this.fCU = ASTCreator.createAST(iCompilationUnit, null);
                if (this.fCU.equals((Object)this.fFactoryUnitHandle)) {
                    this.fFactoryCU = this.fCU;
                }
            }
            return this.fCU;
        }
        if (iCompilationUnit.equals(this.fFactoryUnitHandle)) {
            if (this.fFactoryCU == null) {
                this.fFactoryCU = ASTCreator.createAST(iCompilationUnit, null);
            }
            return this.fFactoryCU;
        }
        return ASTCreator.createAST(iCompilationUnit, null);
    }

    private boolean replaceConstructorCalls(SearchResultGroup searchResultGroup, CompilationUnit compilationUnit, ASTRewrite aSTRewrite, CompilationUnitChange compilationUnitChange) throws CoreException {
        Assert.isTrue((boolean)ASTCreator.getCu((ASTNode)compilationUnit).equals(searchResultGroup.getCompilationUnit()));
        SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
        AST aST = compilationUnit.getAST();
        boolean bl = false;
        int n = 0;
        while (n < searchMatchArray.length) {
            ClassInstanceCreation classInstanceCreation = this.getCtorCallAt(searchMatchArray[n].getOffset(), searchMatchArray[n].getLength(), compilationUnit);
            if (classInstanceCreation != null) {
                TextEditGroup textEditGroup = new TextEditGroup(RefactoringCoreMessages.IntroduceFactory_replaceCalls);
                this.createFactoryMethodCall(aST, classInstanceCreation, aSTRewrite, textEditGroup);
                compilationUnitChange.addTextEditGroup(textEditGroup);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    private ClassInstanceCreation getCtorCallAt(int n, int n2, CompilationUnit compilationUnit) throws CoreException {
        ICompilationUnit iCompilationUnit = ASTCreator.getCu((ASTNode)compilationUnit);
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, n, n2);
        if (aSTNode == null) {
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_noASTNodeForConstructorSearchHit, new Object[]{Integer.toString(n), Integer.toString(n + n2), iCompilationUnit.getSource().substring(n, n + n2), iCompilationUnit.getElementName()}), null));
        }
        if (aSTNode instanceof ClassInstanceCreation) {
            return (ClassInstanceCreation)aSTNode;
        }
        if (aSTNode instanceof VariableDeclaration) {
            Expression expression = ((VariableDeclaration)aSTNode).getInitializer();
            if (expression instanceof ClassInstanceCreation) {
                return (ClassInstanceCreation)expression;
            }
            if (expression != null) {
                throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedInitializerNodeType, new Object[]{expression.toString(), iCompilationUnit.getElementName()}), null));
            }
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_noConstructorCallNodeInsideFoundVarbleDecl, new Object[]{aSTNode.toString()}), null));
        }
        if (aSTNode instanceof ConstructorInvocation) {
            return null;
        }
        if (aSTNode instanceof SuperConstructorInvocation) {
            this.fConstructorVisibility = 4;
            return null;
        }
        if (aSTNode instanceof ExpressionStatement) {
            Expression expression = ((ExpressionStatement)aSTNode).getExpression();
            if (expression instanceof ClassInstanceCreation) {
                return (ClassInstanceCreation)expression;
            }
            throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedASTNodeTypeForConstructorSearchHit, new Object[]{expression.toString(), iCompilationUnit.getElementName()}), null));
        }
        if (aSTNode instanceof SimpleName && (aSTNode.getParent() instanceof MethodDeclaration || aSTNode.getParent() instanceof AbstractTypeDeclaration)) {
            this.fConstructorVisibility = 4;
            return null;
        }
        throw new CoreException(JavaUIStatus.createError(4, Messages.format(RefactoringCoreMessages.IntroduceFactory_unexpectedASTNodeTypeForConstructorSearchHit, new Object[]{String.valueOf(aSTNode.getClass().getName()) + "('" + aSTNode.toString() + "')", iCompilationUnit.getElementName()}), null));
    }

    private void createFactoryChange(ASTRewrite aSTRewrite, CompilationUnit compilationUnit, TextEditGroup textEditGroup) {
        AST aST = compilationUnit.getAST();
        this.fFactoryMethod = this.createFactoryMethod(aST, this.fCtorBinding, aSTRewrite);
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)compilationUnit.findDeclaringNode(this.fFactoryOwningClass.resolveBinding().getKey());
        this.fImportRewriter.addImport(this.fCtorOwningClass.resolveBinding());
        int n = ASTNodes.getInsertionIndex((BodyDeclaration)this.fFactoryMethod, abstractTypeDeclaration.bodyDeclarations());
        if (n < 0) {
            n = 0;
        }
        aSTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAt((ASTNode)this.fFactoryMethod, n, textEditGroup);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.IntroduceFactory_createChanges, this.fAllCallsTo.length);
            ITypeBinding iTypeBinding = this.fFactoryOwningClass.resolveBinding();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = null;
            IJavaProject iJavaProject = this.fCUHandle.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589830;
            if (iTypeBinding.isNested() && !iTypeBinding.isMember()) {
                n |= 0x40000;
            }
            String string2 = Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_descriptor_description_short, this.fCtorOwningClass.getName());
            String string3 = Messages.format(RefactoringCoreMessages.IntroduceFactory_descriptor_description, new String[]{this.fNewMethodName, BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)this.fCtorBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)});
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)this.fCtorBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_factory_pattern, this.fNewMethodName));
            jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceFactoryRefactoring_owner_pattern, BindingLabelProvider.getBindingLabel((IBinding)iTypeBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
            if (this.fProtectConstructor) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.IntroduceFactoryRefactoring_declare_private);
            }
            JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.introduce.factory", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
            hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCUHandle));
            hashMap.put("name", this.fNewMethodName);
            hashMap.put("element1", jDTRefactoringDescriptor.elementToHandle(iTypeBinding.getJavaElement()));
            hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
            hashMap.put(ATTRIBUTE_PROTECT, Boolean.valueOf(this.fProtectConstructor).toString());
            DynamicValidationRefactoringChange dynamicValidationRefactoringChange2 = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.IntroduceFactory_name);
            boolean bl = false;
            boolean bl2 = false;
            int n2 = 0;
            while (n2 < this.fAllCallsTo.length) {
                CompilationUnitChange compilationUnitChange;
                SearchResultGroup searchResultGroup = this.fAllCallsTo[n2];
                ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
                if (this.addAllChangesFor(searchResultGroup, iCompilationUnit, compilationUnitChange = new CompilationUnitChange(this.getName(), iCompilationUnit))) {
                    dynamicValidationRefactoringChange2.add((Change)compilationUnitChange);
                }
                if (iCompilationUnit.equals(this.fFactoryUnitHandle)) {
                    bl = true;
                }
                if (iCompilationUnit.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                    bl2 = true;
                }
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++n2;
            }
            if (!bl) {
                CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.getName(), this.fFactoryUnitHandle);
                this.addAllChangesFor(null, this.fFactoryUnitHandle, compilationUnitChange);
                dynamicValidationRefactoringChange2.add((Change)compilationUnitChange);
            }
            if (!bl2 && !this.fFactoryUnitHandle.equals(ASTCreator.getCu((ASTNode)this.fCtorOwningClass))) {
                CompilationUnitChange compilationUnitChange = new CompilationUnitChange(this.getName(), ASTCreator.getCu((ASTNode)this.fCtorOwningClass));
                this.addAllChangesFor(null, ASTCreator.getCu((ASTNode)this.fCtorOwningClass), compilationUnitChange);
                dynamicValidationRefactoringChange2.add((Change)compilationUnitChange);
            }
            dynamicValidationRefactoringChange = dynamicValidationRefactoringChange2;
            Object var18_21 = null;
        }
        catch (Throwable throwable) {
            Object var18_22 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceFactory_name;
    }

    public String getNewMethodName() {
        return this.fNewMethodName;
    }

    public RefactoringStatus setNewMethodName(String string) {
        Assert.isNotNull((Object)string);
        this.fNewMethodName = string;
        RefactoringStatus refactoringStatus = Checks.checkMethodName(string);
        refactoringStatus.merge(this.isUniqueMethodName(string));
        return refactoringStatus;
    }

    private RefactoringStatus isUniqueMethodName(String string) {
        boolean bl = this.hasMethod(this.fFactoryOwningClass, string);
        return bl ? RefactoringStatus.createErrorStatus((String)(String.valueOf(RefactoringCoreMessages.IntroduceFactory_duplicateMethodName) + string)) : new RefactoringStatus();
    }

    private boolean hasMethod(AbstractTypeDeclaration abstractTypeDeclaration, String string) {
        List list = abstractTypeDeclaration.bodyDeclarations();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            BodyDeclaration bodyDeclaration = (BodyDeclaration)iterator.next();
            if (!(bodyDeclaration instanceof MethodDeclaration) || !((MethodDeclaration)bodyDeclaration).getName().getIdentifier().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean canProtectConstructor() {
        return !this.fCtorBinding.isSynthetic() && this.fFactoryCU.findDeclaringNode(this.fCtorBinding.getKey()) != null;
    }

    public void setProtectConstructor(boolean bl) {
        this.fProtectConstructor = bl;
    }

    public IJavaProject getProject() {
        return this.fCUHandle.getJavaProject();
    }

    public RefactoringStatus setFactoryClass(String string) {
        IType iType;
        try {
            iType = this.findFactoryClass(string);
            if (iType == null) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceFactory_noSuchClass, string));
            }
            if (iType.isAnnotation()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryMethodOnAnnotation);
            }
            if (iType.isInterface()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryMethodOnInterface);
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantCheckForInterface);
        }
        ICompilationUnit iCompilationUnit = iType.getCompilationUnit();
        if (iType.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceFactory_cantPutFactoryInBinaryClass);
        }
        try {
            String string2;
            if (!this.fFactoryUnitHandle.equals(iCompilationUnit)) {
                this.fFactoryCU = this.getASTFor(iCompilationUnit);
                this.fFactoryUnitHandle = iCompilationUnit;
            }
            ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fFactoryCU, iType.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fFactoryOwningClass = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
            String string3 = iType.getPackageFragment().getElementName();
            if (!string3.equals(string2 = this.fCtorOwningClass.resolveBinding().getPackage().getName())) {
                this.fConstructorVisibility = 1;
            } else if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
            if (this.fFactoryOwningClass != this.fCtorOwningClass) {
                this.fConstructorVisibility = 0;
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)javaModelException.getMessage());
        }
        return new RefactoringStatus();
    }

    private IType findFactoryClass(String string) throws JavaModelException {
        IType iType = this.getProject().findType(string);
        if (iType == null) {
            iType = this.findNonPrimaryType(string, (IProgressMonitor)new NullProgressMonitor(), new RefactoringStatus());
        }
        return iType;
    }

    public String getFactoryClassName() {
        return this.fFactoryOwningClass.resolveBinding().getQualifiedName();
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        Object object;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object2;
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("selection");
            if (string != null) {
                n2 = -1;
                n = -1;
                object = new StringTokenizer(string);
                if (((StringTokenizer)object).hasMoreTokens()) {
                    n2 = Integer.valueOf(((StringTokenizer)object).nextToken());
                }
                if (((StringTokenizer)object).hasMoreTokens()) {
                    n = Integer.valueOf(((StringTokenizer)object).nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string2 = javaRefactoringArguments.getAttribute("input");
            if (string2 != null) {
                object2 = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object2 == null || !object2.exists() || object2.getElementType() != 5) {
                    return this.createInputFatalStatus(object2, "org.eclipse.wst.jsdt.ui.introduce.factory");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCUHandle = (ICompilationUnit)object2;
            this.initialize();
            string2 = javaRefactoringArguments.getAttribute("element1");
            if (string2 != null) {
                object2 = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string2, false);
                if (object2 == null || !object2.exists() || object2.getElementType() != 7) {
                    return this.createInputFatalStatus(object2, "org.eclipse.wst.jsdt.ui.introduce.factory");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            object = (IType)object2;
            this.fFactoryClassName = object.getFullyQualifiedName();
            object2 = javaRefactoringArguments.getAttribute("name");
            if (object2 == null || "".equals(object2)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
            }
            this.fNewMethodName = object2;
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_PROTECT);
            if (object == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_PROTECT));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fProtectConstructor = Boolean.valueOf((String)object);
        return new RefactoringStatus();
    }
}

