/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.PrimitiveType;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class IntroduceIndirectionRefactoring
extends ScriptableRefactoring {
    private ICompilationUnit fSelectionCompilationUnit;
    private IClassFile fSelectionClassFile;
    private int fSelectionStart;
    private int fSelectionLength;
    private MethodInvocation fSelectionMethodInvocation;
    private IType fIntermediaryClass;
    private ITypeBinding fIntermediaryClassBinding;
    private String fIntermediaryMethodName;
    private ITypeBinding fIntermediaryFirstParameterType;
    private IMethod fTargetMethod;
    private IMethodBinding fTargetMethodBinding;
    private boolean fUpdateReferences;
    private Map fRewrites;
    private TextChangeManager fTextChangeManager;
    private MemberVisibilityAdjustor fAdjustor;
    private Map fIntermediaryAdjustments;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IntroduceIndirectionRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        this.fSelectionCompilationUnit = iCompilationUnit;
        this.initialize(n, n2);
    }

    public IntroduceIndirectionRefactoring(IClassFile iClassFile, int n, int n2) {
        this.fSelectionClassFile = iClassFile;
        this.initialize(n, n2);
    }

    public IntroduceIndirectionRefactoring(IMethod iMethod) {
        this.fTargetMethod = iMethod;
        this.initialize(0, 0);
    }

    private void initialize(int n, int n2) {
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fUpdateReferences = true;
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection_name;
    }

    public IJavaProject getProject() {
        if (this.fSelectionCompilationUnit != null) {
            return this.fSelectionCompilationUnit.getJavaProject();
        }
        if (this.fSelectionClassFile != null) {
            return this.fSelectionClassFile.getJavaProject();
        }
        if (this.fTargetMethod != null) {
            return this.fTargetMethod.getJavaProject();
        }
        return null;
    }

    public IPackageFragment getInvocationPackage() {
        return this.fSelectionCompilationUnit != null ? (IPackageFragment)this.fSelectionCompilationUnit.getAncestor(4) : null;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public void setEnableUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public RefactoringStatus setIntermediaryMethodName(String string) {
        Assert.isNotNull((Object)string);
        this.fIntermediaryMethodName = string;
        RefactoringStatus refactoringStatus = Checks.checkMethodName(string);
        refactoringStatus.merge(this.checkOverloading());
        return refactoringStatus;
    }

    private RefactoringStatus checkOverloading() {
        try {
            if (this.fIntermediaryClass != null) {
                IMethod[] iMethodArray = this.fIntermediaryClass.getMethods();
                int n = 0;
                while (n < iMethodArray.length) {
                    IMethod iMethod = iMethodArray[n];
                    if (iMethod.getElementName().equals(this.fIntermediaryMethodName)) {
                        return RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_duplicate_method_name_in_declaring_class_error, this.fIntermediaryMethodName));
                    }
                    ++n;
                }
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_could_not_parse_declaring_class_error);
        }
        return new RefactoringStatus();
    }

    public String getIntermediaryMethodName() {
        return this.fIntermediaryMethodName;
    }

    public RefactoringStatus setIntermediaryClassName(String string) {
        IType iType = null;
        try {
            if (string.length() == 0) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_class_not_selected_error);
            }
            iType = this.getProject().findType(string, (IProgressMonitor)new NullProgressMonitor());
            if (iType == null || !iType.exists()) {
                return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_class_does_not_exist_error, string));
            }
            if (iType.isAnnotation()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_annotation);
            }
            if (iType.isInterface()) {
                return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_on_interface);
            }
        }
        catch (JavaModelException javaModelException) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_unable_determine_declaring_type);
        }
        if (iType.isReadOnly()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_readonly);
        }
        if (iType.isBinary()) {
            return RefactoringStatus.createErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_binary);
        }
        this.fIntermediaryClass = iType;
        return new RefactoringStatus();
    }

    public String getIntermediaryClassName() {
        return this.fIntermediaryClass != null ? JavaModelUtil.getFullyQualifiedName(this.fIntermediaryClass) : "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        RefactoringStatus refactoringStatus;
        block28: {
            RefactoringStatus refactoringStatus2;
            block27: {
                RefactoringStatus refactoringStatus3;
                block26: {
                    RefactoringStatus refactoringStatus4;
                    block25: {
                        RefactoringStatus refactoringStatus5;
                        block24: {
                            RefactoringStatus refactoringStatus6;
                            block23: {
                                try {
                                    iProgressMonitor.beginTask(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_activation, 1);
                                    this.fRewrites = new HashMap();
                                    if (this.fTargetMethod == null) {
                                        ASTParser aSTParser;
                                        ASTNode aSTNode;
                                        if (this.fSelectionStart == 0) {
                                            refactoringStatus6 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                            Object var5_8 = null;
                                            break block23;
                                        }
                                        if (this.fSelectionCompilationUnit != null) {
                                            CompilationUnit compilationUnit = this.getCachedCURewrite(this.fSelectionCompilationUnit).getRoot();
                                            aSTNode = IntroduceIndirectionRefactoring.getSelectedNode(this.fSelectionCompilationUnit, compilationUnit, this.fSelectionStart, this.fSelectionLength);
                                        } else {
                                            aSTParser = ASTParser.newParser((int)3);
                                            aSTParser.setResolveBindings(true);
                                            aSTParser.setSource(this.fSelectionClassFile);
                                            CompilationUnit compilationUnit = (CompilationUnit)aSTParser.createAST(null);
                                            aSTNode = IntroduceIndirectionRefactoring.getSelectedNode(null, compilationUnit, this.fSelectionStart, this.fSelectionLength);
                                        }
                                        if (aSTNode == null) {
                                            refactoringStatus5 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                            break block24;
                                        }
                                        aSTParser = null;
                                        if (aSTNode.getNodeType() == 32) {
                                            aSTParser = ((MethodInvocation)aSTNode).resolveMethodBinding();
                                        } else if (aSTNode.getNodeType() == 31) {
                                            aSTParser = ((MethodDeclaration)aSTNode).resolveBinding();
                                        } else {
                                            if (aSTNode.getNodeType() != 48) {
                                                refactoringStatus4 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                                break block25;
                                            }
                                            aSTParser = ((SuperMethodInvocation)aSTNode).resolveMethodBinding();
                                        }
                                        this.fTargetMethodBinding = aSTParser.getMethodDeclaration();
                                        this.fTargetMethod = (IMethod)this.fTargetMethodBinding.getJavaElement();
                                        if (aSTNode instanceof MethodInvocation && this.fSelectionCompilationUnit != null) {
                                            this.fSelectionMethodInvocation = (MethodInvocation)aSTNode;
                                        }
                                    } else if (this.fTargetMethod.getCompilationUnit() != null) {
                                        CompilationUnit compilationUnit = this.getCachedCURewrite(this.fTargetMethod.getCompilationUnit()).getRoot();
                                        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(this.fTargetMethod, compilationUnit);
                                        this.fTargetMethodBinding = methodDeclaration.resolveBinding().getMethodDeclaration();
                                    } else {
                                        ASTParser aSTParser = ASTParser.newParser((int)3);
                                        aSTParser.setProject(this.fTargetMethod.getJavaProject());
                                        IBinding[] iBindingArray = aSTParser.createBindings(new IJavaElement[]{this.fTargetMethod}, null);
                                        this.fTargetMethodBinding = ((IMethodBinding)iBindingArray[0]).getMethodDeclaration();
                                    }
                                    if (this.fTargetMethod == null || this.fTargetMethodBinding == null || !RefactoringAvailabilityTester.isIntroduceIndirectionAvailable(this.fTargetMethod)) {
                                        refactoringStatus3 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_on_this_selection);
                                        break block26;
                                    }
                                    if (this.fTargetMethod.isConstructor()) {
                                        refactoringStatus2 = RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_not_available_for_constructors);
                                        break block27;
                                    }
                                    if (this.fIntermediaryMethodName == null) {
                                        this.fIntermediaryMethodName = this.fTargetMethod.getElementName();
                                    }
                                    if (this.fIntermediaryClass == null) {
                                        if (this.fSelectionCompilationUnit != null && !this.fSelectionCompilationUnit.isReadOnly()) {
                                            this.fIntermediaryClass = this.getEnclosingInitialSelectionMember().getDeclaringType();
                                        } else if (!this.fTargetMethod.isBinary() && !this.fTargetMethod.isReadOnly()) {
                                            this.fIntermediaryClass = this.fTargetMethod.getDeclaringType();
                                        }
                                    }
                                    refactoringStatus = new RefactoringStatus();
                                    break block28;
                                }
                                catch (Throwable throwable) {
                                    Object var5_14 = null;
                                    iProgressMonitor.done();
                                    throw throwable;
                                }
                            }
                            iProgressMonitor.done();
                            return refactoringStatus6;
                        }
                        Object var5_9 = null;
                        iProgressMonitor.done();
                        return refactoringStatus5;
                    }
                    Object var5_10 = null;
                    iProgressMonitor.done();
                    return refactoringStatus4;
                }
                Object var5_11 = null;
                iProgressMonitor.done();
                return refactoringStatus3;
            }
            Object var5_12 = null;
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        Object var5_13 = null;
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        IMember iMember;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fTextChangeManager = new TextChangeManager();
        this.fIntermediaryFirstParameterType = null;
        this.fIntermediaryClassBinding = null;
        Iterator iterator = this.fRewrites.values().iterator();
        while (iterator.hasNext()) {
            ((CompilationUnitRewrite)iterator.next()).clearASTAndImportRewrites();
        }
        int n = 5;
        int n2 = 5;
        int n3 = 5;
        int n4 = this.fUpdateReferences ? 30 : 5;
        int n5 = 5;
        iProgressMonitor.beginTask("", n + n2 + n3 + n4 + n5);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        refactoringStatus.merge(Checks.checkMethodName(this.fIntermediaryMethodName));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (this.fIntermediaryClass == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_run_without_intermediary_type);
        }
        CompilationUnitRewrite compilationUnitRewrite = this.getCachedCURewrite(this.fIntermediaryClass.getCompilationUnit());
        this.fIntermediaryClassBinding = this.typeToBinding(this.fIntermediaryClass, compilationUnitRewrite.getRoot());
        this.fAdjustor = new MemberVisibilityAdjustor((IJavaElement)this.fIntermediaryClass, (IMember)this.fIntermediaryClass);
        this.fIntermediaryAdjustments = new HashMap();
        if (this.fIntermediaryClassBinding.isNested() && !Modifier.isStatic(this.fIntermediaryClassBinding.getModifiers())) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_create_in_nested_nonstatic, (RefactoringStatusContext)JavaStatusContext.create((IMember)this.fIntermediaryClass));
        }
        iProgressMonitor.worked(n);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fUpdateReferences) {
            iProgressMonitor.setTaskName(String.valueOf(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions) + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_looking_for_references);
            refactoringStatus.merge(this.updateReferences((IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, n4)));
            iProgressMonitor.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        } else {
            if (this.fSelectionMethodInvocation != null) {
                this.fIntermediaryFirstParameterType = this.getExpressionType(this.fSelectionMethodInvocation);
                iMember = this.getEnclosingInitialSelectionMember();
                refactoringStatus.merge(this.updateMethodInvocation(this.fSelectionMethodInvocation, iMember, this.getCachedCURewrite(this.fSelectionCompilationUnit)));
                if (!this.isRewriteKept(this.fSelectionCompilationUnit)) {
                    this.createChangeAndDiscardRewrite(this.fSelectionCompilationUnit);
                }
                refactoringStatus.merge(this.adjustVisibility((IMember)this.fIntermediaryClass, (IMember)iMember.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 0)));
            }
            iProgressMonitor.worked(n4);
        }
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (this.fIntermediaryFirstParameterType == null) {
            this.fIntermediaryFirstParameterType = this.fTargetMethodBinding.getDeclaringClass();
        }
        iMember = (IType)this.fIntermediaryFirstParameterType.getJavaElement();
        if (this.fTargetMethod.getDeclaringType() == null || !this.fTargetMethod.getDeclaringType().equals(iMember)) {
            IMethod iMethod;
            this.fTargetMethod = iMethod = new MethodOverrideTester((IType)iMember, iMember.newSupertypeHierarchy(null)).findOverriddenMethodInHierarchy((IType)iMember, this.fTargetMethod);
            this.fTargetMethodBinding = this.findMethodBindingInHierarchy(this.fIntermediaryFirstParameterType, iMethod);
            Assert.isNotNull((Object)this.fTargetMethodBinding);
        }
        refactoringStatus.merge(this.checkCanCreateIntermediaryMethod());
        this.createIntermediaryMethod();
        iProgressMonitor.worked(n5);
        iProgressMonitor.setTaskName(String.valueOf(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions) + " " + RefactoringCoreMessages.IntroduceIndirectionRefactoring_adjusting_visibility);
        refactoringStatus.merge(this.updateTargetVisibility((IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 0)));
        refactoringStatus.merge(this.updateIntermediaryVisibility(new NoOverrideProgressMonitor(iProgressMonitor, 0)));
        iProgressMonitor.worked(n3);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.IntroduceIndirectionRefactoring_checking_conditions);
        this.createChangeAndDiscardRewrite(this.fIntermediaryClass.getCompilationUnit());
        refactoringStatus.merge(Checks.validateModifiesFiles(this.getAllFilesToModify(), this.getValidationContext()));
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus updateTargetVisibility(IProgressMonitor iProgressMonitor) throws JavaModelException, CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(this.adjustVisibility((IMember)((IType)this.fIntermediaryFirstParameterType.getJavaElement()), (IMember)this.fIntermediaryClass, iProgressMonitor));
        if (refactoringStatus.hasError()) {
            return refactoringStatus;
        }
        Modifier.ModifierKeyword modifierKeyword = this.getNeededVisibility((IMember)this.fTargetMethod, (IMember)this.fIntermediaryClass);
        if (modifierKeyword != null) {
            refactoringStatus.merge(this.adjustVisibility((IMember)this.fTargetMethod, modifierKeyword, iProgressMonitor));
            if (refactoringStatus.hasError()) {
                return refactoringStatus;
            }
            if (this.fTargetMethod.getDeclaringType() != null) {
                ITypeHierarchy iTypeHierarchy = this.fTargetMethod.getDeclaringType().newTypeHierarchy(null);
                MethodOverrideTester methodOverrideTester = new MethodOverrideTester(this.fTargetMethod.getDeclaringType(), iTypeHierarchy);
                IType[] iTypeArray = iTypeHierarchy.getAllSubtypes(this.fTargetMethod.getDeclaringType());
                int n = 0;
                while (n < iTypeArray.length) {
                    IMethod iMethod = methodOverrideTester.findOverridingMethodInType(iTypeArray[n], this.fTargetMethod);
                    if (iMethod != null && iMethod.exists()) {
                        refactoringStatus.merge(this.adjustVisibility((IMember)iMethod, modifierKeyword, iProgressMonitor));
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (refactoringStatus.hasError()) {
                            return refactoringStatus;
                        }
                    }
                    ++n;
                }
            }
        }
        return refactoringStatus;
    }

    private RefactoringStatus updateIntermediaryVisibility(NoOverrideProgressMonitor noOverrideProgressMonitor) throws JavaModelException {
        return this.rewriteVisibility(this.fIntermediaryAdjustments, this.fRewrites, (IProgressMonitor)noOverrideProgressMonitor);
    }

    private RefactoringStatus updateReferences(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        iProgressMonitor.beginTask("", 90);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        IMethod[] iMethodArray = RippleMethodFinder2.getRelatedMethods(this.fTargetMethod, false, (IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 10), null);
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        SearchResultGroup[] searchResultGroupArray = Checks.excludeCompilationUnits(this.getReferences(iMethodArray, (IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 10), refactoringStatus), refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(Checks.checkCompileErrorsInAffectedFiles(searchResultGroupArray));
        if (iProgressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        int n = searchResultGroupArray.length == 0 ? 0 : 70 / searchResultGroupArray.length;
        int n2 = 0;
        while (n2 < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n2];
            SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
            CompilationUnitRewrite compilationUnitRewrite = this.getCachedCURewrite(searchResultGroup.getCompilationUnit());
            int n3 = 0;
            while (n3 < searchMatchArray.length) {
                SearchMatch searchMatch = searchMatchArray[n3];
                if (!searchMatch.isInsideDocComment()) {
                    IMember iMember = (IMember)searchMatch.getElement();
                    ASTNode aSTNode = IntroduceIndirectionRefactoring.getSelectedNode(searchResultGroup.getCompilationUnit(), compilationUnitRewrite.getRoot(), searchMatch.getOffset(), searchMatch.getLength());
                    if (aSTNode instanceof SuperMethodInvocation) {
                        refactoringStatus.merge(this.createWarningAboutCall(iMember, aSTNode, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_super_keyword));
                    } else {
                        Assert.isTrue((boolean)(aSTNode instanceof MethodInvocation), (String)"Element of call should be a MethodInvocation.");
                        MethodInvocation methodInvocation = (MethodInvocation)aSTNode;
                        ITypeBinding iTypeBinding = this.getExpressionType(methodInvocation);
                        if (this.fIntermediaryFirstParameterType == null) {
                            this.fIntermediaryFirstParameterType = iTypeBinding.getTypeDeclaration();
                        } else {
                            refactoringStatus.merge(this.findCommonParent(iTypeBinding.getTypeDeclaration()));
                        }
                        if (refactoringStatus.hasFatalError()) {
                            return refactoringStatus;
                        }
                        refactoringStatus.merge(this.updateMethodInvocation(methodInvocation, iMember, compilationUnitRewrite));
                        refactoringStatus.merge(this.adjustVisibility((IMember)this.fIntermediaryClass, (IMember)iMember.getDeclaringType(), (IProgressMonitor)new NoOverrideProgressMonitor(iProgressMonitor, 0)));
                        if (iProgressMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                    }
                }
                ++n3;
            }
            if (!this.isRewriteKept(searchResultGroup.getCompilationUnit())) {
                this.createChangeAndDiscardRewrite(searchResultGroup.getCompilationUnit());
            }
            iProgressMonitor.worked(n);
            ++n2;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus findCommonParent(ITypeBinding iTypeBinding) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        ITypeBinding iTypeBinding2 = iTypeBinding;
        ITypeBinding iTypeBinding3 = this.fIntermediaryFirstParameterType;
        if (iTypeBinding2.equals((Object)iTypeBinding3) || Bindings.isSuperType(iTypeBinding3, iTypeBinding2)) {
            return refactoringStatus;
        }
        ITypeBinding[] iTypeBindingArray = this.getTypeAndAllSuperTypes(iTypeBinding2);
        ITypeBinding[] iTypeBindingArray2 = this.getTypeAndAllSuperTypes(iTypeBinding3);
        ITypeBinding iTypeBinding4 = null;
        int n = 0;
        while (n < iTypeBindingArray.length) {
            int n2 = 0;
            while (n2 < iTypeBindingArray2.length) {
                if (iTypeBindingArray2[n2].isEqualTo((IBinding)iTypeBindingArray[n]) && Bindings.findMethodInHierarchy(iTypeBindingArray2[n2], this.fTargetMethodBinding.getName(), this.fTargetMethodBinding.getParameterTypes()) != null) {
                    iTypeBinding4 = iTypeBindingArray2[n2];
                    break;
                }
                ++n2;
            }
            if (iTypeBinding4 != null) break;
            ++n;
        }
        if (iTypeBinding4 != null) {
            this.fIntermediaryFirstParameterType = iTypeBinding4;
        } else {
            String string = this.fIntermediaryFirstParameterType.getQualifiedName();
            String string2 = iTypeBinding2.getQualifiedName();
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_open_hierarchy_error, new String[]{string, string2}));
        }
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException, OperationCanceledException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fTargetMethod.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        int n = 589830;
        IType iType = this.fTargetMethod.getDeclaringType();
        try {
            if (iType.isLocal() || iType.isAnonymous()) {
                n |= 0x40000;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        String string2 = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description_short, this.fTargetMethod.getElementName());
        String string3 = Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_descriptor_description, new String[]{JavaElementLabels.getTextLabel(this.fTargetMethod, JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getTextLabel(iType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_original_pattern, JavaElementLabels.getTextLabel(this.fTargetMethod, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_method_pattern, this.fIntermediaryMethodName));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_declaring_pattern, JavaElementLabels.getTextLabel(this.fIntermediaryClass, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (this.fUpdateReferences) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.JavaRefactoringDescriptor_update_references);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.introduce.indirection", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fTargetMethod));
        hashMap.put("name", this.fIntermediaryMethodName);
        hashMap.put("element1", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fIntermediaryClass));
        hashMap.put("references", Boolean.valueOf(this.fUpdateReferences).toString());
        return new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.IntroduceIndirectionRefactoring_introduce_indirection, (Change[])this.fTextChangeManager.getAllChanges());
    }

    private RefactoringStatus checkCanCreateIntermediaryMethod() throws JavaModelException {
        ArrayList<ITypeBinding> arrayList = new ArrayList<ITypeBinding>();
        if (!this.isStaticTarget()) {
            arrayList.add(this.fIntermediaryFirstParameterType);
        }
        arrayList.addAll(Arrays.asList(this.fTargetMethodBinding.getParameterTypes()));
        return Checks.checkMethodInType(this.fIntermediaryClassBinding, this.fIntermediaryMethodName, arrayList.toArray(new ITypeBinding[arrayList.size()]));
    }

    private void createIntermediaryMethod() throws CoreException {
        ChildListPropertyDescriptor childListPropertyDescriptor;
        String string;
        ICompilationUnit iCompilationUnit;
        ParameterizedType parameterizedType;
        Type type;
        SingleVariableDeclaration singleVariableDeclaration;
        CompilationUnitRewrite compilationUnitRewrite = this.getCachedCURewrite(this.fIntermediaryClass.getCompilationUnit());
        AST aST = compilationUnitRewrite.getAST();
        MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
        methodDeclaration.setName(aST.newSimpleName(this.fIntermediaryMethodName));
        List list = methodDeclaration.modifiers();
        list.add(compilationUnitRewrite.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        list.add(compilationUnitRewrite.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        String string2 = StubUtility.suggestArgumentName(this.getProject(), this.fIntermediaryFirstParameterType.getName(), this.fTargetMethod.getParameterNames());
        if (!this.isStaticTarget()) {
            singleVariableDeclaration = compilationUnitRewrite.getAST().newSingleVariableDeclaration();
            type = compilationUnitRewrite.getImportRewrite().addImport(this.fIntermediaryFirstParameterType, compilationUnitRewrite.getAST());
            if (this.fIntermediaryFirstParameterType.isGenericType()) {
                parameterizedType = compilationUnitRewrite.getAST().newParameterizedType(type);
                iCompilationUnit = this.fIntermediaryFirstParameterType.getTypeParameters();
                int n = 0;
                while (n < ((ITypeBinding[])iCompilationUnit).length) {
                    parameterizedType.typeArguments().add(compilationUnitRewrite.getImportRewrite().addImport(iCompilationUnit[n], compilationUnitRewrite.getAST()));
                    ++n;
                }
                type = parameterizedType;
            }
            singleVariableDeclaration.setType(type);
            singleVariableDeclaration.setName(compilationUnitRewrite.getAST().newSimpleName(string2));
            methodDeclaration.parameters().add(singleVariableDeclaration);
        }
        this.copyArguments(methodDeclaration, compilationUnitRewrite);
        if (!this.isStaticTarget() && this.fIntermediaryFirstParameterType.isGenericType()) {
            this.addTypeParameters(compilationUnitRewrite, methodDeclaration.typeParameters(), this.fIntermediaryFirstParameterType);
        }
        this.copyTypeParameters(methodDeclaration, compilationUnitRewrite);
        methodDeclaration.setReturnType2(compilationUnitRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getReturnType(), aST));
        this.copyExceptions(methodDeclaration, compilationUnitRewrite);
        singleVariableDeclaration = compilationUnitRewrite.getAST().newMethodInvocation();
        singleVariableDeclaration.setName(compilationUnitRewrite.getAST().newSimpleName(this.fTargetMethod.getElementName()));
        if (this.isStaticTarget()) {
            type = compilationUnitRewrite.getImportRewrite().addImport(this.fTargetMethodBinding.getDeclaringClass(), aST);
            singleVariableDeclaration.setExpression((Expression)ASTNodeFactory.newName(aST, ASTNodes.asString((ASTNode)type)));
        } else {
            singleVariableDeclaration.setExpression((Expression)compilationUnitRewrite.getAST().newSimpleName(string2));
        }
        this.copyInvocationParameters((MethodInvocation)singleVariableDeclaration, aST);
        type = this.encapsulateInvocation(methodDeclaration, (MethodInvocation)singleVariableDeclaration);
        parameterizedType = compilationUnitRewrite.getAST().newBlock();
        parameterizedType.statements().add(type);
        methodDeclaration.setBody((Block)parameterizedType);
        iCompilationUnit = compilationUnitRewrite.getCu();
        if (StubUtility.doAddComments(iCompilationUnit.getJavaProject()) && (string = CodeGeneration.getMethodComment(iCompilationUnit, this.getIntermediaryClassName(), methodDeclaration, null, StubUtility.getLineDelimiterUsed((IJavaElement)iCompilationUnit))) != null) {
            childListPropertyDescriptor = (Javadoc)compilationUnitRewrite.getASTRewrite().createStringPlaceholder(string, 29);
            methodDeclaration.setJavadoc((Javadoc)childListPropertyDescriptor);
        }
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)this.typeToDeclaration(this.fIntermediaryClass, compilationUnitRewrite.getRoot());
        childListPropertyDescriptor = this.typeToBodyDeclarationProperty(this.fIntermediaryClass, compilationUnitRewrite.getRoot());
        ListRewrite listRewrite = compilationUnitRewrite.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, childListPropertyDescriptor);
        listRewrite.insertAt((ASTNode)methodDeclaration, ASTNodes.getInsertionIndex((BodyDeclaration)methodDeclaration, abstractTypeDeclaration.bodyDeclarations()), compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_create_new_method));
    }

    private void addTypeParameters(CompilationUnitRewrite compilationUnitRewrite, List list, ITypeBinding iTypeBinding) {
        ITypeBinding iTypeBinding2 = iTypeBinding.getDeclaringClass();
        if (iTypeBinding2 != null) {
            this.addTypeParameters(compilationUnitRewrite, list, iTypeBinding2);
        }
        ITypeBinding[] iTypeBindingArray = iTypeBinding.getTypeParameters();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            TypeParameter typeParameter = compilationUnitRewrite.getAST().newTypeParameter();
            typeParameter.setName(compilationUnitRewrite.getAST().newSimpleName(iTypeBindingArray[n].getName()));
            ITypeBinding[] iTypeBindingArray2 = iTypeBindingArray[n].getTypeBounds();
            int n2 = 0;
            while (n2 < iTypeBindingArray2.length) {
                if (!"java.lang.Object".equals(iTypeBindingArray2[n2].getQualifiedName())) {
                    typeParameter.typeBounds().add(compilationUnitRewrite.getImportRewrite().addImport(iTypeBindingArray2[n2], compilationUnitRewrite.getAST()));
                }
                ++n2;
            }
            list.add(typeParameter);
            ++n;
        }
    }

    private Statement encapsulateInvocation(MethodDeclaration methodDeclaration, MethodInvocation methodInvocation) {
        Type type = methodDeclaration.getReturnType2();
        if (type == null || type instanceof PrimitiveType && PrimitiveType.VOID.equals(((PrimitiveType)type).getPrimitiveTypeCode())) {
            return methodInvocation.getAST().newExpressionStatement((Expression)methodInvocation);
        }
        ReturnStatement returnStatement = methodInvocation.getAST().newReturnStatement();
        returnStatement.setExpression((Expression)methodInvocation);
        return returnStatement;
    }

    private void copyInvocationParameters(MethodInvocation methodInvocation, AST aST) throws JavaModelException {
        String[] stringArray = this.fTargetMethod.getParameterNames();
        int n = 0;
        while (n < stringArray.length) {
            methodInvocation.arguments().add(aST.newSimpleName(stringArray[n]));
            ++n;
        }
    }

    private void copyArguments(MethodDeclaration methodDeclaration, CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        String[] stringArray = this.fTargetMethod.getParameterNames();
        ITypeBinding[] iTypeBindingArray = this.fTargetMethodBinding.getParameterTypes();
        int n = 0;
        while (n < stringArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            SingleVariableDeclaration singleVariableDeclaration = compilationUnitRewrite.getAST().newSingleVariableDeclaration();
            singleVariableDeclaration.setName(compilationUnitRewrite.getAST().newSimpleName(stringArray[n]));
            if (n == stringArray.length - 1 && this.fTargetMethodBinding.isVarargs()) {
                singleVariableDeclaration.setVarargs(true);
                if (iTypeBinding.isArray()) {
                    iTypeBinding = iTypeBinding.getComponentType();
                }
            }
            singleVariableDeclaration.setType(compilationUnitRewrite.getImportRewrite().addImport(iTypeBinding, compilationUnitRewrite.getAST()));
            methodDeclaration.parameters().add(singleVariableDeclaration);
            ++n;
        }
    }

    private void copyTypeParameters(MethodDeclaration methodDeclaration, CompilationUnitRewrite compilationUnitRewrite) {
        ITypeBinding[] iTypeBindingArray = this.fTargetMethodBinding.getTypeParameters();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            ITypeBinding iTypeBinding = iTypeBindingArray[n];
            TypeParameter typeParameter = compilationUnitRewrite.getAST().newTypeParameter();
            typeParameter.setName(compilationUnitRewrite.getAST().newSimpleName(iTypeBinding.getName()));
            ITypeBinding[] iTypeBindingArray2 = iTypeBinding.getTypeBounds();
            int n2 = 0;
            while (n2 < iTypeBindingArray2.length) {
                if (!"java.lang.Object".equals(iTypeBindingArray2[n2].getQualifiedName())) {
                    typeParameter.typeBounds().add(compilationUnitRewrite.getImportRewrite().addImport(iTypeBindingArray2[n2], compilationUnitRewrite.getAST()));
                }
                ++n2;
            }
            methodDeclaration.typeParameters().add(typeParameter);
            ++n;
        }
    }

    private void copyExceptions(MethodDeclaration methodDeclaration, CompilationUnitRewrite compilationUnitRewrite) {
        ITypeBinding[] iTypeBindingArray = this.fTargetMethodBinding.getExceptionTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            String string = compilationUnitRewrite.getImportRewrite().addImport(iTypeBindingArray[n]);
            methodDeclaration.thrownExceptions().add(ASTNodeFactory.newName(compilationUnitRewrite.getAST(), string));
            ++n;
        }
    }

    private RefactoringStatus updateMethodInvocation(MethodInvocation methodInvocation, IMember iMember, CompilationUnitRewrite compilationUnitRewrite) throws JavaModelException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus refactoringStatus2 = new RefactoringStatus();
        if (methodInvocation.typeArguments().size() > 0) {
            return this.createWarningAboutCall(iMember, (ASTNode)methodInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_type_arguments);
        }
        MethodInvocation methodInvocation2 = compilationUnitRewrite.getAST().newMethodInvocation();
        List list = methodInvocation2.arguments();
        List list2 = methodInvocation.arguments();
        String string = compilationUnitRewrite.getImportRewrite().addImport(this.fIntermediaryClassBinding);
        methodInvocation2.setExpression((Expression)ASTNodeFactory.newName(compilationUnitRewrite.getAST(), string));
        methodInvocation2.setName(compilationUnitRewrite.getAST().newSimpleName(this.getIntermediaryMethodName()));
        Expression expression = methodInvocation.getExpression();
        if (!this.isStaticTarget()) {
            ThisExpression thisExpression;
            if (expression == null) {
                thisExpression = compilationUnitRewrite.getAST().newThisExpression();
                refactoringStatus = this.qualifyThisExpression(thisExpression, methodInvocation, iMember, compilationUnitRewrite);
                refactoringStatus2.merge(refactoringStatus);
                if (refactoringStatus.hasEntries()) {
                    return refactoringStatus2;
                }
                list.add(thisExpression);
            } else {
                thisExpression = compilationUnitRewrite.getASTRewrite().createMoveTarget((ASTNode)expression);
                list.add(thisExpression);
            }
        } else if (!(expression == null || expression instanceof Name && ASTNodes.getTypeBinding((Name)expression) != null)) {
            return this.createWarningAboutCall(iMember, (ASTNode)methodInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_static_expression_access);
        }
        int n = 0;
        while (n < list2.size()) {
            refactoringStatus = (Expression)list2.get(n);
            ASTNode aSTNode = compilationUnitRewrite.getASTRewrite().createMoveTarget((ASTNode)refactoringStatus);
            list.add(aSTNode);
            ++n;
        }
        compilationUnitRewrite.getASTRewrite().replace((ASTNode)methodInvocation, (ASTNode)methodInvocation2, compilationUnitRewrite.createGroupDescription(RefactoringCoreMessages.IntroduceIndirectionRefactoring_group_description_replace_call));
        return refactoringStatus2;
    }

    private RefactoringStatus qualifyThisExpression(ThisExpression thisExpression, MethodInvocation methodInvocation, IMember iMember, CompilationUnitRewrite compilationUnitRewrite) {
        ASTNode aSTNode;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IMethodBinding iMethodBinding = methodInvocation.resolveMethodBinding();
        MethodDeclaration methodDeclaration = (MethodDeclaration)ASTNodes.findDeclaration((IBinding)iMethodBinding, methodInvocation.getRoot());
        ITypeBinding iTypeBinding = null;
        if (methodDeclaration != null) {
            iTypeBinding = ASTNodes.isParent((ASTNode)methodInvocation, methodDeclaration.getParent()) ? iMethodBinding.getDeclaringClass() : ASTNodes.getEnclosingType((ASTNode)methodInvocation);
        } else {
            aSTNode = this.getEnclosingTypeDeclaration((ASTNode)methodInvocation);
            iTypeBinding = ASTNodes.getEnclosingType(aSTNode);
            while (aSTNode != null && Bindings.findMethodInHierarchy(iTypeBinding, iMethodBinding.getName(), iMethodBinding.getParameterTypes()) == null) {
                aSTNode = this.getEnclosingTypeDeclaration(aSTNode.getParent());
                iTypeBinding = ASTNodes.getEnclosingType(aSTNode);
            }
        }
        if (iTypeBinding == null) {
            refactoringStatus.merge(this.createWarningAboutCall(iMember, (ASTNode)methodInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_declaring_type_not_found));
            return refactoringStatus;
        }
        aSTNode = ASTNodes.getEnclosingType((ASTNode)methodInvocation);
        if (!aSTNode.equals((Object)iTypeBinding)) {
            if (iTypeBinding.isAnonymous()) {
                refactoringStatus.merge(this.createWarningAboutCall(iMember, (ASTNode)methodInvocation, RefactoringCoreMessages.IntroduceIndirectionRefactoring_call_warning_anonymous_cannot_qualify));
            } else {
                thisExpression.setQualifier((Name)compilationUnitRewrite.getAST().newSimpleName(iTypeBinding.getName()));
            }
        }
        return refactoringStatus;
    }

    private IMethodBinding findMethodBindingInHierarchy(ITypeBinding iTypeBinding, IMethod iMethod) {
        IMethodBinding iMethodBinding;
        IMethodBinding[] iMethodBindingArray = iTypeBinding.getDeclaredMethods();
        int n = 0;
        while (n < iMethodBindingArray.length) {
            if (iMethod.equals(iMethodBindingArray[n].getJavaElement())) {
                return iMethodBindingArray[n];
            }
            ++n;
        }
        ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
        if (iTypeBinding2 != null && (iMethodBinding = this.findMethodBindingInHierarchy(iTypeBinding2, iMethod)) != null) {
            return iMethodBinding;
        }
        iMethodBinding = iTypeBinding.getInterfaces();
        int n2 = 0;
        while (n2 < ((IMethodBinding)iMethodBinding).length) {
            IMethodBinding iMethodBinding2 = this.findMethodBindingInHierarchy((ITypeBinding)iMethodBinding[n2], iMethod);
            if (iMethodBinding2 != null) {
                return iMethodBinding2;
            }
            ++n2;
        }
        return null;
    }

    private ITypeBinding[] getTypeAndAllSuperTypes(ITypeBinding iTypeBinding) {
        ArrayList arrayList = new ArrayList();
        this.collectSuperTypes(iTypeBinding, arrayList);
        return arrayList.toArray(new ITypeBinding[arrayList.size()]);
    }

    private void collectSuperTypes(ITypeBinding iTypeBinding, List list) {
        if (list.add(iTypeBinding.getTypeDeclaration())) {
            ITypeBinding[] iTypeBindingArray = iTypeBinding.getInterfaces();
            int n = 0;
            while (n < iTypeBindingArray.length) {
                this.collectSuperTypes(iTypeBindingArray[n], list);
                ++n;
            }
            ITypeBinding iTypeBinding2 = iTypeBinding.getSuperclass();
            if (iTypeBinding2 != null) {
                this.collectSuperTypes(iTypeBinding2, list);
            }
        }
    }

    private CompilationUnitRewrite getCachedCURewrite(ICompilationUnit iCompilationUnit) {
        CompilationUnitRewrite compilationUnitRewrite = (CompilationUnitRewrite)this.fRewrites.get(iCompilationUnit);
        if (compilationUnitRewrite == null) {
            compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit);
            this.fRewrites.put(iCompilationUnit, compilationUnitRewrite);
        }
        return compilationUnitRewrite;
    }

    private boolean isRewriteKept(ICompilationUnit iCompilationUnit) {
        return this.fIntermediaryClass.getCompilationUnit().equals(iCompilationUnit);
    }

    private void createChangeAndDiscardRewrite(ICompilationUnit iCompilationUnit) throws CoreException {
        CompilationUnitRewrite compilationUnitRewrite = (CompilationUnitRewrite)this.fRewrites.get(iCompilationUnit);
        if (compilationUnitRewrite != null) {
            this.fTextChangeManager.manage(iCompilationUnit, (TextChange)compilationUnitRewrite.createChange());
            this.fRewrites.remove(iCompilationUnit);
        }
    }

    private SearchResultGroup[] getReferences(IMethod[] iMethodArray, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])iMethodArray, 2);
        IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)this.fIntermediaryClass, false);
        return RefactoringSearchEngine.search(searchPattern, iJavaSearchScope, iProgressMonitor, refactoringStatus);
    }

    private ITypeBinding typeToBinding(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = this.typeToDeclaration(iType, compilationUnit);
        if (iType.isAnonymous()) {
            return ((AnonymousClassDeclaration)aSTNode).resolveBinding();
        }
        return ((AbstractTypeDeclaration)aSTNode).resolveBinding();
    }

    private ASTNode typeToDeclaration(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        Name name = (Name)NodeFinder.perform((ASTNode)compilationUnit, iType.getNameRange());
        if (iType.isAnonymous()) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return ASTNodes.getParent((ASTNode)name, clazz);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)name, clazz);
    }

    private ASTNode getEnclosingTypeDeclaration(ASTNode aSTNode) {
        while (aSTNode != null) {
            if (aSTNode instanceof AbstractTypeDeclaration) {
                return aSTNode;
            }
            if (aSTNode instanceof AnonymousClassDeclaration) {
                return aSTNode;
            }
            aSTNode = aSTNode.getParent();
        }
        return null;
    }

    private ChildListPropertyDescriptor typeToBodyDeclarationProperty(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = this.typeToDeclaration(iType, compilationUnit);
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private RefactoringStatus createWarningAboutCall(IMember iMember, ASTNode aSTNode, String string) {
        String string2 = JavaElementLabels.getElementLabel((IJavaElement)iMember, JavaElementLabels.ALL_DEFAULT);
        String string3 = JavaElementLabels.getElementLabel((IJavaElement)iMember.getDeclaringType(), JavaElementLabels.ALL_FULLY_QUALIFIED);
        return RefactoringStatus.createWarningStatus((String)Messages.format(string, new String[]{string2, string3}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)iMember.getCompilationUnit(), aSTNode));
    }

    private ITypeBinding getExpressionType(MethodInvocation methodInvocation) {
        Expression expression = methodInvocation.getExpression();
        ITypeBinding iTypeBinding = null;
        iTypeBinding = expression == null ? methodInvocation.resolveMethodBinding().getDeclaringClass() : expression.resolveTypeBinding();
        Assert.isNotNull((Object)iTypeBinding, (String)"Type binding of target expression may not be null");
        return iTypeBinding;
    }

    private IFile[] getAllFilesToModify() {
        ArrayList<ICompilationUnit> arrayList = new ArrayList<ICompilationUnit>();
        arrayList.addAll(Arrays.asList(this.fTextChangeManager.getAllCompilationUnits()));
        return ResourceUtil.getFiles(arrayList.toArray(new ICompilationUnit[arrayList.size()]));
    }

    private boolean isStaticTarget() throws JavaModelException {
        return Flags.isStatic((int)this.fTargetMethod.getFlags());
    }

    private IMember getEnclosingInitialSelectionMember() throws JavaModelException {
        return (IMember)this.fSelectionCompilationUnit.getElementAt(this.fSelectionStart);
    }

    private static ASTNode getSelectedNode(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, int n, int n2) {
        ASTNode aSTNode = null;
        try {
            aSTNode = iCompilationUnit != null ? IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2, (ITypeRoot)iCompilationUnit)) : IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2));
        }
        catch (JavaModelException javaModelException) {}
        if (aSTNode != null) {
            return aSTNode;
        }
        return IntroduceIndirectionRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2));
    }

    private static ASTNode checkNode(ASTNode aSTNode) {
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getNodeType() == 42) {
            aSTNode = aSTNode.getParent();
        } else if (aSTNode.getNodeType() == 21) {
            aSTNode = ((ExpressionStatement)aSTNode).getExpression();
        }
        switch (aSTNode.getNodeType()) {
            case 31: 
            case 32: 
            case 48: {
                return aSTNode;
            }
        }
        return null;
    }

    private Modifier.ModifierKeyword getNeededVisibility(IMember iMember, IMember iMember2) throws JavaModelException {
        return this.fAdjustor.getVisibilityThreshold((IJavaElement)iMember2, iMember, (IProgressMonitor)new NullProgressMonitor());
    }

    private RefactoringStatus adjustVisibility(IMember iMember, IMember iMember2, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.adjustVisibility(iMember, this.getNeededVisibility(iMember, iMember2), true, iProgressMonitor);
    }

    private RefactoringStatus adjustVisibility(IMember iMember, Modifier.ModifierKeyword modifierKeyword, IProgressMonitor iProgressMonitor) throws CoreException {
        return this.adjustVisibility(iMember, modifierKeyword, false, iProgressMonitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus adjustVisibility(IMember iMember, Modifier.ModifierKeyword modifierKeyword, boolean bl, IProgressMonitor iProgressMonitor) throws CoreException {
        boolean bl2;
        HashMap hashMap = this.isRewriteKept(iMember.getCompilationUnit()) ? this.fIntermediaryAdjustments : new HashMap();
        int n = hashMap.size();
        this.addAdjustment(iMember, modifierKeyword, hashMap);
        if (bl) {
            while (iMember.getDeclaringType() != null) {
                iMember = iMember.getDeclaringType();
                this.addAdjustment(iMember, modifierKeyword, hashMap);
            }
        }
        boolean bl3 = bl2 = hashMap.size() - n > 0;
        if (bl2 && (iMember.isReadOnly() || iMember.isBinary())) {
            return RefactoringStatus.createErrorStatus((String)Messages.format(RefactoringCoreMessages.IntroduceIndirectionRefactoring_cannot_update_binary_target_visibility, new String[]{JavaElementLabels.getElementLabel((IJavaElement)iMember, JavaElementLabels.ALL_DEFAULT)}), (RefactoringStatusContext)JavaStatusContext.create(iMember));
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (!bl2) {
            return refactoringStatus;
        }
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.MemberVisibilityAdjustor_adjusting, 2);
            if (!this.isRewriteKept(iMember.getCompilationUnit())) {
                CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(iMember.getCompilationUnit());
                compilationUnitRewrite.setResolveBindings(false);
                HashMap<ICompilationUnit, CompilationUnitRewrite> hashMap2 = new HashMap<ICompilationUnit, CompilationUnitRewrite>();
                hashMap2.put(iMember.getCompilationUnit(), compilationUnitRewrite);
                refactoringStatus.merge(this.rewriteVisibility(hashMap, hashMap2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2)));
                compilationUnitRewrite.attachChange((CompilationUnitChange)this.fTextChangeManager.get(iMember.getCompilationUnit()), true, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1, 2));
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        {
            Object var11_13 = null;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus rewriteVisibility(Map map, Map map2, IProgressMonitor iProgressMonitor) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fAdjustor.setRewrites(map2);
        this.fAdjustor.setAdjustments(map);
        this.fAdjustor.setStatus(refactoringStatus);
        this.fAdjustor.rewriteVisibility(iProgressMonitor);
        return refactoringStatus;
    }

    private void addAdjustment(IMember iMember, Modifier.ModifierKeyword modifierKeyword, Map map) throws JavaModelException {
        Modifier.ModifierKeyword modifierKeyword2 = Modifier.ModifierKeyword.fromFlagValue((int)JdtFlags.getVisibilityCode(iMember));
        if (MemberVisibilityAdjustor.hasLowerVisibility(modifierKeyword2, modifierKeyword) && MemberVisibilityAdjustor.needsVisibilityAdjustments(iMember, modifierKeyword, map)) {
            map.put(iMember, new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(iMember, modifierKeyword, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(iMember), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)iMember), MemberVisibilityAdjustor.getLabel(modifierKeyword)}), (RefactoringStatusContext)JavaStatusContext.create(iMember))));
        }
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("input");
            if (string != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (object == null || !object.exists() || object.getElementType() != 9) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.introduce.indirection");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fTargetMethod = (IMethod)object;
            string = javaRefactoringArguments.getAttribute("element1");
            if (string != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (object == null || !object.exists() || object.getElementType() != 7) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.introduce.indirection");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "element1"));
            }
            this.fIntermediaryClass = (IType)object;
            object = javaRefactoringArguments.getAttribute("references");
            if (object == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
            }
            this.fUpdateReferences = Boolean.valueOf((String)object);
            String string2 = javaRefactoringArguments.getAttribute("name");
            if (string2 != null && !"".equals(string2)) {
                return this.setIntermediaryMethodName(string2);
            }
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
    }

    private class NoOverrideProgressMonitor
    extends SubProgressMonitor {
        public NoOverrideProgressMonitor(IProgressMonitor iProgressMonitor, int n) {
            super(iProgressMonitor, n, 2);
        }

        public void setTaskName(String string) {
        }
    }
}

