/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ArrayCreation;
import org.eclipse.wst.jsdt.core.dom.ArrayInitializer;
import org.eclipse.wst.jsdt.core.dom.ArrayType;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.NameCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.TempAssignmentFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempDeclarationFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.TempOccurrenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class PromoteTempToFieldRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_STATIC = "static";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_INITIALIZE = "initialize";
    private int fSelectionStart;
    private int fSelectionLength;
    private ICompilationUnit fCu;
    public static final int INITIALIZE_IN_FIELD = 0;
    public static final int INITIALIZE_IN_METHOD = 1;
    public static final int INITIALIZE_IN_CONSTRUCTOR = 2;
    private static final String LINKED_NAME = "name";
    private String fFieldName;
    private int fVisibility;
    private boolean fDeclareStatic;
    private boolean fDeclareFinal;
    private int fInitializeIn;
    private CompilationUnit fCompilationUnitNode;
    private VariableDeclaration fTempDeclarationNode;
    private boolean fInitializerUsesLocalTypes;
    private boolean fTempTypeUsesClassTypeVariables;
    private boolean fSelfInitializing = false;
    private LinkedProposalModel fLinkedProposalModel;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public PromoteTempToFieldRefactoring(ICompilationUnit iCompilationUnit, int n, int n2) {
        Assert.isTrue((n >= 0 ? 1 : 0) != 0);
        Assert.isTrue((n2 >= 0 ? 1 : 0) != 0);
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
        this.fCu = iCompilationUnit;
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fLinkedProposalModel = null;
    }

    public PromoteTempToFieldRefactoring(VariableDeclaration variableDeclaration) {
        Assert.isTrue((variableDeclaration != null ? 1 : 0) != 0);
        this.fTempDeclarationNode = variableDeclaration;
        IVariableBinding iVariableBinding = variableDeclaration.resolveBinding();
        Assert.isTrue((iVariableBinding != null && !iVariableBinding.isParameter() && !iVariableBinding.isField() ? 1 : 0) != 0);
        ASTNode aSTNode = variableDeclaration.getRoot();
        Assert.isTrue((boolean)(aSTNode instanceof CompilationUnit));
        this.fCompilationUnitNode = (CompilationUnit)aSTNode;
        IJavaElement iJavaElement = this.fCompilationUnitNode.getJavaElement();
        Assert.isTrue((boolean)(iJavaElement instanceof ICompilationUnit));
        this.fCu = (ICompilationUnit)iJavaElement;
        this.fSelectionStart = variableDeclaration.getStartPosition();
        this.fSelectionLength = variableDeclaration.getLength();
        this.fFieldName = "";
        this.fVisibility = 2;
        this.fDeclareStatic = false;
        this.fDeclareFinal = false;
        this.fInitializeIn = 1;
        this.fLinkedProposalModel = null;
    }

    public String getName() {
        return RefactoringCoreMessages.PromoteTempToFieldRefactoring_name;
    }

    public int[] getAvailableVisibilities() {
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[3] = 2;
        return nArray;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public boolean getDeclareFinal() {
        return this.fDeclareFinal;
    }

    public boolean getDeclareStatic() {
        return this.fDeclareStatic;
    }

    public int getInitializeIn() {
        return this.fInitializeIn;
    }

    public void setVisibility(int n) {
        Assert.isTrue((n == 2 || n == 0 || n == 4 || n == 1 ? 1 : 0) != 0);
        this.fVisibility = n;
    }

    public void setDeclareFinal(boolean bl) {
        this.fDeclareFinal = bl;
    }

    public void setDeclareStatic(boolean bl) {
        this.fDeclareStatic = bl;
    }

    public void setFieldName(String string) {
        Assert.isNotNull((Object)string);
        this.fFieldName = string;
    }

    public void setInitializeIn(int n) {
        Assert.isTrue((n == 2 || n == 0 || n == 1 ? 1 : 0) != 0);
        this.fInitializeIn = n;
    }

    public boolean canEnableSettingStatic() {
        return this.fInitializeIn != 2 && !this.isTempDeclaredInStaticMethod() && !this.fTempTypeUsesClassTypeVariables;
    }

    public boolean canEnableSettingFinal() {
        if (this.fInitializeIn == 2) {
            return this.canEnableSettingDeclareInConstructors() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.fInitializeIn == 0) {
            return this.canEnableSettingDeclareInFieldDeclaration() && !this.tempHasAssignmentsOtherThanInitialization();
        }
        if (this.getMethodDeclaration().isConstructor()) {
            return !this.tempHasAssignmentsOtherThanInitialization();
        }
        return false;
    }

    private boolean tempHasAssignmentsOtherThanInitialization() {
        TempAssignmentFinder tempAssignmentFinder = new TempAssignmentFinder(this.fTempDeclarationNode);
        this.fCompilationUnitNode.accept((ASTVisitor)tempAssignmentFinder);
        return tempAssignmentFinder.hasAssignments();
    }

    public boolean canEnableSettingDeclareInConstructors() {
        return !this.fDeclareStatic && !this.fInitializerUsesLocalTypes && !this.getMethodDeclaration().isConstructor() && !this.isDeclaredInAnonymousClass() && !this.isTempDeclaredInStaticMethod() && this.tempHasInitializer();
    }

    public boolean canEnableSettingDeclareInMethod() {
        return !this.fDeclareFinal && this.tempHasInitializer();
    }

    private boolean tempHasInitializer() {
        return this.getTempInitializer() != null;
    }

    public boolean canEnableSettingDeclareInFieldDeclaration() {
        return !this.fInitializerUsesLocalTypes && this.tempHasInitializer();
    }

    private Expression getTempInitializer() {
        return this.fTempDeclarationNode.getInitializer();
    }

    private boolean isTempDeclaredInStaticMethod() {
        return Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
    }

    private MethodDeclaration getMethodDeclaration() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz);
    }

    private boolean isDeclaredInAnonymousClass() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz) != null;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCu}), this.getValidationContext());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.initAST(iProgressMonitor);
        if (this.fTempDeclarationNode == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_select_declaration);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!Checks.isDeclaredIn(this.fTempDeclarationNode, clazz)) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_only_declared_in_methods);
        }
        if (this.isMethodParameter()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_method_parameters);
        }
        if (this.isTempAnExceptionInCatchBlock()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_exceptions);
        }
        refactoringStatus.merge(this.checkTempTypeForLocalTypeUsage());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.checkTempInitializerForLocalTypeUsage();
        if (!this.fSelfInitializing) {
            this.initializeDefaults();
        }
        return refactoringStatus;
    }

    private void initializeDefaults() {
        this.fVisibility = 2;
        this.fDeclareStatic = Modifier.isStatic((int)this.getMethodDeclaration().getModifiers());
        this.fDeclareFinal = false;
        if (this.canEnableSettingDeclareInMethod()) {
            this.fInitializeIn = 1;
        } else if (this.canEnableSettingDeclareInFieldDeclaration()) {
            this.fInitializeIn = 0;
        } else if (this.canEnableSettingDeclareInConstructors()) {
            this.fInitializeIn = 2;
        }
    }

    public String[] guessFieldNames() {
        String string = StubUtility.removePrefixAndSuffixForVariable(this.fCu.getJavaProject(), this.fTempDeclarationNode.resolveBinding());
        String[] stringArray = this.getNamesOfFieldsInDeclaringType();
        int n = ASTNodes.getDimensions(this.fTempDeclarationNode);
        return StubUtility.getFieldNameSuggestions(this.fCu.getJavaProject(), string, n, this.getModifiers(), stringArray);
    }

    private String getInitialFieldName() {
        String[] stringArray = this.guessFieldNames();
        if (stringArray.length > 0) {
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup linkedProposalPositionGroup = this.fLinkedProposalModel.getPositionGroup(LINKED_NAME, true);
                int n = 0;
                while (n < stringArray.length) {
                    linkedProposalPositionGroup.addProposal(stringArray[n], null, stringArray.length - n);
                    ++n;
                }
            }
            return stringArray[0];
        }
        return this.fTempDeclarationNode.getName().getIdentifier();
    }

    private String[] getNamesOfFieldsInDeclaringType() {
        AbstractTypeDeclaration abstractTypeDeclaration = this.getEnclosingType();
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            FieldDeclaration[] fieldDeclarationArray = ((TypeDeclaration)abstractTypeDeclaration).getFields();
            ArrayList<String> arrayList = new ArrayList<String>(fieldDeclarationArray.length);
            int n = 0;
            while (n < fieldDeclarationArray.length) {
                Iterator iterator = fieldDeclarationArray[n].fragments().iterator();
                while (iterator.hasNext()) {
                    VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)iterator.next();
                    arrayList.add(variableDeclarationFragment.getName().getIdentifier());
                }
                ++n;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return new String[0];
    }

    private void checkTempInitializerForLocalTypeUsage() {
        Expression expression = this.fTempDeclarationNode.getInitializer();
        if (expression == null) {
            return;
        }
        ITypeBinding[] iTypeBindingArray = this.getMethodDeclaration().resolveBinding().getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer localTypeAndVariableUsageAnalyzer = new LocalTypeAndVariableUsageAnalyzer(iTypeBindingArray);
        expression.accept((ASTVisitor)localTypeAndVariableUsageAnalyzer);
        this.fInitializerUsesLocalTypes = !localTypeAndVariableUsageAnalyzer.getUsageOfEnclosingNodes().isEmpty();
    }

    private RefactoringStatus checkTempTypeForLocalTypeUsage() {
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        if (variableDeclarationStatement == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        Type type = variableDeclarationStatement.getType();
        ITypeBinding iTypeBinding = type.resolveBinding();
        if (iTypeBinding == null) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_cannot_promote);
        }
        ITypeBinding[] iTypeBindingArray = this.getMethodDeclaration().resolveBinding().getTypeParameters();
        LocalTypeAndVariableUsageAnalyzer localTypeAndVariableUsageAnalyzer = new LocalTypeAndVariableUsageAnalyzer(iTypeBindingArray);
        type.accept((ASTVisitor)localTypeAndVariableUsageAnalyzer);
        boolean bl = !localTypeAndVariableUsageAnalyzer.getUsageOfEnclosingNodes().isEmpty();
        this.fTempTypeUsesClassTypeVariables = localTypeAndVariableUsageAnalyzer.getClassTypeVariablesUsed();
        if (bl) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_uses_type_declared_locally);
        }
        return null;
    }

    private VariableDeclarationStatement getTempDeclarationStatement() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (VariableDeclarationStatement)ASTNodes.getParent((ASTNode)this.fTempDeclarationNode, clazz);
    }

    private boolean isTempAnExceptionInCatchBlock() {
        return this.fTempDeclarationNode.getParent() instanceof CatchClause;
    }

    private boolean isMethodParameter() {
        return this.fTempDeclarationNode.getParent() instanceof MethodDeclaration;
    }

    private void initAST(IProgressMonitor iProgressMonitor) {
        if (this.fCompilationUnitNode == null) {
            this.fCompilationUnitNode = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCu, true, iProgressMonitor);
            this.fTempDeclarationNode = TempDeclarationFinder.findTempDeclaration(this.fCompilationUnitNode, this.fSelectionStart, this.fSelectionLength);
        }
    }

    public RefactoringStatus validateInput() {
        return Checks.checkFieldName(this.fFieldName);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        try {
            RefactoringStatus refactoringStatus2 = new RefactoringStatus();
            refactoringStatus2.merge(this.checkClashesWithExistingFields());
            if (this.fInitializeIn == 2) {
                refactoringStatus2.merge(this.checkClashesInConstructors());
            }
            refactoringStatus = refactoringStatus2;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkClashesInConstructors() {
        Assert.isTrue((this.fInitializeIn == 2 ? 1 : 0) != 0);
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            MethodDeclaration[] methodDeclarationArray = ((TypeDeclaration)abstractTypeDeclaration).getMethods();
            int n = 0;
            while (n < methodDeclarationArray.length) {
                MethodDeclaration methodDeclaration = methodDeclarationArray[n];
                if (methodDeclaration.isConstructor()) {
                    NameCollector nameCollector = new NameCollector((ASTNode)methodDeclaration){

                        protected boolean visitNode(ASTNode aSTNode) {
                            return true;
                        }
                    };
                    methodDeclaration.accept((ASTVisitor)nameCollector);
                    List list = nameCollector.getNames();
                    if (list.contains(this.fFieldName)) {
                        Object[] objectArray = new String[]{this.fFieldName, BindingLabelProvider.getBindingLabel((IBinding)methodDeclaration.resolveBinding(), JavaElementLabels.ALL_FULLY_QUALIFIED)};
                        String string = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict, objectArray);
                        return RefactoringStatus.createFatalErrorStatus((String)string);
                    }
                }
                ++n;
            }
        }
        return null;
    }

    private RefactoringStatus checkClashesWithExistingFields() {
        FieldDeclaration[] fieldDeclarationArray = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        int n = 0;
        while (n < fieldDeclarationArray.length) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n];
            VariableDeclarationFragment[] variableDeclarationFragmentArray = fieldDeclaration.fragments().toArray(new VariableDeclarationFragment[fieldDeclaration.fragments().size()]);
            int n2 = 0;
            while (n2 < variableDeclarationFragmentArray.length) {
                VariableDeclarationFragment variableDeclarationFragment = variableDeclarationFragmentArray[n2];
                if (this.fFieldName.equals(variableDeclarationFragment.getName().getIdentifier())) {
                    RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)this.fCu, (ASTNode)variableDeclarationFragment);
                    return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.PromoteTempToFieldRefactoring_Name_conflict_with_field, (RefactoringStatusContext)refactoringStatusContext);
                }
                ++n2;
            }
            ++n;
        }
        return null;
    }

    private ChildListPropertyDescriptor getBodyDeclarationListOfDeclaringType() {
        ASTNode aSTNode = this.getMethodDeclaration().getParent();
        if (aSTNode instanceof AbstractTypeDeclaration) {
            return ((AbstractTypeDeclaration)aSTNode).getBodyDeclarationsProperty();
        }
        if (aSTNode instanceof AnonymousClassDeclaration) {
            return AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY;
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private FieldDeclaration[] getFieldDeclarations(ChildListPropertyDescriptor childListPropertyDescriptor) {
        List list = (List)this.getMethodDeclaration().getParent().getStructuralProperty((StructuralPropertyDescriptor)childListPropertyDescriptor);
        ArrayList arrayList = new ArrayList(1);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof FieldDeclaration)) continue;
            arrayList.add(e);
        }
        return arrayList.toArray(new FieldDeclaration[arrayList.size()]);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        Change change;
        iProgressMonitor.beginTask("", 1);
        try {
            if (this.fFieldName.length() == 0) {
                this.fFieldName = this.getInitialFieldName();
            }
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)this.fCompilationUnitNode.getAST());
            if (this.fInitializeIn == 1 && this.tempHasInitializer()) {
                this.addLocalDeclarationSplit(aSTRewrite);
            } else {
                this.addLocalDeclarationRemoval(aSTRewrite);
            }
            if (this.fInitializeIn == 2) {
                this.addInitializersToConstructors(aSTRewrite);
            }
            this.addTempRenames(aSTRewrite);
            this.addFieldDeclaration(aSTRewrite);
            change = this.createChange(aSTRewrite);
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return change;
    }

    private void addTempRenames(ASTRewrite aSTRewrite) {
        boolean bl = this.fFieldName.equals(this.fTempDeclarationNode.getName().getIdentifier());
        if (this.fLinkedProposalModel == null && bl) {
            return;
        }
        TempOccurrenceAnalyzer tempOccurrenceAnalyzer = new TempOccurrenceAnalyzer(this.fTempDeclarationNode, false);
        tempOccurrenceAnalyzer.perform();
        SimpleName[] simpleNameArray = tempOccurrenceAnalyzer.getReferenceNodes();
        int n = 0;
        while (n < simpleNameArray.length) {
            SimpleName simpleName = simpleNameArray[n];
            if (bl) {
                this.addLinkedName(aSTRewrite, simpleName, false);
            } else {
                SimpleName simpleName2 = this.getAST().newSimpleName(this.fFieldName);
                this.addLinkedName(aSTRewrite, simpleName2, false);
                aSTRewrite.replace((ASTNode)simpleName, (ASTNode)simpleName2, null);
            }
            ++n;
        }
    }

    private void addInitializersToConstructors(ASTRewrite aSTRewrite) throws CoreException {
        Assert.isTrue((!this.isDeclaredInAnonymousClass() ? 1 : 0) != 0);
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)this.getMethodDeclaration().getParent();
        MethodDeclaration[] methodDeclarationArray = PromoteTempToFieldRefactoring.getAllConstructors(abstractTypeDeclaration);
        if (methodDeclarationArray.length == 0) {
            AST aST = aSTRewrite.getAST();
            MethodDeclaration methodDeclaration = aST.newMethodDeclaration();
            methodDeclaration.setConstructor(true);
            methodDeclaration.modifiers().addAll(aST.newModifiers(abstractTypeDeclaration.getModifiers() & 7));
            methodDeclaration.setName(aST.newSimpleName(abstractTypeDeclaration.getName().getIdentifier()));
            methodDeclaration.setJavadoc(this.getNewConstructorComment(aSTRewrite));
            methodDeclaration.setBody(aST.newBlock());
            this.addFieldInitializationToConstructor(aSTRewrite, methodDeclaration);
            int n = this.computeInsertIndexForNewConstructor(abstractTypeDeclaration);
            aSTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty()).insertAt((ASTNode)methodDeclaration, n, null);
        } else {
            int n = 0;
            while (n < methodDeclarationArray.length) {
                if (PromoteTempToFieldRefactoring.shouldInsertTempInitialization(methodDeclarationArray[n])) {
                    this.addFieldInitializationToConstructor(aSTRewrite, methodDeclarationArray[n]);
                }
                ++n;
            }
        }
    }

    private String getEnclosingTypeName() {
        return this.getEnclosingType().getName().getIdentifier();
    }

    private AbstractTypeDeclaration getEnclosingType() {
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)variableDeclarationStatement, clazz);
    }

    private Javadoc getNewConstructorComment(ASTRewrite aSTRewrite) throws CoreException {
        String string;
        if (StubUtility.doAddComments(this.fCu.getJavaProject()) && (string = CodeGeneration.getMethodComment(this.fCu, this.getEnclosingTypeName(), this.getEnclosingTypeName(), new String[0], new String[0], null, null, StubUtility.getLineDelimiterUsed((IJavaElement)this.fCu))) != null && string.length() > 0) {
            return (Javadoc)aSTRewrite.createStringPlaceholder(string, 29);
        }
        return null;
    }

    private int computeInsertIndexForNewConstructor(AbstractTypeDeclaration abstractTypeDeclaration) {
        List list = abstractTypeDeclaration.bodyDeclarations();
        if (list.isEmpty()) {
            return 0;
        }
        int n = this.findFirstMethodIndex(abstractTypeDeclaration);
        if (n == -1) {
            return list.size();
        }
        return n;
    }

    private int findFirstMethodIndex(AbstractTypeDeclaration abstractTypeDeclaration) {
        int n = 0;
        int n2 = abstractTypeDeclaration.bodyDeclarations().size();
        while (n < n2) {
            if (abstractTypeDeclaration.bodyDeclarations().get(n) instanceof MethodDeclaration) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void addFieldInitializationToConstructor(ASTRewrite aSTRewrite, MethodDeclaration methodDeclaration) throws JavaModelException {
        if (methodDeclaration.getBody() == null) {
            methodDeclaration.setBody(this.getAST().newBlock());
        }
        ExpressionStatement expressionStatement = this.createExpressionStatementThatInitializesField(aSTRewrite);
        aSTRewrite.getListRewrite((ASTNode)methodDeclaration.getBody(), Block.STATEMENTS_PROPERTY).insertLast((ASTNode)expressionStatement, null);
    }

    private static boolean shouldInsertTempInitialization(MethodDeclaration methodDeclaration) {
        Assert.isTrue((boolean)methodDeclaration.isConstructor());
        if (methodDeclaration.getBody() == null) {
            return false;
        }
        List list = methodDeclaration.getBody().statements();
        if (list == null) {
            return false;
        }
        return list.size() <= 0 || !(list.get(0) instanceof ConstructorInvocation);
    }

    private static MethodDeclaration[] getAllConstructors(AbstractTypeDeclaration abstractTypeDeclaration) {
        if (abstractTypeDeclaration instanceof TypeDeclaration) {
            MethodDeclaration[] methodDeclarationArray = ((TypeDeclaration)abstractTypeDeclaration).getMethods();
            ArrayList<MethodDeclaration> arrayList = new ArrayList<MethodDeclaration>(Math.min(methodDeclarationArray.length, 1));
            int n = 0;
            while (n < methodDeclarationArray.length) {
                MethodDeclaration methodDeclaration = methodDeclarationArray[n];
                if (methodDeclaration.isConstructor()) {
                    arrayList.add(methodDeclaration);
                }
                ++n;
            }
            return arrayList.toArray(new MethodDeclaration[arrayList.size()]);
        }
        return new MethodDeclaration[0];
    }

    private Change createChange(ASTRewrite aSTRewrite) throws CoreException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fCu.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        IVariableBinding iVariableBinding = this.fTempDeclarationNode.resolveBinding();
        String string2 = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_descriptor_description_short, iVariableBinding.getName());
        String string3 = Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)iVariableBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)iVariableBinding.getDeclaringMethod(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)iVariableBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_field_pattern, this.fFieldName));
        switch (this.fInitializeIn) {
            case 2: {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_constructor);
                break;
            }
            case 0: {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_declaration);
                break;
            }
            case 1: {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_initialize_method);
            }
        }
        String string4 = JdtFlags.getVisibilityString(this.fVisibility);
        if ("".equals(string4)) {
            string4 = RefactoringCoreMessages.PromoteTempToFieldRefactoring_default_visibility;
        }
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.PromoteTempToFieldRefactoring_visibility_pattern, string4));
        if (this.fDeclareFinal && this.fDeclareStatic) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_final_static);
        } else if (this.fDeclareFinal) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_final);
        } else if (this.fDeclareStatic) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.PromoteTempToFieldRefactoring_declare_static);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.promote.temp", string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, 2);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fCu));
        hashMap.put(LINKED_NAME, this.fFieldName);
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        hashMap.put(ATTRIBUTE_STATIC, Boolean.valueOf(this.fDeclareStatic).toString());
        hashMap.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fDeclareFinal).toString());
        hashMap.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        hashMap.put(ATTRIBUTE_INITIALIZE, new Integer(this.fInitializeIn).toString());
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(RefactoringCoreMessages.PromoteTempToFieldRefactoring_name, this.fCu);
        compilationUnitChange.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)jDTRefactoringDescriptor));
        TextEdit textEdit = aSTRewrite.rewriteAST();
        TextChangeCompatibility.addTextEdit((TextChange)compilationUnitChange, RefactoringCoreMessages.PromoteTempToFieldRefactoring_editName, textEdit);
        return compilationUnitChange;
    }

    private void addLocalDeclarationSplit(ASTRewrite aSTRewrite) throws JavaModelException {
        VariableDeclarationFragment variableDeclarationFragment;
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        Block block = (Block)variableDeclarationStatement.getParent();
        int n = block.statements().indexOf(variableDeclarationStatement);
        Assert.isTrue((n != -1 ? 1 : 0) != 0);
        List list = variableDeclarationStatement.fragments();
        int n2 = list.indexOf(this.fTempDeclarationNode);
        Assert.isTrue((n2 != -1 ? 1 : 0) != 0);
        int n3 = n2;
        int n4 = list.size();
        while (n3 < n4) {
            variableDeclarationFragment = (VariableDeclarationFragment)list.get(n3);
            aSTRewrite.remove((ASTNode)variableDeclarationFragment, null);
            ++n3;
        }
        if (n2 == 0) {
            aSTRewrite.remove((ASTNode)variableDeclarationStatement, null);
        }
        Assert.isTrue((boolean)this.tempHasInitializer());
        aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)this.createExpressionStatementThatInitializesField(aSTRewrite), n + 1, null);
        if (n2 + 1 < list.size()) {
            ASTNode aSTNode;
            ASTNode aSTNode2;
            VariableDeclarationFragment variableDeclarationFragment2 = (VariableDeclarationFragment)list.get(n2 + 1);
            VariableDeclarationFragment variableDeclarationFragment3 = (VariableDeclarationFragment)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationFragment2);
            variableDeclarationFragment = this.getAST().newVariableDeclarationStatement(variableDeclarationFragment3);
            Type type = (Type)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationStatement.getType());
            variableDeclarationFragment.setType(type);
            List list2 = variableDeclarationStatement.modifiers();
            if (list2.size() > 0) {
                ListRewrite listRewrite = aSTRewrite.getListRewrite((ASTNode)variableDeclarationStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                aSTNode2 = (ASTNode)list2.get(0);
                aSTNode = (ASTNode)list2.get(list2.size() - 1);
                ASTNode aSTNode3 = listRewrite.createCopyTarget(aSTNode2, aSTNode);
                variableDeclarationFragment.modifiers().add(aSTNode3);
            }
            int n5 = n2 + 2;
            while (n5 < list.size()) {
                aSTNode2 = (VariableDeclarationFragment)list.get(n5);
                aSTNode = (VariableDeclarationFragment)aSTRewrite.createCopyTarget(aSTNode2);
                variableDeclarationFragment.fragments().add(aSTNode);
                ++n5;
            }
            aSTRewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)variableDeclarationFragment, n + 2, null);
        }
    }

    private ExpressionStatement createExpressionStatementThatInitializesField(ASTRewrite aSTRewrite) throws JavaModelException {
        AST aST = this.getAST();
        Assignment assignment = aST.newAssignment();
        SimpleName simpleName = aST.newSimpleName(this.fFieldName);
        this.addLinkedName(aSTRewrite, simpleName, true);
        assignment.setLeftHandSide((Expression)simpleName);
        assignment.setRightHandSide(this.getTempInitializerCopy(aSTRewrite));
        return aST.newExpressionStatement((Expression)assignment);
    }

    private void addLinkedName(ASTRewrite aSTRewrite, SimpleName simpleName, boolean bl) {
        if (this.fLinkedProposalModel != null) {
            this.fLinkedProposalModel.getPositionGroup(LINKED_NAME, true).addPosition(aSTRewrite.track((ASTNode)simpleName), bl);
        }
    }

    private Expression getTempInitializerCopy(ASTRewrite aSTRewrite) throws JavaModelException {
        Expression expression = (Expression)aSTRewrite.createCopyTarget((ASTNode)this.getTempInitializer());
        if (expression instanceof ArrayInitializer && ASTNodes.getDimensions(this.fTempDeclarationNode) > 0) {
            ArrayCreation arrayCreation = aSTRewrite.getAST().newArrayCreation();
            arrayCreation.setType((ArrayType)ASTNodeFactory.newType(aSTRewrite.getAST(), this.fTempDeclarationNode));
            arrayCreation.setInitializer((ArrayInitializer)expression);
            return arrayCreation;
        }
        return expression;
    }

    private void addLocalDeclarationRemoval(ASTRewrite aSTRewrite) {
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        List list = variableDeclarationStatement.fragments();
        int n = list.indexOf(this.fTempDeclarationNode);
        Assert.isTrue((n != -1 ? 1 : 0) != 0);
        VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)list.get(n);
        aSTRewrite.remove((ASTNode)variableDeclarationFragment, null);
        if (list.size() == 1) {
            aSTRewrite.remove((ASTNode)variableDeclarationStatement, null);
        }
    }

    private void addFieldDeclaration(ASTRewrite aSTRewrite) {
        ChildListPropertyDescriptor childListPropertyDescriptor = this.getBodyDeclarationListOfDeclaringType();
        FieldDeclaration[] fieldDeclarationArray = this.getFieldDeclarations(this.getBodyDeclarationListOfDeclaringType());
        ASTNode aSTNode = this.getMethodDeclaration().getParent();
        int n = fieldDeclarationArray.length == 0 ? 0 : ((List)aSTNode.getStructuralProperty((StructuralPropertyDescriptor)childListPropertyDescriptor)).indexOf(fieldDeclarationArray[fieldDeclarationArray.length - 1]) + 1;
        FieldDeclaration fieldDeclaration = this.createNewFieldDeclaration(aSTRewrite);
        aSTRewrite.getListRewrite(aSTNode, childListPropertyDescriptor).insertAt((ASTNode)fieldDeclaration, n, null);
    }

    private FieldDeclaration createNewFieldDeclaration(ASTRewrite aSTRewrite) {
        FieldDeclaration fieldDeclaration;
        AST aST = this.getAST();
        VariableDeclarationFragment variableDeclarationFragment = aST.newVariableDeclarationFragment();
        SimpleName simpleName = aST.newSimpleName(this.fFieldName);
        variableDeclarationFragment.setName(simpleName);
        this.addLinkedName(aSTRewrite, simpleName, false);
        variableDeclarationFragment.setExtraDimensions(this.fTempDeclarationNode.getExtraDimensions());
        if (this.fInitializeIn == 0 && this.tempHasInitializer()) {
            fieldDeclaration = (Expression)aSTRewrite.createCopyTarget((ASTNode)this.getTempInitializer());
            variableDeclarationFragment.setInitializer((Expression)fieldDeclaration);
        }
        fieldDeclaration = aST.newFieldDeclaration(variableDeclarationFragment);
        VariableDeclarationStatement variableDeclarationStatement = this.getTempDeclarationStatement();
        Type type = (Type)aSTRewrite.createCopyTarget((ASTNode)variableDeclarationStatement.getType());
        fieldDeclaration.setType(type);
        fieldDeclaration.modifiers().addAll(ASTNodeFactory.newModifiers(aST, this.getModifiers()));
        return fieldDeclaration;
    }

    private int getModifiers() {
        int n = this.fVisibility;
        if (this.fDeclareFinal) {
            n |= 0x10;
        }
        if (this.fDeclareStatic) {
            n |= 8;
        }
        return n;
    }

    private AST getAST() {
        return this.fTempDeclarationNode.getAST();
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        String string;
        this.fSelfInitializing = true;
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            String string2;
            Object object;
            Object object2;
            int n;
            int n2;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string3 = javaRefactoringArguments.getAttribute("selection");
            if (string3 != null) {
                n2 = -1;
                n = -1;
                object2 = new StringTokenizer(string3);
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    n2 = Integer.valueOf(((StringTokenizer)object2).nextToken());
                }
                if (((StringTokenizer)object2).hasMoreTokens()) {
                    n = Integer.valueOf(((StringTokenizer)object2).nextToken());
                }
                if (n2 < 0 || n < 0) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{string3, "selection"}));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
            }
            this.fSelectionStart = n2;
            this.fSelectionLength = n;
            String string4 = javaRefactoringArguments.getAttribute("input");
            if (string4 != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string4, false);
                if (object == null || !object.exists() || object.getElementType() != 5) {
                    return this.createInputFatalStatus(object, "org.eclipse.wst.jsdt.ui.promote.temp");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fCu = (ICompilationUnit)object;
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_VISIBILITY);
            if (object != null && !"".equals(object)) {
                int n3 = 0;
                try {
                    n3 = Integer.parseInt((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
                }
                this.fVisibility = n3;
            }
            if ((object2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_INITIALIZE)) != null && !"".equals(object2)) {
                int n4 = 0;
                try {
                    n4 = Integer.parseInt((String)object2);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_INITIALIZE));
                }
                this.fInitializeIn = n4;
            }
            if ((string2 = javaRefactoringArguments.getAttribute(LINKED_NAME)) == null || "".equals(string2)) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, LINKED_NAME));
            }
            this.fFieldName = string2;
            String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_STATIC);
            if (string5 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_STATIC));
            }
            this.fDeclareStatic = Boolean.valueOf(string5);
            string = javaRefactoringArguments.getAttribute(ATTRIBUTE_FINAL);
            if (string == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fDeclareFinal = Boolean.valueOf(string);
        return new RefactoringStatus();
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    private static class LocalTypeAndVariableUsageAnalyzer
    extends HierarchicalASTVisitor {
        private final List fLocalDefinitions = new ArrayList(0);
        private final List fLocalReferencesToEnclosing = new ArrayList(0);
        private final List fMethodTypeVariables;
        private boolean fClassTypeVariablesUsed = false;

        public LocalTypeAndVariableUsageAnalyzer(ITypeBinding[] iTypeBindingArray) {
            this.fMethodTypeVariables = Arrays.asList(iTypeBindingArray);
        }

        public List getUsageOfEnclosingNodes() {
            return this.fLocalReferencesToEnclosing;
        }

        public boolean getClassTypeVariablesUsed() {
            return this.fClassTypeVariablesUsed;
        }

        public boolean visit(SimpleName simpleName) {
            IBinding iBinding;
            ITypeBinding iTypeBinding = simpleName.resolveTypeBinding();
            if (iTypeBinding != null && iTypeBinding.isLocal()) {
                if (simpleName.isDeclaration()) {
                    this.fLocalDefinitions.add(iTypeBinding);
                } else if (!this.fLocalDefinitions.contains(iTypeBinding)) {
                    this.fLocalReferencesToEnclosing.add(simpleName);
                }
            }
            if (iTypeBinding != null && iTypeBinding.isTypeVariable()) {
                if (simpleName.isDeclaration()) {
                    this.fLocalDefinitions.add(iTypeBinding);
                } else if (!this.fLocalDefinitions.contains(iTypeBinding)) {
                    if (this.fMethodTypeVariables.contains(iTypeBinding)) {
                        this.fLocalReferencesToEnclosing.add(simpleName);
                    } else {
                        this.fClassTypeVariablesUsed = true;
                    }
                }
            }
            if ((iBinding = simpleName.resolveBinding()) != null && iBinding.getKind() == 3 && !((IVariableBinding)iBinding).isField()) {
                if (simpleName.isDeclaration()) {
                    this.fLocalDefinitions.add(iBinding);
                } else if (!this.fLocalDefinitions.contains(iBinding)) {
                    this.fLocalReferencesToEnclosing.add(simpleName);
                }
            }
            return super.visit(simpleName);
        }
    }
}

