/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.binary.StubCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public class ReplaceInvocationsRefactoring
extends ScriptableRefactoring {
    private static final String ID_REPLACE_INVOCATIONS = "org.eclipse.wst.jsdt.ui.replace.invocations";
    private static final String ATTRIBUTE_MODE = "mode";
    private final ITypeRoot fSelectionTypeRoot;
    private final int fSelectionStart;
    private final int fSelectionLength;
    private ASTNode fSelectionNode;
    private IMethod fMethod;
    private String fBody;
    private String[] fParameterNames;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private TextChangeManager fChangeManager;
    private IMethodBinding fMethodBinding;

    public ReplaceInvocationsRefactoring(ITypeRoot iTypeRoot, int n, int n2) {
        this.fSelectionTypeRoot = iTypeRoot;
        this.fSelectionStart = n;
        this.fSelectionLength = n2;
    }

    public ReplaceInvocationsRefactoring(IMethod iMethod) {
        this.fMethod = iMethod;
        this.fSelectionTypeRoot = iMethod.getTypeRoot();
        this.fSelectionStart = -1;
        this.fSelectionLength = -1;
    }

    public String getName() {
        return RefactoringCoreMessages.ReplaceInvocationsRefactoring_name;
    }

    public boolean canReplaceSingle() {
        return this.fSelectionNode instanceof MethodInvocation;
    }

    public RefactoringStatus setCurrentMode(Mode mode) throws JavaModelException {
        if (this.fTargetProvider.isSingle() == (mode == Mode.REPLACE_SINGLE)) {
            return new RefactoringStatus();
        }
        Assert.isTrue((boolean)this.canReplaceSingle());
        this.fTargetProvider = mode == Mode.REPLACE_SINGLE ? TargetProvider.create((ICompilationUnit)this.fSelectionTypeRoot, (MethodInvocation)this.fSelectionNode) : TargetProvider.create(this.fSourceProvider.getDeclaration());
        return this.fTargetProvider.checkActivation();
    }

    public void setBody(String string, String[] stringArray) {
        this.fBody = string;
        this.fParameterNames = stringArray;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fMethod == null) {
            if (!(this.fSelectionTypeRoot instanceof ICompilationUnit)) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReplaceInvocationsRefactoring_cannot_replace_in_binary);
            }
            ICompilationUnit iCompilationUnit = (ICompilationUnit)this.fSelectionTypeRoot;
            CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, true);
            this.fSelectionNode = ReplaceInvocationsRefactoring.getTargetNode(iCompilationUnit, compilationUnit, this.fSelectionStart, this.fSelectionLength);
            if (this.fSelectionNode == null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.ReplaceInvocationsRefactoring_select_method_to_apply);
            }
            if (this.fSelectionNode.getNodeType() == 31) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)this.fSelectionNode;
                this.fTargetProvider = TargetProvider.create(methodDeclaration);
                this.fMethodBinding = methodDeclaration.resolveBinding();
            } else {
                MethodInvocation methodInvocation = (MethodInvocation)this.fSelectionNode;
                this.fTargetProvider = TargetProvider.create(iCompilationUnit, methodInvocation);
                this.fMethodBinding = methodInvocation.resolveMethodBinding();
            }
            if (this.fMethodBinding == null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            }
            this.fMethod = (IMethod)this.fMethodBinding.getJavaElement();
        } else {
            ASTParser aSTParser = ASTParser.newParser((int)3);
            aSTParser.setProject(this.fMethod.getJavaProject());
            IBinding[] iBindingArray = aSTParser.createBindings(new IJavaElement[]{this.fMethod}, null);
            this.fMethodBinding = (IMethodBinding)iBindingArray[0];
            if (this.fMethodBinding == null) {
                return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            }
            this.fTargetProvider = TargetProvider.create(this.fMethodBinding);
        }
        refactoringStatus.merge(this.fTargetProvider.checkActivation());
        return refactoringStatus;
    }

    private SourceProvider resolveSourceProvider(IMethodBinding iMethodBinding, RefactoringStatus refactoringStatus) throws JavaModelException {
        CompilationUnit compilationUnit;
        Document document;
        IClassFile iClassFile;
        ICompilationUnit iCompilationUnit;
        final IMethod iMethod = (IMethod)iMethodBinding.getJavaElement();
        ICompilationUnit iCompilationUnit2 = iMethod.getCompilationUnit();
        if (iCompilationUnit2 != null) {
            SingleVariableDeclaration singleVariableDeclaration;
            iCompilationUnit = iCompilationUnit2;
            iClassFile = ASTParser.newParser((int)3);
            iClassFile.setSource(iCompilationUnit2);
            iClassFile.setFocalPosition(iMethod.getNameRange().getOffset());
            CompilationUnit compilationUnit2 = (CompilationUnit)iClassFile.createAST(null);
            MethodDeclaration methodDeclaration = (MethodDeclaration)NodeFinder.perform((ASTNode)compilationUnit2, iMethod.getNameRange()).getParent();
            AST aST = compilationUnit2.getAST();
            ASTRewrite aSTRewrite = ASTRewrite.create((AST)aST);
            Block block = aST.newBlock();
            block.statements().add(aSTRewrite.createStringPlaceholder(this.fBody, 20));
            aSTRewrite.replace((ASTNode)methodDeclaration.getBody(), (ASTNode)block, null);
            List list = methodDeclaration.parameters();
            int n = 0;
            while (n < list.size()) {
                singleVariableDeclaration = (SingleVariableDeclaration)list.get(n);
                aSTRewrite.set((ASTNode)singleVariableDeclaration.getName(), (StructuralPropertyDescriptor)SimpleName.IDENTIFIER_PROPERTY, (Object)this.fParameterNames[n], null);
                ++n;
            }
            TextEdit textEdit = aSTRewrite.rewriteAST();
            singleVariableDeclaration = new Document(iCompilationUnit2.getBuffer().getContents());
            try {
                textEdit.apply((IDocument)singleVariableDeclaration);
            }
            catch (MalformedTreeException malformedTreeException) {
                JavaPlugin.log(malformedTreeException);
            }
            catch (BadLocationException badLocationException) {
                JavaPlugin.log(badLocationException);
            }
            document = singleVariableDeclaration;
            compilationUnit = new RefactoringASTParser(3).parse(document.get(), iCompilationUnit2, true, true, null);
        } else {
            iClassFile = iMethod.getClassFile();
            StubCreator stubCreator = new StubCreator(true){

                protected void appendMethodBody(IMethod iMethod2) throws JavaModelException {
                    if (iMethod2.equals(iMethod)) {
                        this.fBuffer.append(ReplaceInvocationsRefactoring.this.fBody);
                    } else {
                        super.appendMethodBody(iMethod2);
                    }
                }

                protected void appendMethodParameterName(IMethod iMethod2, int n) {
                    if (iMethod2.equals(iMethod)) {
                        this.fBuffer.append(ReplaceInvocationsRefactoring.this.fParameterNames[n]);
                    } else {
                        super.appendMethodParameterName(iMethod2, n);
                    }
                }
            };
            String string = stubCreator.createStub(iClassFile.getType(), null);
            document = new Document(string);
            compilationUnit = new RefactoringASTParser(3).parse(string, iClassFile, true, true, null);
            iCompilationUnit = iClassFile;
        }
        iClassFile = compilationUnit.findDeclaringNode(iMethodBinding.getKey());
        if (iClassFile instanceof MethodDeclaration) {
            return new SourceProvider((ITypeRoot)iCompilationUnit, (IDocument)document, (MethodDeclaration)iClassFile);
        }
        refactoringStatus.addFatalError(RefactoringCoreMessages.ReplaceInvocationsRefactoring_cannot_find_method_declaration);
        return null;
    }

    private static ASTNode getTargetNode(ICompilationUnit iCompilationUnit, CompilationUnit compilationUnit, int n, int n2) {
        ASTNode aSTNode = null;
        try {
            aSTNode = ReplaceInvocationsRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2, (ITypeRoot)iCompilationUnit), iCompilationUnit);
        }
        catch (JavaModelException javaModelException) {}
        if (aSTNode != null) {
            return aSTNode;
        }
        return ReplaceInvocationsRefactoring.checkNode(NodeFinder.perform((ASTNode)compilationUnit, n, n2), iCompilationUnit);
    }

    private static ASTNode checkNode(ASTNode aSTNode, ICompilationUnit iCompilationUnit) {
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getNodeType() == 42) {
            aSTNode = aSTNode.getParent();
        } else if (aSTNode.getNodeType() == 21) {
            aSTNode = ((ExpressionStatement)aSTNode).getExpression();
        }
        switch (aSTNode.getNodeType()) {
            case 31: 
            case 32: {
                return aSTNode;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask("", 20);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fSourceProvider = this.resolveSourceProvider(this.fMethodBinding, refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(this.fSourceProvider.checkActivation());
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        iProgressMonitor.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus refactoringStatus2 = new RefactoringStatus();
        ICompilationUnit[] iCompilationUnitArray = this.fTargetProvider.getAffectedCompilationUnits(refactoringStatus2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        if (refactoringStatus2.hasFatalError()) {
            refactoringStatus.merge(refactoringStatus2);
            return refactoringStatus;
        }
        IFile[] iFileArray = this.getFilesToBeModified(iCompilationUnitArray);
        refactoringStatus.merge(Checks.validateModifiesFiles(iFileArray, this.getValidationContext()));
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])iFileArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        this.checkOverridden(refactoringStatus, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 4));
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 15);
        subProgressMonitor.beginTask("", iCompilationUnitArray.length * 3);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            block19: {
                Object var21_22;
                ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
                subProgressMonitor.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, iCompilationUnit.getElementName()));
                CallInliner callInliner = null;
                try {
                    BodyDeclaration bodyDeclaration;
                    boolean bl = false;
                    MultiTextEdit multiTextEdit = new MultiTextEdit();
                    CompilationUnitChange compilationUnitChange = (CompilationUnitChange)this.fChangeManager.get(iCompilationUnit);
                    compilationUnitChange.setEdit((TextEdit)multiTextEdit);
                    BodyDeclaration[] bodyDeclarationArray = this.fTargetProvider.getAffectedBodyDeclarations(iCompilationUnit, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                    if (bodyDeclarationArray.length == 0) {
                        var21_22 = null;
                        if (callInliner != null) {
                            callInliner.dispose();
                        }
                        break block19;
                    }
                    callInliner = new CallInliner(iCompilationUnit, (CompilationUnit)bodyDeclarationArray[0].getRoot(), this.fSourceProvider);
                    int n2 = 0;
                    while (n2 < bodyDeclarationArray.length) {
                        bodyDeclaration = bodyDeclarationArray[n2];
                        callInliner.initialize(bodyDeclaration);
                        RefactoringStatus refactoringStatus3 = new RefactoringStatus();
                        ASTNode[] aSTNodeArray = this.removeNestedCalls(refactoringStatus3, iCompilationUnit, this.fTargetProvider.getInvocations(bodyDeclaration, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 2)));
                        int n3 = 0;
                        while (n3 < aSTNodeArray.length) {
                            ASTNode aSTNode = aSTNodeArray[n3];
                            refactoringStatus.merge(callInliner.initialize(aSTNode, this.fTargetProvider.getStatusSeverity()));
                            if (refactoringStatus.hasFatalError()) break;
                            if (refactoringStatus.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                bl = true;
                                TextEditGroup textEditGroup = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_inline);
                                compilationUnitChange.addTextEditGroup(textEditGroup);
                                refactoringStatus.merge(callInliner.perform(textEditGroup));
                            }
                            ++n3;
                        }
                        refactoringStatus.merge(refactoringStatus3);
                        ++n2;
                    }
                    if (!bl) {
                        this.fChangeManager.remove(iCompilationUnit);
                    } else {
                        multiTextEdit.addChild(callInliner.getModifications());
                        ImportRewrite importRewrite = callInliner.getImportEdit();
                        if (importRewrite.hasRecordedChanges() && (!((bodyDeclaration = importRewrite.rewriteImports(null)) instanceof MultiTextEdit) || ((MultiTextEdit)bodyDeclaration).getChildrenSize() > 0)) {
                            multiTextEdit.addChild((TextEdit)bodyDeclaration);
                            compilationUnitChange.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_import, new TextEdit[]{bodyDeclaration}));
                        }
                    }
                    var21_22 = null;
                    if (callInliner != null) {
                        callInliner.dispose();
                    }
                }
                catch (Throwable throwable) {
                    var21_22 = null;
                    if (callInliner != null) {
                        callInliner.dispose();
                    }
                    throw throwable;
                }
                subProgressMonitor.worked(1);
                if (subProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
        refactoringStatus.merge(refactoringStatus2);
        subProgressMonitor.done();
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string = null;
        IJavaProject iJavaProject = this.fSelectionTypeRoot.getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        IMethodBinding iMethodBinding = this.fSourceProvider.getDeclaration().resolveBinding();
        int n = 786434;
        if (!Modifier.isPrivate((int)iMethodBinding.getModifiers())) {
            n |= 4;
        }
        String string2 = Messages.format(RefactoringCoreMessages.ReplaceInvocationsRefactoring_descriptor_description_short, iMethodBinding.getName());
        String string3 = Messages.format(RefactoringCoreMessages.ReplaceInvocationsRefactoring_descriptor_description, new String[]{BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, JavaElementLabels.ALL_FULLY_QUALIFIED), BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding.getDeclaringClass(), JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string3);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.ReplaceInvocationsRefactoring_original_pattern, BindingLabelProvider.getBindingLabel((IBinding)iMethodBinding, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        if (!this.fTargetProvider.isSingle()) {
            jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.ReplaceInvocationsRefactoring_replace_references);
        }
        JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor(ID_REPLACE_INVOCATIONS, string, string2, jDTRefactoringDescriptorComment.asString(), hashMap, n);
        hashMap.put("input", jDTRefactoringDescriptor.elementToHandle((IJavaElement)this.fSelectionTypeRoot));
        hashMap.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        hashMap.put(ATTRIBUTE_MODE, new Integer(this.fTargetProvider.isSingle() ? 0 : 1).toString());
        return new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.ReplaceInvocationsRefactoring_change_name, (Change[])this.fChangeManager.getAllChanges());
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] iCompilationUnitArray) {
        ArrayList<IFile> arrayList = new ArrayList<IFile>(iCompilationUnitArray.length + 1);
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            IFile iFile = this.getFile(iCompilationUnitArray[n]);
            if (iFile != null) {
                arrayList.add(iFile);
            }
            ++n;
        }
        return arrayList.toArray(new IFile[arrayList.size()]);
    }

    private IFile getFile(ICompilationUnit iCompilationUnit) {
        IResource iResource = (iCompilationUnit = iCompilationUnit.getPrimary()).getResource();
        if (iResource != null && iResource.getType() == 1) {
            return (IFile)iResource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask("", 9);
        iProgressMonitor.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden);
        MethodDeclaration methodDeclaration = this.fSourceProvider.getDeclaration();
        IMethod iMethod = (IMethod)methodDeclaration.resolveBinding().getJavaElement();
        if (iMethod == null || Flags.isPrivate((int)iMethod.getFlags())) {
            iProgressMonitor.worked(8);
            return;
        }
        IType iType = iMethod.getDeclaringType();
        ITypeHierarchy iTypeHierarchy = iType.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 6));
        this.checkSubTypes(refactoringStatus, iMethod, iTypeHierarchy.getAllSubtypes(iType), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.checkSuperClasses(refactoringStatus, iMethod, iTypeHierarchy.getAllSuperclasses(iType), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        this.checkSuperInterfaces(refactoringStatus, iMethod, iTypeHierarchy.getAllSuperInterfaces(iType), (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        this.checkTypes(refactoringStatus, iMethod, iTypeArray, RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden_error, iProgressMonitor);
    }

    private void checkSuperClasses(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        this.checkTypes(refactoringStatus, iMethod, iTypeArray, RefactoringCoreMessages.InlineMethodRefactoring_checking_overrides_error, iProgressMonitor);
    }

    private void checkSuperInterfaces(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, IProgressMonitor iProgressMonitor) {
        this.checkTypes(refactoringStatus, iMethod, iTypeArray, RefactoringCoreMessages.InlineMethodRefactoring_checking_implements_error, iProgressMonitor);
    }

    private void checkTypes(RefactoringStatus refactoringStatus, IMethod iMethod, IType[] iTypeArray, String string, IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask("", iTypeArray.length);
        int n = 0;
        while (n < iTypeArray.length) {
            iProgressMonitor.worked(1);
            IMethod[] iMethodArray = iTypeArray[n].findMethods(iMethod);
            if (iMethodArray != null && iMethodArray.length > 0) {
                refactoringStatus.addError(Messages.format(string, iTypeArray[n].getElementName()), JavaStatusContext.create((IMember)iMethodArray[0]));
            }
            ++n;
        }
    }

    private ASTNode[] removeNestedCalls(RefactoringStatus refactoringStatus, ICompilationUnit iCompilationUnit, ASTNode[] aSTNodeArray) {
        if (aSTNodeArray.length <= 1) {
            return aSTNodeArray;
        }
        ASTNode[] aSTNodeArray2 = new ASTNode[aSTNodeArray.length];
        int n = 0;
        while (n < aSTNodeArray.length) {
            aSTNodeArray2[n] = aSTNodeArray[n].getParent();
            ++n;
        }
        n = 0;
        while (n < aSTNodeArray.length) {
            this.removeNestedCalls(refactoringStatus, iCompilationUnit, aSTNodeArray2, aSTNodeArray, n);
            ++n;
        }
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>();
        int n2 = 0;
        while (n2 < aSTNodeArray.length) {
            if (aSTNodeArray[n2] != null) {
                arrayList.add(aSTNodeArray[n2]);
            }
            ++n2;
        }
        return arrayList.toArray(new ASTNode[arrayList.size()]);
    }

    private void removeNestedCalls(RefactoringStatus refactoringStatus, ICompilationUnit iCompilationUnit, ASTNode[] aSTNodeArray, ASTNode[] aSTNodeArray2, int n) {
        ASTNode aSTNode = aSTNodeArray2[n];
        int n2 = 0;
        while (n2 < aSTNodeArray.length) {
            ASTNode aSTNode2 = aSTNodeArray[n2];
            while (aSTNode2 != null) {
                if (aSTNode2 == aSTNode) {
                    refactoringStatus.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation, JavaStatusContext.create((ITypeRoot)iCompilationUnit, aSTNode2));
                    aSTNodeArray2[n] = null;
                }
                aSTNode2 = aSTNode2.getParent();
            }
            ++n2;
        }
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute(ATTRIBUTE_MODE);
            if (string != null && !"".equals(string)) {
                int n = 0;
                try {
                    n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MODE));
                }
                try {
                    this.setCurrentMode(n == 1 ? Mode.REPLACE_ALL : Mode.REPLACE_SINGLE);
                }
                catch (JavaModelException javaModelException) {
                    return RefactoringStatus.createFatalErrorStatus((String)javaModelException.getLocalizedMessage());
                }
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public IMethod getMethod() {
        return this.fMethod;
    }

    public static class Mode {
        public static final Mode REPLACE_ALL = new Mode();
        public static final Mode REPLACE_SINGLE = new Mode();

        private Mode() {
        }
    }
}

