/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.GenericVisitor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSPropertyFileModifier;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSSubstitution;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class AccessorClassModifier {
    private CompilationUnit fRoot;
    private AST fAst;
    private ASTRewrite fASTRewrite;
    private ListRewrite fListRewrite;
    private ICompilationUnit fCU;
    private List fFields;

    private AccessorClassModifier(ICompilationUnit iCompilationUnit) throws CoreException {
        this.fCU = iCompilationUnit;
        this.fRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)iCompilationUnit, ASTProvider.WAIT_YES, null);
        this.fAst = this.fRoot.getAST();
        this.fASTRewrite = ASTRewrite.create((AST)this.fAst);
        AbstractTypeDeclaration abstractTypeDeclaration = null;
        if (this.fRoot.types().size() <= 0) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 10001, NLSMessages.AccessorClassModifier_missingType, null);
            throw new CoreException((IStatus)status);
        }
        abstractTypeDeclaration = (AbstractTypeDeclaration)this.fRoot.types().get(0);
        this.fFields = new ArrayList();
        abstractTypeDeclaration.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(FieldDeclaration fieldDeclaration) {
                int n = fieldDeclaration.getModifiers();
                if (!Modifier.isPublic((int)n)) {
                    return false;
                }
                if (!Modifier.isStatic((int)n)) {
                    return false;
                }
                List list = fieldDeclaration.fragments();
                if (list.size() != 1) {
                    return false;
                }
                VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)list.get(0);
                if (variableDeclarationFragment.getInitializer() != null) {
                    return false;
                }
                AccessorClassModifier.this.fFields.add(fieldDeclaration);
                return false;
            }
        });
        this.fListRewrite = this.fASTRewrite.getListRewrite((ASTNode)abstractTypeDeclaration, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TextEdit getTextEdit() throws CoreException {
        Document document = null;
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        IPath iPath = this.fCU.getPath();
        if (iTextFileBufferManager != null && iPath != null) {
            iTextFileBufferManager.connect(iPath, LocationKind.NORMALIZE, null);
            try {
                ITextFileBuffer iTextFileBuffer = iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.NORMALIZE);
                if (iTextFileBuffer != null) {
                    document = iTextFileBuffer.getDocument();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                iTextFileBufferManager.disconnect(iPath, LocationKind.NORMALIZE, null);
                throw throwable;
            }
            {
                Object var5_7 = null;
            }
            iTextFileBufferManager.disconnect(iPath, LocationKind.NORMALIZE, null);
        }
        if (document == null) {
            document = new Document(this.fCU.getSource());
        }
        return this.fASTRewrite.rewriteAST((IDocument)document, this.fCU.getJavaProject().getOptions(true));
    }

    public static Change create(ICompilationUnit iCompilationUnit, NLSSubstitution[] nLSSubstitutionArray) throws CoreException {
        NLSSubstitution nLSSubstitution;
        HashMap hashMap = NLSPropertyFileModifier.getNewKeyToSubstitutionMap(nLSSubstitutionArray);
        HashMap hashMap2 = NLSPropertyFileModifier.getOldKeyToSubstitutionMap(nLSSubstitutionArray);
        AccessorClassModifier accessorClassModifier = new AccessorClassModifier(iCompilationUnit);
        String string = Messages.format(NLSMessages.NLSSourceModifier_change_description, iCompilationUnit.getElementName());
        CompilationUnitChange compilationUnitChange = new CompilationUnitChange(string, iCompilationUnit);
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        compilationUnitChange.setEdit((TextEdit)multiTextEdit);
        int n = 0;
        while (n < nLSSubstitutionArray.length) {
            nLSSubstitution = nLSSubstitutionArray[n];
            if (NLSPropertyFileModifier.doRemove(nLSSubstitution, hashMap, hashMap2)) {
                accessorClassModifier.removeKey(nLSSubstitution, (TextChange)compilationUnitChange);
            }
            ++n;
        }
        n = 0;
        while (n < nLSSubstitutionArray.length) {
            nLSSubstitution = nLSSubstitutionArray[n];
            if (nLSSubstitution.isKeyRename() && NLSPropertyFileModifier.doReplace(nLSSubstitution, hashMap, hashMap2)) {
                accessorClassModifier.renameKey(nLSSubstitution, (TextChange)compilationUnitChange);
            }
            ++n;
        }
        n = 0;
        while (n < nLSSubstitutionArray.length) {
            nLSSubstitution = nLSSubstitutionArray[n];
            if (NLSPropertyFileModifier.doInsert(nLSSubstitution, hashMap, hashMap2)) {
                accessorClassModifier.addKey(nLSSubstitution, (TextChange)compilationUnitChange);
            }
            ++n;
        }
        if (compilationUnitChange.getChangeGroups().length == 0) {
            return null;
        }
        compilationUnitChange.addEdit(accessorClassModifier.getTextEdit());
        return compilationUnitChange;
    }

    private void removeKey(NLSSubstitution nLSSubstitution, TextChange textChange) throws CoreException {
        ASTNode aSTNode = this.findField((ASTNode)this.fRoot, nLSSubstitution.getKey());
        if (aSTNode == null) {
            return;
        }
        String string = Messages.format(NLSMessages.AccessorClassModifier_remove_entry, nLSSubstitution.getKey());
        TextEditGroup textEditGroup = new TextEditGroup(string);
        this.fListRewrite.remove(aSTNode, textEditGroup);
        textChange.addTextEditGroup(textEditGroup);
        this.fFields.remove(aSTNode);
    }

    private void renameKey(NLSSubstitution nLSSubstitution, TextChange textChange) throws CoreException {
        ASTNode aSTNode = this.findField((ASTNode)this.fRoot, nLSSubstitution.getInitialKey());
        if (aSTNode == null) {
            return;
        }
        String string = Messages.format(NLSMessages.AccessorClassModifier_replace_entry, nLSSubstitution.getKey());
        TextEditGroup textEditGroup = new TextEditGroup(string);
        this.fListRewrite.remove(aSTNode, textEditGroup);
        this.fFields.remove(aSTNode);
        this.addKey(nLSSubstitution, textChange, textEditGroup);
        textChange.addTextEditGroup(textEditGroup);
    }

    private ASTNode findField(ASTNode aSTNode, final String string) {
        class STOP_VISITING
        extends RuntimeException {
            private static final long serialVersionUID = 1L;
            final /* synthetic */ AccessorClassModifier this$0;

            STOP_VISITING(AccessorClassModifier accessorClassModifier) {
                this.this$0 = accessorClassModifier;
            }
        }
        final ASTNode[] aSTNodeArray = new ASTNode[1];
        try {
            aSTNode.accept(new ASTVisitor(){

                public boolean visit(VariableDeclarationFragment variableDeclarationFragment) {
                    if (string.equals(variableDeclarationFragment.getName().getFullyQualifiedName())) {
                        aSTNodeArray[0] = variableDeclarationFragment.getParent();
                        throw new STOP_VISITING(AccessorClassModifier.this);
                    }
                    return true;
                }
            });
        }
        catch (STOP_VISITING sTOP_VISITING) {}
        return aSTNodeArray[0];
    }

    private void addKey(NLSSubstitution nLSSubstitution, TextChange textChange) throws CoreException {
        String string = Messages.format(NLSMessages.AccessorClassModifier_add_entry, nLSSubstitution.getKey());
        TextEditGroup textEditGroup = new TextEditGroup(string);
        textChange.addTextEditGroup(textEditGroup);
        this.addKey(nLSSubstitution, textChange, textEditGroup);
    }

    private void addKey(NLSSubstitution nLSSubstitution, TextChange textChange, TextEditGroup textEditGroup) throws CoreException {
        if (this.fListRewrite == null) {
            return;
        }
        String string = nLSSubstitution.getKey();
        FieldDeclaration fieldDeclaration = this.getNewFinalStringFieldDeclaration(string);
        Iterator iterator = this.fFields.iterator();
        int n = 0;
        if (iterator.hasNext()) {
            FieldDeclaration fieldDeclaration2;
            VariableDeclarationFragment variableDeclarationFragment;
            String string2;
            Collator collator = Collator.getInstance();
            if (collator.compare(string, string2 = (variableDeclarationFragment = (VariableDeclarationFragment)(fieldDeclaration2 = (FieldDeclaration)iterator.next()).fragments().get(0)).getName().getIdentifier()) != 1) {
                n = 0;
                this.fListRewrite.insertBefore((ASTNode)fieldDeclaration, (ASTNode)fieldDeclaration2, textEditGroup);
            } else {
                ++n;
                while (iterator.hasNext()) {
                    FieldDeclaration fieldDeclaration3 = (FieldDeclaration)iterator.next();
                    variableDeclarationFragment = (VariableDeclarationFragment)fieldDeclaration3.fragments().get(0);
                    string2 = variableDeclarationFragment.getName().getIdentifier();
                    if (collator.compare(string, string2) == -1) break;
                    ++n;
                    fieldDeclaration2 = fieldDeclaration3;
                }
                this.fListRewrite.insertAfter((ASTNode)fieldDeclaration, (ASTNode)fieldDeclaration2, textEditGroup);
            }
        } else {
            n = 0;
            this.fListRewrite.insertLast((ASTNode)fieldDeclaration, textEditGroup);
        }
        this.fFields.add(n, fieldDeclaration);
    }

    private FieldDeclaration getNewFinalStringFieldDeclaration(String string) {
        VariableDeclarationFragment variableDeclarationFragment = this.fAst.newVariableDeclarationFragment();
        variableDeclarationFragment.setName(this.fAst.newSimpleName(string));
        FieldDeclaration fieldDeclaration = this.fAst.newFieldDeclaration(variableDeclarationFragment);
        fieldDeclaration.setType((Type)this.fAst.newSimpleType((Name)this.fAst.newSimpleName("String")));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        fieldDeclaration.modifiers().add(this.fAst.newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
        return fieldDeclaration;
    }
}

