/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.CreateFileChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.changes.NLSChangesMessages;
import org.eclipse.wst.jsdt.internal.corext.util.IOCloser;

public class DeleteFileChange
extends JDTChange {
    private IPath fPath;
    private String fSource;

    public DeleteFileChange(IFile iFile) {
        Assert.isNotNull((Object)iFile, (String)"file");
        this.fPath = iFile.getFullPath().removeFirstSegments(ResourcesPlugin.getWorkspace().getRoot().getFullPath().segmentCount());
    }

    public RefactoringStatus isValid(IProgressMonitor iProgressMonitor) throws CoreException {
        return this.isValid(iProgressMonitor, 3);
    }

    public Change perform(IProgressMonitor iProgressMonitor) throws CoreException {
        CreateFileChange createFileChange;
        try {
            iProgressMonitor.beginTask(NLSChangesMessages.deleteFile_deleting_resource, 1);
            IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
            Assert.isNotNull((Object)iFile);
            Assert.isTrue((boolean)iFile.exists());
            Assert.isTrue((!iFile.isReadOnly() ? 1 : 0) != 0);
            this.fSource = this.getSource(iFile);
            CreateFileChange createFileChange2 = DeleteFileChange.createUndoChange(iFile, this.fPath, iFile.getModificationStamp(), this.fSource);
            iFile.delete(true, true, iProgressMonitor);
            createFileChange = createFileChange2;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return createFileChange;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getSource(IFile iFile) throws CoreException {
        String string = null;
        try {
            string = iFile.getCharset();
        }
        catch (CoreException coreException) {}
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = null;
        InputStream inputStream = null;
        try {
            try {
                inputStream = iFile.getContents();
                bufferedReader = string != null ? new BufferedReader(new InputStreamReader(inputStream, string)) : new BufferedReader(new InputStreamReader(inputStream));
                int n = 0;
                while ((n = bufferedReader.read()) != -1) {
                    stringBuffer.append((char)n);
                }
            }
            catch (IOException iOException) {
                throw new JavaModelException((Throwable)iOException, 985);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                IOCloser.rethrows(bufferedReader, inputStream);
                throw throwable;
            }
            catch (IOException iOException) {
                throw new JavaModelException((Throwable)iOException, 985);
            }
        }
        {
            Object var7_10 = null;
        }
        try {}
        catch (IOException iOException) {
            throw new JavaModelException((Throwable)iOException, 985);
        }
        IOCloser.rethrows(bufferedReader, inputStream);
        return stringBuffer.toString();
    }

    private static CreateFileChange createUndoChange(IFile iFile, IPath iPath, long l, String string) {
        String string2;
        try {
            string2 = iFile.getCharset(false);
        }
        catch (CoreException coreException) {
            string2 = null;
        }
        return new CreateFileChange(iPath, string, string2, l);
    }

    public String getName() {
        return NLSChangesMessages.deleteFile_Delete_File;
    }

    public Object getModifiedElement() {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(this.fPath);
    }
}

