/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.internal.corext.Corext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RippleMethodFinder2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;

public class MethodChecks {
    private MethodChecks() {
    }

    public static boolean isVirtual(IMethod iMethod) throws JavaModelException {
        if (iMethod.isConstructor()) {
            return false;
        }
        if (JdtFlags.isPrivate((IMember)iMethod)) {
            return false;
        }
        if (JdtFlags.isStatic((IMember)iMethod)) {
            return false;
        }
        return iMethod.getDeclaringType() != null;
    }

    public static boolean isVirtual(IMethodBinding iMethodBinding) {
        if (iMethodBinding.isConstructor()) {
            return false;
        }
        if (Modifier.isPrivate((int)iMethodBinding.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic((int)iMethodBinding.getModifiers());
    }

    public static RefactoringStatus checkIfOverridesAnother(IMethod iMethod, ITypeHierarchy iTypeHierarchy) throws JavaModelException {
        IMethod iMethod2 = MethodChecks.overridesAnotherMethod(iMethod, iTypeHierarchy);
        if (iMethod2 == null) {
            return null;
        }
        RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((IMember)iMethod2);
        String string = Messages.format(RefactoringCoreMessages.MethodChecks_overrides, new String[]{JavaElementUtil.createMethodSignature(iMethod2), JavaModelUtil.getFullyQualifiedName(iMethod2.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)string, (RefactoringStatusContext)refactoringStatusContext, (String)Corext.getPluginId(), (int)1, (Object)iMethod2);
    }

    public static RefactoringStatus checkIfComesFromInterface(IMethod iMethod, ITypeHierarchy iTypeHierarchy, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMethod iMethod2 = MethodChecks.isDeclaredInInterface(iMethod, iTypeHierarchy, iProgressMonitor);
        if (iMethod2 == null) {
            return null;
        }
        RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((IMember)iMethod2);
        String string = Messages.format(RefactoringCoreMessages.MethodChecks_implements, new String[]{JavaElementUtil.createMethodSignature(iMethod2), JavaModelUtil.getFullyQualifiedName(iMethod2.getDeclaringType())});
        return RefactoringStatus.createStatus((int)4, (String)string, (RefactoringStatusContext)refactoringStatusContext, (String)Corext.getPluginId(), (int)2, (Object)iMethod2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IMethod isDeclaredInInterface(IMethod iMethod, ITypeHierarchy iTypeHierarchy, IProgressMonitor iProgressMonitor) throws JavaModelException {
        SubProgressMonitor subProgressMonitor;
        block7: {
            IMethod iMethod2;
            block8: {
                Assert.isTrue((boolean)MethodChecks.isVirtual(iMethod));
                subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
                try {
                    IType[] iTypeArray = iTypeHierarchy.getAllClasses();
                    subProgressMonitor.beginTask("", iTypeArray.length);
                    int n = 0;
                    block2: while (true) {
                        if (n >= iTypeArray.length) {
                            break block7;
                        }
                        IType iType = iTypeArray[n];
                        IType[] iTypeArray2 = null;
                        iTypeArray2 = iType.equals(iTypeHierarchy.getType()) ? iTypeHierarchy.getAllSuperInterfaces(iType) : iType.newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1)).getAllSuperInterfaces(iType);
                        int n2 = 0;
                        while (true) {
                            if (n2 >= iTypeArray2.length) {
                                subProgressMonitor.worked(1);
                                ++n;
                                continue block2;
                            }
                            IMethod iMethod3 = Checks.findSimilarMethod(iMethod, iTypeArray2[n2]);
                            if (iMethod3 != null && !iMethod3.equals(iMethod)) {
                                iMethod2 = iMethod3;
                                Object var10_11 = null;
                                break block8;
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_13 = null;
                    subProgressMonitor.done();
                    throw throwable;
                }
            }
            subProgressMonitor.done();
            return iMethod2;
        }
        Object var10_12 = null;
        subProgressMonitor.done();
        return null;
    }

    public static IMethod overridesAnotherMethod(IMethod iMethod, ITypeHierarchy iTypeHierarchy) throws JavaModelException {
        boolean bl;
        MethodOverrideTester methodOverrideTester = new MethodOverrideTester(iMethod.getDeclaringType(), iTypeHierarchy);
        IMethod iMethod2 = methodOverrideTester.findDeclaringMethod(iMethod, true);
        boolean bl2 = bl = iMethod2 != null && !iMethod2.equals(iMethod) && !JdtFlags.isStatic((IMember)iMethod2) && !JdtFlags.isPrivate((IMember)iMethod2);
        if (bl) {
            return iMethod2;
        }
        return null;
    }

    public static IMethod getTopmostMethod(IMethod iMethod, ITypeHierarchy iTypeHierarchy, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IMethod iMethod2;
        Assert.isNotNull((Object)iMethod);
        ITypeHierarchy iTypeHierarchy2 = iTypeHierarchy;
        IMethod iMethod3 = null;
        IType iType = iMethod.getDeclaringType();
        if (iType == null) {
            return iMethod;
        }
        if (!iType.isInterface()) {
            if (iTypeHierarchy2 == null || !iType.equals(iTypeHierarchy2.getType())) {
                iTypeHierarchy2 = iType.newTypeHierarchy(iProgressMonitor);
            }
            if ((iMethod2 = MethodChecks.isDeclaredInInterface(iMethod, iTypeHierarchy2, iProgressMonitor)) != null && !iMethod2.equals(iMethod)) {
                iMethod3 = iMethod2;
            }
        }
        if (iMethod3 == null) {
            if (iTypeHierarchy2 == null) {
                iTypeHierarchy2 = iType.newSupertypeHierarchy(iProgressMonitor);
            }
            if ((iMethod2 = MethodChecks.overridesAnotherMethod(iMethod, iTypeHierarchy2)) != null && !iMethod2.equals(iMethod)) {
                iMethod3 = iMethod2;
            }
        }
        return iMethod3;
    }

    public static IMethod[] getOverriddenMethods(IMethod iMethod, IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)iMethod);
        return RippleMethodFinder2.getRelatedMethods(iMethod, iProgressMonitor, null);
    }
}

