/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.search.FieldDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStringStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RefactoringAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;

class RenameAnalyzeUtil {
    static /* synthetic */ Class class$0;

    private RenameAnalyzeUtil() {
    }

    static RefactoringStatus analyzeRenameChanges(TextChangeManager textChangeManager, SearchResultGroup[] searchResultGroupArray, SearchResultGroup[] searchResultGroupArray2) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    SearchMatch searchMatch = searchMatchArray[n2];
                    if (!RenameAnalyzeUtil.existsInNewOccurrences(searchMatch, searchResultGroupArray2, textChangeManager)) {
                        RenameAnalyzeUtil.addShadowsError(iCompilationUnit, searchMatch, refactoringStatus);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return refactoringStatus;
    }

    static ICompilationUnit findWorkingCopyForCu(ICompilationUnit[] iCompilationUnitArray, ICompilationUnit iCompilationUnit) {
        ICompilationUnit iCompilationUnit2 = iCompilationUnit == null ? null : iCompilationUnit.getPrimary();
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            if (iCompilationUnitArray[n].getPrimary().equals(iCompilationUnit2)) {
                return iCompilationUnitArray[n];
            }
            ++n;
        }
        return null;
    }

    static ICompilationUnit[] createNewWorkingCopies(ICompilationUnit[] iCompilationUnitArray, TextChangeManager textChangeManager, WorkingCopyOwner workingCopyOwner, SubProgressMonitor subProgressMonitor) throws CoreException {
        subProgressMonitor.beginTask("", iCompilationUnitArray.length);
        ICompilationUnit[] iCompilationUnitArray2 = new ICompilationUnit[iCompilationUnitArray.length];
        int n = 0;
        while (n < iCompilationUnitArray.length) {
            ICompilationUnit iCompilationUnit = iCompilationUnitArray[n];
            iCompilationUnitArray2[n] = RenameAnalyzeUtil.createNewWorkingCopy(iCompilationUnit, textChangeManager, workingCopyOwner, new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
            ++n;
        }
        subProgressMonitor.done();
        return iCompilationUnitArray2;
    }

    static ICompilationUnit createNewWorkingCopy(ICompilationUnit iCompilationUnit, TextChangeManager textChangeManager, WorkingCopyOwner workingCopyOwner, SubProgressMonitor subProgressMonitor) throws CoreException {
        ICompilationUnit iCompilationUnit2 = iCompilationUnit.getWorkingCopy(workingCopyOwner, null, null);
        String string = textChangeManager.get(iCompilationUnit).getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        iCompilationUnit2.getBuffer().setContents(string);
        iCompilationUnit2.reconcile(0, false, workingCopyOwner, (IProgressMonitor)subProgressMonitor);
        return iCompilationUnit2;
    }

    private static boolean existsInNewOccurrences(SearchMatch searchMatch, SearchResultGroup[] searchResultGroupArray, TextChangeManager textChangeManager) {
        SearchResultGroup searchResultGroup = RenameAnalyzeUtil.findOccurrenceGroup(searchMatch.getResource(), searchResultGroupArray);
        if (searchResultGroup == null) {
            return false;
        }
        IRegion iRegion = RenameAnalyzeUtil.getCorrespondingEditChangeRange(searchMatch, textChangeManager);
        if (iRegion == null) {
            return false;
        }
        SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
        int n = iRegion.getOffset();
        int n2 = 0;
        while (n2 < searchMatchArray.length) {
            if (searchMatchArray[n2].getOffset() == n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IRegion getCorrespondingEditChangeRange(SearchMatch searchMatch, TextChangeManager textChangeManager) {
        TextChange textChange = RenameAnalyzeUtil.getTextChange(searchMatch, textChangeManager);
        if (textChange == null) {
            return null;
        }
        IRegion iRegion = RenameAnalyzeUtil.createTextRange(searchMatch);
        TextEditChangeGroup[] textEditChangeGroupArray = textChange.getTextEditChangeGroups();
        int n = 0;
        while (n < textEditChangeGroupArray.length) {
            if (iRegion.equals(textEditChangeGroupArray[n].getRegion())) {
                return TextEdit.getCoverage((TextEdit[])textChange.getPreviewEdits(textEditChangeGroupArray[n].getTextEdits()));
            }
            ++n;
        }
        return null;
    }

    private static TextChange getTextChange(SearchMatch searchMatch, TextChangeManager textChangeManager) {
        ICompilationUnit iCompilationUnit = SearchUtils.getCompilationUnit(searchMatch);
        if (iCompilationUnit == null) {
            return null;
        }
        return textChangeManager.get(iCompilationUnit);
    }

    private static IRegion createTextRange(SearchMatch searchMatch) {
        return new Region(searchMatch.getOffset(), searchMatch.getLength());
    }

    private static SearchResultGroup findOccurrenceGroup(IResource iResource, SearchResultGroup[] searchResultGroupArray) {
        int n = 0;
        while (n < searchResultGroupArray.length) {
            if (searchResultGroupArray[n].getResource().equals((Object)iResource)) {
                return searchResultGroupArray[n];
            }
            ++n;
        }
        return null;
    }

    static RefactoringStatus analyzeRenameChanges2(TextChangeManager textChangeManager, SearchResultGroup[] searchResultGroupArray, SearchResultGroup[] searchResultGroupArray2, String string) {
        SearchMatch[] searchMatchArray;
        ICompilationUnit iCompilationUnit;
        Object object;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        HashMap<ICompilationUnit, SearchMatch[]> hashMap = new HashMap<ICompilationUnit, SearchMatch[]>(searchResultGroupArray2.length);
        int n = 0;
        while (n < searchResultGroupArray2.length) {
            object = searchResultGroupArray2[n].getCompilationUnit();
            if (object != null) {
                hashMap.put(object.getPrimary(), searchResultGroupArray2[n].getSearchResults());
            }
            ++n;
        }
        n = 0;
        while (n < searchResultGroupArray.length) {
            object = searchResultGroupArray[n];
            iCompilationUnit = ((SearchResultGroup)object).getSearchResults();
            searchMatchArray = ((SearchResultGroup)object).getCompilationUnit();
            if (searchMatchArray != null) {
                SearchMatch[] searchMatchArray2 = (SearchMatch[])hashMap.remove(searchMatchArray);
                if (searchMatchArray2 == null) {
                    int n2 = 0;
                    while (n2 < ((ICompilationUnit)iCompilationUnit).length) {
                        ICompilationUnit iCompilationUnit2 = iCompilationUnit[n2];
                        RenameAnalyzeUtil.addShadowsError((ICompilationUnit)searchMatchArray, (SearchMatch)iCompilationUnit2, refactoringStatus);
                        ++n2;
                    }
                } else {
                    RenameAnalyzeUtil.analyzeChanges((ICompilationUnit)searchMatchArray, textChangeManager.get((ICompilationUnit)searchMatchArray), (SearchMatch[])iCompilationUnit, searchMatchArray2, string, refactoringStatus);
                }
            }
            ++n;
        }
        Iterator iterator = hashMap.entrySet().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            iCompilationUnit = (ICompilationUnit)object.getKey();
            searchMatchArray = (SearchMatch[])object.getValue();
            int n3 = 0;
            while (n3 < searchMatchArray.length) {
                SearchMatch searchMatch = searchMatchArray[n3];
                RenameAnalyzeUtil.addReferenceShadowedError(iCompilationUnit, searchMatch, string, refactoringStatus);
                ++n3;
            }
        }
        return refactoringStatus;
    }

    private static void analyzeChanges(ICompilationUnit iCompilationUnit, TextChange textChange, SearchMatch[] searchMatchArray, SearchMatch[] searchMatchArray2, String string, RefactoringStatus refactoringStatus) {
        SearchMatch searchMatch;
        Map map = RenameAnalyzeUtil.getUpdatedChangeOffsets(textChange, searchMatchArray);
        int n = 0;
        while (n < searchMatchArray2.length) {
            searchMatch = searchMatchArray2[n];
            Integer n2 = new Integer(searchMatch.getOffset());
            SearchMatch searchMatch2 = (SearchMatch)map.remove(n2);
            if (searchMatch2 == null) {
                RenameAnalyzeUtil.addReferenceShadowedError(iCompilationUnit, searchMatch, string, refactoringStatus);
            }
            ++n;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            searchMatch = (SearchMatch)iterator.next();
            RenameAnalyzeUtil.addShadowsError(iCompilationUnit, searchMatch, refactoringStatus);
        }
    }

    private static Map getUpdatedChangeOffsets(TextChange textChange, SearchMatch[] searchMatchArray) {
        HashMap<Integer, SearchMatch> hashMap = new HashMap<Integer, SearchMatch>();
        Map map = RenameAnalyzeUtil.getEditChangeOffsetUpdates(textChange);
        int n = 0;
        while (n < searchMatchArray.length) {
            SearchMatch searchMatch = searchMatchArray[n];
            Integer n2 = (Integer)map.get(new Integer(searchMatch.getOffset()));
            if (n2 == null) {
                n2 = new Integer(-1);
            }
            hashMap.put(n2, searchMatch);
            ++n;
        }
        return hashMap;
    }

    private static Map getEditChangeOffsetUpdates(TextChange textChange) {
        TextEditChangeGroup[] textEditChangeGroupArray = textChange.getTextEditChangeGroups();
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>(textEditChangeGroupArray.length);
        int n = 0;
        while (n < textEditChangeGroupArray.length) {
            IRegion iRegion;
            TextEditChangeGroup textEditChangeGroup = textEditChangeGroupArray[n];
            IRegion iRegion2 = textEditChangeGroup.getRegion();
            if (iRegion2 != null && (iRegion = TextEdit.getCoverage((TextEdit[])textChange.getPreviewEdits(textEditChangeGroup.getTextEdits()))) != null) {
                hashMap.put(new Integer(iRegion2.getOffset()), new Integer(iRegion.getOffset()));
            }
            ++n;
        }
        return hashMap;
    }

    private static void addReferenceShadowedError(ICompilationUnit iCompilationUnit, SearchMatch searchMatch, String string, RefactoringStatus refactoringStatus) {
        if (searchMatch instanceof MethodDeclarationMatch || searchMatch instanceof FieldDeclarationMatch) {
            return;
        }
        ISourceRange iSourceRange = RenameAnalyzeUtil.getOldSourceRange(searchMatch);
        RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iCompilationUnit, iSourceRange);
        String string2 = Messages.format(RefactoringCoreMessages.RenameAnalyzeUtil_reference_shadowed, new String[]{iCompilationUnit.getElementName(), string});
        refactoringStatus.addError(string2, refactoringStatusContext);
    }

    private static ISourceRange getOldSourceRange(SearchMatch searchMatch) {
        IJavaElement iJavaElement = (IJavaElement)searchMatch.getElement();
        IJavaElement iJavaElement2 = iJavaElement.getPrimaryElement();
        ISourceRange iSourceRange = null;
        if (iJavaElement2.exists() && iJavaElement2 instanceof ISourceReference) {
            try {
                iSourceRange = ((ISourceReference)iJavaElement2).getSourceRange();
            }
            catch (JavaModelException javaModelException) {}
        }
        return iSourceRange;
    }

    private static void addShadowsError(ICompilationUnit iCompilationUnit, SearchMatch searchMatch, RefactoringStatus refactoringStatus) {
        if (searchMatch instanceof MethodDeclarationMatch || searchMatch instanceof FieldDeclarationMatch) {
            return;
        }
        SourceRange sourceRange = new SourceRange(searchMatch.getOffset(), searchMatch.getLength());
        RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)iCompilationUnit, sourceRange);
        String string = Messages.format(RefactoringCoreMessages.RenameAnalyzeUtil_shadows, iCompilationUnit.getElementName());
        refactoringStatus.addError(string, refactoringStatusContext);
    }

    public static RefactoringStatus analyzeLocalRenames(LocalAnalyzePackage[] localAnalyzePackageArray, TextChange textChange, CompilationUnit compilationUnit, boolean bl) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        ICompilationUnit iCompilationUnit = (ICompilationUnit)compilationUnit.getJavaElement();
        String string = textChange.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        CompilationUnit compilationUnit2 = new RefactoringASTParser(3).parse(string, iCompilationUnit, true, bl, null);
        refactoringStatus.merge(RenameAnalyzeUtil.analyzeCompileErrors(string, compilationUnit2, compilationUnit));
        if (refactoringStatus.hasError()) {
            return refactoringStatus;
        }
        int n = 0;
        while (n < localAnalyzePackageArray.length) {
            ASTNode aSTNode = RenameAnalyzeUtil.getEnclosingBlockOrMethod(localAnalyzePackageArray[n].fDeclarationEdit, textChange, compilationUnit2);
            IRegion iRegion = RefactoringAnalyzeUtil.getNewTextRange(localAnalyzePackageArray[n].fDeclarationEdit, textChange);
            ASTNode aSTNode2 = NodeFinder.perform((ASTNode)compilationUnit2, iRegion.getOffset(), iRegion.getLength());
            Assert.isTrue((boolean)(aSTNode2 instanceof Name));
            VariableDeclaration variableDeclaration = RenameAnalyzeUtil.getVariableDeclaration((Name)aSTNode2);
            Assert.isNotNull((Object)variableDeclaration);
            SimpleName[] simpleNameArray = ProblemNodeFinder.getProblemNodes(aSTNode, variableDeclaration, localAnalyzePackageArray[n].fOccurenceEdits, textChange);
            refactoringStatus.merge(RefactoringAnalyzeUtil.reportProblemNodes(string, simpleNameArray));
            ++n;
        }
        return refactoringStatus;
    }

    private static VariableDeclaration getVariableDeclaration(Name name) {
        IBinding iBinding = name.resolveBinding();
        if (iBinding == null && name.getParent() instanceof VariableDeclaration) {
            return (VariableDeclaration)name.getParent();
        }
        if (iBinding != null && iBinding.getKind() == 3) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            CompilationUnit compilationUnit = (CompilationUnit)ASTNodes.getParent((ASTNode)name, clazz);
            return ASTNodes.findVariableDeclaration((IVariableBinding)iBinding, (ASTNode)compilationUnit);
        }
        return null;
    }

    private static ASTNode getEnclosingBlockOrMethod(TextEdit textEdit, TextChange textChange, CompilationUnit compilationUnit) {
        Block block = RefactoringAnalyzeUtil.getBlock(textEdit, textChange, compilationUnit);
        if (block == null) {
            block = RefactoringAnalyzeUtil.getMethodDeclaration(textEdit, textChange, compilationUnit);
        }
        return block;
    }

    private static RefactoringStatus analyzeCompileErrors(String string, CompilationUnit compilationUnit, CompilationUnit compilationUnit2) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        IProblem[] iProblemArray = RefactoringAnalyzeUtil.getIntroducedCompileProblems(compilationUnit, compilationUnit2);
        int n = 0;
        while (n < iProblemArray.length) {
            IProblem iProblem = iProblemArray[n];
            if (iProblem.isError()) {
                refactoringStatus.addEntry(new RefactoringStatusEntry(iProblem.isError() ? 3 : 2, iProblem.getMessage(), (RefactoringStatusContext)new JavaStringStatusContext(string, new SourceRange(iProblem))));
            }
            ++n;
        }
        return refactoringStatus;
    }

    static class LocalAnalyzePackage {
        public final TextEdit fDeclarationEdit;
        public final TextEdit[] fOccurenceEdits;

        public LocalAnalyzePackage(TextEdit textEdit, TextEdit[] textEditArray) {
            this.fDeclarationEdit = textEdit;
            this.fOccurenceEdits = textEditArray;
        }
    }

    private static class ProblemNodeFinder {
        private ProblemNodeFinder() {
        }

        public static SimpleName[] getProblemNodes(ASTNode aSTNode, VariableDeclaration variableDeclaration, TextEdit[] textEditArray, TextChange textChange) {
            String string = variableDeclaration.resolveBinding().getKey();
            NameNodeVisitor nameNodeVisitor = new NameNodeVisitor(textEditArray, textChange, string);
            aSTNode.accept((ASTVisitor)nameNodeVisitor);
            return nameNodeVisitor.getProblemNodes();
        }

        private static class NameNodeVisitor
        extends ASTVisitor {
            private Collection fRanges;
            private Collection fProblemNodes;
            private String fKey;

            public NameNodeVisitor(TextEdit[] textEditArray, TextChange textChange, String string) {
                Assert.isNotNull((Object)textEditArray);
                Assert.isNotNull((Object)string);
                this.fRanges = new HashSet<IRegion>(Arrays.asList(RefactoringAnalyzeUtil.getNewRanges(textEditArray, textChange)));
                this.fProblemNodes = new ArrayList(0);
                this.fKey = string;
            }

            public SimpleName[] getProblemNodes() {
                return this.fProblemNodes.toArray(new SimpleName[this.fProblemNodes.size()]);
            }

            public boolean visit(SimpleName simpleName) {
                VariableDeclaration variableDeclaration = RenameAnalyzeUtil.getVariableDeclaration((Name)simpleName);
                if (variableDeclaration == null) {
                    return super.visit(simpleName);
                }
                IVariableBinding iVariableBinding = variableDeclaration.resolveBinding();
                if (iVariableBinding == null) {
                    return super.visit(simpleName);
                }
                boolean bl = this.fKey.equals(iVariableBinding.getKey());
                boolean bl2 = this.fRanges.contains(new Region(simpleName.getStartPosition(), simpleName.getLength()));
                if (bl && !bl2) {
                    this.fProblemNodes.add(simpleName);
                }
                if (!bl && bl2) {
                    this.fProblemNodes.add(simpleName);
                }
                return super.visit(simpleName);
            }
        }
    }
}

