/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaElementDescriptor;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.MethodDeclarationMatch;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodChecks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.MethodOccurenceCollector;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameAnalyzeUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public abstract class RenameMethodProcessor
extends JavaRenameProcessor
implements IReferenceUpdating,
IDelegateUpdating {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private SearchResultGroup[] fOccurrences;
    private boolean fUpdateReferences;
    private IMethod fMethod;
    private Set fMethodsToRename;
    private TextChangeManager fChangeManager;
    private WorkingCopyOwner fWorkingCopyOwner;
    private boolean fIsComposite;
    private GroupCategorySet fCategorySet;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    protected boolean fInitialized = false;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.renameMethodProcessor";

    protected RenameMethodProcessor(IMethod iMethod) {
        this(iMethod, new TextChangeManager(true), null);
        this.fIsComposite = false;
    }

    protected RenameMethodProcessor(IMethod iMethod, TextChangeManager textChangeManager, GroupCategorySet groupCategorySet) {
        this.initialize(iMethod);
        this.fChangeManager = textChangeManager;
        this.fCategorySet = groupCategorySet;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
        this.fIsComposite = true;
    }

    protected void initialize(IMethod iMethod) {
        this.fMethod = iMethod;
        if (!this.fInitialized) {
            if (iMethod != null) {
                this.setNewElementName(iMethod.getElementName());
            }
            this.fUpdateReferences = true;
            this.initializeWorkingCopyOwner();
        }
    }

    protected void initializeWorkingCopyOwner() {
        this.fWorkingCopyOwner = new WorkingCopyOwner(){};
    }

    protected void setData(RenameMethodProcessor renameMethodProcessor) {
        this.fUpdateReferences = renameMethodProcessor.fUpdateReferences;
        this.setNewElementName(renameMethodProcessor.getNewElementName());
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameAvailable(this.fMethod);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.RenameMethodRefactoring_name;
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fMethod);
    }

    public Object[] getElements() {
        return new Object[]{this.fMethod};
    }

    protected RenameModifications computeRenameModifications() throws CoreException {
        RenameModifications renameModifications = new RenameModifications();
        RenameArguments renameArguments = new RenameArguments(this.getNewElementName(), this.getUpdateReferences());
        Iterator iterator = this.fMethodsToRename.iterator();
        while (iterator.hasNext()) {
            IMethod iMethod = (IMethod)iterator.next();
            renameModifications.rename(iMethod, renameArguments);
        }
        return renameModifications;
    }

    protected IFile[] getChangedFiles() throws CoreException {
        return ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits());
    }

    public int getSaveMode() {
        return 3;
    }

    public final String getCurrentElementName() {
        return this.fMethod.getElementName();
    }

    public final RefactoringStatus checkNewElementName(String string) {
        Assert.isNotNull((Object)string, (String)"new name");
        RefactoringStatus refactoringStatus = Checks.checkName(string, JavaConventions.validateMethodName((String)string));
        if (refactoringStatus.isOK() && Checks.startsWithUpperCase(string)) {
            refactoringStatus = RefactoringStatus.createWarningStatus((String)(this.fIsComposite ? Messages.format(RefactoringCoreMessages.Checks_method_names_lowercase2, new String[]{string, this.fMethod.getDeclaringType().getElementName()}) : RefactoringCoreMessages.Checks_method_names_lowercase));
        }
        if (Checks.isAlreadyNamed((IJavaElement)this.fMethod, string)) {
            refactoringStatus.addFatalError(this.fIsComposite ? Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_same_name2, new String[]{string, this.fMethod.getDeclaringType().getElementName()}) : RefactoringCoreMessages.RenameMethodRefactoring_same_name, JavaStatusContext.create((IMember)this.fMethod));
        }
        return refactoringStatus;
    }

    public Object getNewElement() {
        if (this.fMethod.getDeclaringType() != null) {
            return this.fMethod.getDeclaringType().getMethod(this.getNewElementName(), this.fMethod.getParameterTypes());
        }
        return this.fMethod.getCompilationUnit().getMethod(this.getNewElementName(), this.fMethod.getParameterTypes());
    }

    public final IMethod getMethod() {
        return this.fMethod;
    }

    private void initializeMethodsToRename(IProgressMonitor iProgressMonitor) throws CoreException {
        if (this.fMethodsToRename == null) {
            this.fMethodsToRename = new HashSet<IMethod>(Arrays.asList(MethodChecks.getOverriddenMethods(this.getMethod(), iProgressMonitor)));
        }
    }

    protected void setMethodsToRename(IMethod[] iMethodArray) {
        this.fMethodsToRename = new HashSet<IMethod>(Arrays.asList(iMethodArray));
    }

    protected Set getMethodsToRename() {
        return this.fMethodsToRename;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public final void setUpdateReferences(boolean bl) {
        this.fUpdateReferences = bl;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableDelegateUpdating() {
        return true;
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean bl) {
        this.fDelegateUpdating = bl;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public void setDeprecateDelegates(boolean bl) {
        this.fDelegateDeprecation = bl;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        if (!this.fMethod.exists()) {
            String string = Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_deleted, this.fMethod.getCompilationUnit().getElementName());
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        RefactoringStatus refactoringStatus = Checks.checkAvailability((IJavaElement)this.fMethod);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
        if (JdtFlags.isNative((IMember)this.fMethod)) {
            refactoringStatus.addError(RefactoringCoreMessages.RenameMethodRefactoring_no_native);
        }
        return refactoringStatus;
    }

    protected RefactoringStatus doCheckFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        boolean bl;
        RefactoringStatus refactoringStatus;
        block14: {
            block13: {
                block12: {
                    block11: {
                        RefactoringStatus refactoringStatus2;
                        try {
                            refactoringStatus = new RefactoringStatus();
                            iProgressMonitor.beginTask("", 9);
                            if (Checks.isAvailable((IJavaElement)this.fMethod)) break block11;
                            refactoringStatus.addFatalError(RefactoringCoreMessages.RenameMethodProcessor_is_binary, JavaStatusContext.create((IMember)this.fMethod));
                            refactoringStatus2 = refactoringStatus;
                            Object var8_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var8_14 = null;
                            iProgressMonitor.done();
                            throw throwable;
                        }
                        iProgressMonitor.done();
                        return refactoringStatus2;
                    }
                    refactoringStatus.merge(Checks.checkIfCuBroken((IMember)this.fMethod));
                    if (!refactoringStatus.hasFatalError()) break block12;
                    RefactoringStatus refactoringStatus3 = refactoringStatus;
                    Object var8_10 = null;
                    iProgressMonitor.done();
                    return refactoringStatus3;
                }
                iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
                refactoringStatus.merge(this.checkNewElementName(this.getNewElementName()));
                if (!refactoringStatus.hasFatalError()) break block13;
                RefactoringStatus refactoringStatus4 = refactoringStatus;
                Object var8_11 = null;
                iProgressMonitor.done();
                return refactoringStatus4;
            }
            IMethod[] iMethodArray = this.searchForDeclarationsOfClashingMethods((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            if (iMethodArray.length == 0) {
                bl = false;
                iProgressMonitor.worked(1);
            } else {
                boolean bl2;
                IType[] iTypeArray = this.searchForOuterTypesOfReferences(iMethodArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                bl = iTypeArray.length > 0 ? true : (bl2 = true);
            }
            this.initializeMethodsToRename((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_searchingForReferences);
            this.fOccurrences = this.getOccurrences((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3), refactoringStatus);
            iProgressMonitor.setTaskName(RefactoringCoreMessages.RenameMethodRefactoring_taskName_checkingPreconditions);
            if (this.fUpdateReferences) {
                refactoringStatus.merge(this.checkRelatedMethods());
            }
            refactoringStatus.merge(this.analyzeCompilationUnits());
            iProgressMonitor.worked(1);
            if (!refactoringStatus.hasFatalError()) break block14;
            RefactoringStatus refactoringStatus5 = refactoringStatus;
            Object var8_12 = null;
            iProgressMonitor.done();
            return refactoringStatus5;
        }
        this.createChanges((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        if (this.fUpdateReferences & bl) {
            refactoringStatus.merge(this.analyzeRenameChanges((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        } else {
            iProgressMonitor.worked(1);
        }
        RefactoringStatus refactoringStatus6 = refactoringStatus;
        Object var8_13 = null;
        iProgressMonitor.done();
        return refactoringStatus6;
    }

    private IType[] searchForOuterTypesOfReferences(IMethod[] iMethodArray, IProgressMonitor iProgressMonitor) throws CoreException {
        final HashSet hashSet = new HashSet();
        SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])iMethodArray, 2);
        IJavaSearchScope iJavaSearchScope = RenameMethodProcessor.createRefactoringScope(this.getMethod());
        SearchRequestor searchRequestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                IMember iMember = (IMember)searchMatch.getElement();
                IType iType = iMember.getDeclaringType();
                if (iType == null) {
                    return;
                }
                IType iType2 = iType.getDeclaringType();
                if (iType2 != null) {
                    hashSet.add(iType);
                }
            }
        };
        new SearchEngine().search(searchPattern, SearchUtils.getDefaultSearchParticipants(), iJavaSearchScope, searchRequestor, iProgressMonitor);
        return hashSet.toArray(new IType[hashSet.size()]);
    }

    private IMethod[] searchForDeclarationsOfClashingMethods(IProgressMonitor iProgressMonitor) throws CoreException {
        final ArrayList arrayList = new ArrayList();
        SearchPattern searchPattern = this.createNewMethodPattern();
        IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)this.getMethod().getJavaProject());
        SearchRequestor searchRequestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch searchMatch) throws CoreException {
                Object object = searchMatch.getElement();
                if (object instanceof IMethod) {
                    arrayList.add(object);
                } else {
                    JavaPlugin.logErrorMessage("Unexpected element in search match: " + searchMatch.toString());
                }
            }
        };
        new SearchEngine().search(searchPattern, SearchUtils.getDefaultSearchParticipants(), iJavaSearchScope, searchRequestor, iProgressMonitor);
        return arrayList.toArray(new IMethod[arrayList.size()]);
    }

    private SearchPattern createNewMethodPattern() throws JavaModelException {
        StringBuffer stringBuffer = new StringBuffer(this.getNewElementName()).append('(');
        int n = this.getMethod().getNumberOfParameters();
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('*');
            ++n2;
        }
        stringBuffer.append(')');
        return SearchPattern.createPattern((String)stringBuffer.toString(), (int)13, (int)0, (int)24);
    }

    protected final IJavaSearchScope createRefactoringScope() throws CoreException {
        return RenameMethodProcessor.createRefactoringScope(this.fMethod);
    }

    protected static final IJavaSearchScope createRefactoringScope(IMethod iMethod) throws CoreException {
        return RefactoringScopeFactory.create((IJavaElement)iMethod);
    }

    SearchPattern createOccurrenceSearchPattern() {
        HashSet<IMethod> hashSet = new HashSet<IMethod>(this.fMethodsToRename);
        hashSet.add(this.fMethod);
        IMethod[] iMethodArray = hashSet.toArray(new IMethod[hashSet.size()]);
        return RefactoringSearchEngine.createOrPattern((IJavaElement[])iMethodArray, 3);
    }

    SearchResultGroup[] getOccurrences() {
        return this.fOccurrences;
    }

    protected SearchResultGroup[] getOccurrences(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        SearchPattern searchPattern = this.createOccurrenceSearchPattern();
        return RefactoringSearchEngine.search(searchPattern, this.createRefactoringScope(), new MethodOccurenceCollector(this.getMethod().getElementName()), iProgressMonitor, refactoringStatus);
    }

    private RefactoringStatus checkRelatedMethods() throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        Iterator iterator = this.fMethodsToRename.iterator();
        while (iterator.hasNext()) {
            IMethod iMethod = (IMethod)iterator.next();
            if (iMethod.getDeclaringType() != null) {
                refactoringStatus.merge(Checks.checkIfConstructorName(iMethod, this.getNewElementName(), iMethod.getDeclaringType().getElementName()));
            }
            Object[] objectArray = new String[]{iMethod.getElementName(), iMethod.getCompilationUnit().getElementName()};
            if (!iMethod.exists()) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_not_in_model, objectArray));
                continue;
            }
            if (iMethod.isBinary()) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_binary, objectArray));
            }
            if (iMethod.isReadOnly()) {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_read_only, objectArray));
            }
            if (!JdtFlags.isNative((IMember)iMethod)) continue;
            refactoringStatus.addError(Messages.format(RefactoringCoreMessages.RenameMethodRefactoring_no_native_1, objectArray));
        }
        return refactoringStatus;
    }

    private RefactoringStatus analyzeCompilationUnits() throws CoreException {
        if (this.fOccurrences.length == 0) {
            return null;
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fOccurrences = Checks.excludeCompilationUnits(this.fOccurrences, refactoringStatus);
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        refactoringStatus.merge(Checks.checkCompileErrorsInAffectedFiles(this.fOccurrences));
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RefactoringStatus analyzeRenameChanges(IProgressMonitor iProgressMonitor) throws CoreException {
        int n;
        Throwable throwable2;
        ICompilationUnit[] iCompilationUnitArray;
        block10: {
            RefactoringStatus refactoringStatus;
            iCompilationUnitArray = null;
            try {
                iProgressMonitor.beginTask("", 4);
                RefactoringStatus refactoringStatus2 = new RefactoringStatus();
                ICompilationUnit[] iCompilationUnitArray2 = this.getDeclarationCUs();
                iCompilationUnitArray = RenameAnalyzeUtil.createNewWorkingCopies(iCompilationUnitArray2, this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(iProgressMonitor, 1));
                IMethod[] iMethodArray = new IMethod[this.fMethodsToRename.size()];
                IMethod[] iMethodArray2 = new IMethod[this.fMethodsToRename.size()];
                int n2 = 0;
                SearchResultGroup[] searchResultGroupArray = this.fMethodsToRename.iterator();
                while (true) {
                    if (!searchResultGroupArray.hasNext()) {
                        searchResultGroupArray = this.batchFindNewOccurrences(iMethodArray2, iMethodArray, iCompilationUnitArray, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 3), refactoringStatus2);
                        refactoringStatus2.merge(RenameAnalyzeUtil.analyzeRenameChanges2(this.fChangeManager, this.fOccurrences, searchResultGroupArray, this.getNewElementName()));
                        refactoringStatus = refactoringStatus2;
                        Object var12_13 = null;
                        break;
                    }
                    IMethod iMethod = (IMethod)searchResultGroupArray.next();
                    ICompilationUnit iCompilationUnit = RenameAnalyzeUtil.findWorkingCopyForCu(iCompilationUnitArray, iMethod.getCompilationUnit());
                    IType iType = (IType)JavaModelUtil.findInCompilationUnit(iCompilationUnit, (IJavaElement)iMethod.getDeclaringType());
                    if (iType != null) {
                        iMethodArray[n2] = this.getMethodInWorkingCopy(iMethod, this.getCurrentElementName(), iType);
                        iMethodArray2[n2] = this.getMethodInWorkingCopy(iMethod, this.getNewElementName(), iType);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable2) {
                Object var12_14 = null;
                iProgressMonitor.done();
                if (iCompilationUnitArray == null) throw throwable2;
                n = 0;
                break block10;
            }
            iProgressMonitor.done();
            if (iCompilationUnitArray == null) return refactoringStatus;
            int n3 = 0;
            while (true) {
                if (n3 >= iCompilationUnitArray.length) {
                    return refactoringStatus;
                }
                iCompilationUnitArray[n3].discardWorkingCopy();
                ++n3;
            }
        }
        while (true) {
            if (n >= iCompilationUnitArray.length) {
                throw throwable2;
            }
            iCompilationUnitArray[n].discardWorkingCopy();
            ++n;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SearchResultGroup[] batchFindNewOccurrences(IMethod[] var1_1, final IMethod[] var2_2, ICompilationUnit[] var3_3, IProgressMonitor var4_4, RefactoringStatus var5_5) throws CoreException {
        var4_4.beginTask("", 2);
        var6_6 = RefactoringSearchEngine.createOrPattern((IJavaElement[])var1_1, 2);
        var7_7 = SearchUtils.getDefaultSearchParticipants();
        var8_8 = RefactoringScopeFactory.create((IMember[])var1_1);
        var9_9 = this.getDelegateUpdating() != false ? new MethodOccurenceCollector(this.getNewElementName()){

            public void acceptSearchMatch(ICompilationUnit iCompilationUnit, SearchMatch searchMatch) throws CoreException {
                int n = 0;
                while (n < var2_2.length) {
                    if (var2_2[n].equals(searchMatch.getElement())) {
                        return;
                    }
                    ++n;
                }
                super.acceptSearchMatch(iCompilationUnit, searchMatch);
            }
        } : new MethodOccurenceCollector(this.getNewElementName());
        var10_10 = new SearchEngine(this.fWorkingCopyOwner);
        var11_11 = new ArrayList<SearchResultGroup[]>();
        var12_12 = new HashSet<ICompilationUnit>(var3_3.length);
        var13_13 = 0;
        while (true) {
            if (var13_13 >= var3_3.length) break;
            var12_12.add(var3_3[var13_13].getPrimary());
            ++var13_13;
        }
        var13_13 = 0;
        while (true) {
            if (var13_13 >= this.fOccurrences.length) {
                var13_14 = null;
                ** try [egrp 0[TRYBLOCK] [0 : 186->251)] { 
lbl21:
                // 1 sources

                break;
            }
            var14_15 = this.fOccurrences[var13_13].getCompilationUnit();
            if (!var12_12.contains(var14_15)) {
                var11_11.add(var14_15);
            }
            ++var13_13;
        }
        {
            var13_14 = RenameAnalyzeUtil.createNewWorkingCopies(var11_11.toArray(new ICompilationUnit[var11_11.size()]), this.fChangeManager, this.fWorkingCopyOwner, new SubProgressMonitor(var4_4, 1));
            var10_10.search(var6_6, var7_7, var8_8, (SearchRequestor)var9_9, (IProgressMonitor)new SubProgressMonitor(var4_4, 1));
            ** GOTO lbl-1000
        }
lbl31:
        // 1 sources

        catch (Throwable var15_16) {
            var14_15 = null;
            var4_4.done();
            if (var13_14 == null) throw var15_16;
            var16_17 = 0;
        }
        while (var16_17 < var13_14.length) {
            var13_14[var16_17].discardWorkingCopy();
            ++var16_17;
        }
        throw var15_16;
lbl-1000:
        // 1 sources

        {
            var14_15 = null;
        }
        var4_4.done();
        if (var13_14 == null) return RefactoringSearchEngine.groupByCu(var9_9.getResults(), var5_5);
        var16_18 = 0;
        while (var16_18 < var13_14.length) {
            var13_14[var16_18].discardWorkingCopy();
            ++var16_18;
        }
        return RefactoringSearchEngine.groupByCu(var9_9.getResults(), var5_5);
    }

    private ICompilationUnit[] getDeclarationCUs() {
        HashSet<ICompilationUnit> hashSet = new HashSet<ICompilationUnit>();
        Iterator iterator = this.fMethodsToRename.iterator();
        while (iterator.hasNext()) {
            IMethod iMethod = (IMethod)iterator.next();
            hashSet.add(iMethod.getCompilationUnit());
        }
        return hashSet.toArray(new ICompilationUnit[hashSet.size()]);
    }

    private IMethod getMethodInWorkingCopy(IMethod iMethod, String string, IType iType) throws CoreException {
        String[] stringArray = iMethod.getParameterTypes();
        return iType.getMethod(string, stringArray);
    }

    private static IMethod[] classesDeclareMethodName(ITypeHierarchy iTypeHierarchy, List list, IMethod iMethod, String string) throws CoreException {
        HashSet<IMethod> hashSet = new HashSet<IMethod>();
        IType iType = iMethod.getDeclaringType();
        List<IType> list2 = Arrays.asList(iTypeHierarchy.getAllSubtypes(iType));
        int n = iMethod.getParameterTypes().length;
        boolean bl = JdtFlags.isPrivate((IMember)iMethod);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            IType iType2 = (IType)iterator.next();
            IMethod[] iMethodArray = iType2.getMethods();
            boolean bl2 = list2.contains(iType2);
            int n2 = 0;
            while (n2 < iMethodArray.length) {
                IMethod iMethod2 = Checks.findMethod(string, n, false, new IMethod[]{iMethodArray[n2]});
                if (iMethod2 != null) {
                    if (bl2 || iType.equals(iType2)) {
                        hashSet.add(iMethod2);
                    } else if (!bl && !JdtFlags.isPrivate((IMember)iMethodArray[n2])) {
                        hashSet.add(iMethod2);
                    }
                }
                ++n2;
            }
        }
        return hashSet.toArray(new IMethod[hashSet.size()]);
    }

    static final IMethod[] hierarchyDeclaresMethodName(IProgressMonitor iProgressMonitor, ITypeHierarchy iTypeHierarchy, IMethod iMethod, String string) throws CoreException {
        IType[] iTypeArray;
        IMethod[] iMethodArray;
        IMethod[] iMethodArray2;
        HashSet<IMethod> hashSet = new HashSet<IMethod>();
        IType iType = iMethod.getDeclaringType();
        IMethod iMethod2 = Checks.findMethod(string, iMethod.getParameterTypes().length, false, iType);
        if (iMethod2 != null) {
            hashSet.add(iMethod2);
        }
        if ((iMethodArray2 = RenameMethodProcessor.classesDeclareMethodName(iTypeHierarchy, Arrays.asList(iTypeHierarchy.getAllClasses()), iMethod, string)) != null) {
            hashSet.addAll(Arrays.asList(iMethodArray2));
        }
        if ((iMethodArray = RenameMethodProcessor.classesDeclareMethodName(iTypeHierarchy, Arrays.asList(iTypeArray = iTypeHierarchy.getImplementingClasses(iType)), iMethod, string)) != null) {
            hashSet.addAll(Arrays.asList(iMethodArray));
        }
        return hashSet.toArray(new IMethod[hashSet.size()]);
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            TextChange[] textChangeArray = this.fChangeManager.getAllChanges();
            ArrayList<TextChange> arrayList = new ArrayList<TextChange>(textChangeArray.length);
            arrayList.addAll(Arrays.asList(textChangeArray));
            String string = null;
            IJavaProject iJavaProject = this.fMethod.getJavaProject();
            if (iJavaProject != null) {
                string = iJavaProject.getElementName();
            }
            int n = 589826;
            try {
                if (!Flags.isPrivate((int)this.fMethod.getFlags())) {
                    n |= 4;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            IType iType = this.fMethod.getDeclaringType();
            try {
                if (iType != null && (iType.isAnonymous() || iType.isLocal())) {
                    n |= 0x40000;
                }
            }
            catch (JavaModelException javaModelException) {
                JavaPlugin.log(javaModelException);
            }
            String string2 = Messages.format(RefactoringCoreMessages.RenameMethodProcessor_descriptor_description_short, this.fMethod.getElementName());
            String string3 = Messages.format(RefactoringCoreMessages.RenameMethodProcessor_descriptor_description, new String[]{JavaElementLabels.getTextLabel(this.fMethod, JavaElementLabels.ALL_FULLY_QUALIFIED), this.getNewElementName()});
            String string4 = new JDTRefactoringDescriptorComment(string, this, string3).asString();
            RenameJavaElementDescriptor renameJavaElementDescriptor = new RenameJavaElementDescriptor("org.eclipse.wst.jsdt.ui.rename.method");
            renameJavaElementDescriptor.setProject(string);
            renameJavaElementDescriptor.setDescription(string2);
            renameJavaElementDescriptor.setComment(string4);
            renameJavaElementDescriptor.setFlags(n);
            renameJavaElementDescriptor.setJavaElement((IJavaElement)this.fMethod);
            renameJavaElementDescriptor.setNewName(this.getNewElementName());
            renameJavaElementDescriptor.setUpdateReferences(this.fUpdateReferences);
            renameJavaElementDescriptor.setKeepOriginal(this.fDelegateUpdating);
            renameJavaElementDescriptor.setDeprecateDelegate(this.fDelegateDeprecation);
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)renameJavaElementDescriptor, RefactoringCoreMessages.RenameMethodProcessor_change_name, arrayList.toArray(new Change[arrayList.size()]));
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    private TextChangeManager createChanges(IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        if (!this.fIsComposite) {
            this.fChangeManager.clear();
        }
        this.addOccurrences(this.fChangeManager, iProgressMonitor, refactoringStatus);
        return this.fChangeManager;
    }

    void addOccurrences(TextChangeManager textChangeManager, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws CoreException {
        iProgressMonitor.beginTask("", this.fOccurrences.length);
        int n = 0;
        while (n < this.fOccurrences.length) {
            ICompilationUnit iCompilationUnit = this.fOccurrences[n].getCompilationUnit();
            if (iCompilationUnit != null) {
                Object object;
                SearchMatch[] searchMatchArray = this.fOccurrences[n].getSearchResults();
                ArrayList<SearchMatch> arrayList = new ArrayList<SearchMatch>();
                ArrayList<SearchMatch> arrayList2 = new ArrayList<SearchMatch>();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    if (searchMatchArray[n2] instanceof MethodDeclarationMatch) {
                        arrayList.add(searchMatchArray[n2]);
                    } else {
                        arrayList2.add(searchMatchArray[n2]);
                    }
                    ++n2;
                }
                if (arrayList.size() > 0) {
                    if (this.fDelegateUpdating) {
                        CompilationUnitRewrite compilationUnitRewrite = new CompilationUnitRewrite(iCompilationUnit);
                        compilationUnitRewrite.setResolveBindings(true);
                        object = arrayList.iterator();
                        while (object.hasNext()) {
                            SearchMatch searchMatch = (SearchMatch)object.next();
                            MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode((IMethod)searchMatch.getElement(), compilationUnitRewrite.getRoot());
                            DelegateMethodCreator delegateMethodCreator = new DelegateMethodCreator();
                            delegateMethodCreator.setDeclareDeprecated(this.fDelegateDeprecation);
                            delegateMethodCreator.setDeclaration((BodyDeclaration)methodDeclaration);
                            delegateMethodCreator.setSourceRewrite(compilationUnitRewrite);
                            delegateMethodCreator.setNewElementName(this.getNewElementName());
                            delegateMethodCreator.prepareDelegate();
                            delegateMethodCreator.createEdit();
                        }
                        object = compilationUnitRewrite.createChange();
                        object.setKeepPreviewEdits(true);
                        textChangeManager.manage(iCompilationUnit, (TextChange)object);
                    }
                    Iterator iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        object = (SearchMatch)iterator.next();
                        this.simpleUpdate((SearchMatch)object, iCompilationUnit, textChangeManager.get(iCompilationUnit));
                    }
                }
                if (this.fUpdateReferences) {
                    Iterator iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        object = (SearchMatch)iterator.next();
                        this.simpleUpdate((SearchMatch)object, iCompilationUnit, textChangeManager.get(iCompilationUnit));
                    }
                }
                iProgressMonitor.worked(1);
                if (iProgressMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++n;
        }
        iProgressMonitor.done();
    }

    private void simpleUpdate(SearchMatch searchMatch, ICompilationUnit iCompilationUnit, TextChange textChange) {
        String string = RefactoringCoreMessages.RenameMethodRefactoring_update_occurrence;
        ReplaceEdit replaceEdit = this.createReplaceEdit(searchMatch, iCompilationUnit);
        this.addTextEdit(textChange, string, replaceEdit);
    }

    protected final ReplaceEdit createReplaceEdit(SearchMatch searchMatch, ICompilationUnit iCompilationUnit) {
        if (searchMatch.isImplicit()) {
            StringBuffer stringBuffer = new StringBuffer(this.getNewElementName());
            if ("insert".equals(iCompilationUnit.getJavaProject().getOption("org.eclipse.wst.jsdt.core.formatter.insert_space_before_assignment_operator", true))) {
                stringBuffer.append(' ');
            }
            stringBuffer.append('=');
            if ("insert".equals(iCompilationUnit.getJavaProject().getOption("org.eclipse.wst.jsdt.core.formatter.insert_space_after_assignment_operator", true))) {
                stringBuffer.append(' ');
            }
            return new ReplaceEdit(searchMatch.getOffset(), 0, stringBuffer.toString());
        }
        return new ReplaceEdit(searchMatch.getOffset(), searchMatch.getLength(), this.getNewElementName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (!(refactoringArguments instanceof JavaRefactoringArguments)) return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        this.fInitialized = true;
        JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
        String string = javaRefactoringArguments.getAttribute("input");
        if (string == null) return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        IJavaElement iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
        String string2 = this.getRefactoring().getName();
        if (!(iJavaElement instanceof IMethod)) return ScriptableRefactoring.createInputFatalStatus(iJavaElement, string2, "org.eclipse.wst.jsdt.ui.rename.method");
        IMethod iMethod = (IMethod)iJavaElement;
        IType iType = iMethod.getDeclaringType();
        if (iType == null || !iType.exists()) return ScriptableRefactoring.createInputFatalStatus(iJavaElement, string2, "org.eclipse.wst.jsdt.ui.rename.method");
        IMethod[] iMethodArray = iType.findMethods(iMethod);
        if (iMethodArray == null || iMethodArray.length != 1 || iMethodArray[0] == null) return ScriptableRefactoring.createInputFatalStatus(null, string2, "org.eclipse.wst.jsdt.ui.rename.method");
        if (!iMethodArray[0].exists()) {
            return ScriptableRefactoring.createInputFatalStatus(iMethodArray[0], string2, "org.eclipse.wst.jsdt.ui.rename.method");
        }
        this.fMethod = iMethodArray[0];
        this.initializeWorkingCopyOwner();
        String string3 = javaRefactoringArguments.getAttribute("name");
        if (string3 == null || "".equals(string3)) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "name"));
        }
        this.setNewElementName(string3);
        string2 = javaRefactoringArguments.getAttribute("references");
        if (string2 == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "references"));
        }
        this.fUpdateReferences = Boolean.valueOf(string2);
        String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DELEGATE);
        if (string4 == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELEGATE));
        }
        this.fDelegateUpdating = Boolean.valueOf(string4);
        String string5 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DEPRECATE);
        if (string5 == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
        }
        this.fDelegateDeprecation = Boolean.valueOf(string5);
        return new RefactoringStatus();
    }

    protected void addTextEdit(TextChange textChange, String string, ReplaceEdit replaceEdit) {
        if (this.fIsComposite) {
            TextChangeCompatibility.addTextEdit(textChange, string, (TextEdit)replaceEdit, this.fCategorySet);
        } else {
            TextChangeCompatibility.addTextEdit(textChange, string, (TextEdit)replaceEdit);
        }
    }
}

