/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.rename;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Javadoc;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;

public class TempOccurrenceAnalyzer
extends ASTVisitor {
    private Set fReferenceNodes;
    private Set fJavadocNodes;
    private VariableDeclaration fTempDeclaration;
    private IBinding fTempBinding;
    private boolean fAnalyzeJavadoc;
    private boolean fIsInJavadoc;
    static /* synthetic */ Class class$0;

    public TempOccurrenceAnalyzer(VariableDeclaration variableDeclaration, boolean bl) {
        Assert.isNotNull((Object)variableDeclaration);
        this.fReferenceNodes = new HashSet();
        this.fJavadocNodes = new HashSet();
        this.fAnalyzeJavadoc = bl;
        this.fTempDeclaration = variableDeclaration;
        this.fTempBinding = variableDeclaration.resolveBinding();
        this.fIsInJavadoc = false;
    }

    public void perform() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.CompilationUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ASTNode aSTNode = ASTNodes.getParent((ASTNode)this.fTempDeclaration, clazz);
        aSTNode.accept((ASTVisitor)this);
    }

    public int[] getReferenceOffsets() {
        int[] nArray = new int[this.fReferenceNodes.size()];
        this.addOffsets(nArray, 0, this.fReferenceNodes);
        return nArray;
    }

    public int[] getReferenceAndJavadocOffsets() {
        int[] nArray = new int[this.fReferenceNodes.size() + this.fJavadocNodes.size()];
        this.addOffsets(nArray, 0, this.fReferenceNodes);
        this.addOffsets(nArray, this.fReferenceNodes.size(), this.fJavadocNodes);
        return nArray;
    }

    private void addOffsets(int[] nArray, int n, Set set) {
        int n2 = n;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ASTNode aSTNode = (ASTNode)iterator.next();
            nArray[n2] = aSTNode.getStartPosition();
            ++n2;
        }
    }

    public int getNumberOfReferences() {
        return this.fReferenceNodes.size();
    }

    public SimpleName[] getReferenceNodes() {
        return this.fReferenceNodes.toArray(new SimpleName[this.fReferenceNodes.size()]);
    }

    public SimpleName[] getJavadocNodes() {
        return this.fJavadocNodes.toArray(new SimpleName[this.fJavadocNodes.size()]);
    }

    public SimpleName[] getReferenceAndDeclarationNodes() {
        SimpleName[] simpleNameArray = this.fReferenceNodes.toArray(new SimpleName[this.fReferenceNodes.size() + 1]);
        simpleNameArray[this.fReferenceNodes.size()] = this.fTempDeclaration.getName();
        return simpleNameArray;
    }

    public boolean visit(Javadoc javadoc) {
        if (this.fAnalyzeJavadoc) {
            this.fIsInJavadoc = true;
        }
        return this.fAnalyzeJavadoc;
    }

    public void endVisit(Javadoc javadoc) {
        this.fIsInJavadoc = false;
    }

    public boolean visit(SimpleName simpleName) {
        if (simpleName.getParent() instanceof VariableDeclaration && ((VariableDeclaration)simpleName.getParent()).getName() == simpleName) {
            return true;
        }
        if (this.fTempBinding != null && this.fTempBinding == simpleName.resolveBinding()) {
            if (this.fIsInJavadoc) {
                this.fJavadocNodes.add(simpleName);
            } else {
                this.fReferenceNodes.add(simpleName);
            }
        }
        return true;
    }
}

