/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.DeleteChangeCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.DeleteModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IConfirmQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.NullReorgQueries;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReadOnlyResourceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public final class JavaDeleteProcessor
extends DeleteProcessor
implements IScriptableRefactoring,
ICommentProvider {
    private static final String ATTRIBUTE_RESOURCES = "resources";
    private static final String ATTRIBUTE_ELEMENTS = "elements";
    private static final String ATTRIBUTE_SUGGEST_ACCESSORS = "accessors";
    private static final String ATTRIBUTE_DELETE_SUBPACKAGES = "subPackages";
    private boolean fAccessorsDeleted;
    private boolean fWasCanceled;
    private boolean fSuggestGetterSetterDeletion;
    private Object[] fElements;
    private IResource[] fResources;
    private IJavaElement[] fJavaElements;
    private IReorgQueries fDeleteQueries;
    private DeleteModifications fDeleteModifications;
    private String fComment;
    private Change fDeleteChange;
    private boolean fDeleteSubPackages;
    public static final String IDENTIFIER = "org.eclipse.wst.jsdt.ui.DeleteProcessor";
    static /* synthetic */ Class class$0;

    public JavaDeleteProcessor(Object[] objectArray) {
        this.fElements = objectArray;
        if (this.fElements != null) {
            this.fResources = RefactoringAvailabilityTester.getResources(objectArray);
            this.fJavaElements = RefactoringAvailabilityTester.getJavaElements(objectArray);
        }
        this.fSuggestGetterSetterDeletion = true;
        this.fDeleteSubPackages = false;
        this.fWasCanceled = false;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fElements.length == 0) {
            return false;
        }
        if (this.fElements.length != this.fResources.length + this.fJavaElements.length) {
            return false;
        }
        int n = 0;
        while (n < this.fResources.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable(this.fResources[n])) {
                return false;
            }
            ++n;
        }
        n = 0;
        while (n < this.fJavaElements.length) {
            if (!RefactoringAvailabilityTester.isDeleteAvailable(this.fJavaElements[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        if (this.fResources != null && this.fResources.length > 0) {
            return true;
        }
        if (this.fJavaElements != null) {
            int n = 0;
            while (n < this.fJavaElements.length) {
                int n2 = this.fJavaElements[n].getElementType();
                if (n2 <= 6) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.DeleteRefactoring_7;
    }

    public Object[] getElements() {
        return this.fElements;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, SharableParticipants sharableParticipants) throws CoreException {
        return this.fDeleteModifications.loadParticipants(refactoringStatus, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharableParticipants);
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] stringArray = JavaProcessors.computeAffectedNaturs(this.fJavaElements);
        String[] stringArray2 = ResourceProcessors.computeAffectedNatures(this.fResources);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(Arrays.asList(stringArray));
        hashSet.addAll(Arrays.asList(stringArray2));
        return hashSet.toArray(new String[hashSet.size()]);
    }

    public void setSuggestGetterSetterDeletion(boolean bl) {
        this.fSuggestGetterSetterDeletion = bl;
    }

    public void setDeleteSubPackages(boolean bl) {
        this.fDeleteSubPackages = bl;
    }

    public boolean getDeleteSubPackages() {
        return this.fDeleteSubPackages;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasSubPackagesToDelete() {
        try {
            int n = 0;
            while (true) {
                IPackageFragment iPackageFragment;
                if (n >= this.fJavaElements.length) {
                    return false;
                }
                if (this.fJavaElements[n] instanceof IPackageFragment && !(iPackageFragment = (IPackageFragment)this.fJavaElements[n]).isDefaultPackage() && iPackageFragment.hasSubpackages()) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        return false;
    }

    public void setQueries(IReorgQueries iReorgQueries) {
        Assert.isNotNull((Object)iReorgQueries);
        this.fDeleteQueries = iReorgQueries;
    }

    public IJavaElement[] getJavaElementsToDelete() {
        return this.fJavaElements;
    }

    public boolean wasCanceled() {
        return this.fWasCanceled;
    }

    public IResource[] getResourcesToDelete() {
        return this.fResources;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        Assert.isNotNull((Object)this.fDeleteQueries);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotLinked(this.fResources))));
        IResource[] iResourceArray = ReorgUtils.getResources(this.fJavaElements);
        refactoringStatus.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(iResourceArray))));
        int n = 0;
        while (n < this.fJavaElements.length) {
            IJavaElement iJavaElement = this.fJavaElements[n];
            if (iJavaElement instanceof IType) {
                ((IType)iJavaElement).isAnonymous();
            }
            ++n;
        }
        return refactoringStatus;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        iProgressMonitor.beginTask(RefactoringCoreMessages.DeleteRefactoring_1, 1);
        try {
            try {
                this.fWasCanceled = false;
                RefactoringStatus refactoringStatus2 = new RefactoringStatus();
                this.recalculateElementsToDelete();
                this.checkDirtyCompilationUnits(refactoringStatus2);
                this.checkDirtyResources(refactoringStatus2);
                this.fDeleteModifications = new DeleteModifications();
                this.fDeleteModifications.delete(this.fResources);
                this.fDeleteModifications.delete(this.fJavaElements);
                List list = this.fDeleteModifications.postProcess();
                TextChangeManager textChangeManager = new TextChangeManager();
                this.fDeleteChange = DeleteChangeCreator.createDeleteChange(textChangeManager, this.fResources, this.fJavaElements, this.getProcessorName(), list);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                ResourceChangeChecker resourceChangeChecker = (ResourceChangeChecker)checkConditionsContext.getChecker((Class)clazz);
                IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory = resourceChangeChecker.getDeltaFactory();
                this.fDeleteModifications.buildDelta(iResourceChangeDescriptionFactory);
                IFile[] iFileArray = ResourceUtil.getFiles(textChangeManager.getAllCompilationUnits());
                int n = 0;
                while (true) {
                    if (n >= iFileArray.length) {
                        refactoringStatus = refactoringStatus2;
                        Object var10_14 = null;
                        break;
                    }
                    iResourceChangeDescriptionFactory.change(iFileArray[n]);
                    ++n;
                }
            }
            catch (OperationCanceledException operationCanceledException) {
                this.fWasCanceled = true;
                throw operationCanceledException;
            }
            catch (JavaModelException javaModelException) {
                throw javaModelException;
            }
            catch (CoreException coreException) {
                throw new JavaModelException(coreException);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private void checkDirtyCompilationUnits(RefactoringStatus refactoringStatus) throws CoreException {
        if (this.fJavaElements == null || this.fJavaElements.length == 0) {
            return;
        }
        int n = 0;
        while (n < this.fJavaElements.length) {
            IJavaElement iJavaElement = this.fJavaElements[n];
            if (iJavaElement instanceof ICompilationUnit) {
                this.checkDirtyCompilationUnit(refactoringStatus, (ICompilationUnit)iJavaElement);
            } else if (iJavaElement instanceof IPackageFragment) {
                ICompilationUnit[] iCompilationUnitArray = ((IPackageFragment)iJavaElement).getCompilationUnits();
                int n2 = 0;
                while (n2 < iCompilationUnitArray.length) {
                    this.checkDirtyCompilationUnit(refactoringStatus, iCompilationUnitArray[n2]);
                    ++n2;
                }
            }
            ++n;
        }
    }

    private void checkDirtyCompilationUnit(RefactoringStatus refactoringStatus, ICompilationUnit iCompilationUnit) {
        IResource iResource = iCompilationUnit.getResource();
        if (iResource == null || iResource.getType() != 1) {
            return;
        }
        this.checkDirtyFile(refactoringStatus, (IFile)iResource);
    }

    private void checkDirtyResources(final RefactoringStatus refactoringStatus) throws CoreException {
        int n = 0;
        while (n < this.fResources.length) {
            IResource iResource = this.fResources[n];
            iResource.accept(new IResourceVisitor(){

                public boolean visit(IResource iResource) throws CoreException {
                    if (iResource instanceof IFile) {
                        JavaDeleteProcessor.this.checkDirtyFile(refactoringStatus, (IFile)iResource);
                    }
                    return true;
                }
            }, 2, false);
            ++n;
        }
    }

    private void checkDirtyFile(RefactoringStatus refactoringStatus, IFile iFile) {
        if (iFile == null || !iFile.exists()) {
            return;
        }
        ITextFileBuffer iTextFileBuffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(iFile.getFullPath(), LocationKind.IFILE);
        if (iTextFileBuffer != null && iTextFileBuffer.isDirty()) {
            if (iTextFileBuffer.isStateValidated() && iTextFileBuffer.isSynchronized()) {
                refactoringStatus.addWarning(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, iFile.getFullPath().toString()));
            } else {
                refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_unsaved_changes, iFile.getFullPath().toString()));
            }
        }
    }

    private void recalculateElementsToDelete() throws CoreException {
        this.fAccessorsDeleted = false;
        if (this.fDeleteSubPackages) {
            this.addSubPackages();
        }
        this.removeElementsWithParentsInSelection();
        this.removeUnconfirmedFoldersThatContainSourceFolders();
        this.removeUnconfirmedReferencedArchives();
        this.addEmptyCusToDelete();
        this.removeJavaElementsChildrenOfJavaElements();
        this.confirmDeletingReadOnly();
        if (this.fSuggestGetterSetterDeletion) {
            this.addGettersSetters();
        }
        this.addDeletableParentPackagesOnPackageDeletion();
    }

    private void addSubPackages() throws JavaModelException {
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < this.fJavaElements.length) {
            if (this.fJavaElements[n] instanceof IPackageFragment) {
                hashSet.addAll(Arrays.asList(JavaElementUtil.getPackageAndSubpackages((IPackageFragment)this.fJavaElements[n])));
            } else {
                hashSet.add(this.fJavaElements[n]);
            }
            ++n;
        }
        this.fJavaElements = hashSet.toArray(new IJavaElement[hashSet.size()]);
    }

    private void addDeletableParentPackagesOnPackageDeletion() throws CoreException {
        IResource iResource;
        IPackageFragment iPackageFragment;
        List list = ReorgUtils.getElementsOfType(this.fJavaElements, 4);
        if (list.size() == 0) {
            return;
        }
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                IPackageFragment iPackageFragment = (IPackageFragment)object;
                IPackageFragment iPackageFragment2 = (IPackageFragment)object2;
                return iPackageFragment2.getElementName().compareTo(iPackageFragment.getElementName());
            }
        });
        HashSet<IResource> hashSet = new HashSet<IResource>();
        hashSet.addAll(Arrays.asList(this.fResources));
        int n = 0;
        while (n < this.fJavaElements.length) {
            if (!ReorgUtils.isInsideCompilationUnit(this.fJavaElements[n])) {
                hashSet.add(this.fJavaElements[n].getResource());
            }
            ++n;
        }
        ArrayList<IPackageFragment> arrayList = new ArrayList<IPackageFragment>();
        Object object = list.iterator();
        while (object.hasNext()) {
            IPackageFragment iPackageFragment2 = (IPackageFragment)object.next();
            arrayList.add(iPackageFragment2);
            if (!this.canRemoveCompletely(iPackageFragment2, list) || (iPackageFragment = JavaElementUtil.getParentSubpackage(iPackageFragment2)) == null || list.contains(iPackageFragment)) continue;
            iResource = new ArrayList();
            this.addDeletableParentPackages(iPackageFragment, list, hashSet, (List)iResource);
            arrayList.addAll((Collection<IPackageFragment>)iResource);
        }
        object = new ArrayList();
        int n2 = 0;
        while (n2 < this.fJavaElements.length) {
            if (!(this.fJavaElements[n2] instanceof IPackageFragment) && !arrayList.contains(iPackageFragment = (IPackageFragment)this.fJavaElements[n2].getAncestor(4))) {
                object.add(this.fJavaElements[n2]);
            }
            ++n2;
        }
        object.addAll(arrayList);
        ArrayList<IResource> arrayList2 = new ArrayList<IResource>();
        int n3 = 0;
        while (n3 < this.fResources.length) {
            iResource = this.fResources[n3];
            if (iResource.getType() == 1) {
                iResource = iResource.getParent();
            }
            if (!hashSet.contains(iResource)) {
                arrayList2.add(this.fResources[n3]);
            }
            ++n3;
        }
        this.fJavaElements = object.toArray(new IJavaElement[object.size()]);
        this.fResources = arrayList2.toArray(new IResource[arrayList2.size()]);
    }

    private boolean canRemoveCompletely(IPackageFragment iPackageFragment, List list) throws JavaModelException {
        IPackageFragment[] iPackageFragmentArray = JavaElementUtil.getPackageAndSubpackages(iPackageFragment);
        int n = 0;
        while (n < iPackageFragmentArray.length) {
            if (!iPackageFragmentArray[n].equals(iPackageFragment) && !list.contains(iPackageFragmentArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void addDeletableParentPackages(IPackageFragment iPackageFragment, List list, Set set, List list2) throws CoreException {
        Object object;
        if (iPackageFragment.getResource().isLinked() && !(object = this.fDeleteQueries.createYesNoQuery(RefactoringCoreMessages.JavaDeleteProcessor_confirm_linked_folder_delete, false, 8)).confirm(Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_delete_linked_folder_question, new String[]{iPackageFragment.getResource().getName()}))) {
            return;
        }
        object = ((IContainer)iPackageFragment.getResource()).members();
        int n = 0;
        while (n < ((IResource[])object).length) {
            if (!set.contains(object[n])) {
                return;
            }
            ++n;
        }
        set.add(iPackageFragment.getResource());
        list2.add(iPackageFragment);
        IPackageFragment iPackageFragment2 = JavaElementUtil.getParentSubpackage(iPackageFragment);
        if (iPackageFragment2 != null && !list.contains(iPackageFragment2)) {
            this.addDeletableParentPackages(iPackageFragment2, list, set, list2);
        }
    }

    private void removeUnconfirmedReferencedArchives() throws JavaModelException {
        String string = RefactoringCoreMessages.DeleteRefactoring_2;
        IConfirmQuery iConfirmQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(string, true, 3);
        this.removeUnconfirmedReferencedPackageFragmentRoots(iConfirmQuery);
        this.removeUnconfirmedReferencedArchiveFiles(iConfirmQuery);
    }

    private void removeUnconfirmedReferencedArchiveFiles(IConfirmQuery iConfirmQuery) throws JavaModelException, OperationCanceledException {
        ArrayList<IResource> arrayList = new ArrayList<IResource>(0);
        int n = 0;
        while (n < this.fResources.length) {
            List<IJavaProject> list;
            IPackageFragmentRoot iPackageFragmentRoot;
            IJavaProject iJavaProject;
            IResource iResource = this.fResources[n];
            if (iResource instanceof IFile && (iJavaProject = JavaCore.create((IProject)iResource.getProject())) != null && iJavaProject.exists() && (iPackageFragmentRoot = iJavaProject.findPackageFragmentRoot(iResource.getFullPath())) != null && JavaDeleteProcessor.skipDeletingReferencedRoot(iConfirmQuery, iPackageFragmentRoot, list = Arrays.asList(JavaElementUtil.getReferencingProjects(iPackageFragmentRoot)))) {
                arrayList.add(iResource);
            }
            ++n;
        }
        this.removeFromSetToDelete((IResource[])arrayList.toArray(new IFile[arrayList.size()]));
    }

    private void removeUnconfirmedReferencedPackageFragmentRoots(IConfirmQuery iConfirmQuery) throws JavaModelException, OperationCanceledException {
        ArrayList<IPackageFragmentRoot> arrayList = new ArrayList<IPackageFragmentRoot>(0);
        int n = 0;
        while (n < this.fJavaElements.length) {
            IJavaElement iJavaElement = this.fJavaElements[n];
            if (iJavaElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)iJavaElement;
                ArrayList<IJavaProject> arrayList2 = new ArrayList<IJavaProject>(Arrays.asList(JavaElementUtil.getReferencingProjects(iPackageFragmentRoot)));
                arrayList2.remove(iPackageFragmentRoot.getJavaProject());
                if (JavaDeleteProcessor.skipDeletingReferencedRoot(iConfirmQuery, iPackageFragmentRoot, arrayList2)) {
                    arrayList.add(iPackageFragmentRoot);
                }
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IJavaElement[arrayList.size()]));
    }

    private static boolean skipDeletingReferencedRoot(IConfirmQuery iConfirmQuery, IPackageFragmentRoot iPackageFragmentRoot, List list) throws OperationCanceledException {
        if (list.isEmpty() || iPackageFragmentRoot == null || !iPackageFragmentRoot.exists() || !iPackageFragmentRoot.isArchive()) {
            return false;
        }
        String string = Messages.format(RefactoringCoreMessages.DeleteRefactoring_3, iPackageFragmentRoot.getElementName());
        return !iConfirmQuery.confirm(string, list.toArray());
    }

    private void removeUnconfirmedFoldersThatContainSourceFolders() throws CoreException {
        String string = RefactoringCoreMessages.DeleteRefactoring_4;
        IConfirmQuery iConfirmQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(string, true, 4);
        ArrayList<IFolder> arrayList = new ArrayList<IFolder>(0);
        int n = 0;
        while (n < this.fResources.length) {
            String string2;
            IFolder iFolder;
            IResource iResource = this.fResources[n];
            if (iResource instanceof IFolder && JavaDeleteProcessor.containsSourceFolder(iFolder = (IFolder)iResource) && !iConfirmQuery.confirm(string2 = Messages.format(RefactoringCoreMessages.DeleteRefactoring_5, iFolder.getName()))) {
                arrayList.add(iFolder);
            }
            ++n;
        }
        this.removeFromSetToDelete(arrayList.toArray(new IResource[arrayList.size()]));
    }

    private static boolean containsSourceFolder(IFolder iFolder) throws CoreException {
        IResource[] iResourceArray = iFolder.members();
        int n = 0;
        while (n < iResourceArray.length) {
            if (iResourceArray[n] instanceof IFolder) {
                IJavaElement iJavaElement = JavaCore.create((IFolder)iFolder);
                if (iJavaElement instanceof IPackageFragmentRoot) {
                    return true;
                }
                if (!(iJavaElement instanceof IPackageFragment) && JavaDeleteProcessor.containsSourceFolder((IFolder)iResourceArray[n])) {
                    return true;
                }
            }
            ++n;
        }
        return false;
    }

    private void removeElementsWithParentsInSelection() {
        ParentChecker parentChecker = new ParentChecker(this.fResources, this.fJavaElements);
        parentChecker.removeElementsWithAncestorsOnList(false);
        this.fJavaElements = parentChecker.getJavaElements();
        this.fResources = parentChecker.getResources();
    }

    private void removeJavaElementsChildrenOfJavaElements() {
        ParentChecker parentChecker = new ParentChecker(this.fResources, this.fJavaElements);
        parentChecker.removeElementsWithAncestorsOnList(true);
        this.fJavaElements = parentChecker.getJavaElements();
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        DynamicValidationRefactoringChange dynamicValidationRefactoringChange;
        try {
            iProgressMonitor.beginTask(RefactoringCoreMessages.JavaDeleteProcessor_creating_change, 1);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = this.fElements.length == 1 ? RefactoringCoreMessages.JavaDeleteProcessor_description_singular : RefactoringCoreMessages.JavaDeleteProcessor_description_plural;
            IProject iProject = this.getSingleProject();
            String string2 = iProject != null ? iProject.getName() : null;
            String string3 = string2 != null ? Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_project_pattern, string2) : RefactoringCoreMessages.JavaDeleteProcessor_workspace;
            String string4 = Messages.format(RefactoringCoreMessages.JavaDeleteProcessor_header, new String[]{String.valueOf(this.fElements.length), string3});
            int n = 589830;
            JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string2, this, string4);
            if (this.fDeleteSubPackages) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.JavaDeleteProcessor_delete_subpackages);
            }
            if (this.fAccessorsDeleted) {
                jDTRefactoringDescriptorComment.addSetting(RefactoringCoreMessages.JavaDeleteProcessor_delete_accessors);
            }
            JDTRefactoringDescriptor jDTRefactoringDescriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.delete", string2, string, jDTRefactoringDescriptorComment.asString(), hashMap, n);
            hashMap.put(ATTRIBUTE_DELETE_SUBPACKAGES, Boolean.valueOf(this.fDeleteSubPackages).toString());
            hashMap.put(ATTRIBUTE_SUGGEST_ACCESSORS, Boolean.valueOf(this.fSuggestGetterSetterDeletion).toString());
            hashMap.put(ATTRIBUTE_RESOURCES, new Integer(this.fResources.length).toString());
            int n2 = 0;
            while (n2 < this.fResources.length) {
                hashMap.put("element" + (n2 + 1), jDTRefactoringDescriptor.resourceToHandle(this.fResources[n2]));
                ++n2;
            }
            hashMap.put(ATTRIBUTE_ELEMENTS, new Integer(this.fJavaElements.length).toString());
            n2 = 0;
            while (n2 < this.fJavaElements.length) {
                hashMap.put("element" + (n2 + this.fResources.length + 1), jDTRefactoringDescriptor.elementToHandle(this.fJavaElements[n2]));
                ++n2;
            }
            dynamicValidationRefactoringChange = new DynamicValidationRefactoringChange(jDTRefactoringDescriptor, RefactoringCoreMessages.DeleteRefactoring_7, new Change[]{this.fDeleteChange});
            Object var12_13 = null;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return dynamicValidationRefactoringChange;
    }

    private IProject getSingleProject() {
        IProject iProject = null;
        int n = 0;
        while (n < this.fElements.length) {
            IProject iProject2 = null;
            if (this.fElements[n] instanceof IJavaElement) {
                iProject2 = ((IJavaElement)this.fElements[n]).getJavaProject().getProject();
            } else if (this.fElements[n] instanceof IResource) {
                iProject2 = ((IResource)this.fElements[n]).getProject();
            }
            if (iProject2 != null) {
                if (iProject == null) {
                    iProject = iProject2;
                } else if (!iProject2.equals((Object)iProject)) {
                    return null;
                }
            }
            ++n;
        }
        return iProject;
    }

    private void addToSetToDelete(IJavaElement[] iJavaElementArray) {
        this.fJavaElements = ReorgUtils.union(this.fJavaElements, iJavaElementArray);
    }

    private void removeFromSetToDelete(IResource[] iResourceArray) {
        this.fResources = ReorgUtils.setMinus(this.fResources, iResourceArray);
    }

    private void removeFromSetToDelete(IJavaElement[] iJavaElementArray) {
        this.fJavaElements = ReorgUtils.setMinus(this.fJavaElements, iJavaElementArray);
    }

    private void addGettersSetters() throws JavaModelException {
        IField[] iFieldArray = JavaDeleteProcessor.getFields(this.fJavaElements);
        if (iFieldArray.length == 0) {
            return;
        }
        Map map = JavaDeleteProcessor.createGetterSetterMapping(iFieldArray);
        if (map.isEmpty()) {
            return;
        }
        this.removeAlreadySelectedMethods(map);
        if (map.isEmpty()) {
            return;
        }
        this.fAccessorsDeleted = true;
        List list = this.getGettersSettersToDelete(map);
        this.addToSetToDelete((IJavaElement[])list.toArray(new IMethod[list.size()]));
    }

    private List getGettersSettersToDelete(Map map) {
        ArrayList<IMethod> arrayList = new ArrayList<IMethod>(map.size());
        String string = RefactoringCoreMessages.DeleteRefactoring_8;
        IConfirmQuery iConfirmQuery = this.fDeleteQueries.createYesYesToAllNoNoToAllQuery(string, true, 1);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IField iField = (IField)iterator.next();
            Assert.isTrue((JavaDeleteProcessor.hasGetter(map, iField) || JavaDeleteProcessor.hasSetter(map, iField) ? 1 : 0) != 0);
            String string2 = Messages.format(RefactoringCoreMessages.DeleteRefactoring_9, JavaElementUtil.createFieldSignature(iField));
            if (!iConfirmQuery.confirm(string2)) continue;
            if (JavaDeleteProcessor.hasGetter(map, iField)) {
                arrayList.add(JavaDeleteProcessor.getGetter(map, iField));
            }
            if (!JavaDeleteProcessor.hasSetter(map, iField)) continue;
            arrayList.add(JavaDeleteProcessor.getSetter(map, iField));
        }
        return arrayList;
    }

    private void removeAlreadySelectedMethods(Map map) {
        List<IJavaElement> list = Arrays.asList(this.fJavaElements);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            IMethod iMethod;
            IField iField = (IField)iterator.next();
            IMethod iMethod2 = JavaDeleteProcessor.getGetter(map, iField);
            if (iMethod2 != null && list.contains(iMethod2)) {
                JavaDeleteProcessor.removeGetterFromMapping(map, iField);
            }
            if ((iMethod = JavaDeleteProcessor.getSetter(map, iField)) != null && list.contains(iMethod)) {
                JavaDeleteProcessor.removeSetterFromMapping(map, iField);
            }
            if (JavaDeleteProcessor.hasGetter(map, iField) || JavaDeleteProcessor.hasSetter(map, iField)) continue;
            iterator.remove();
        }
    }

    private static Map createGetterSetterMapping(IField[] iFieldArray) throws JavaModelException {
        HashMap<IField, IMethod[]> hashMap = new HashMap<IField, IMethod[]>();
        int n = 0;
        while (n < iFieldArray.length) {
            IField iField = iFieldArray[n];
            IMethod[] iMethodArray = JavaDeleteProcessor.getGetterSetter(iField);
            if (iMethodArray != null) {
                hashMap.put(iField, iMethodArray);
            }
            ++n;
        }
        return hashMap;
    }

    private static boolean hasSetter(Map map, IField iField) {
        return map.containsKey(iField) && JavaDeleteProcessor.getSetter(map, iField) != null;
    }

    private static boolean hasGetter(Map map, IField iField) {
        return map.containsKey(iField) && JavaDeleteProcessor.getGetter(map, iField) != null;
    }

    private static void removeGetterFromMapping(Map map, IField iField) {
        ((IMethod[])map.get((Object)iField))[0] = null;
    }

    private static void removeSetterFromMapping(Map map, IField iField) {
        ((IMethod[])map.get((Object)iField))[1] = null;
    }

    private static IMethod getGetter(Map map, IField iField) {
        return ((IMethod[])map.get(iField))[0];
    }

    private static IMethod getSetter(Map map, IField iField) {
        return ((IMethod[])map.get(iField))[1];
    }

    private static IField[] getFields(IJavaElement[] iJavaElementArray) {
        ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>(3);
        int n = 0;
        while (n < iJavaElementArray.length) {
            if (iJavaElementArray[n] instanceof IField) {
                arrayList.add(iJavaElementArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IField[arrayList.size()]);
    }

    private static IMethod[] getGetterSetter(IField iField) throws JavaModelException {
        IMethod iMethod = GetterSetterUtil.getGetter(iField);
        IMethod iMethod2 = GetterSetterUtil.getSetter(iField);
        if (iMethod != null && iMethod.exists() || iMethod2 != null && iMethod2.exists()) {
            return new IMethod[]{iMethod, iMethod2};
        }
        return null;
    }

    private void confirmDeletingReadOnly() throws CoreException {
        if (!ReadOnlyResourceFinder.confirmDeleteOfReadOnlyElements(this.fJavaElements, this.fResources, this.fDeleteQueries)) {
            throw new OperationCanceledException();
        }
    }

    private void addEmptyCusToDelete() throws JavaModelException {
        Set set = this.getCusToEmpty();
        this.addToSetToDelete((IJavaElement[])set.toArray(new ICompilationUnit[set.size()]));
    }

    private Set getCusToEmpty() throws JavaModelException {
        HashSet<ICompilationUnit> hashSet = new HashSet<ICompilationUnit>();
        int n = 0;
        while (n < this.fJavaElements.length) {
            IJavaElement iJavaElement = this.fJavaElements[n];
            ICompilationUnit iCompilationUnit = ReorgUtils.getCompilationUnit(iJavaElement);
            if (iCompilationUnit != null && !hashSet.contains(iCompilationUnit) && this.willHaveAllTopLevelTypesDeleted(iCompilationUnit)) {
                hashSet.add(iCompilationUnit);
            }
            ++n;
        }
        return hashSet;
    }

    private boolean willHaveAllTopLevelTypesDeleted(ICompilationUnit iCompilationUnit) throws JavaModelException {
        HashSet<IJavaElement> hashSet = new HashSet<IJavaElement>(Arrays.asList(this.fJavaElements));
        IType[] iTypeArray = iCompilationUnit.getTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            if (!hashSet.contains(iTypeArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String string) {
        this.fComment = string;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        ArrayList<IResource> arrayList;
        this.setQueries(new NullReorgQueries());
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            IResource iResource;
            String string;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DELETE_SUBPACKAGES);
            if (string2 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELETE_SUBPACKAGES));
            }
            this.fDeleteSubPackages = Boolean.valueOf(string2);
            String string3 = javaRefactoringArguments.getAttribute(ATTRIBUTE_SUGGEST_ACCESSORS);
            if (string3 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_SUGGEST_ACCESSORS));
            }
            this.fSuggestGetterSetterDeletion = Boolean.valueOf(string3);
            int n = 0;
            int n2 = 0;
            String string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_RESOURCES);
            if (string4 != null && !"".equals(string4)) {
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_RESOURCES));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_RESOURCES));
            }
            string4 = javaRefactoringArguments.getAttribute(ATTRIBUTE_ELEMENTS);
            if (string4 != null && !"".equals(string4)) {
                try {
                    n2 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ELEMENTS));
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_ELEMENTS));
            }
            String string5 = null;
            arrayList = new ArrayList<IResource>();
            int n3 = 0;
            while (n3 < n) {
                string = "element" + (n3 + 1);
                string5 = javaRefactoringArguments.getAttribute(string);
                if (string5 != null && !"".equals(string5)) {
                    iResource = JDTRefactoringDescriptor.handleToResource(javaRefactoringArguments.getProject(), string5);
                    if (iResource == null || !iResource.exists()) {
                        refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iResource, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.delete"));
                    } else {
                        arrayList.add(iResource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string));
                }
                ++n3;
            }
            this.fResources = arrayList.toArray(new IResource[arrayList.size()]);
            arrayList = new ArrayList();
            n3 = 0;
            while (n3 < n2) {
                string = "element" + (n + n3 + 1);
                string5 = javaRefactoringArguments.getAttribute(string);
                if (string5 != null && !"".equals(string5)) {
                    iResource = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string5, false);
                    if (iResource == null || !iResource.exists()) {
                        refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iResource, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.delete"));
                    } else {
                        arrayList.add(iResource);
                    }
                } else {
                    return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, string));
                }
                ++n3;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fJavaElements = arrayList.toArray(new IJavaElement[arrayList.size()]);
        this.fElements = new Object[this.fResources.length + this.fJavaElements.length];
        System.arraycopy(this.fResources, 0, this.fElements, 0, this.fResources.length);
        System.arraycopy(this.fJavaElements, 0, this.fElements, this.fResources.length, this.fJavaElements.length);
        return refactoringStatus;
    }
}

