/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;

public class JavaElementTransfer
extends ByteArrayTransfer {
    private static final JavaElementTransfer fInstance = new JavaElementTransfer();
    private static final String TYPE_NAME = "java-element-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)fInstance)).hashCode();
    private static final int TYPEID = JavaElementTransfer.registerType((String)TYPE_NAME);

    private JavaElementTransfer() {
    }

    public static JavaElementTransfer getInstance() {
        return fInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof IJavaElement[])) {
            return;
        }
        IJavaElement[] iJavaElementArray = (IJavaElement[])object;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(iJavaElementArray.length);
            int n = 0;
            while (n < iJavaElementArray.length) {
                JavaElementTransfer.writeJavaElement(dataOutputStream, iJavaElementArray[n]);
                ++n;
            }
            dataOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            super.javaToNative((Object)byArray, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] byArray = (byte[])super.nativeToJava(transferData);
        if (byArray == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
        try {
            int n = dataInputStream.readInt();
            IJavaElement[] iJavaElementArray = new IJavaElement[n];
            int n2 = 0;
            while (n2 < n) {
                iJavaElementArray[n2] = this.readJavaElement(dataInputStream);
                ++n2;
            }
            return iJavaElementArray;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IJavaElement readJavaElement(DataInputStream dataInputStream) throws IOException {
        String string = dataInputStream.readUTF();
        return JavaCore.create((String)string);
    }

    private static void writeJavaElement(DataOutputStream dataOutputStream, IJavaElement iJavaElement) throws IOException {
        dataOutputStream.writeUTF(iJavaElement.getHandleIdentifier());
    }
}

