/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IParticipantDescriptorFilter;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.RefactoringModifications;

public class MoveModifications
extends RefactoringModifications {
    private List fMoves = new ArrayList();
    private List fMoveArguments = new ArrayList();
    private List fParticipantDescriptorFilter = new ArrayList();

    public void move(IResource iResource, MoveArguments moveArguments) {
        this.add(iResource, (RefactoringArguments)moveArguments, null);
    }

    public void move(IPackageFragmentRoot iPackageFragmentRoot, MoveArguments moveArguments) {
        this.add(iPackageFragmentRoot, (RefactoringArguments)moveArguments, null);
        IResource iResource = iPackageFragmentRoot.getResource();
        if (iResource != null) {
            this.getResourceModifications().addMove(iResource, new MoveArguments((Object)this.getResourceDestination(moveArguments), moveArguments.getUpdateReferences()));
            IFile iFile = this.getClasspathFile(iResource);
            if (iFile != null) {
                this.getResourceModifications().addChanged(iFile);
            }
            if ((iFile = this.getClasspathFile(this.getResourceDestination(moveArguments))) != null) {
                this.getResourceModifications().addChanged(iFile);
            }
        }
    }

    public void move(IPackageFragment iPackageFragment, MoveArguments moveArguments) throws CoreException {
        this.add(iPackageFragment, (RefactoringArguments)moveArguments, null);
        if (iPackageFragment.getResource() == null) {
            return;
        }
        IPackageFragmentRoot iPackageFragmentRoot = (IPackageFragmentRoot)moveArguments.getDestination();
        if (iPackageFragmentRoot.getResource() == null) {
            return;
        }
        IPackageFragment iPackageFragment2 = iPackageFragmentRoot.getPackageFragment(iPackageFragment.getElementName());
        if (!iPackageFragment.hasSubpackages() && !iPackageFragment2.exists()) {
            IContainer iContainer = iPackageFragment2.getResource().getParent();
            this.createIncludingParents(iContainer);
            this.getResourceModifications().addMove(iPackageFragment.getResource(), new MoveArguments((Object)iContainer, moveArguments.getUpdateReferences()));
        } else {
            IResource iResource;
            IContainer iContainer = (IContainer)iPackageFragment.getResource();
            IContainer iContainer2 = (IContainer)iPackageFragment2.getResource();
            this.createIncludingParents(iContainer2);
            MoveArguments moveArguments2 = new MoveArguments((Object)iContainer2, moveArguments.getUpdateReferences());
            IResource[] iResourceArray = this.collectResourcesOfInterest(iPackageFragment);
            HashSet<IResource> hashSet = new HashSet<IResource>(Arrays.asList(iContainer.members()));
            int n = 0;
            while (n < iResourceArray.length) {
                iResource = iResourceArray[n];
                this.getResourceModifications().addMove(iResource, moveArguments2);
                hashSet.remove(iResource);
                ++n;
            }
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                iResource = (IResource)iterator.next();
                if (!(iResource instanceof IFile)) continue;
                this.getResourceModifications().addDelete(iResource);
                iterator.remove();
            }
            if (hashSet.isEmpty()) {
                this.getResourceModifications().addDelete((IResource)iContainer);
            }
        }
    }

    public void move(ICompilationUnit iCompilationUnit, MoveArguments moveArguments) throws CoreException {
        this.add(iCompilationUnit, (RefactoringArguments)moveArguments, null);
        IType[] iTypeArray = iCompilationUnit.getTypes();
        int n = 0;
        while (n < iTypeArray.length) {
            this.add(iTypeArray[n], (RefactoringArguments)moveArguments, null);
            ++n;
        }
        IResource iResource = this.getResourceDestination(moveArguments);
        if (iResource != null && iCompilationUnit.getResource() != null) {
            this.getResourceModifications().addMove(iCompilationUnit.getResource(), new MoveArguments((Object)iResource, moveArguments.getUpdateReferences()));
        }
    }

    public void buildDelta(IResourceChangeDescriptionFactory iResourceChangeDescriptionFactory) {
        int n = 0;
        while (n < this.fMoves.size()) {
            Object e = this.fMoves.get(n);
            if (e instanceof IResource) {
                ResourceModifications.buildMoveDelta(iResourceChangeDescriptionFactory, (IResource)e, (MoveArguments)this.fMoveArguments.get(n));
            }
            ++n;
        }
        this.getResourceModifications().buildDelta(iResourceChangeDescriptionFactory);
    }

    public void buildValidateEdits(ValidateEditChecker validateEditChecker) {
        Iterator iterator = this.fMoves.iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit;
            IResource iResource;
            Object e = iterator.next();
            if (!(e instanceof ICompilationUnit) || (iResource = (iCompilationUnit = (ICompilationUnit)e).getResource()) == null || iResource.getType() != 1) continue;
            validateEditChecker.addFile((IFile)iResource);
        }
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, RefactoringProcessor refactoringProcessor, String[] stringArray, SharableParticipants sharableParticipants) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.fMoves.size()) {
            arrayList.addAll(Arrays.asList(ParticipantManager.loadMoveParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)refactoringProcessor, this.fMoves.get(n), (MoveArguments)((MoveArguments)this.fMoveArguments.get(n)), (IParticipantDescriptorFilter)((IParticipantDescriptorFilter)this.fParticipantDescriptorFilter.get(n)), (String[])stringArray, (SharableParticipants)sharableParticipants)));
            ++n;
        }
        arrayList.addAll(Arrays.asList(this.getResourceModifications().getParticipants(refactoringStatus, refactoringProcessor, stringArray, sharableParticipants)));
        return arrayList.toArray(new RefactoringParticipant[arrayList.size()]);
    }

    private void add(Object object, RefactoringArguments refactoringArguments, IParticipantDescriptorFilter iParticipantDescriptorFilter) {
        Assert.isNotNull((Object)object);
        Assert.isNotNull((Object)refactoringArguments);
        this.fMoves.add(object);
        this.fMoveArguments.add(refactoringArguments);
        this.fParticipantDescriptorFilter.add(iParticipantDescriptorFilter);
    }

    private IResource getResourceDestination(MoveArguments moveArguments) {
        Object object = moveArguments.getDestination();
        IResource iResource = null;
        if (object instanceof IJavaElement) {
            iResource = ((IJavaElement)object).getResource();
        } else if (object instanceof IResource) {
            iResource = (IResource)object;
        }
        return iResource;
    }
}

