/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IImportContainer;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageDeclaration;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.dom.SelectionAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

public class ASTNodeSearchUtil {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;

    private ASTNodeSearchUtil() {
    }

    public static ASTNode[] getAstNodes(SearchMatch[] searchMatchArray, CompilationUnit compilationUnit) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(searchMatchArray.length);
        int n = 0;
        while (n < searchMatchArray.length) {
            ASTNode aSTNode = ASTNodeSearchUtil.getAstNode(searchMatchArray[n], compilationUnit);
            if (aSTNode != null) {
                arrayList.add(aSTNode);
            }
            ++n;
        }
        return arrayList.toArray(new ASTNode[arrayList.size()]);
    }

    public static ASTNode getAstNode(SearchMatch searchMatch, CompilationUnit compilationUnit) {
        ASTNode aSTNode = ASTNodeSearchUtil.getAstNode(compilationUnit, searchMatch.getOffset(), searchMatch.getLength());
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getParent() == null) {
            return null;
        }
        return aSTNode;
    }

    public static ASTNode getAstNode(CompilationUnit compilationUnit, int n, int n2) {
        SelectionAnalyzer selectionAnalyzer = new SelectionAnalyzer(Selection.createFromStartLength(n, n2), true);
        compilationUnit.accept((ASTVisitor)selectionAnalyzer);
        ASTNode aSTNode = selectionAnalyzer.getFirstSelectedNode();
        if (aSTNode == null && selectionAnalyzer.getLastCoveringNode() instanceof SuperConstructorInvocation) {
            aSTNode = selectionAnalyzer.getLastCoveringNode().getParent();
        } else if (aSTNode == null && selectionAnalyzer.getLastCoveringNode() instanceof ConstructorInvocation) {
            aSTNode = selectionAnalyzer.getLastCoveringNode().getParent();
        }
        if (aSTNode == null) {
            return null;
        }
        ASTNode aSTNode2 = aSTNode.getParent();
        if (aSTNode2 instanceof MethodDeclaration) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)aSTNode2;
            if (!(aSTNode instanceof SimpleName) && methodDeclaration.isConstructor() && methodDeclaration.getBody() != null && methodDeclaration.getBody().statements().size() > 0 && (methodDeclaration.getBody().statements().get(0) instanceof ConstructorInvocation || methodDeclaration.getBody().statements().get(0) instanceof SuperConstructorInvocation) && ((ASTNode)methodDeclaration.getBody().statements().get(0)).getLength() == n2 + 1) {
                return (ASTNode)methodDeclaration.getBody().statements().get(0);
            }
        }
        if (aSTNode2 instanceof SuperConstructorInvocation && aSTNode2.getLength() == n2 + 1) {
            return aSTNode2;
        }
        if (aSTNode2 instanceof ConstructorInvocation && aSTNode2.getLength() == n2 + 1) {
            return aSTNode2;
        }
        return aSTNode;
    }

    public static MethodDeclaration getMethodDeclarationNode(IMethod iMethod, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iMethod, compilationUnit);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (MethodDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static AnnotationTypeMemberDeclaration getAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iMethod, compilationUnit);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AnnotationTypeMemberDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static BodyDeclaration getMethodOrAnnotationTypeMemberDeclarationNode(IMethod iMethod, CompilationUnit compilationUnit) throws JavaModelException {
        if (JdtFlags.isAnnotation((IMember)iMethod.getDeclaringType())) {
            return ASTNodeSearchUtil.getAnnotationTypeMemberDeclarationNode(iMethod, compilationUnit);
        }
        return ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, compilationUnit);
    }

    public static VariableDeclarationFragment getFieldDeclarationFragmentNode(IField iField, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iField, compilationUnit);
        if (aSTNode instanceof VariableDeclarationFragment) {
            return (VariableDeclarationFragment)aSTNode;
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (VariableDeclarationFragment)ASTNodes.getParent(aSTNode, clazz);
    }

    public static FieldDeclaration getFieldDeclarationNode(IField iField, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iField, compilationUnit);
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.dom.FieldDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (FieldDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static EnumConstantDeclaration getEnumConstantDeclaration(IField iField, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iField, compilationUnit);
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EnumConstantDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static BodyDeclaration getFieldOrEnumConstantDeclaration(IField iField, CompilationUnit compilationUnit) throws JavaModelException {
        if (JdtFlags.isEnum((IMember)iField)) {
            return ASTNodeSearchUtil.getEnumConstantDeclaration(iField, compilationUnit);
        }
        return ASTNodeSearchUtil.getFieldDeclarationNode(iField, compilationUnit);
    }

    public static EnumDeclaration getEnumDeclarationNode(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, compilationUnit);
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.wst.jsdt.core.dom.EnumDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (EnumDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static AnnotationTypeDeclaration getAnnotationTypeDeclarationNode(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, compilationUnit);
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AnnotationTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static BodyDeclaration getBodyDeclarationNode(IMember iMember, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode(iMember, compilationUnit);
        Class<?> clazz = class$7;
        if (clazz == null) {
            try {
                clazz = class$7 = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (BodyDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static AbstractTypeDeclaration getAbstractTypeDeclarationNode(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, compilationUnit);
        Class<?> clazz = class$8;
        if (clazz == null) {
            try {
                clazz = class$8 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static TypeDeclaration getTypeDeclarationNode(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, compilationUnit);
        Class<?> clazz = class$9;
        if (clazz == null) {
            try {
                clazz = class$9 = Class.forName("org.eclipse.wst.jsdt.core.dom.TypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (TypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
    }

    public static ClassInstanceCreation getClassInstanceCreationNode(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.getNameNode((IMember)iType, compilationUnit);
        Class<?> clazz = class$10;
        if (clazz == null) {
            try {
                clazz = class$10 = Class.forName("org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ClassInstanceCreation)ASTNodes.getParent(aSTNode, clazz);
    }

    public static List getBodyDeclarationList(IType iType, CompilationUnit compilationUnit) throws JavaModelException {
        if (iType.isAnonymous()) {
            return ASTNodeSearchUtil.getClassInstanceCreationNode(iType, compilationUnit).getAnonymousClassDeclaration().bodyDeclarations();
        }
        return ASTNodeSearchUtil.getAbstractTypeDeclarationNode(iType, compilationUnit).bodyDeclarations();
    }

    public static ASTNode[] getDeclarationNodes(IJavaElement iJavaElement, CompilationUnit compilationUnit) throws JavaModelException {
        switch (iJavaElement.getElementType()) {
            case 8: {
                return new ASTNode[]{ASTNodeSearchUtil.getFieldOrEnumConstantDeclaration((IField)iJavaElement, compilationUnit)};
            }
            case 12: {
                return ASTNodeSearchUtil.getImportNodes((IImportContainer)iJavaElement, compilationUnit);
            }
            case 13: {
                return new ASTNode[]{ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)iJavaElement, compilationUnit)};
            }
            case 10: {
                return new ASTNode[]{ASTNodeSearchUtil.getInitializerNode((IInitializer)iJavaElement, compilationUnit)};
            }
            case 9: {
                return new ASTNode[]{ASTNodeSearchUtil.getMethodOrAnnotationTypeMemberDeclarationNode((IMethod)iJavaElement, compilationUnit)};
            }
            case 11: {
                return new ASTNode[]{ASTNodeSearchUtil.getPackageDeclarationNode((IPackageDeclaration)iJavaElement, compilationUnit)};
            }
            case 7: {
                return new ASTNode[]{ASTNodeSearchUtil.getAbstractTypeDeclarationNode((IType)iJavaElement, compilationUnit)};
            }
        }
        Assert.isTrue((boolean)false, (String)String.valueOf(iJavaElement.getElementType()));
        return null;
    }

    private static ASTNode getNameNode(IMember iMember, CompilationUnit compilationUnit) throws JavaModelException {
        return NodeFinder.perform((ASTNode)compilationUnit, iMember.getNameRange());
    }

    public static PackageDeclaration getPackageDeclarationNode(IPackageDeclaration iPackageDeclaration, CompilationUnit compilationUnit) throws JavaModelException {
        return (PackageDeclaration)ASTNodeSearchUtil.findNode(iPackageDeclaration.getSourceRange(), compilationUnit);
    }

    public static ImportDeclaration getImportDeclarationNode(IImportDeclaration iImportDeclaration, CompilationUnit compilationUnit) throws JavaModelException {
        return (ImportDeclaration)ASTNodeSearchUtil.findNode(iImportDeclaration.getSourceRange(), compilationUnit);
    }

    public static ASTNode[] getImportNodes(IImportContainer iImportContainer, CompilationUnit compilationUnit) throws JavaModelException {
        IJavaElement[] iJavaElementArray = iImportContainer.getChildren();
        ASTNode[] aSTNodeArray = new ASTNode[iJavaElementArray.length];
        int n = 0;
        while (n < iJavaElementArray.length) {
            aSTNodeArray[n] = ASTNodeSearchUtil.getImportDeclarationNode((IImportDeclaration)iJavaElementArray[n], compilationUnit);
            ++n;
        }
        return aSTNodeArray;
    }

    public static Initializer getInitializerNode(IInitializer iInitializer, CompilationUnit compilationUnit) throws JavaModelException {
        ASTNode aSTNode = ASTNodeSearchUtil.findNode(iInitializer.getSourceRange(), compilationUnit);
        if (aSTNode instanceof Initializer) {
            return (Initializer)aSTNode;
        }
        if (aSTNode instanceof Block && aSTNode.getParent() instanceof Initializer) {
            return (Initializer)aSTNode.getParent();
        }
        return null;
    }

    private static ASTNode findNode(ISourceRange iSourceRange, CompilationUnit compilationUnit) {
        NodeFinder nodeFinder = new NodeFinder(iSourceRange.getOffset(), iSourceRange.getLength());
        compilationUnit.accept((ASTVisitor)nodeFinder);
        ASTNode aSTNode = nodeFinder.getCoveredNode();
        if (aSTNode != null) {
            return aSTNode;
        }
        return nodeFinder.getCoveringNode();
    }

    public static ASTNode[] findNodes(SearchMatch[] searchMatchArray, CompilationUnit compilationUnit) {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(searchMatchArray.length);
        int n = 0;
        while (n < searchMatchArray.length) {
            ASTNode aSTNode = ASTNodeSearchUtil.findNode(searchMatchArray[n], compilationUnit);
            if (aSTNode != null) {
                arrayList.add(aSTNode);
            }
            ++n;
        }
        return arrayList.toArray(new ASTNode[arrayList.size()]);
    }

    public static ASTNode findNode(SearchMatch searchMatch, CompilationUnit compilationUnit) {
        ASTNode aSTNode = NodeFinder.perform((ASTNode)compilationUnit, searchMatch.getOffset(), searchMatch.getLength());
        if (aSTNode == null) {
            return null;
        }
        if (aSTNode.getParent() == null) {
            return null;
        }
        return aSTNode;
    }
}

