/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;

class ConstructorReferenceFinder {
    private final IType fType;
    private final IMethod[] fConstructors;

    private ConstructorReferenceFinder(IType iType) throws JavaModelException {
        this.fConstructors = JavaElementUtil.getAllConstructors(iType);
        this.fType = iType;
    }

    private ConstructorReferenceFinder(IMethod iMethod) {
        this.fConstructors = new IMethod[]{iMethod};
        this.fType = iMethod.getDeclaringType();
    }

    public static SearchResultGroup[] getConstructorReferences(IType iType, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        return new ConstructorReferenceFinder(iType).getConstructorReferences(iProgressMonitor, null, 2, refactoringStatus);
    }

    public static SearchResultGroup[] getConstructorReferences(IType iType, WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        return new ConstructorReferenceFinder(iType).getConstructorReferences(iProgressMonitor, workingCopyOwner, 2, refactoringStatus);
    }

    public static SearchResultGroup[] getConstructorOccurrences(IMethod iMethod, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        Assert.isTrue((boolean)iMethod.isConstructor());
        return new ConstructorReferenceFinder(iMethod).getConstructorReferences(iProgressMonitor, null, 3, refactoringStatus);
    }

    private SearchResultGroup[] getConstructorReferences(IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner, int n, RefactoringStatus refactoringStatus) throws JavaModelException {
        IJavaSearchScope iJavaSearchScope = this.createSearchScope();
        SearchPattern searchPattern = RefactoringSearchEngine.createOrPattern((IJavaElement[])this.fConstructors, n);
        if (searchPattern == null) {
            if (this.fConstructors.length != 0) {
                return new SearchResultGroup[0];
            }
            return this.getImplicitConstructorReferences(iProgressMonitor, workingCopyOwner, refactoringStatus);
        }
        return this.removeUnrealReferences(RefactoringSearchEngine.search(searchPattern, workingCopyOwner, iJavaSearchScope, iProgressMonitor, refactoringStatus));
    }

    private SearchResultGroup[] removeUnrealReferences(SearchResultGroup[] searchResultGroupArray) {
        ArrayList<SearchResultGroup> arrayList = new ArrayList<SearchResultGroup>(searchResultGroupArray.length);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, false);
                SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
                ArrayList<SearchMatch> arrayList2 = new ArrayList<SearchMatch>(Arrays.asList(searchMatchArray));
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    SearchMatch searchMatch = searchMatchArray[n2];
                    if (!this.isRealConstructorReferenceNode(ASTNodeSearchUtil.getAstNode(searchMatch, compilationUnit))) {
                        arrayList2.remove(searchMatch);
                    }
                    ++n2;
                }
                if (!arrayList2.isEmpty()) {
                    arrayList.add(new SearchResultGroup(searchResultGroup.getResource(), arrayList2.toArray(new SearchMatch[arrayList2.size()])));
                }
            }
            ++n;
        }
        return arrayList.toArray(new SearchResultGroup[arrayList.size()]);
    }

    private boolean isRealConstructorReferenceNode(ASTNode aSTNode) {
        MethodDeclaration methodDeclaration;
        String string = this.fConstructors[0].getDeclaringType().getElementName();
        if (aSTNode.getParent() instanceof AbstractTypeDeclaration && ((AbstractTypeDeclaration)aSTNode.getParent()).getNameProperty().equals(aSTNode.getLocationInParent())) {
            return false;
        }
        return !(aSTNode.getParent() instanceof MethodDeclaration) || !MethodDeclaration.NAME_PROPERTY.equals(aSTNode.getLocationInParent()) || !(methodDeclaration = (MethodDeclaration)aSTNode.getParent()).isConstructor() || methodDeclaration.getName().getIdentifier().equals(string);
    }

    private IJavaSearchScope createSearchScope() throws JavaModelException {
        if (this.fConstructors.length == 0) {
            return RefactoringScopeFactory.create((IJavaElement)this.fType);
        }
        return RefactoringScopeFactory.create((IJavaElement)this.getMostVisibleConstructor());
    }

    private IMethod getMostVisibleConstructor() throws JavaModelException {
        Assert.isTrue((this.fConstructors.length > 0 ? 1 : 0) != 0);
        IMethod iMethod = this.fConstructors[0];
        int n = JdtFlags.getVisibilityCode((IMember)this.fConstructors[0]);
        int n2 = 1;
        while (n2 < this.fConstructors.length) {
            IMethod iMethod2 = this.fConstructors[n2];
            if (JdtFlags.isHigherVisibility(JdtFlags.getVisibilityCode((IMember)iMethod2), n)) {
                iMethod = iMethod2;
            }
            ++n2;
        }
        return iMethod;
    }

    private SearchResultGroup[] getImplicitConstructorReferences(IProgressMonitor iProgressMonitor, WorkingCopyOwner workingCopyOwner, RefactoringStatus refactoringStatus) throws JavaModelException {
        iProgressMonitor.beginTask("", 2);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getImplicitConstructorReferencesFromHierarchy(workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
        arrayList.addAll(this.getImplicitConstructorReferencesInClassCreations(workingCopyOwner, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus));
        iProgressMonitor.done();
        return RefactoringSearchEngine.groupByCu(arrayList.toArray(new SearchMatch[arrayList.size()]), refactoringStatus);
    }

    private List getImplicitConstructorReferencesInClassCreations(WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        SearchPattern searchPattern = SearchPattern.createPattern((IJavaElement)this.fType, (int)2, (int)24);
        IJavaSearchScope iJavaSearchScope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchResultGroup[] searchResultGroupArray = RefactoringSearchEngine.search(searchPattern, workingCopyOwner, iJavaSearchScope, iProgressMonitor, refactoringStatus);
        ArrayList<SearchMatch> arrayList = new ArrayList<SearchMatch>();
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchResultGroup searchResultGroup = searchResultGroupArray[n];
            ICompilationUnit iCompilationUnit = searchResultGroup.getCompilationUnit();
            if (iCompilationUnit != null) {
                CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iCompilationUnit, false);
                SearchMatch[] searchMatchArray = searchResultGroup.getSearchResults();
                int n2 = 0;
                while (n2 < searchMatchArray.length) {
                    SearchMatch searchMatch = searchMatchArray[n2];
                    ASTNode aSTNode = ASTNodeSearchUtil.getAstNode(searchMatch, compilationUnit);
                    if (ConstructorReferenceFinder.isImplicitConstructorReferenceNodeInClassCreations(aSTNode)) {
                        arrayList.add(searchMatch);
                    }
                    ++n2;
                }
            }
            ++n;
        }
        return arrayList;
    }

    public static boolean isImplicitConstructorReferenceNodeInClassCreations(ASTNode aSTNode) {
        if (aSTNode instanceof Type) {
            ASTNode aSTNode2;
            ASTNode aSTNode3 = aSTNode.getParent();
            if (aSTNode3 instanceof ClassInstanceCreation) {
                return aSTNode.equals((Object)((ClassInstanceCreation)aSTNode3).getType());
            }
            if (aSTNode3 instanceof ParameterizedType && (aSTNode2 = aSTNode3.getParent()) instanceof ClassInstanceCreation) {
                ParameterizedType parameterizedType = (ParameterizedType)((ClassInstanceCreation)aSTNode2).getType();
                return aSTNode.equals((Object)parameterizedType.getType());
            }
        }
        return false;
    }

    private List getImplicitConstructorReferencesFromHierarchy(WorkingCopyOwner workingCopyOwner, IProgressMonitor iProgressMonitor) throws JavaModelException {
        IType[] iTypeArray = ConstructorReferenceFinder.getNonBinarySubtypes(workingCopyOwner, this.fType, iProgressMonitor);
        ArrayList arrayList = new ArrayList(iTypeArray.length);
        int n = 0;
        while (n < iTypeArray.length) {
            arrayList.addAll(ConstructorReferenceFinder.getAllSuperConstructorInvocations(iTypeArray[n]));
            ++n;
        }
        return arrayList;
    }

    private static IType[] getNonBinarySubtypes(WorkingCopyOwner workingCopyOwner, IType iType, IProgressMonitor iProgressMonitor) throws JavaModelException {
        ITypeHierarchy iTypeHierarchy = null;
        iTypeHierarchy = workingCopyOwner == null ? iType.newTypeHierarchy(iProgressMonitor) : iType.newSupertypeHierarchy(workingCopyOwner, iProgressMonitor);
        IType[] iTypeArray = iTypeHierarchy.getAllSubtypes(iType);
        ArrayList<IType> arrayList = new ArrayList<IType>(iTypeArray.length);
        int n = 0;
        while (n < iTypeArray.length) {
            if (!iTypeArray[n].isBinary()) {
                arrayList.add(iTypeArray[n]);
            }
            ++n;
        }
        return arrayList.toArray(new IType[arrayList.size()]);
    }

    private static Collection getAllSuperConstructorInvocations(IType iType) throws JavaModelException {
        IMethod[] iMethodArray = JavaElementUtil.getAllConstructors(iType);
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)iType.getCompilationUnit(), false);
        ArrayList<SearchMatch> arrayList = new ArrayList<SearchMatch>(iMethodArray.length);
        int n = 0;
        while (n < iMethodArray.length) {
            SuperConstructorInvocation superConstructorInvocation = ConstructorReferenceFinder.getSuperConstructorCallNode(iMethodArray[n], compilationUnit);
            if (superConstructorInvocation != null) {
                arrayList.add(ConstructorReferenceFinder.createSearchResult((ASTNode)superConstructorInvocation, iMethodArray[n]));
            }
            ++n;
        }
        return arrayList;
    }

    private static SearchMatch createSearchResult(ASTNode aSTNode, IMethod iMethod) {
        int n = aSTNode.getStartPosition();
        int n2 = ASTNodes.getInclusiveEnd(aSTNode);
        IResource iResource = iMethod.getResource();
        return new SearchMatch((IJavaElement)iMethod, 0, n, n2 - n, SearchEngine.getDefaultSearchParticipant(), iResource);
    }

    private static SuperConstructorInvocation getSuperConstructorCallNode(IMethod iMethod, CompilationUnit compilationUnit) throws JavaModelException {
        Assert.isTrue((boolean)iMethod.isConstructor());
        MethodDeclaration methodDeclaration = ASTNodeSearchUtil.getMethodDeclarationNode(iMethod, compilationUnit);
        Assert.isTrue((boolean)methodDeclaration.isConstructor());
        Block block = methodDeclaration.getBody();
        Assert.isNotNull((Object)block);
        List list = block.statements();
        if (!list.isEmpty() && list.get(0) instanceof SuperConstructorInvocation) {
            return (SuperConstructorInvocation)list.get(0);
        }
        return null;
    }
}

