/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.JavaRefactoringDescriptor;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.MoveStaticMembersDescriptor;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateFieldCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.delegates.DelegateMethodCreator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberCheckUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MoveStaticMemberAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MovedMemberAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ReferenceAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IDelegateUpdating;
import org.eclipse.wst.jsdt.internal.corext.refactoring.tagging.IScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.ui.JavaElementLabels;

public final class MoveStaticMembersProcessor
extends MoveProcessor
implements IDelegateUpdating,
IScriptableRefactoring,
ICommentProvider {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String TRACKED_POSITION_PROPERTY = "MoveStaticMembersProcessor.trackedPosition";
    private IMember[] fMembersToMove;
    private IType fDestinationType;
    private String fDestinationTypeName;
    private CodeGenerationSettings fPreferences;
    private CompositeChange fChange;
    private CompilationUnitRewrite fSource;
    private ITypeBinding fSourceBinding;
    private CompilationUnitRewrite fTarget;
    private IBinding[] fMemberBindings;
    private BodyDeclaration[] fMemberDeclarations;
    private boolean fDelegateUpdating;
    private boolean fDelegateDeprecation;
    private String fComment;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public MoveStaticMembersProcessor(IMember[] iMemberArray, CodeGenerationSettings codeGenerationSettings) {
        this.fMembersToMove = iMemberArray;
        this.fPreferences = codeGenerationSettings;
        this.fDelegateUpdating = false;
        this.fDelegateDeprecation = true;
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isMoveStaticMembersAvailable(this.fMembersToMove);
    }

    public Object[] getElements() {
        Object[] objectArray = new Object[this.fMembersToMove.length];
        System.arraycopy(this.fMembersToMove, 0, objectArray, 0, this.fMembersToMove.length);
        return objectArray;
    }

    public String getIdentifier() {
        return "org.eclipse.wst.jsdt.ui.MoveStaticMemberProcessor";
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus refactoringStatus, SharableParticipants sharableParticipants) throws CoreException {
        ArrayList<MoveParticipant> arrayList = new ArrayList<MoveParticipant>();
        MoveArguments moveArguments = new MoveArguments((Object)this.fDestinationType, true);
        String[] stringArray = JavaProcessors.computeAffectedNaturs((IJavaElement[])this.fMembersToMove);
        int n = 0;
        while (n < this.fMembersToMove.length) {
            IMember iMember = this.fMembersToMove[n];
            arrayList.addAll(Arrays.asList(ParticipantManager.loadMoveParticipants((RefactoringStatus)refactoringStatus, (RefactoringProcessor)this, (Object)iMember, (MoveArguments)moveArguments, (String[])stringArray, (SharableParticipants)sharableParticipants)));
            ++n;
        }
        return arrayList.toArray(new RefactoringParticipant[arrayList.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean canEnableDelegateUpdating() {
        try {
            int n = 0;
            while (true) {
                if (n >= this.fMembersToMove.length) {
                    return false;
                }
                if (this.isDelegateCreationAvailable(this.fMembersToMove[n])) {
                    return true;
                }
                ++n;
            }
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    private boolean isDelegateCreationAvailable(IMember iMember) throws JavaModelException {
        if (iMember instanceof IMethod) {
            return true;
        }
        return iMember instanceof IField && RefactoringAvailabilityTester.isDelegateCreationAvailable((IField)iMember);
    }

    public boolean getDelegateUpdating() {
        return this.fDelegateUpdating;
    }

    public void setDelegateUpdating(boolean bl) {
        this.fDelegateUpdating = bl;
    }

    public boolean getDeprecateDelegates() {
        return this.fDelegateDeprecation;
    }

    public void setDeprecateDelegates(boolean bl) {
        this.fDelegateDeprecation = bl;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.MoveMembersRefactoring_Move_Members;
    }

    public IType getDestinationType() {
        return this.fDestinationType;
    }

    public void setDestinationTypeFullyQualifiedName(String string) throws JavaModelException {
        Assert.isNotNull((Object)string);
        this.fDestinationType = this.resolveType(string);
        this.fDestinationTypeName = string;
    }

    public IMember[] getMembersToMove() {
        return this.fMembersToMove;
    }

    public IType getDeclaringType() {
        return this.fMembersToMove[0].getDeclaringType();
    }

    private IType resolveType(String string) throws JavaModelException {
        IType iType = this.getDeclaringType().getJavaProject().findType(string);
        if (iType == null) {
            iType = this.getDeclaringType().getJavaProject().findType(this.getDeclaringType().getPackageFragment().getElementName(), string);
        }
        return iType;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        RefactoringStatus refactoringStatus;
        block4: {
            RefactoringStatus refactoringStatus2;
            try {
                iProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 1);
                refactoringStatus = new RefactoringStatus();
                refactoringStatus.merge(this.checkDeclaringType());
                iProgressMonitor.worked(1);
                if (!refactoringStatus.hasFatalError()) break block4;
                refactoringStatus2 = refactoringStatus;
                Object var3_5 = null;
            }
            catch (Throwable throwable) {
                Object var3_7 = null;
                iProgressMonitor.done();
                throw throwable;
            }
            iProgressMonitor.done();
            return refactoringStatus2;
        }
        this.fSource = new CompilationUnitRewrite(this.fMembersToMove[0].getCompilationUnit());
        this.fSourceBinding = (ITypeBinding)((SimpleName)NodeFinder.perform((ASTNode)this.fSource.getRoot(), this.fMembersToMove[0].getDeclaringType().getNameRange())).resolveBinding();
        this.fMemberBindings = this.getMemberBindings();
        if (this.fSourceBinding == null || this.hasUnresolvedMemberBinding()) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_compile_errors, this.fSource.getCu().getElementName()));
        }
        this.fMemberDeclarations = this.getASTMembers(refactoringStatus);
        RefactoringStatus refactoringStatus3 = refactoringStatus;
        Object var3_6 = null;
        iProgressMonitor.done();
        return refactoringStatus3;
    }

    private boolean hasUnresolvedMemberBinding() {
        int n = 0;
        while (n < this.fMemberBindings.length) {
            if (this.fMemberBindings[n] == null) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private RefactoringStatus checkDeclaringType() {
        IType iType = this.getDeclaringType();
        if (JavaModelUtil.getFullyQualifiedName(iType).equals("java.lang.Object")) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_Object);
        }
        if (iType.isBinary()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_binary);
        }
        if (iType.isReadOnly()) {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.MoveMembersRefactoring_read_only);
        }
        return null;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor, CheckConditionsContext checkConditionsContext) throws CoreException {
        RefactoringStatus refactoringStatus;
        RefactoringStatus refactoringStatus2;
        block13: {
            block12: {
                block11: {
                    block10: {
                        this.fTarget = null;
                        iProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 10);
                        refactoringStatus2 = new RefactoringStatus();
                        this.fSource.clearASTAndImportRewrites();
                        refactoringStatus2.merge(this.checkDestinationType());
                        if (!refactoringStatus2.hasFatalError()) break block10;
                        RefactoringStatus refactoringStatus3 = refactoringStatus2;
                        Object var8_9 = null;
                        iProgressMonitor.done();
                        return refactoringStatus3;
                    }
                    refactoringStatus2.merge(this.checkDestinationInsideTypeToMove());
                    if (!refactoringStatus2.hasFatalError()) break block11;
                    RefactoringStatus refactoringStatus4 = refactoringStatus2;
                    Object var8_10 = null;
                    iProgressMonitor.done();
                    return refactoringStatus4;
                }
                refactoringStatus2.merge(MemberCheckUtil.checkMembersInDestinationType(this.fMembersToMove, this.fDestinationType));
                if (!refactoringStatus2.hasFatalError()) break block12;
                RefactoringStatus refactoringStatus5 = refactoringStatus2;
                Object var8_11 = null;
                iProgressMonitor.done();
                return refactoringStatus5;
            }
            refactoringStatus2.merge(this.checkNativeMovedMethods((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
            if (!refactoringStatus2.hasFatalError()) break block13;
            RefactoringStatus refactoringStatus6 = refactoringStatus2;
            Object var8_12 = null;
            iProgressMonitor.done();
            return refactoringStatus6;
        }
        try {
            ArrayList arrayList = new ArrayList();
            this.createChange(arrayList, refactoringStatus2, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 7));
            IFile[] iFileArray = this.getAllFilesToModify(arrayList);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ResourceChangeChecker resourceChangeChecker = (ResourceChangeChecker)checkConditionsContext.getChecker((Class)clazz);
            int n = 0;
            while (n < iFileArray.length) {
                resourceChangeChecker.getDeltaFactory().change(iFileArray[n]);
                ++n;
            }
            refactoringStatus = refactoringStatus2;
            Object var8_13 = null;
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            iProgressMonitor.done();
            throw throwable;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private IFile[] getAllFilesToModify(List list) {
        HashSet<IResource> hashSet = new HashSet<IResource>();
        IResource iResource = this.fDestinationType.getCompilationUnit().getResource();
        hashSet.add(iResource);
        int n = 0;
        while (n < this.fMembersToMove.length) {
            iResource = this.fMembersToMove[n].getCompilationUnit().getResource();
            if (iResource != null) {
                hashSet.add(iResource);
            }
            ++n;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ICompilationUnit iCompilationUnit = (ICompilationUnit)iterator.next();
            if (iCompilationUnit.getResource() == null) continue;
            hashSet.add(iCompilationUnit.getResource());
        }
        return hashSet.toArray(new IFile[hashSet.size()]);
    }

    private RefactoringStatus checkDestinationType() throws JavaModelException {
        if (this.fDestinationType == null) {
            String string = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_not_found, this.fDestinationTypeName);
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        if (this.fDestinationType.equals(this.getDeclaringType())) {
            String string = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_same, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        if (!this.fDestinationType.exists()) {
            String string = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_not_exist, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        if (this.fDestinationType.isBinary()) {
            String string = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_dest_binary, JavaElementUtil.createSignature((IMember)this.fDestinationType));
            return RefactoringStatus.createFatalErrorStatus((String)string);
        }
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (this.fDestinationType.isInterface() && !this.getDeclaringType().isInterface()) {
            refactoringStatus.merge(this.checkFieldsForInterface());
        }
        if (refactoringStatus.hasFatalError()) {
            return refactoringStatus;
        }
        if (!JdtFlags.isStatic((IMember)this.fDestinationType) && this.fDestinationType.getDeclaringType() != null) {
            String string = RefactoringCoreMessages.MoveMembersRefactoring_static_declaration;
            refactoringStatus.addError(string);
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkDestinationInsideTypeToMove() throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < this.fMembersToMove.length) {
            IType iType;
            if (this.fMembersToMove[n] instanceof IType && (this.fDestinationType.equals(iType = (IType)this.fMembersToMove[n]) || JavaElementUtil.isAncestorOf((IJavaElement)iType, (IJavaElement)this.fDestinationType))) {
                String string = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_inside, new String[]{JavaModelUtil.getFullyQualifiedName(iType), JavaModelUtil.getFullyQualifiedName(this.fDestinationType)});
                RefactoringStatusContext refactoringStatusContext = JavaStatusContext.create((ITypeRoot)this.fDestinationType.getCompilationUnit(), this.fDestinationType.getNameRange());
                refactoringStatus.addFatalError(string, refactoringStatusContext);
                return refactoringStatus;
            }
            ++n;
        }
        return refactoringStatus;
    }

    private RefactoringStatus checkFieldsForInterface() throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < this.fMembersToMove.length) {
            if (!this.canMoveToInterface(this.fMembersToMove[n])) {
                String string = RefactoringCoreMessages.MoveMembersRefactoring_only_public_static;
                refactoringStatus.addError(string, JavaStatusContext.create(this.fMembersToMove[n]));
            }
            ++n;
        }
        return refactoringStatus;
    }

    private boolean canMoveToInterface(IMember iMember) throws JavaModelException {
        int n = iMember.getFlags();
        switch (iMember.getElementType()) {
            case 8: {
                if (!(Flags.isPublic((int)n) && Flags.isStatic((int)n) && Flags.isFinal((int)n))) {
                    return false;
                }
                if (Flags.isEnum((int)n)) {
                    return false;
                }
                VariableDeclarationFragment variableDeclarationFragment = ASTNodeSearchUtil.getFieldDeclarationFragmentNode((IField)iMember, this.fSource.getRoot());
                if (variableDeclarationFragment != null) {
                    return variableDeclarationFragment.getInitializer() != null;
                }
            }
            case 7: {
                IType iType = (IType)iMember;
                if (iType.isInterface() && !Checks.isTopLevel(iType)) {
                    return true;
                }
                return Flags.isPublic((int)n) && Flags.isStatic((int)n);
            }
        }
        return false;
    }

    private RefactoringStatus checkMovedMemberAvailability(IMember iMember, IProgressMonitor iProgressMonitor) throws JavaModelException {
        int n;
        IJavaElement[] iJavaElementArray;
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        if (iMember instanceof IType) {
            iJavaElementArray = ((IType)iMember).getChildren();
            iProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, iJavaElementArray.length + 1);
            n = 0;
            while (n < iJavaElementArray.length) {
                if (iJavaElementArray[n] instanceof IInitializer) {
                    iProgressMonitor.worked(1);
                } else {
                    refactoringStatus.merge(this.checkMovedMemberAvailability((IMember)iJavaElementArray[n], (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1)));
                }
                ++n;
            }
        } else {
            iProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, 1);
        }
        iJavaElementArray = this.getTypesNotSeeingMovedMember(iMember, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        n = 0;
        while (n < iJavaElementArray.length) {
            String string = this.createNonAccessibleMemberMessage(iMember, (IType)iJavaElementArray[n], true);
            refactoringStatus.addError(string, JavaStatusContext.create(iMember));
            ++n;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    private IType[] getTypesNotSeeingMovedMember(IMember iMember, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        IType iType;
        if (JdtFlags.isPublic(iMember) && JdtFlags.isPublic((IMember)this.fDestinationType)) {
            return new IType[0];
        }
        HashSet<IType> hashSet = new HashSet<IType>();
        SearchResultGroup[] searchResultGroupArray = MoveStaticMembersProcessor.getReferences(iMember, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1), refactoringStatus);
        int n = 0;
        while (n < searchResultGroupArray.length) {
            SearchMatch[] searchMatchArray = searchResultGroupArray[n].getSearchResults();
            int n2 = 0;
            while (n2 < searchMatchArray.length) {
                SearchMatch searchMatch = searchMatchArray[n2];
                IJavaElement iJavaElement = SearchUtils.getEnclosingJavaElement(searchMatch);
                IType iType2 = (IType)iJavaElement.getAncestor(7);
                if (!(iType2 == null || hashSet.contains(iType2) || this.isWithinMemberToMove(searchMatch) || MoveStaticMembersProcessor.isVisibleFrom(iMember, this.getDestinationType(), iType2))) {
                    hashSet.add(iType2);
                }
                ++n2;
            }
            ++n;
        }
        if (this.fDelegateUpdating && this.isDelegateCreationAvailable(iMember) && !hashSet.contains(iType = iMember.getDeclaringType()) && !MoveStaticMembersProcessor.isVisibleFrom(iMember, this.getDestinationType(), iType)) {
            hashSet.add(iType);
        }
        return hashSet.toArray(new IType[hashSet.size()]);
    }

    private String createNonAccessibleMemberMessage(IMember iMember, IType iType, boolean bl) {
        IType iType2 = bl ? this.getDestinationType() : this.getDeclaringType();
        switch (iMember.getElementType()) {
            case 8: {
                String string = bl ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_field, new String[]{JavaElementUtil.createFieldSignature((IField)iMember), JavaModelUtil.getFullyQualifiedName(iType), JavaModelUtil.getFullyQualifiedName(iType2)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_field, new String[]{JavaElementUtil.createFieldSignature((IField)iMember), JavaModelUtil.getFullyQualifiedName(iType)});
                return string;
            }
            case 9: {
                String string = bl ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_method, new String[]{JavaElementUtil.createMethodSignature((IMethod)iMember), JavaModelUtil.getFullyQualifiedName(iType), JavaModelUtil.getFullyQualifiedName(iType2)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_method, new String[]{JavaElementUtil.createMethodSignature((IMethod)iMember), JavaModelUtil.getFullyQualifiedName(iType)});
                return string;
            }
            case 7: {
                String string = bl ? Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_moved_type, new String[]{JavaModelUtil.getFullyQualifiedName((IType)iMember), JavaModelUtil.getFullyQualifiedName(iType), JavaModelUtil.getFullyQualifiedName(iType2)}) : Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_accessed_type, new String[]{JavaModelUtil.getFullyQualifiedName((IType)iMember), JavaModelUtil.getFullyQualifiedName(iType)});
                return string;
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static SearchResultGroup[] getReferences(IMember iMember, IProgressMonitor iProgressMonitor, RefactoringStatus refactoringStatus) throws JavaModelException {
        RefactoringSearchEngine2 refactoringSearchEngine2 = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaElement)iMember, (int)2, (int)24));
        refactoringSearchEngine2.setFiltering(true, true);
        refactoringSearchEngine2.setScope(RefactoringScopeFactory.create((IJavaElement)iMember));
        refactoringSearchEngine2.setStatus(refactoringStatus);
        refactoringSearchEngine2.searchPattern((IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        return (SearchResultGroup[])refactoringSearchEngine2.getResults();
    }

    private static boolean isVisibleFrom(IMember iMember, IType iType, IType iType2) throws JavaModelException {
        int n = JdtFlags.getVisibilityCode((IMember)iType);
        IType iType3 = iType.getDeclaringType();
        while (iType3 != null) {
            n = JdtFlags.getLowerVisibility(n, JdtFlags.getVisibilityCode((IMember)iType3));
            iType3 = iType3.getDeclaringType();
        }
        switch (n) {
            case 2: {
                return MoveStaticMembersProcessor.isEqualOrEnclosedType(iType2, iType);
            }
            case 0: {
                return JavaModelUtil.isSamePackage(iType2.getPackageFragment(), iType.getPackageFragment());
            }
            case 4: {
                return JavaModelUtil.isSamePackage(iType2.getPackageFragment(), iType.getPackageFragment()) || iType2.newSupertypeHierarchy(null).contains(iType);
            }
            case 1: {
                return true;
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private static boolean isEqualOrEnclosedType(IType iType, IType iType2) {
        while (iType != null) {
            if (iType.equals(iType2)) {
                return true;
            }
            iType = iType.getDeclaringType();
        }
        return false;
    }

    private boolean isWithinMemberToMove(SearchMatch searchMatch) throws JavaModelException {
        ICompilationUnit iCompilationUnit = SearchUtils.getCompilationUnit(searchMatch);
        if (!iCompilationUnit.equals(this.fSource.getCu())) {
            return false;
        }
        int n = searchMatch.getOffset();
        int n2 = 0;
        while (n2 < this.fMembersToMove.length) {
            ISourceRange iSourceRange = this.fMembersToMove[n2].getSourceRange();
            if (iSourceRange.getOffset() <= n && iSourceRange.getOffset() + iSourceRange.getLength() >= n) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private RefactoringStatus checkNativeMovedMethods(IProgressMonitor iProgressMonitor) throws JavaModelException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_checking, this.fMembersToMove.length);
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        int n = 0;
        while (n < this.fMembersToMove.length) {
            if (this.fMembersToMove[n].getElementType() == 9 && JdtFlags.isNative(this.fMembersToMove[n])) {
                String string = Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_native, JavaElementUtil.createMethodSignature((IMethod)this.fMembersToMove[n]));
                refactoringStatus.addWarning(string, JavaStatusContext.create(this.fMembersToMove[n]));
                iProgressMonitor.worked(1);
            }
            ++n;
        }
        iProgressMonitor.done();
        return refactoringStatus;
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.done();
        return this.fChange;
    }

    private void createChange(List list, RefactoringStatus refactoringStatus, IProgressMonitor iProgressMonitor) throws CoreException {
        iProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, 5);
        IMember[] iMemberArray = this.getMembersToMove();
        String string = null;
        IJavaProject iJavaProject = this.getDeclaringType().getJavaProject();
        if (iJavaProject != null) {
            string = iJavaProject.getElementName();
        }
        String string2 = null;
        string2 = iMemberArray.length == 1 ? Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_descriptor_description_single, new String[]{JavaElementLabels.getElementLabel((IJavaElement)iMemberArray[0], JavaElementLabels.ALL_FULLY_QUALIFIED), JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)}) : Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_descriptor_description_multi, new String[]{String.valueOf(iMemberArray.length), JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        int n = 589830;
        IType iType = iMemberArray[0].getDeclaringType();
        try {
            if (iType.isLocal() || iType.isAnonymous()) {
                n |= 0x40000;
            }
        }
        catch (JavaModelException javaModelException) {
            JavaPlugin.log(javaModelException);
        }
        String string3 = iMemberArray.length == 1 ? Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_description_descriptor_short_multi, iMemberArray[0].getElementName()) : RefactoringCoreMessages.MoveMembersRefactoring_move_members;
        JDTRefactoringDescriptorComment jDTRefactoringDescriptorComment = new JDTRefactoringDescriptorComment(string, this, string2);
        jDTRefactoringDescriptorComment.addSetting(Messages.format(RefactoringCoreMessages.MoveStaticMembersProcessor_target_element_pattern, JavaElementLabels.getElementLabel((IJavaElement)this.fDestinationType, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        MoveStaticMembersDescriptor moveStaticMembersDescriptor = new MoveStaticMembersDescriptor();
        moveStaticMembersDescriptor.setProject(string);
        moveStaticMembersDescriptor.setDescription(string3);
        moveStaticMembersDescriptor.setComment(jDTRefactoringDescriptorComment.asString());
        moveStaticMembersDescriptor.setFlags(n);
        moveStaticMembersDescriptor.setDestinationType(this.fDestinationType);
        moveStaticMembersDescriptor.setKeepOriginal(this.fDelegateUpdating);
        moveStaticMembersDescriptor.setDeprecateDelegate(this.fDelegateDeprecation);
        moveStaticMembersDescriptor.setMembers(iMemberArray);
        this.fChange = new DynamicValidationRefactoringChange((JavaRefactoringDescriptor)moveStaticMembersDescriptor, RefactoringCoreMessages.MoveMembersRefactoring_move_members);
        this.fTarget = this.getCuRewrite(this.fDestinationType.getCompilationUnit());
        ITypeBinding iTypeBinding = this.getDestinationBinding();
        if (iTypeBinding == null) {
            refactoringStatus.addFatalError(Messages.format(RefactoringCoreMessages.MoveMembersRefactoring_compile_errors, this.fTarget.getCu().getElementName()));
            iProgressMonitor.done();
            return;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment> hashMap = new HashMap<IMember, MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment>();
            IMember iMember = null;
            SubProgressMonitor subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1, 2);
            subProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, this.fMembersToMove.length);
            HashSet hashSet = new HashSet();
            int n2 = 0;
            while (n2 < this.fMembersToMove.length) {
                iMember = this.fMembersToMove[n2];
                object3 = new MemberVisibilityAdjustor((IJavaElement)this.fDestinationType, iMember);
                ((MemberVisibilityAdjustor)object3).setAdjustments(hashMap);
                ((MemberVisibilityAdjustor)object3).setStatus(refactoringStatus);
                ((MemberVisibilityAdjustor)object3).setVisibilitySeverity(2);
                ((MemberVisibilityAdjustor)object3).setFailureSeverity(2);
                ((MemberVisibilityAdjustor)object3).setRewrite(this.fSource.getASTRewrite(), this.fSource.getRoot());
                ((MemberVisibilityAdjustor)object3).adjustVisibility((IProgressMonitor)new NullProgressMonitor());
                if (this.fDelegateUpdating && this.isDelegateCreationAvailable(iMember)) {
                    Modifier.ModifierKeyword modifierKeyword;
                    object2 = ((MemberVisibilityAdjustor)object3).getVisibilityThreshold((IJavaElement)iMember, (IMember)this.fDestinationType, (IProgressMonitor)new NullProgressMonitor());
                    object = (MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment)hashMap.get(iMember);
                    Modifier.ModifierKeyword modifierKeyword2 = modifierKeyword = object != null ? ((MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment)object).getKeyword() : Modifier.ModifierKeyword.fromFlagValue((int)JdtFlags.getVisibilityCode(iMember));
                    if (MemberVisibilityAdjustor.hasLowerVisibility(modifierKeyword, (Modifier.ModifierKeyword)object2)) {
                        hashMap.put(iMember, new MemberVisibilityAdjustor.IncomingMemberVisibilityAdjustment(iMember, (Modifier.ModifierKeyword)object2, RefactoringStatus.createWarningStatus((String)Messages.format(MemberVisibilityAdjustor.getMessage(iMember), new String[]{MemberVisibilityAdjustor.getLabel((IJavaElement)iMember), MemberVisibilityAdjustor.getLabel((Modifier.ModifierKeyword)object2)}), (RefactoringStatusContext)JavaStatusContext.create(iMember))));
                    }
                }
                refactoringStatus.merge(this.checkMovedMemberAvailability(iMember, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1)));
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    hashMap.remove(object2.next());
                }
                hashSet.addAll(hashMap.keySet());
                ((MemberVisibilityAdjustor)object3).rewriteVisibility((IProgressMonitor)new NullProgressMonitor());
                ++n2;
            }
            String[] stringArray = this.getUpdatedMemberSource(refactoringStatus, this.fMemberDeclarations, iTypeBinding);
            iProgressMonitor.worked(1);
            if (refactoringStatus.hasFatalError()) {
                return;
            }
            object3 = new RefactoringSearchEngine2();
            ((RefactoringSearchEngine2)object3).setPattern((IJavaElement[])this.fMembersToMove, 3);
            ((RefactoringSearchEngine2)object3).setGranularity(2);
            ((RefactoringSearchEngine2)object3).setFiltering(true, true);
            ((RefactoringSearchEngine2)object3).setScope(RefactoringScopeFactory.create(this.fMembersToMove));
            ((RefactoringSearchEngine2)object3).setStatus(refactoringStatus);
            ((RefactoringSearchEngine2)object3).searchPattern((IProgressMonitor)new NullProgressMonitor());
            object2 = ((RefactoringSearchEngine2)object3).getAffectedCompilationUnits();
            list.addAll(Arrays.asList(object2));
            object = new MemberVisibilityAdjustor((IJavaElement)this.fDestinationType, (IMember)this.fDestinationType);
            subProgressMonitor = new SubProgressMonitor(iProgressMonitor, 1);
            subProgressMonitor.beginTask(RefactoringCoreMessages.MoveMembersRefactoring_creating, ((Object)object2).length);
            int n3 = 0;
            while (n3 < ((Object)object2).length) {
                Object object4 = object2[n3];
                CompilationUnitRewrite compilationUnitRewrite = this.getCuRewrite((ICompilationUnit)object4);
                ((MemberVisibilityAdjustor)object).setRewrites(Collections.singletonMap(object4, compilationUnitRewrite));
                ((MemberVisibilityAdjustor)object).setAdjustments(hashMap);
                ((MemberVisibilityAdjustor)object).rewriteVisibility((ICompilationUnit)object4, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subProgressMonitor, 1));
                ReferenceAnalyzer referenceAnalyzer = new ReferenceAnalyzer(compilationUnitRewrite, this.fMemberBindings, iTypeBinding, this.fSourceBinding);
                compilationUnitRewrite.getRoot().accept((ASTVisitor)referenceAnalyzer);
                refactoringStatus.merge(referenceAnalyzer.getStatus());
                if (refactoringStatus.hasFatalError()) {
                    this.fChange = null;
                    return;
                }
                if (!this.fSource.getCu().equals(object4) && !this.fTarget.getCu().equals(object4)) {
                    this.fChange.add((Change)compilationUnitRewrite.createChange());
                }
                ++n3;
            }
            refactoringStatus.merge(this.moveMembers(this.fMemberDeclarations, stringArray));
            this.fChange.add((Change)this.fSource.createChange());
            list.add(this.fSource.getCu());
            if (!this.fSource.getCu().equals(this.fTarget.getCu())) {
                this.fChange.add((Change)this.fTarget.createChange());
                list.add(this.fTarget.getCu());
            }
            iProgressMonitor.worked(1);
        }
        catch (BadLocationException badLocationException) {
            JavaPlugin.log(badLocationException);
        }
    }

    private CompilationUnitRewrite getCuRewrite(ICompilationUnit iCompilationUnit) {
        if (this.fSource.getCu().equals(iCompilationUnit)) {
            return this.fSource;
        }
        if (this.fTarget != null && this.fTarget.getCu().equals(iCompilationUnit)) {
            return this.fTarget;
        }
        return new CompilationUnitRewrite(iCompilationUnit);
    }

    private ITypeBinding getDestinationBinding() throws JavaModelException {
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fTarget.getRoot(), this.fDestinationType.getNameRange());
        if (!(aSTNode instanceof SimpleName)) {
            return null;
        }
        IBinding iBinding = ((SimpleName)aSTNode).resolveBinding();
        if (!(iBinding instanceof ITypeBinding)) {
            return null;
        }
        return (ITypeBinding)iBinding;
    }

    private IBinding[] getMemberBindings() throws JavaModelException {
        IBinding[] iBindingArray = new IBinding[this.fMembersToMove.length];
        int n = 0;
        while (n < this.fMembersToMove.length) {
            IMember iMember = this.fMembersToMove[n];
            SimpleName simpleName = (SimpleName)NodeFinder.perform((ASTNode)this.fSource.getRoot(), iMember.getNameRange());
            iBindingArray[n] = simpleName.resolveBinding();
            ++n;
        }
        return iBindingArray;
    }

    private String[] getUpdatedMemberSource(RefactoringStatus refactoringStatus, BodyDeclaration[] bodyDeclarationArray, ITypeBinding iTypeBinding) throws CoreException, BadLocationException {
        Object object;
        Object object2;
        BodyDeclaration bodyDeclaration;
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        boolean bl2 = this.fSource != this.fTarget;
        HashSet<Object> hashSet = new HashSet<Object>();
        int n = 0;
        while (n < bodyDeclarationArray.length) {
            bodyDeclaration = bodyDeclarationArray[n];
            if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                object2 = (AbstractTypeDeclaration)bodyDeclaration;
                object = object2.resolveBinding();
                if (object != null) {
                    hashSet.add(object);
                }
            } else if (bodyDeclaration instanceof MethodDeclaration) {
                object2 = (MethodDeclaration)bodyDeclaration;
                object = object2.resolveBinding();
                if (object != null) {
                    hashSet.add(object);
                }
            } else if (bodyDeclaration instanceof FieldDeclaration) {
                object2 = (FieldDeclaration)bodyDeclaration;
                object = object2.fragments().iterator();
                while (object.hasNext()) {
                    VariableDeclarationFragment variableDeclarationFragment = (VariableDeclarationFragment)object.next();
                    IVariableBinding iVariableBinding = variableDeclarationFragment.resolveBinding();
                    if (iVariableBinding == null) continue;
                    hashSet.add(iVariableBinding);
                }
            }
            ++n;
        }
        n = 0;
        while (n < bodyDeclarationArray.length) {
            bodyDeclaration = bodyDeclarationArray[n];
            if (bl2) {
                arrayList.addAll(TypeReferenceFinder.perform((ASTNode)bodyDeclaration));
            }
            object2 = new MovedMemberAnalyzer(this.fSource, this.fMemberBindings, this.fSourceBinding, iTypeBinding);
            bodyDeclaration.accept((ASTVisitor)object2);
            ImportRewriteUtil.addImports(this.fTarget, (ASTNode)bodyDeclaration, new HashMap(), new HashMap(), hashSet, false);
            if (this.getDeclaringType().isInterface() && !this.fDestinationType.isInterface()) {
                if (bodyDeclaration instanceof FieldDeclaration) {
                    object = (FieldDeclaration)bodyDeclaration;
                    int n2 = 25;
                    if ((object.getModifiers() & n2) != n2) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)object).setModifiers(n2, null);
                    }
                } else if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                    object = (AbstractTypeDeclaration)bodyDeclaration;
                    int n3 = 9;
                    if ((object.getModifiers() & n3) != n3) {
                        ModifierRewrite.create(this.fSource.getASTRewrite(), (ASTNode)object).setModifiers(object.getModifiers() | n3, null);
                    }
                }
            }
            object = this.fSource.getASTRewrite().track((ASTNode)bodyDeclaration);
            bodyDeclaration.setProperty(TRACKED_POSITION_PROPERTY, object);
            bl |= ((MovedMemberAnalyzer)((Object)object2)).targetNeedsSourceImport();
            refactoringStatus.merge(((MoveStaticMemberAnalyzer)((Object)object2)).getStatus());
            ++n;
        }
        if (bl && bl2) {
            this.fTarget.getImportRewrite().addImport(this.fSourceBinding);
        }
        if (bl2) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                bodyDeclaration = (ITypeBinding)iterator.next();
                this.fTarget.getImportRewrite().addImport((ITypeBinding)bodyDeclaration);
            }
        }
        String[] stringArray = new String[bodyDeclarationArray.length];
        bodyDeclaration = new Document(this.fSource.getCu().getBuffer().getContents());
        object2 = this.fSource.getASTRewrite().rewriteAST((IDocument)bodyDeclaration, this.fSource.getCu().getJavaProject().getOptions(true));
        object2.apply((IDocument)bodyDeclaration, 2);
        int n4 = 0;
        while (n4 < bodyDeclarationArray.length) {
            stringArray[n4] = this.getUpdatedMember((IDocument)bodyDeclaration, bodyDeclarationArray[n4]);
            ++n4;
        }
        this.fSource.clearASTRewrite();
        return stringArray;
    }

    private String getUpdatedMember(IDocument iDocument, BodyDeclaration bodyDeclaration) throws BadLocationException {
        ITrackedNodePosition iTrackedNodePosition = (ITrackedNodePosition)bodyDeclaration.getProperty(TRACKED_POSITION_PROPERTY);
        return Strings.trimIndentation(iDocument.get(iTrackedNodePosition.getStartPosition(), iTrackedNodePosition.getLength()), this.fPreferences.tabWidth, this.fPreferences.indentWidth, false);
    }

    private RefactoringStatus moveMembers(BodyDeclaration[] bodyDeclarationArray, String[] stringArray) throws CoreException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fTarget.getRoot(), this.fDestinationType.getNameRange());
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        AbstractTypeDeclaration abstractTypeDeclaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz);
        ListRewrite listRewrite = this.fTarget.getASTRewrite().getListRewrite((ASTNode)abstractTypeDeclaration, abstractTypeDeclaration.getBodyDeclarationsProperty());
        TextEditGroup textEditGroup = this.fSource.createGroupDescription(RefactoringCoreMessages.MoveMembersRefactoring_deleteMembers);
        TextEditGroup textEditGroup2 = this.fTarget.createGroupDescription(RefactoringCoreMessages.MoveMembersRefactoring_addMembers);
        int n = 0;
        while (n < bodyDeclarationArray.length) {
            Object object;
            DelegateMethodCreator delegateMethodCreator;
            BodyDeclaration bodyDeclaration = bodyDeclarationArray[n];
            BodyDeclaration bodyDeclaration2 = null;
            boolean bl = false;
            if (this.fDelegateUpdating) {
                if (bodyDeclaration instanceof MethodDeclaration) {
                    delegateMethodCreator = new DelegateMethodCreator();
                    delegateMethodCreator.setDeclaration(bodyDeclaration);
                    delegateMethodCreator.setDeclareDeprecated(this.fDelegateDeprecation);
                    delegateMethodCreator.setSourceRewrite(this.fSource);
                    delegateMethodCreator.setCopy(false);
                    delegateMethodCreator.setNewLocation(this.getDestinationBinding());
                    delegateMethodCreator.prepareDelegate();
                    delegateMethodCreator.createEdit();
                    bodyDeclaration2 = ((MethodDeclaration)bodyDeclaration).getBody();
                    bl = true;
                }
                if (bodyDeclaration instanceof FieldDeclaration) {
                    delegateMethodCreator = (VariableDeclarationFragment)((FieldDeclaration)bodyDeclaration).fragments().get(0);
                    if (!Modifier.isFinal((int)bodyDeclaration.getModifiers())) {
                        refactoringStatus.addInfo(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_not_final, delegateMethodCreator.getName()), null);
                    } else if (delegateMethodCreator.getInitializer() == null) {
                        refactoringStatus.addInfo(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_field_delegate_no_initializer, delegateMethodCreator.getName()), null);
                    } else {
                        object = new DelegateFieldCreator();
                        ((DelegateCreator)object).setDeclaration(bodyDeclaration);
                        ((DelegateCreator)object).setDeclareDeprecated(this.fDelegateDeprecation);
                        ((DelegateCreator)object).setSourceRewrite(this.fSource);
                        ((DelegateCreator)object).setCopy(false);
                        ((DelegateCreator)object).setNewLocation(this.getDestinationBinding());
                        ((DelegateCreator)object).prepareDelegate();
                        ((DelegateCreator)object).createEdit();
                        bodyDeclaration2 = delegateMethodCreator.getInitializer();
                        bl = true;
                    }
                }
                if (bodyDeclaration instanceof AbstractTypeDeclaration) {
                    refactoringStatus.addInfo(Messages.format(RefactoringCoreMessages.DelegateCreator_cannot_create_delegate_for_type, ((AbstractTypeDeclaration)bodyDeclaration).getName().getIdentifier()), null);
                }
            }
            if (!bl) {
                this.fSource.getASTRewrite().remove((ASTNode)bodyDeclaration, textEditGroup);
                bodyDeclaration2 = bodyDeclaration;
            }
            if (bodyDeclaration2 != null && this.fSource != this.fTarget) {
                this.fSource.getImportRemover().registerRemovedNode((ASTNode)bodyDeclaration2);
            }
            delegateMethodCreator = this.fTarget.getASTRewrite().createStringPlaceholder(stringArray[n], bodyDeclaration.getNodeType());
            object = listRewrite.getRewrittenList();
            int n2 = ASTNodes.getInsertionIndex((BodyDeclaration)delegateMethodCreator, (List)object);
            listRewrite.insertAt((ASTNode)delegateMethodCreator, n2, textEditGroup2);
            ++n;
        }
        return refactoringStatus;
    }

    private BodyDeclaration[] getASTMembers(RefactoringStatus refactoringStatus) throws JavaModelException {
        BodyDeclaration[] bodyDeclarationArray = new BodyDeclaration[this.fMembersToMove.length];
        int n = 0;
        while (n < this.fMembersToMove.length) {
            IMember iMember = this.fMembersToMove[n];
            ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fSource.getRoot(), iMember.getNameRange());
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = Class.forName("org.eclipse.wst.jsdt.core.dom.BodyDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            bodyDeclarationArray[n] = (BodyDeclaration)ASTNodes.getParent(aSTNode, clazz);
            if (bodyDeclarationArray[n] instanceof FieldDeclaration && ((FieldDeclaration)bodyDeclarationArray[n]).fragments().size() != 1) {
                refactoringStatus.addFatalError(RefactoringCoreMessages.MoveMembersRefactoring_multi_var_fields);
                return bodyDeclarationArray;
            }
            ++n;
        }
        Arrays.sort(bodyDeclarationArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((BodyDeclaration)object).getStartPosition() - ((BodyDeclaration)object2).getStartPosition();
            }
        });
        return bodyDeclarationArray;
    }

    public RefactoringStatus initialize(RefactoringArguments refactoringArguments) {
        if (refactoringArguments instanceof JavaRefactoringArguments) {
            IJavaElement iJavaElement;
            Object object;
            JavaRefactoringArguments javaRefactoringArguments = (JavaRefactoringArguments)refactoringArguments;
            String string = javaRefactoringArguments.getAttribute("input");
            if (string != null) {
                object = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (object == null || !object.exists() || object.getElementType() != 7) {
                    return ScriptableRefactoring.createInputFatalStatus(object, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.move.static");
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            this.fDestinationType = (IType)object;
            this.fDestinationTypeName = this.fDestinationType.getFullyQualifiedName();
            object = javaRefactoringArguments.getAttribute(ATTRIBUTE_DELEGATE);
            if (object == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DELEGATE));
            }
            this.fDelegateUpdating = Boolean.valueOf((String)object);
            String string2 = javaRefactoringArguments.getAttribute(ATTRIBUTE_DEPRECATE);
            if (string2 == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DEPRECATE));
            }
            this.fDelegateDeprecation = Boolean.valueOf(string2);
            int n = 1;
            ArrayList<IJavaElement> arrayList = new ArrayList<IJavaElement>();
            String string3 = "element" + n;
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            while ((string = javaRefactoringArguments.getAttribute(string3)) != null) {
                iJavaElement = JDTRefactoringDescriptor.handleToElement(javaRefactoringArguments.getProject(), string, false);
                if (iJavaElement == null || !iJavaElement.exists()) {
                    refactoringStatus.merge(ScriptableRefactoring.createInputWarningStatus(iJavaElement, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.move.static"));
                } else {
                    arrayList.add(iJavaElement);
                }
                string3 = "element" + ++n;
            }
            this.fMembersToMove = arrayList.toArray(new IMember[arrayList.size()]);
            if (arrayList.isEmpty()) {
                return ScriptableRefactoring.createInputFatalStatus(null, this.getRefactoring().getName(), "org.eclipse.wst.jsdt.ui.move.static");
            }
            iJavaElement = null;
            if (this.fMembersToMove.length > 0) {
                iJavaElement = this.fMembersToMove[0].getJavaProject();
            }
            this.fPreferences = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)iJavaElement);
            if (!refactoringStatus.isOK()) {
                return refactoringStatus;
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        return new RefactoringStatus();
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String string) {
        this.fComment = string;
    }

    public String getDelegateUpdatingTitle(boolean bl) {
        if (bl) {
            return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_plural;
        }
        return RefactoringCoreMessages.DelegateMethodCreator_keep_original_moved_singular;
    }

    private static class TypeReferenceFinder
    extends ASTVisitor {
        List fResult = new ArrayList();
        Set fDefined = new HashSet();

        private TypeReferenceFinder() {
        }

        public static List perform(ASTNode aSTNode) {
            TypeReferenceFinder typeReferenceFinder = new TypeReferenceFinder();
            aSTNode.accept((ASTVisitor)typeReferenceFinder);
            return typeReferenceFinder.fResult;
        }

        public boolean visit(TypeDeclaration typeDeclaration) {
            this.fDefined.add(typeDeclaration.resolveBinding());
            return true;
        }

        public boolean visit(SimpleName simpleName) {
            IBinding iBinding = simpleName.resolveBinding();
            if (!(iBinding instanceof ITypeBinding)) {
                return true;
            }
            if (!this.fDefined.contains(iBinding)) {
                this.fResult.add(iBinding);
            }
            return true;
        }

        public boolean visit(AnnotationTypeDeclaration annotationTypeDeclaration) {
            this.fDefined.add(annotationTypeDeclaration.resolveBinding());
            return true;
        }

        public boolean visit(EnumDeclaration enumDeclaration) {
            this.fDefined.add(enumDeclaration.resolveBinding());
            return true;
        }
    }
}

