/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CastExpression;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.ConditionalTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.CovariantTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.IndependentTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ParameterTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ReturnTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.SubTypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.VariableVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;

public final class SuperTypeConstraintsModel {
    private static final String DATA_USAGE = "us";
    private static final int MAX_CACHE = 64;
    private final Collection fCastVariables = new ArrayList();
    private int fCompliance = 3;
    private final HashedSet fConstraintVariables = new HashedSet();
    private final Collection fCovariantTypeConstraints = new ArrayList();
    private TypeEnvironment fEnvironment;
    private final TType fSubType;
    private final TType fSuperType;
    private Map fTTypeCache = new LinkedHashMap(64, 0.75f, true){
        private static final long serialVersionUID = 1L;

        protected final boolean removeEldestEntry(Map.Entry entry) {
            return this.size() > 64;
        }
    };
    private final Set fTypeConstraints = new HashSet();

    public static Collection getVariableUsage(ConstraintVariable2 constraintVariable2) {
        Object object = constraintVariable2.getData(DATA_USAGE);
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        if (object instanceof Collection) {
            return Collections.unmodifiableCollection((Collection)object);
        }
        return Collections.singletonList(object);
    }

    public static boolean isConstrainedType(ITypeBinding iTypeBinding) {
        return iTypeBinding != null && !iTypeBinding.isSynthetic() && !iTypeBinding.isPrimitive();
    }

    public static void setVariableUsage(ConstraintVariable2 constraintVariable2, ITypeConstraint2 iTypeConstraint2) {
        Object object = constraintVariable2.getData(DATA_USAGE);
        if (object == null) {
            constraintVariable2.setData(DATA_USAGE, iTypeConstraint2);
        } else if (object instanceof Collection) {
            ((Collection)object).add(iTypeConstraint2);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object);
            arrayList.add(iTypeConstraint2);
            constraintVariable2.setData(DATA_USAGE, arrayList);
        }
    }

    public SuperTypeConstraintsModel(TypeEnvironment typeEnvironment, TType tType, TType tType2) {
        this.fEnvironment = typeEnvironment;
        this.fSubType = tType;
        this.fSuperType = tType2;
    }

    public final void beginCreation() {
    }

    public final ConstraintVariable2 createCastVariable(CastExpression castExpression, ConstraintVariable2 constraintVariable2) {
        ITypeBinding iTypeBinding = castExpression.resolveTypeBinding();
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            CastVariable2 castVariable2 = new CastVariable2(this.createTType(iTypeBinding), new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)castExpression), (ASTNode)castExpression), constraintVariable2);
            this.fCastVariables.add(castVariable2);
            return castVariable2;
        }
        return null;
    }

    public final void createConditionalTypeConstraint(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22, ConstraintVariable2 constraintVariable23) {
        ConditionalTypeConstraint conditionalTypeConstraint = new ConditionalTypeConstraint(constraintVariable2, constraintVariable22, constraintVariable23);
        if (!this.fTypeConstraints.contains(conditionalTypeConstraint)) {
            this.fTypeConstraints.add(conditionalTypeConstraint);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable2, conditionalTypeConstraint);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable22, conditionalTypeConstraint);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable23, conditionalTypeConstraint);
        }
    }

    public final void createCovariantTypeConstraint(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        CovariantTypeConstraint covariantTypeConstraint = new CovariantTypeConstraint(constraintVariable2, constraintVariable22);
        if (!this.fTypeConstraints.contains(covariantTypeConstraint)) {
            this.fTypeConstraints.add(covariantTypeConstraint);
            this.fCovariantTypeConstraints.add(covariantTypeConstraint);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable2, covariantTypeConstraint);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable22, covariantTypeConstraint);
        }
    }

    public final ConstraintVariable2 createDeclaringTypeVariable(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        iTypeBinding = iTypeBinding.getTypeDeclaration();
        return (ConstraintVariable2)this.fConstraintVariables.addExisting(new ImmutableTypeVariable2(this.createTType(iTypeBinding)));
    }

    public final void createEqualityConstraint(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        if (constraintVariable2 != null && constraintVariable22 != null) {
            TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
            TypeEquivalenceSet typeEquivalenceSet2 = constraintVariable22.getTypeEquivalenceSet();
            if (typeEquivalenceSet == null) {
                if (typeEquivalenceSet2 == null) {
                    TypeEquivalenceSet typeEquivalenceSet3 = new TypeEquivalenceSet(constraintVariable2, constraintVariable22);
                    constraintVariable2.setTypeEquivalenceSet(typeEquivalenceSet3);
                    constraintVariable22.setTypeEquivalenceSet(typeEquivalenceSet3);
                } else {
                    typeEquivalenceSet2.add(constraintVariable2);
                    constraintVariable2.setTypeEquivalenceSet(typeEquivalenceSet2);
                }
            } else if (typeEquivalenceSet2 == null) {
                typeEquivalenceSet.add(constraintVariable22);
                constraintVariable22.setTypeEquivalenceSet(typeEquivalenceSet);
            } else {
                if (typeEquivalenceSet == typeEquivalenceSet2) {
                    return;
                }
                ConstraintVariable2[] constraintVariable2Array = typeEquivalenceSet2.getContributingVariables();
                typeEquivalenceSet.addAll(constraintVariable2Array);
                int n = 0;
                while (n < constraintVariable2Array.length) {
                    constraintVariable2Array[n].setTypeEquivalenceSet(typeEquivalenceSet);
                    ++n;
                }
            }
        }
    }

    public final ConstraintVariable2 createExceptionVariable(Name name) {
        ITypeBinding iTypeBinding = name.resolveTypeBinding();
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new TypeVariable2(this.createTType(iTypeBinding), new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)name), (ASTNode)name)));
        }
        return null;
    }

    public final ConstraintVariable2 createImmutableTypeVariable(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new ImmutableTypeVariable2(this.createTType(iTypeBinding)));
        }
        return null;
    }

    public final ConstraintVariable2 createIndependentTypeVariable(ITypeBinding iTypeBinding) {
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new IndependentTypeVariable2(this.createTType(iTypeBinding)));
        }
        return null;
    }

    public final ConstraintVariable2 createMethodParameterVariable(IMethodBinding iMethodBinding, int n) {
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getParameterTypes();
        ITypeBinding iTypeBinding = iTypeBindingArray[Math.min(n, iTypeBindingArray.length - 1)];
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            ConstraintVariable2 constraintVariable2 = null;
            TType tType = this.createTType(iTypeBinding);
            constraintVariable2 = iMethodBinding.getDeclaringClass().isFromSource() ? new ParameterTypeVariable2(tType, n, iMethodBinding.getMethodDeclaration()) : new ImmutableTypeVariable2(tType);
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(constraintVariable2);
        }
        return null;
    }

    public final ConstraintVariable2 createReturnTypeVariable(IMethodBinding iMethodBinding) {
        if (!iMethodBinding.isConstructor()) {
            ITypeBinding iTypeBinding = iMethodBinding.getReturnType();
            if (iTypeBinding != null && iTypeBinding.isArray()) {
                iTypeBinding = iTypeBinding.getElementType();
            }
            if (iTypeBinding != null && SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
                ConstraintVariable2 constraintVariable2 = null;
                TType tType = this.createTType(iTypeBinding);
                constraintVariable2 = iMethodBinding.getDeclaringClass().isFromSource() ? new ReturnTypeVariable2(tType, iMethodBinding) : new ImmutableTypeVariable2(tType);
                return (ConstraintVariable2)this.fConstraintVariables.addExisting(constraintVariable2);
            }
        }
        return null;
    }

    public final void createSubtypeConstraint(ConstraintVariable2 constraintVariable2, ConstraintVariable2 constraintVariable22) {
        SubTypeConstraint2 subTypeConstraint2 = new SubTypeConstraint2(constraintVariable2, constraintVariable22);
        if (!this.fTypeConstraints.contains(subTypeConstraint2)) {
            this.fTypeConstraints.add(subTypeConstraint2);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable2, subTypeConstraint2);
            SuperTypeConstraintsModel.setVariableUsage(constraintVariable22, subTypeConstraint2);
        }
    }

    public final TType createTType(ITypeBinding iTypeBinding) {
        String string = iTypeBinding.getKey();
        TType tType = (TType)this.fTTypeCache.get(string);
        if (tType != null) {
            return tType;
        }
        TType tType2 = this.fEnvironment.create(iTypeBinding);
        this.fTTypeCache.put(string, tType2);
        return tType2;
    }

    public final ConstraintVariable2 createTypeVariable(ITypeBinding iTypeBinding, CompilationUnitRange compilationUnitRange) {
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(new TypeVariable2(this.createTType(iTypeBinding), compilationUnitRange));
        }
        return null;
    }

    public final ConstraintVariable2 createTypeVariable(Type type) {
        ITypeBinding iTypeBinding = type.resolveBinding();
        if (iTypeBinding != null) {
            if (iTypeBinding.isArray()) {
                iTypeBinding = iTypeBinding.getElementType();
            }
            if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
                return (ConstraintVariable2)this.fConstraintVariables.addExisting(new TypeVariable2(this.createTType(iTypeBinding), new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)type), (ASTNode)type)));
            }
        }
        return null;
    }

    public final ConstraintVariable2 createVariableVariable(IVariableBinding iVariableBinding) {
        ITypeBinding iTypeBinding = iVariableBinding.getType();
        if (iTypeBinding.isArray()) {
            iTypeBinding = iTypeBinding.getElementType();
        }
        if (SuperTypeConstraintsModel.isConstrainedType(iTypeBinding)) {
            ConstraintVariable2 constraintVariable2 = null;
            IVariableBinding iVariableBinding2 = iVariableBinding.getVariableDeclaration();
            if (iVariableBinding2.isField()) {
                ITypeBinding iTypeBinding2 = iVariableBinding2.getDeclaringClass();
                if (!iTypeBinding2.isFromSource()) {
                    constraintVariable2 = new ImmutableTypeVariable2(this.createTType(iTypeBinding));
                }
            } else {
                IMethodBinding iMethodBinding = iVariableBinding2.getDeclaringMethod();
                if (iMethodBinding != null && !iMethodBinding.getDeclaringClass().isFromSource()) {
                    constraintVariable2 = new ImmutableTypeVariable2(this.createTType(iTypeBinding));
                }
            }
            if (constraintVariable2 == null) {
                constraintVariable2 = new VariableVariable2(this.createTType(iTypeBinding), iVariableBinding2);
            }
            return (ConstraintVariable2)this.fConstraintVariables.addExisting(constraintVariable2);
        }
        return null;
    }

    public final void endCreation() {
        this.fEnvironment = null;
        this.fTTypeCache = null;
    }

    public final Collection getCastVariables() {
        return Collections.unmodifiableCollection(this.fCastVariables);
    }

    public final int getCompliance() {
        return this.fCompliance;
    }

    public final Collection getConstraintVariables() {
        return Collections.unmodifiableCollection(this.fConstraintVariables);
    }

    public final TType getSubType() {
        return this.fSubType;
    }

    public final TType getSuperType() {
        return this.fSuperType;
    }

    public final Collection getTypeConstraints() {
        return Collections.unmodifiableCollection(this.fTypeConstraints);
    }

    public final void setCompliance(int n) {
        this.fCompliance = n;
    }

    private static class HashedSet
    extends AbstractSet
    implements Set {
        private final Map fImplementation = new HashMap();

        private HashedSet() {
        }

        public final boolean add(Object object) {
            return this.fImplementation.put(object, object) == null;
        }

        public final Object addExisting(Object object) {
            Object v = this.fImplementation.get(object);
            if (v != null) {
                return v;
            }
            this.fImplementation.put(object, object);
            return object;
        }

        public final void clear() {
            this.fImplementation.clear();
        }

        public final boolean contains(Object object) {
            return this.fImplementation.containsKey(object);
        }

        public final boolean isEmpty() {
            return this.fImplementation.isEmpty();
        }

        public final Iterator iterator() {
            return this.fImplementation.keySet().iterator();
        }

        public final boolean remove(Object object) {
            return this.fImplementation.remove(object) == object;
        }

        public final int size() {
            return this.fImplementation.size();
        }
    }
}

