/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.ConditionalTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.CovariantTypeConstraint;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.constraints.SuperTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.CastVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraint2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeConstraintVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ITypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.ImmutableTypeVariable2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TypeEquivalenceSet;

public class SuperTypeConstraintsSolver {
    public static final String DATA_TYPE_ESTIMATE = "te";
    protected final SuperTypeConstraintsModel fModel;
    protected Map fObsoleteCasts = null;
    protected LinkedList fProcessable = null;
    protected Map fTypeOccurrences = null;

    public SuperTypeConstraintsSolver(SuperTypeConstraintsModel superTypeConstraintsModel) {
        Assert.isNotNull((Object)superTypeConstraintsModel);
        this.fModel = superTypeConstraintsModel;
    }

    private void computeConditionalTypeConstraints(Collection collection, int n) {
        ITypeConstraint2 iTypeConstraint2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            iTypeConstraint2 = (ITypeConstraint2)iterator.next();
            if (!(iTypeConstraint2 instanceof ConditionalTypeConstraint)) continue;
            ConditionalTypeConstraint conditionalTypeConstraint = (ConditionalTypeConstraint)iTypeConstraint2;
            this.fModel.createEqualityConstraint(iTypeConstraint2.getLeft(), iTypeConstraint2.getRight());
            this.fModel.createEqualityConstraint(conditionalTypeConstraint.getExpression(), iTypeConstraint2.getLeft());
            this.fModel.createEqualityConstraint(conditionalTypeConstraint.getExpression(), iTypeConstraint2.getRight());
        }
    }

    private void computeNonCovariantConstraints(Collection collection, int n) {
        if (n != 3) {
            ITypeConstraint2 iTypeConstraint2 = null;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                iTypeConstraint2 = (ITypeConstraint2)iterator.next();
                if (!(iTypeConstraint2 instanceof CovariantTypeConstraint)) continue;
                this.fModel.createEqualityConstraint(iTypeConstraint2.getLeft(), iTypeConstraint2.getRight());
            }
        }
    }

    private void computeObsoleteCasts(Collection collection) {
        this.fObsoleteCasts = new HashMap();
        CastVariable2 castVariable2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            castVariable2 = (CastVariable2)iterator.next();
            TType tType = (TType)castVariable2.getExpressionVariable().getData(DATA_TYPE_ESTIMATE);
            if (tType == null || !tType.canAssignTo(castVariable2.getType())) continue;
            ICompilationUnit iCompilationUnit = castVariable2.getCompilationUnit();
            ArrayList<CastVariable2> arrayList = (ArrayList<CastVariable2>)this.fObsoleteCasts.get(iCompilationUnit);
            if (arrayList != null) {
                arrayList.add(castVariable2);
                continue;
            }
            arrayList = new ArrayList<CastVariable2>(1);
            arrayList.add(castVariable2);
            this.fObsoleteCasts.put(iCompilationUnit, arrayList);
        }
    }

    protected ITypeSet computeTypeEstimate(ConstraintVariable2 constraintVariable2) {
        TType tType = constraintVariable2.getType();
        if (constraintVariable2 instanceof ImmutableTypeVariable2 || !tType.getErasure().equals(this.fModel.getSubType().getErasure())) {
            return SuperTypeSet.createTypeSet(tType);
        }
        return SuperTypeSet.createTypeSet(tType, this.fModel.getSuperType());
    }

    private void computeTypeEstimates(Collection collection) {
        ConstraintVariable2 constraintVariable2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            constraintVariable2 = (ConstraintVariable2)iterator.next();
            TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
            if (typeEquivalenceSet == null) {
                typeEquivalenceSet = new TypeEquivalenceSet(constraintVariable2);
                typeEquivalenceSet.setTypeEstimate(this.computeTypeEstimate(constraintVariable2));
                constraintVariable2.setTypeEquivalenceSet(typeEquivalenceSet);
                continue;
            }
            ITypeSet iTypeSet = constraintVariable2.getTypeEstimate();
            if (iTypeSet != null) continue;
            ConstraintVariable2[] constraintVariable2Array = typeEquivalenceSet.getContributingVariables();
            iTypeSet = SuperTypeSet.getUniverse();
            int n = 0;
            while (n < constraintVariable2Array.length) {
                iTypeSet = iTypeSet.restrictedTo(this.computeTypeEstimate(constraintVariable2Array[n]));
                ++n;
            }
            typeEquivalenceSet.setTypeEstimate(iTypeSet);
        }
    }

    private void computeTypeOccurrences(Collection collection) {
        this.fTypeOccurrences = new HashMap();
        TType tType = this.fModel.getSuperType().getErasure();
        TType tType2 = null;
        ITypeSet iTypeSet = null;
        ICompilationUnit iCompilationUnit = null;
        ConstraintVariable2 constraintVariable2 = null;
        ITypeConstraintVariable iTypeConstraintVariable = null;
        TType tType3 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TType tType4;
            constraintVariable2 = (ConstraintVariable2)iterator.next();
            if (!(constraintVariable2 instanceof ITypeConstraintVariable)) continue;
            iTypeConstraintVariable = (ITypeConstraintVariable)((Object)constraintVariable2);
            tType3 = constraintVariable2.getType();
            iTypeSet = iTypeConstraintVariable.getTypeEstimate();
            if (iTypeSet == null || (tType2 = iTypeSet.chooseSingleType()) == null || (tType4 = tType2.getErasure()).equals(tType3.getErasure()) || !tType4.equals(tType)) continue;
            iTypeConstraintVariable.setData(DATA_TYPE_ESTIMATE, tType2);
            iCompilationUnit = iTypeConstraintVariable.getCompilationUnit();
            if (iCompilationUnit == null) continue;
            ArrayList<ITypeConstraintVariable> arrayList = (ArrayList<ITypeConstraintVariable>)this.fTypeOccurrences.get(iCompilationUnit);
            if (arrayList != null) {
                arrayList.add(iTypeConstraintVariable);
                continue;
            }
            arrayList = new ArrayList<ITypeConstraintVariable>(1);
            arrayList.add(iTypeConstraintVariable);
            this.fTypeOccurrences.put(iCompilationUnit, arrayList);
        }
    }

    public final Map getObsoleteCasts() {
        return this.fObsoleteCasts;
    }

    public final Map getTypeOccurrences() {
        return this.fTypeOccurrences;
    }

    private void processConstraints(Collection collection) {
        int n = this.fModel.getCompliance();
        ITypeConstraint2 iTypeConstraint2 = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            iTypeConstraint2 = (ITypeConstraint2)iterator.next();
            if (n != 3 && iTypeConstraint2 instanceof CovariantTypeConstraint || iTypeConstraint2 instanceof ConditionalTypeConstraint) continue;
            ConstraintVariable2 constraintVariable2 = iTypeConstraint2.getLeft();
            ITypeSet iTypeSet = constraintVariable2.getTypeEstimate();
            TypeEquivalenceSet typeEquivalenceSet = constraintVariable2.getTypeEquivalenceSet();
            ITypeSet iTypeSet2 = iTypeSet.restrictedTo(iTypeConstraint2.getRight().getTypeEstimate());
            if (iTypeSet == iTypeSet2) continue;
            typeEquivalenceSet.setTypeEstimate(iTypeSet2);
            this.fProcessable.addAll(Arrays.asList(typeEquivalenceSet.getContributingVariables()));
        }
    }

    public final void solveConstraints() {
        this.fProcessable = new LinkedList();
        Collection collection = this.fModel.getConstraintVariables();
        Collection collection2 = this.fModel.getTypeConstraints();
        int n = this.fModel.getCompliance();
        this.computeNonCovariantConstraints(collection2, n);
        this.computeConditionalTypeConstraints(collection2, n);
        this.computeTypeEstimates(collection);
        this.fProcessable.addAll(collection);
        Collection collection3 = null;
        ConstraintVariable2 constraintVariable2 = null;
        while (!this.fProcessable.isEmpty()) {
            constraintVariable2 = (ConstraintVariable2)this.fProcessable.removeFirst();
            collection3 = SuperTypeConstraintsModel.getVariableUsage(constraintVariable2);
            if (!collection3.isEmpty()) {
                this.processConstraints(collection3);
                continue;
            }
            constraintVariable2.setData(DATA_TYPE_ESTIMATE, constraintVariable2.getTypeEstimate().chooseSingleType());
        }
        this.computeTypeOccurrences(collection);
        this.computeObsoleteCasts(this.fModel.getCastVariables());
    }
}

