/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.surround;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.BodyDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.MethodInvocation;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.ThrowStatement;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.AbstractExceptionAnalyzer;

public class ExceptionAnalyzer
extends AbstractExceptionAnalyzer {
    private Selection fSelection;

    private ExceptionAnalyzer(Selection selection) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
    }

    public static ITypeBinding[] perform(BodyDeclaration bodyDeclaration, Selection selection) {
        ExceptionAnalyzer exceptionAnalyzer = new ExceptionAnalyzer(selection);
        bodyDeclaration.accept((ASTVisitor)exceptionAnalyzer);
        List list = exceptionAnalyzer.getCurrentExceptions();
        if (bodyDeclaration.getNodeType() == 31) {
            List list2 = ((MethodDeclaration)bodyDeclaration).thrownExceptions();
            Iterator iterator = list2.iterator();
            while (iterator.hasNext()) {
                ITypeBinding iTypeBinding = ((Name)iterator.next()).resolveTypeBinding();
                if (iTypeBinding == null) continue;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    ITypeBinding iTypeBinding2 = (ITypeBinding)iterator2.next();
                    if (!iTypeBinding2.isAssignmentCompatible(iTypeBinding)) continue;
                    iterator2.remove();
                }
            }
        }
        Collections.sort(list, new ExceptionComparator());
        return list.toArray(new ITypeBinding[list.size()]);
    }

    public boolean visit(ThrowStatement throwStatement) {
        ITypeBinding iTypeBinding = throwStatement.getExpression().resolveTypeBinding();
        if (!this.isSelected((ASTNode)throwStatement) || iTypeBinding == null || Bindings.isRuntimeException(iTypeBinding)) {
            return true;
        }
        this.addException(iTypeBinding);
        return true;
    }

    public boolean visit(MethodInvocation methodInvocation) {
        if (!this.isSelected((ASTNode)methodInvocation)) {
            return false;
        }
        return this.handleExceptions(methodInvocation.resolveMethodBinding(), methodInvocation.getAST());
    }

    public boolean visit(SuperMethodInvocation superMethodInvocation) {
        if (!this.isSelected((ASTNode)superMethodInvocation)) {
            return false;
        }
        return this.handleExceptions(superMethodInvocation.resolveMethodBinding(), superMethodInvocation.getAST());
    }

    public boolean visit(ClassInstanceCreation classInstanceCreation) {
        if (!this.isSelected((ASTNode)classInstanceCreation)) {
            return false;
        }
        return this.handleExceptions(classInstanceCreation.resolveConstructorBinding(), classInstanceCreation.getAST());
    }

    public boolean visit(ConstructorInvocation constructorInvocation) {
        if (!this.isSelected((ASTNode)constructorInvocation)) {
            return false;
        }
        return this.handleExceptions(constructorInvocation.resolveConstructorBinding(), constructorInvocation.getAST());
    }

    public boolean visit(SuperConstructorInvocation superConstructorInvocation) {
        if (!this.isSelected((ASTNode)superConstructorInvocation)) {
            return false;
        }
        return this.handleExceptions(superConstructorInvocation.resolveConstructorBinding(), superConstructorInvocation.getAST());
    }

    private boolean handleExceptions(IMethodBinding iMethodBinding, AST aST) {
        if (iMethodBinding == null) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = iMethodBinding.getExceptionTypes();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            this.addException(iTypeBindingArray[n]);
            ++n;
        }
        return true;
    }

    private boolean isSelected(ASTNode aSTNode) {
        return this.fSelection.getVisitSelectionMode(aSTNode) == 2;
    }

    private static class ExceptionComparator
    implements Comparator {
        private ExceptionComparator() {
        }

        public int compare(Object object, Object object2) {
            int n;
            int n2 = this.getDepth((ITypeBinding)object);
            if (n2 < (n = this.getDepth((ITypeBinding)object2))) {
                return 1;
            }
            if (n2 > n) {
                return -1;
            }
            return 0;
        }

        private int getDepth(ITypeBinding iTypeBinding) {
            int n = 0;
            while (iTypeBinding != null) {
                iTypeBinding = iTypeBinding.getSuperclass();
                ++n;
            }
            return n;
        }
    }
}

