/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IExtendedModifier;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.TryStatement;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.CodeScopeBuilder;
import org.eclipse.wst.jsdt.internal.corext.dom.Selection;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.ISurroundWithTryCatchQuery;
import org.eclipse.wst.jsdt.internal.corext.refactoring.surround.SurroundWithTryCatchAnalyzer;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class SurroundWithTryCatchRefactoring
extends Refactoring {
    private Selection fSelection;
    private ISurroundWithTryCatchQuery fQuery;
    private SurroundWithTryCatchAnalyzer fAnalyzer;
    private boolean fLeaveDirty;
    private ICompilationUnit fCUnit;
    private CompilationUnit fRootNode;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewrite;
    private CodeScopeBuilder.Scope fScope;
    private ASTNode[] fSelectedNodes;

    private SurroundWithTryCatchRefactoring(ICompilationUnit iCompilationUnit, Selection selection, ISurroundWithTryCatchQuery iSurroundWithTryCatchQuery) {
        this.fCUnit = iCompilationUnit;
        this.fSelection = selection;
        this.fQuery = iSurroundWithTryCatchQuery;
        this.fLeaveDirty = false;
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit iCompilationUnit, ITextSelection iTextSelection, ISurroundWithTryCatchQuery iSurroundWithTryCatchQuery) {
        return new SurroundWithTryCatchRefactoring(iCompilationUnit, Selection.createFromStartLength(iTextSelection.getOffset(), iTextSelection.getLength()), iSurroundWithTryCatchQuery);
    }

    public static SurroundWithTryCatchRefactoring create(ICompilationUnit iCompilationUnit, int n, int n2, ISurroundWithTryCatchQuery iSurroundWithTryCatchQuery) {
        return new SurroundWithTryCatchRefactoring(iCompilationUnit, Selection.createFromStartLength(n, n2), iSurroundWithTryCatchQuery);
    }

    public void setLeaveDirty(boolean bl) {
        this.fLeaveDirty = bl;
    }

    public boolean stopExecution() {
        if (this.fAnalyzer == null) {
            return true;
        }
        ITypeBinding[] iTypeBindingArray = this.fAnalyzer.getExceptions();
        return iTypeBindingArray == null || iTypeBindingArray.length == 0;
    }

    public String getName() {
        return RefactoringCoreMessages.SurroundWithTryCatchRefactoring_name;
    }

    public RefactoringStatus checkActivationBasics(CompilationUnit compilationUnit) throws JavaModelException {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        this.fRootNode = compilationUnit;
        this.fAnalyzer = new SurroundWithTryCatchAnalyzer(this.fCUnit, this.fSelection, this.fQuery);
        this.fRootNode.accept((ASTVisitor)this.fAnalyzer);
        refactoringStatus.merge(this.fAnalyzer.getStatus());
        return refactoringStatus;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnit compilationUnit = new RefactoringASTParser(3).parse((ITypeRoot)this.fCUnit, true, iProgressMonitor);
        return this.checkActivationBasics(compilationUnit);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor iProgressMonitor) throws CoreException {
        return Checks.validateModifiesFiles(ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit}), this.getValidationContext());
    }

    public Change createChange(IProgressMonitor iProgressMonitor) throws CoreException {
        CompilationUnitChange compilationUnitChange;
        if (iProgressMonitor == null) {
            iProgressMonitor = new NullProgressMonitor();
        }
        iProgressMonitor.beginTask("", 2);
        IPath iPath = this.getFile().getFullPath();
        ITextFileBufferManager iTextFileBufferManager = FileBuffers.getTextFileBufferManager();
        try {
            TextEdit textEdit;
            iTextFileBufferManager.connect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
            IDocument iDocument = iTextFileBufferManager.getTextFileBuffer(iPath, LocationKind.IFILE).getDocument();
            CompilationUnitChange compilationUnitChange2 = new CompilationUnitChange(this.getName(), this.fCUnit);
            if (this.fLeaveDirty) {
                compilationUnitChange2.setSaveMode(4);
            }
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            compilationUnitChange2.setEdit((TextEdit)multiTextEdit);
            this.fRewriter = ASTRewrite.create((AST)this.fAnalyzer.getEnclosingBodyDeclaration().getAST());
            this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(this.fAnalyzer.getSelectedNodes(), iDocument, this.fSelection.getOffset(), this.fSelection.getLength()));
            this.fImportRewrite = StubUtility.createImportRewrite(this.fRootNode, true);
            this.fScope = CodeScopeBuilder.perform(this.fAnalyzer.getEnclosingBodyDeclaration(), this.fSelection).findScope(this.fSelection.getOffset(), this.fSelection.getLength());
            this.fScope.setCursor(this.fSelection.getOffset());
            this.fSelectedNodes = this.fAnalyzer.getSelectedNodes();
            this.createTryCatchStatement(iDocument);
            if (this.fImportRewrite.hasRecordedChanges()) {
                textEdit = this.fImportRewrite.rewriteImports(null);
                multiTextEdit.addChild(textEdit);
                compilationUnitChange2.addTextEditGroup(new TextEditGroup("", new TextEdit[]{textEdit}));
            }
            textEdit = this.fRewriter.rewriteAST(iDocument, this.fCUnit.getJavaProject().getOptions(true));
            multiTextEdit.addChild(textEdit);
            compilationUnitChange2.addTextEditGroup(new TextEditGroup("", new TextEdit[]{textEdit}));
            compilationUnitChange = compilationUnitChange2;
            Object var8_10 = null;
        }
        catch (BadLocationException badLocationException) {
            try {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, badLocationException.getMessage(), (Throwable)badLocationException));
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
                iProgressMonitor.done();
                throw throwable;
            }
        }
        iTextFileBufferManager.disconnect(iPath, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(iProgressMonitor, 1));
        iProgressMonitor.done();
        return compilationUnitChange;
    }

    private AST getAST() {
        return this.fRootNode.getAST();
    }

    private void createTryCatchStatement(IDocument iDocument) throws CoreException, BadLocationException {
        VariableDeclarationStatement variableDeclarationStatement;
        String string;
        Object object;
        CatchClause catchClause;
        ITypeBinding iTypeBinding;
        String string2 = iDocument.getLineDelimiter(0);
        ArrayList<Object> arrayList = new ArrayList<Object>(1);
        TryStatement tryStatement = this.getAST().newTryStatement();
        ITypeBinding[] iTypeBindingArray = this.fAnalyzer.getExceptions();
        int n = 0;
        while (n < iTypeBindingArray.length) {
            iTypeBinding = iTypeBindingArray[n];
            String string3 = this.fImportRewrite.addImport(iTypeBinding);
            catchClause = this.getAST().newCatchClause();
            tryStatement.catchClauses().add(catchClause);
            SingleVariableDeclaration singleVariableDeclaration = this.getAST().newSingleVariableDeclaration();
            object = StubUtility.getExceptionVariableName(this.fCUnit.getJavaProject());
            string = this.fScope.createName((String)object, false);
            singleVariableDeclaration.setName(this.getAST().newSimpleName(string));
            singleVariableDeclaration.setType(ASTNodeFactory.newType(this.getAST(), string3));
            catchClause.setException(singleVariableDeclaration);
            variableDeclarationStatement = this.getCatchBody(string3, string, string2);
            if (variableDeclarationStatement != null) {
                catchClause.getBody().statements().add(variableDeclarationStatement);
            }
            ++n;
        }
        List list = this.getSpecialVariableDeclarationStatements();
        iTypeBinding = this.fRewriter.getListRewrite((ASTNode)tryStatement.getBody(), Block.STATEMENTS_PROPERTY);
        boolean bl = false;
        catchClause = null;
        int n2 = 0;
        while (n2 < this.fSelectedNodes.length) {
            object = this.fSelectedNodes[n2];
            if (object instanceof VariableDeclarationStatement && list.contains(object)) {
                Object object2;
                Type type;
                Object object3;
                Object object4;
                string = this.getAST();
                variableDeclarationStatement = (VariableDeclarationStatement)object;
                VariableDeclarationStatement variableDeclarationStatement2 = (VariableDeclarationStatement)ASTNode.copySubtree((AST)string, (ASTNode)variableDeclarationStatement);
                List list2 = variableDeclarationStatement2.modifiers();
                Object object5 = list2.iterator();
                while (object5.hasNext()) {
                    object4 = (IExtendedModifier)object5.next();
                    if (!object4.isModifier() || !Modifier.isFinal((int)((Modifier)object4).getKeyword().toFlagValue())) continue;
                    object5.remove();
                }
                object5 = variableDeclarationStatement2.fragments();
                object4 = object5.iterator();
                Iterator iterator = variableDeclarationStatement.fragments().iterator();
                while (object4.hasNext()) {
                    object3 = (VariableDeclarationFragment)object4.next();
                    ((VariableDeclarationFragment)iterator.next()).resolveBinding();
                    object3.setInitializer(null);
                }
                object4 = (CompilationUnit)variableDeclarationStatement.getRoot();
                int n3 = object4.getExtendedStartPosition((ASTNode)variableDeclarationStatement);
                if (n3 != variableDeclarationStatement.getStartPosition() && n3 >= this.fSelection.getOffset()) {
                    object3 = iDocument.get(n3, variableDeclarationStatement.getStartPosition() - n3);
                    object3 = Strings.trimTrailingTabsAndSpaces((String)object3);
                    type = variableDeclarationStatement.getType();
                    object2 = iDocument.get(type.getStartPosition(), type.getLength());
                    variableDeclarationStatement2.setType((Type)this.fRewriter.createStringPlaceholder(String.valueOf(object3) + (String)object2, type.getNodeType()));
                }
                arrayList.add(variableDeclarationStatement2);
                object5 = variableDeclarationStatement.fragments();
                if (!object5.isEmpty()) {
                    object3 = new ArrayList();
                    type = object5.iterator();
                    while (type.hasNext()) {
                        object2 = (VariableDeclarationFragment)type.next();
                        Expression expression = object2.getInitializer();
                        if (expression == null) continue;
                        Assignment assignment = string.newAssignment();
                        assignment.setLeftHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)object2.getName()));
                        assignment.setRightHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)expression));
                        object3.add(string.newExpressionStatement((Expression)assignment));
                    }
                    if (!object3.isEmpty()) {
                        if (this.fSelectedNodes.length == 1) {
                            catchClause = this.fRewriter.createGroupNode(object3.toArray(new ASTNode[object3.size()]));
                        } else {
                            this.fRewriter.replace((ASTNode)variableDeclarationStatement, this.fRewriter.createGroupNode(object3.toArray(new ASTNode[object3.size()])), null);
                        }
                    } else {
                        this.fRewriter.remove((ASTNode)variableDeclarationStatement, null);
                        bl = true;
                    }
                } else {
                    this.fRewriter.remove((ASTNode)variableDeclarationStatement, null);
                    bl = true;
                }
            }
            ++n2;
        }
        arrayList.add(tryStatement);
        ASTNode aSTNode = arrayList.size() == 1 ? (ASTNode)arrayList.get(0) : this.fRewriter.createGroupNode(arrayList.toArray(new ASTNode[arrayList.size()]));
        if (this.fSelectedNodes.length == 1) {
            if (catchClause != null) {
                iTypeBinding.insertLast((ASTNode)catchClause, null);
            } else if (!bl) {
                iTypeBinding.insertLast(this.fRewriter.createMoveTarget(this.fSelectedNodes[0]), null);
            }
            this.fRewriter.replace(this.fSelectedNodes[0], aSTNode, null);
        } else {
            object = this.fRewriter.getListRewrite(this.fSelectedNodes[0].getParent(), (ChildListPropertyDescriptor)this.fSelectedNodes[0].getLocationInParent());
            string = object.createMoveTarget(this.fSelectedNodes[0], this.fSelectedNodes[this.fSelectedNodes.length - 1], aSTNode, null);
            iTypeBinding.insertLast((ASTNode)string, null);
        }
    }

    private List getSpecialVariableDeclarationStatements() {
        ArrayList<ASTNode> arrayList = new ArrayList<ASTNode>(3);
        VariableDeclaration[] variableDeclarationArray = this.fAnalyzer.getAffectedLocals();
        int n = 0;
        while (n < variableDeclarationArray.length) {
            ASTNode aSTNode = variableDeclarationArray[n].getParent();
            if (aSTNode instanceof VariableDeclarationStatement && !arrayList.contains(aSTNode)) {
                arrayList.add(aSTNode);
            }
            ++n;
        }
        return arrayList;
    }

    private Statement getCatchBody(String string, String string2, String string3) throws CoreException {
        String string4 = StubUtility.getCatchBodyContent(this.fCUnit, string, string2, this.fSelectedNodes[0], string3);
        if (string4 == null) {
            return null;
        }
        return (Statement)this.fRewriter.createStringPlaceholder(string4, 41);
    }

    private IFile getFile() {
        return (IFile)this.fCUnit.getPrimary().getResource();
    }
}

