/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types;

import org.eclipse.core.runtime.Assert;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.AbstractTypeVariable;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.WildcardType;

public final class CaptureType
extends AbstractTypeVariable {
    private WildcardType fWildcard;
    private IJavaProject fJavaProject;

    protected CaptureType(TypeEnvironment typeEnvironment) {
        super(typeEnvironment);
    }

    protected void initialize(ITypeBinding iTypeBinding, IJavaProject iJavaProject) {
        Assert.isTrue((boolean)iTypeBinding.isCapture());
        super.initialize(iTypeBinding);
        this.fWildcard = (WildcardType)this.getEnvironment().create(iTypeBinding.getWildcard());
        this.fJavaProject = iJavaProject;
    }

    public int getKind() {
        return 13;
    }

    public WildcardType getWildcard() {
        return this.fWildcard;
    }

    public boolean doEquals(TType tType) {
        return this.getBindingKey().equals(((CaptureType)tType).getBindingKey()) && this.fJavaProject.equals(((CaptureType)tType).fJavaProject);
    }

    public int hashCode() {
        return this.getBindingKey().hashCode();
    }

    protected boolean doCanAssignTo(TType tType) {
        switch (tType.getKind()) {
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
            case 4: {
                return this.canAssignFirstBoundTo(tType);
            }
            case 6: {
                return false;
            }
            case 5: 
            case 7: 
            case 8: {
                return this.canAssignOneBoundTo(tType);
            }
            case 9: 
            case 10: 
            case 11: {
                return ((WildcardType)tType).checkAssignmentBound(this);
            }
            case 12: {
                return false;
            }
            case 13: {
                return ((CaptureType)tType).checkLowerBound(this.getWildcard());
            }
        }
        return false;
    }

    protected boolean checkLowerBound(TType tType) {
        if (!this.getWildcard().isSuperWildcardType()) {
            return false;
        }
        return tType.canAssignTo(this.getWildcard().getBound());
    }

    private boolean canAssignFirstBoundTo(TType tType) {
        if (this.fBounds.length > 0 && this.fBounds[0].isArrayType()) {
            return this.fBounds[0].canAssignTo(tType);
        }
        return false;
    }

    public String getName() {
        return "";
    }

    protected String getPlainPrettySignature() {
        return "capture-of " + this.fWildcard.getPrettySignature();
    }
}

