/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets;

import java.util.Iterator;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.ArraySuperTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.EnumeratedTypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSet;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints.typesets.TypeSetEnvironment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.typeconstraints2.TTypes;

public class ArrayTypeSet
extends TypeSet {
    protected TypeSet fElemTypeSet;
    private EnumeratedTypeSet fEnumCache = null;

    protected ArrayTypeSet(TypeSetEnvironment typeSetEnvironment) {
        super(typeSetEnvironment);
    }

    public ArrayTypeSet(TypeSet typeSet) {
        super(typeSet.getTypeSetEnvironment());
        this.fElemTypeSet = typeSet;
    }

    public TypeSet getElemTypeSet() {
        return this.fElemTypeSet;
    }

    public boolean isUniverse() {
        return false;
    }

    public TypeSet makeClone() {
        return new ArrayTypeSet(this.fElemTypeSet);
    }

    public boolean isEmpty() {
        return this.fElemTypeSet.isEmpty();
    }

    public TypeSet upperBound() {
        return new ArrayTypeSet(this.fElemTypeSet.upperBound());
    }

    public TypeSet lowerBound() {
        return new ArrayTypeSet(this.fElemTypeSet.lowerBound());
    }

    public boolean hasUniqueLowerBound() {
        return this.fElemTypeSet.hasUniqueLowerBound();
    }

    public boolean hasUniqueUpperBound() {
        return this.fElemTypeSet.hasUniqueUpperBound();
    }

    public TType uniqueLowerBound() {
        return TTypes.createArrayType(this.fElemTypeSet.uniqueLowerBound(), 1);
    }

    public TType uniqueUpperBound() {
        return TTypes.createArrayType(this.fElemTypeSet.uniqueUpperBound(), 1);
    }

    public boolean contains(TType tType) {
        if (!(tType instanceof ArrayType)) {
            return false;
        }
        ArrayType arrayType = (ArrayType)tType;
        return this.fElemTypeSet.contains(arrayType.getComponentType());
    }

    public boolean containsAll(TypeSet typeSet) {
        if (typeSet instanceof ArrayTypeSet && !(typeSet instanceof ArraySuperTypeSet)) {
            ArrayTypeSet arrayTypeSet = (ArrayTypeSet)typeSet;
            return this.fElemTypeSet.containsAll(arrayTypeSet.fElemTypeSet);
        }
        Iterator iterator = typeSet.iterator();
        while (iterator.hasNext()) {
            TType tType = (TType)iterator.next();
            if (this.contains(tType)) continue;
            return false;
        }
        return true;
    }

    public Iterator iterator() {
        if (this.fEnumCache != null) {
            return this.fEnumCache.iterator();
        }
        return new Iterator(){
            Iterator fElemIter;
            {
                this.fElemIter = ArrayTypeSet.this.fElemTypeSet.iterator();
            }

            public boolean hasNext() {
                return this.fElemIter.hasNext();
            }

            public Object next() {
                return TTypes.createArrayType((TType)this.fElemIter.next(), 1);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public EnumeratedTypeSet enumerate() {
        if (this.fEnumCache == null) {
            this.fEnumCache = new EnumeratedTypeSet(this.getTypeSetEnvironment());
            Iterator iterator = this.fElemTypeSet.iterator();
            while (iterator.hasNext()) {
                TType tType = (TType)iterator.next();
                this.fEnumCache.add(TTypes.createArrayType(tType, 1));
            }
            this.fEnumCache.initComplete();
        }
        return this.fEnumCache;
    }

    public boolean isSingleton() {
        return this.fElemTypeSet.isSingleton();
    }

    public TType anyMember() {
        return TTypes.createArrayType(this.fElemTypeSet.anyMember(), 1);
    }

    public TypeSet superTypes() {
        return new ArraySuperTypeSet(this.fElemTypeSet);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ArrayTypeSet) {
            ArrayTypeSet arrayTypeSet = (ArrayTypeSet)object;
            return this.fElemTypeSet.equals(arrayTypeSet.fElemTypeSet);
        }
        return false;
    }

    public String toString() {
        return "{" + this.fID + ": array(" + this.fElemTypeSet + ")}";
    }
}

